/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.scene.control.ReadOnlyUnbackedObservableList;
import com.sun.javafx.scene.control.behavior.TreeTableViewBehavior;
import com.sun.javafx.scene.control.skin.TableColumnHeader;
import com.sun.javafx.scene.control.skin.TableViewSkinBase;
import com.sun.javafx.scene.control.skin.TreeTableViewSkin$$Lambda$1;
import com.sun.javafx.scene.control.skin.TreeTableViewSkin$$Lambda$10;
import com.sun.javafx.scene.control.skin.TreeTableViewSkin$$Lambda$11;
import com.sun.javafx.scene.control.skin.TreeTableViewSkin$$Lambda$12;
import com.sun.javafx.scene.control.skin.TreeTableViewSkin$$Lambda$2;
import com.sun.javafx.scene.control.skin.TreeTableViewSkin$$Lambda$3;
import com.sun.javafx.scene.control.skin.TreeTableViewSkin$$Lambda$4;
import com.sun.javafx.scene.control.skin.TreeTableViewSkin$$Lambda$5;
import com.sun.javafx.scene.control.skin.TreeTableViewSkin$$Lambda$6;
import com.sun.javafx.scene.control.skin.TreeTableViewSkin$$Lambda$7;
import com.sun.javafx.scene.control.skin.TreeTableViewSkin$$Lambda$8;
import com.sun.javafx.scene.control.skin.TreeTableViewSkin$$Lambda$9;
import com.sun.javafx.scene.control.skin.Utils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.event.WeakEventHandler;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.ResizeFeaturesBase;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTablePosition;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;

public class TreeTableViewSkin<S>
extends TableViewSkinBase<S, TreeItem<S>, TreeTableView<S>, TreeTableViewBehavior<S>, TreeTableRow<S>, TreeTableColumn<S, ?>> {
    private TreeTableViewBackingList<S> tableBackingList;
    private ObjectProperty<ObservableList<TreeItem<S>>> tableBackingListProperty;
    private TreeTableView<S> treeTableView;
    private WeakReference<TreeItem<S>> weakRootRef;
    private EventHandler<TreeItem.TreeModificationEvent<S>> rootListener = TreeTableViewSkin$$Lambda$1.lambdaFactory$(this);
    private WeakEventHandler<TreeItem.TreeModificationEvent<S>> weakRootListener;

    public TreeTableViewSkin(TreeTableView<S> treeTableView) {
        super(treeTableView, new TreeTableViewBehavior<S>(treeTableView));
        this.treeTableView = treeTableView;
        this.tableBackingList = new TreeTableViewBackingList<S>(treeTableView);
        this.tableBackingListProperty = new SimpleObjectProperty<TreeTableViewBackingList<S>>(this.tableBackingList);
        this.flow.setFixedCellSize(treeTableView.getFixedCellSize());
        super.init(treeTableView);
        this.setRoot(((TreeTableView)this.getSkinnable()).getRoot());
        EventHandler ml = TreeTableViewSkin$$Lambda$2.lambdaFactory$(treeTableView);
        this.flow.getVbar().addEventFilter(MouseEvent.MOUSE_PRESSED, ml);
        this.flow.getHbar().addEventFilter(MouseEvent.MOUSE_PRESSED, ml);
        TreeTableViewBehavior behavior = (TreeTableViewBehavior)this.getBehavior();
        behavior.setOnFocusPreviousRow(TreeTableViewSkin$$Lambda$3.lambdaFactory$(this));
        behavior.setOnFocusNextRow(TreeTableViewSkin$$Lambda$4.lambdaFactory$(this));
        behavior.setOnMoveToFirstCell(TreeTableViewSkin$$Lambda$5.lambdaFactory$(this));
        behavior.setOnMoveToLastCell(TreeTableViewSkin$$Lambda$6.lambdaFactory$(this));
        behavior.setOnScrollPageDown(TreeTableViewSkin$$Lambda$7.lambdaFactory$(this));
        behavior.setOnScrollPageUp(TreeTableViewSkin$$Lambda$8.lambdaFactory$(this));
        behavior.setOnSelectPreviousRow(TreeTableViewSkin$$Lambda$9.lambdaFactory$(this));
        behavior.setOnSelectNextRow(TreeTableViewSkin$$Lambda$10.lambdaFactory$(this));
        behavior.setOnSelectLeftCell(TreeTableViewSkin$$Lambda$11.lambdaFactory$(this));
        behavior.setOnSelectRightCell(TreeTableViewSkin$$Lambda$12.lambdaFactory$(this));
        this.registerChangeListener(treeTableView.rootProperty(), "ROOT");
        this.registerChangeListener(treeTableView.showRootProperty(), "SHOW_ROOT");
        this.registerChangeListener(treeTableView.rowFactoryProperty(), "ROW_FACTORY");
        this.registerChangeListener(treeTableView.expandedItemCountProperty(), "TREE_ITEM_COUNT");
        this.registerChangeListener(treeTableView.fixedCellSizeProperty(), "FIXED_CELL_SIZE");
    }

    @Override
    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("ROOT".equals(p)) {
            ((TreeTableView)this.getSkinnable()).edit(-1, null);
            this.setRoot(((TreeTableView)this.getSkinnable()).getRoot());
        } else if ("SHOW_ROOT".equals(p)) {
            if (!((TreeTableView)this.getSkinnable()).isShowRoot() && this.getRoot() != null) {
                this.getRoot().setExpanded(true);
            }
            this.updateRowCount();
        } else if ("ROW_FACTORY".equals(p)) {
            this.flow.recreateCells();
        } else if ("TREE_ITEM_COUNT".equals(p)) {
            this.rowCountDirty = true;
        } else if ("FIXED_CELL_SIZE".equals(p)) {
            this.flow.setFixedCellSize(((TreeTableView)this.getSkinnable()).getFixedCellSize());
        }
    }

    private TreeItem<S> getRoot() {
        return this.weakRootRef == null ? null : (TreeItem)this.weakRootRef.get();
    }

    private void setRoot(TreeItem<S> newRoot) {
        if (this.getRoot() != null && this.weakRootListener != null) {
            this.getRoot().removeEventHandler(TreeItem.treeNotificationEvent(), this.weakRootListener);
        }
        this.weakRootRef = new WeakReference<TreeItem<S>>(newRoot);
        if (this.getRoot() != null) {
            this.weakRootListener = new WeakEventHandler<TreeItem.TreeModificationEvent<S>>(this.rootListener);
            this.getRoot().addEventHandler(TreeItem.treeNotificationEvent(), this.weakRootListener);
        }
        this.updateRowCount();
    }

    @Override
    protected ObservableList<TreeTableColumn<S, ?>> getVisibleLeafColumns() {
        return this.treeTableView.getVisibleLeafColumns();
    }

    @Override
    protected int getVisibleLeafIndex(TreeTableColumn<S, ?> tc) {
        return this.treeTableView.getVisibleLeafIndex(tc);
    }

    @Override
    protected TreeTableColumn<S, ?> getVisibleLeafColumn(int col) {
        return this.treeTableView.getVisibleLeafColumn(col);
    }

    protected TreeTableView.TreeTableViewFocusModel<S> getFocusModel() {
        return this.treeTableView.getFocusModel();
    }

    protected TreeTablePosition<S, ?> getFocusedCell() {
        return this.treeTableView.getFocusModel().getFocusedCell();
    }

    @Override
    protected TableSelectionModel<TreeItem<S>> getSelectionModel() {
        return this.treeTableView.getSelectionModel();
    }

    @Override
    protected ObjectProperty<Callback<TreeTableView<S>, TreeTableRow<S>>> rowFactoryProperty() {
        return this.treeTableView.rowFactoryProperty();
    }

    @Override
    protected ObjectProperty<Node> placeholderProperty() {
        return this.treeTableView.placeholderProperty();
    }

    @Override
    protected ObjectProperty<ObservableList<TreeItem<S>>> itemsProperty() {
        return this.tableBackingListProperty;
    }

    @Override
    protected ObservableList<TreeTableColumn<S, ?>> getColumns() {
        return this.treeTableView.getColumns();
    }

    @Override
    protected BooleanProperty tableMenuButtonVisibleProperty() {
        return this.treeTableView.tableMenuButtonVisibleProperty();
    }

    @Override
    protected ObjectProperty<Callback<ResizeFeaturesBase, Boolean>> columnResizePolicyProperty() {
        return this.treeTableView.columnResizePolicyProperty();
    }

    @Override
    protected ObservableList<TreeTableColumn<S, ?>> getSortOrder() {
        return this.treeTableView.getSortOrder();
    }

    @Override
    protected boolean resizeColumn(TreeTableColumn<S, ?> tc, double delta) {
        return this.treeTableView.resizeColumn(tc, delta);
    }

    @Override
    protected void edit(int index, TreeTableColumn<S, ?> column) {
        this.treeTableView.edit(index, column);
    }

    @Override
    protected void resizeColumnToFitContent(TreeTableColumn<S, ?> tc, int maxRows) {
        Node n;
        TreeTableColumn<S, ?> col = tc;
        List items = (List)this.itemsProperty().get();
        if (items == null || items.isEmpty()) {
            return;
        }
        Callback<TreeTableColumn<S, ?>, TreeTableCell<S, ?>> cellFactory = col.getCellFactory();
        if (cellFactory == null) {
            return;
        }
        TreeTableCell<Object, ?> cell = cellFactory.call(col);
        if (cell == null) {
            return;
        }
        cell.getProperties().put("deferToParentPrefWidth", Boolean.TRUE);
        double padding = 10.0;
        Node node = n = cell.getSkin() == null ? null : cell.getSkin().getNode();
        if (n instanceof Region) {
            Region r = (Region)n;
            padding = r.snappedLeftInset() + r.snappedRightInset();
        }
        TreeTableRow<S> treeTableRow = new TreeTableRow<S>();
        treeTableRow.updateTreeTableView(this.treeTableView);
        int rows = maxRows == -1 ? items.size() : Math.min(items.size(), maxRows);
        double maxWidth = 0.0;
        for (int row = 0; row < rows; ++row) {
            treeTableRow.updateIndex(row);
            treeTableRow.updateTreeItem(this.treeTableView.getTreeItem(row));
            cell.updateTreeTableColumn(col);
            cell.updateTreeTableView(this.treeTableView);
            cell.updateTreeTableRow(treeTableRow);
            cell.updateIndex(row);
            if ((cell.getText() == null || cell.getText().isEmpty()) && cell.getGraphic() == null) continue;
            this.getChildren().add(cell);
            cell.applyCss();
            double w = cell.prefWidth(-1.0);
            maxWidth = Math.max(maxWidth, w);
            this.getChildren().remove(cell);
        }
        cell.updateIndex(-1);
        TableColumnHeader header = this.getTableHeaderRow().getColumnHeaderFor(tc);
        double headerTextWidth = Utils.computeTextWidth(header.label.getFont(), tc.getText(), -1.0);
        Node graphic = header.label.getGraphic();
        double headerGraphicWidth = graphic == null ? 0.0 : graphic.prefWidth(-1.0) + header.label.getGraphicTextGap();
        double headerWidth = headerTextWidth + headerGraphicWidth + 10.0 + header.snappedLeftInset() + header.snappedRightInset();
        maxWidth = Math.max(maxWidth, headerWidth);
        maxWidth += padding;
        if (this.treeTableView.getColumnResizePolicy() == TreeTableView.CONSTRAINED_RESIZE_POLICY) {
            maxWidth = Math.max(maxWidth, col.getWidth());
        }
        col.impl_setWidth(maxWidth);
    }

    @Override
    public int getItemCount() {
        return this.treeTableView.getExpandedItemCount();
    }

    @Override
    public TreeTableRow<S> createCell() {
        TreeTableRow<Object> cell = this.treeTableView.getRowFactory() != null ? this.treeTableView.getRowFactory().call(this.treeTableView) : new TreeTableRow();
        if (cell.getDisclosureNode() == null) {
            StackPane disclosureNode = new StackPane();
            disclosureNode.getStyleClass().setAll((String[])new String[]{"tree-disclosure-node"});
            disclosureNode.setMouseTransparent(true);
            StackPane disclosureNodeArrow = new StackPane();
            disclosureNodeArrow.getStyleClass().setAll((String[])new String[]{"arrow"});
            disclosureNode.getChildren().add(disclosureNodeArrow);
            cell.setDisclosureNode(disclosureNode);
        }
        cell.updateTreeTableView(this.treeTableView);
        return cell;
    }

    @Override
    protected void horizontalScroll() {
        super.horizontalScroll();
        if (((TreeTableView)this.getSkinnable()).getFixedCellSize() > 0.0) {
            this.flow.requestCellLayout();
        }
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case ROW_AT_INDEX: {
                int rowIndex = (Integer)parameters[0];
                return rowIndex < 0 ? null : this.flow.getPrivateCell(rowIndex);
            }
            case SELECTED_ITEMS: {
                ArrayList<TreeTableRow> selection = new ArrayList<TreeTableRow>();
                TreeTableView.TreeTableViewSelectionModel sm = ((TreeTableView)this.getSkinnable()).getSelectionModel();
                for (TreeTablePosition treeTablePosition : sm.getSelectedCells()) {
                    TreeTableRow row = (TreeTableRow)this.flow.getPrivateCell(treeTablePosition.getRow());
                    if (row == null) continue;
                    selection.add(row);
                }
                return FXCollections.observableArrayList(selection);
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    @Override
    protected void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
        switch (action) {
            case SHOW_ITEM: {
                Node item = (Node)parameters[0];
                if (!(item instanceof TreeTableCell)) break;
                TreeTableCell cell = (TreeTableCell)item;
                this.flow.show(cell.getIndex());
                break;
            }
            case SET_SELECTED_ITEMS: {
                TreeTableView.TreeTableViewSelectionModel sm;
                ObservableList items = (ObservableList)parameters[0];
                if (items == null || (sm = ((TreeTableView)this.getSkinnable()).getSelectionModel()) == null) break;
                sm.clearSelection();
                for (Node item : items) {
                    if (!(item instanceof TreeTableCell)) continue;
                    TreeTableCell cell = (TreeTableCell)item;
                    sm.select(cell.getIndex(), cell.getTableColumn());
                }
                break;
            }
            default: {
                super.executeAccessibleAction(action, parameters);
            }
        }
    }

    @Override
    protected void updateRowCount() {
        this.updatePlaceholderRegionVisibility();
        this.tableBackingList.resetSize();
        int oldCount = this.flow.getCellCount();
        int newCount = this.getItemCount();
        this.flow.setCellCount(newCount);
        if (this.forceCellRecreate) {
            this.needCellsRecreated = true;
            this.forceCellRecreate = false;
        } else if (newCount != oldCount) {
            this.needCellsRebuilt = true;
        } else {
            this.needCellsReconfigured = true;
        }
    }

    private /* synthetic */ void lambda$new$537(TreeItem.TreeModificationEvent e) {
        if (e.wasAdded() && e.wasRemoved() && e.getAddedSize() == e.getRemovedSize()) {
            this.rowCountDirty = true;
            ((TreeTableView)this.getSkinnable()).requestLayout();
        } else if (e.getEventType().equals(TreeItem.valueChangedEvent())) {
            this.needCellsRebuilt = true;
            ((TreeTableView)this.getSkinnable()).requestLayout();
        } else {
            for (EventType<? extends Event> eventType = e.getEventType(); eventType != null; eventType = eventType.getSuperType()) {
                if (!eventType.equals(TreeItem.expandedItemCountChangeEvent())) continue;
                this.rowCountDirty = true;
                ((TreeTableView)this.getSkinnable()).requestLayout();
                break;
            }
        }
        ((TreeTableView)this.getSkinnable()).edit(-1, null);
    }

    private /* synthetic */ void lambda$new$536() {
        this.onSelectRightCell();
    }

    private /* synthetic */ void lambda$new$535() {
        this.onSelectLeftCell();
    }

    private /* synthetic */ void lambda$new$534() {
        this.onSelectNextCell();
    }

    private /* synthetic */ void lambda$new$533() {
        this.onSelectPreviousCell();
    }

    private /* synthetic */ Integer lambda$new$532(Boolean isFocusDriven) {
        return this.onScrollPageUp(isFocusDriven);
    }

    private /* synthetic */ Integer lambda$new$531(Boolean isFocusDriven) {
        return this.onScrollPageDown(isFocusDriven);
    }

    private /* synthetic */ void lambda$new$530() {
        this.onMoveToLastCell();
    }

    private /* synthetic */ void lambda$new$529() {
        this.onMoveToFirstCell();
    }

    private /* synthetic */ void lambda$new$528() {
        this.onFocusNextCell();
    }

    private /* synthetic */ void lambda$new$527() {
        this.onFocusPreviousCell();
    }

    private static /* synthetic */ void lambda$new$526(TreeTableView treeTableView, MouseEvent event) {
        if (treeTableView.getEditingCell() != null) {
            treeTableView.edit(-1, null);
        }
        if (treeTableView.isFocusTraversable()) {
            treeTableView.requestFocus();
        }
    }

    static /* synthetic */ void access$lambda$0(TreeTableViewSkin treeTableViewSkin, TreeItem.TreeModificationEvent treeModificationEvent) {
        treeTableViewSkin.lambda$new$537(treeModificationEvent);
    }

    static /* synthetic */ void access$lambda$1(TreeTableView treeTableView, MouseEvent mouseEvent) {
        TreeTableViewSkin.lambda$new$526(treeTableView, mouseEvent);
    }

    static /* synthetic */ void access$lambda$2(TreeTableViewSkin treeTableViewSkin) {
        treeTableViewSkin.lambda$new$527();
    }

    static /* synthetic */ void access$lambda$3(TreeTableViewSkin treeTableViewSkin) {
        treeTableViewSkin.lambda$new$528();
    }

    static /* synthetic */ void access$lambda$4(TreeTableViewSkin treeTableViewSkin) {
        treeTableViewSkin.lambda$new$529();
    }

    static /* synthetic */ void access$lambda$5(TreeTableViewSkin treeTableViewSkin) {
        treeTableViewSkin.lambda$new$530();
    }

    static /* synthetic */ Integer access$lambda$6(TreeTableViewSkin treeTableViewSkin, Boolean bl) {
        return treeTableViewSkin.lambda$new$531(bl);
    }

    static /* synthetic */ Integer access$lambda$7(TreeTableViewSkin treeTableViewSkin, Boolean bl) {
        return treeTableViewSkin.lambda$new$532(bl);
    }

    static /* synthetic */ void access$lambda$8(TreeTableViewSkin treeTableViewSkin) {
        treeTableViewSkin.lambda$new$533();
    }

    static /* synthetic */ void access$lambda$9(TreeTableViewSkin treeTableViewSkin) {
        treeTableViewSkin.lambda$new$534();
    }

    static /* synthetic */ void access$lambda$10(TreeTableViewSkin treeTableViewSkin) {
        treeTableViewSkin.lambda$new$535();
    }

    static /* synthetic */ void access$lambda$11(TreeTableViewSkin treeTableViewSkin) {
        treeTableViewSkin.lambda$new$536();
    }

    private static class TreeTableViewBackingList<S>
    extends ReadOnlyUnbackedObservableList<TreeItem<S>> {
        private final TreeTableView<S> treeTable;
        private int size = -1;

        TreeTableViewBackingList(TreeTableView<S> treeTable) {
            this.treeTable = treeTable;
        }

        void resetSize() {
            int oldSize = this.size;
            this.size = -1;
            this.callObservers(new NonIterableChange.GenericAddRemoveChange(0, oldSize, FXCollections.emptyObservableList(), this));
        }

        @Override
        public TreeItem<S> get(int i) {
            return this.treeTable.getTreeItem(i);
        }

        @Override
        public int size() {
            if (this.size == -1) {
                this.size = this.treeTable.getExpandedItemCount();
            }
            return this.size;
        }
    }
}

