/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.skin.VirtualFlow;
import com.sun.javafx.scene.control.skin.VirtualScrollBar$$Lambda$1;
import com.sun.javafx.util.Utils;
import javafx.beans.Observable;
import javafx.scene.control.ScrollBar;

public class VirtualScrollBar
extends ScrollBar {
    private final VirtualFlow flow;
    private boolean virtual;
    private boolean adjusting;

    public VirtualScrollBar(VirtualFlow flow) {
        this.flow = flow;
        super.valueProperty().addListener(VirtualScrollBar$$Lambda$1.lambdaFactory$(this, flow));
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    @Override
    public void decrement() {
        if (this.isVirtual()) {
            this.flow.adjustPixels(-10.0);
        } else {
            super.decrement();
        }
    }

    @Override
    public void increment() {
        if (this.isVirtual()) {
            this.flow.adjustPixels(10.0);
        } else {
            super.increment();
        }
    }

    @Override
    public void adjustValue(double pos) {
        if (this.isVirtual()) {
            this.adjusting = true;
            double oldValue = this.flow.getPosition();
            double newValue = (this.getMax() - this.getMin()) * Utils.clamp(0.0, pos, 1.0) + this.getMin();
            if (newValue < oldValue) {
                Object cell = this.flow.getFirstVisibleCell();
                if (cell == null) {
                    return;
                }
                this.flow.showAsLast(cell);
            } else if (newValue > oldValue) {
                Object cell = this.flow.getLastVisibleCell();
                if (cell == null) {
                    return;
                }
                this.flow.showAsFirst(cell);
            }
            this.adjusting = false;
        } else {
            super.adjustValue(pos);
        }
    }

    private /* synthetic */ void lambda$new$101(VirtualFlow flow, Observable valueModel) {
        if (this.isVirtual() && !this.adjusting) {
            flow.setPosition(this.getValue());
        }
    }

    static /* synthetic */ void access$lambda$0(VirtualScrollBar virtualScrollBar, VirtualFlow virtualFlow, Observable observable) {
        virtualScrollBar.lambda$new$101(virtualFlow, observable);
    }
}

