/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Window;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.logging.PulseLogger;
import com.sun.javafx.tk.CompletionListener;
import com.sun.javafx.tk.RenderJob;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.PaintCollector$$Lambda$1;
import com.sun.javafx.tk.quantum.PaintCollector$$Lambda$2;
import com.sun.javafx.tk.quantum.PaintCollector$$Lambda$3;
import com.sun.javafx.tk.quantum.PaintRenderJob;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.javafx.tk.quantum.WindowStage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CountDownLatch;

final class PaintCollector
implements CompletionListener {
    private static volatile PaintCollector collector;
    private static final Comparator<GlassScene> DIRTY_SCENE_SORTER;
    private final List<GlassScene> dirtyScenes = new ArrayList<GlassScene>();
    private volatile CountDownLatch allWorkCompletedLatch = new CountDownLatch(0);
    private volatile boolean hasDirty;
    private final QuantumToolkit toolkit;
    private volatile boolean needsHint;

    static PaintCollector createInstance(QuantumToolkit toolkit) {
        collector = new PaintCollector(toolkit);
        return collector;
    }

    static PaintCollector getInstance() {
        return collector;
    }

    private PaintCollector(QuantumToolkit qt) {
        this.toolkit = qt;
    }

    void waitForRenderingToComplete() {
        while (true) {
            try {
                this.allWorkCompletedLatch.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    final boolean hasDirty() {
        return this.hasDirty;
    }

    final void addDirtyScene(GlassScene scene) {
        assert (Thread.currentThread() == QuantumToolkit.getFxUserThread());
        assert (scene != null);
        if (QuantumToolkit.verbose) {
            System.err.println("PC.addDirtyScene: " + System.nanoTime() + scene);
        }
        if (!this.dirtyScenes.contains(scene)) {
            this.dirtyScenes.add(scene);
            this.hasDirty = true;
        }
    }

    final void removeDirtyScene(GlassScene scene) {
        assert (Thread.currentThread() == QuantumToolkit.getFxUserThread());
        assert (scene != null);
        if (QuantumToolkit.verbose) {
            System.err.println("PC.removeDirtyScene: " + scene);
        }
        this.dirtyScenes.remove(scene);
        this.hasDirty = !this.dirtyScenes.isEmpty();
    }

    final CompletionListener getRendered() {
        return this;
    }

    @Override
    public void done(RenderJob job) {
        assert (Thread.currentThread() != QuantumToolkit.getFxUserThread());
        if (!(job instanceof PaintRenderJob)) {
            throw new IllegalArgumentException("PaintCollector: invalid RenderJob");
        }
        PaintRenderJob paintjob = (PaintRenderJob)job;
        GlassScene scene = paintjob.getScene();
        if (scene == null) {
            throw new IllegalArgumentException("PaintCollector: null scene");
        }
        scene.frameRendered();
        if (this.allWorkCompletedLatch.getCount() == 1L) {
            if (this.needsHint && !this.toolkit.hasNativeSystemVsync()) {
                this.toolkit.vsyncHint();
            }
            Application.GetApplication().notifyRenderingFinished();
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.renderEnd();
            }
        }
        this.allWorkCompletedLatch.countDown();
    }

    final void liveRepaintRenderJob(ViewScene scene) {
        ViewPainter viewPainter = scene.getPainter();
        QuantumToolkit quantum = (QuantumToolkit)QuantumToolkit.getToolkit();
        quantum.pulse(false);
        CountDownLatch latch = new CountDownLatch(1);
        QuantumToolkit.runWithoutRenderLock(PaintCollector$$Lambda$1.lambdaFactory$(quantum, viewPainter, latch));
    }

    final void renderAll() {
        assert (Thread.currentThread() == QuantumToolkit.getFxUserThread());
        if (QuantumToolkit.pulseDebug) {
            System.err.println("PC.renderAll(" + this.dirtyScenes.size() + "): " + System.nanoTime());
        }
        if (!this.hasDirty) {
            return;
        }
        assert (!this.dirtyScenes.isEmpty());
        Collections.sort(this.dirtyScenes, DIRTY_SCENE_SORTER);
        this.hasDirty = false;
        this.needsHint = false;
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.renderStart();
        }
        if (!Application.GetApplication().hasWindowManager()) {
            List<Window> glassWindowList = Window.getWindows();
            this.allWorkCompletedLatch = new CountDownLatch(glassWindowList.size());
            int n = glassWindowList.size();
            for (int i = 0; i < n; ++i) {
                Window w = glassWindowList.get(i);
                WindowStage ws = WindowStage.findWindowStage(w);
                if (ws == null) continue;
                ViewScene vs = ws.getViewScene();
                if (this.dirtyScenes.indexOf(vs) != -1 && !this.needsHint) {
                    this.needsHint = vs.isSynchronous();
                }
                if (!PlatformUtil.useEGL() || i == n - 1) {
                    vs.setDoPresent(true);
                } else {
                    vs.setDoPresent(false);
                }
                try {
                    vs.repaint();
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        } else {
            this.allWorkCompletedLatch = new CountDownLatch(this.dirtyScenes.size());
            for (GlassScene gs : this.dirtyScenes) {
                if (!this.needsHint) {
                    this.needsHint = gs.isSynchronous();
                }
                gs.setDoPresent(true);
                try {
                    gs.repaint();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        this.dirtyScenes.clear();
        if (this.toolkit.shouldWaitForRenderingToComplete()) {
            this.waitForRenderingToComplete();
        }
    }

    private static /* synthetic */ Object lambda$liveRepaintRenderJob$368(QuantumToolkit quantum, ViewPainter viewPainter, CountDownLatch latch) {
        quantum.addRenderJob(new RenderJob((Runnable)viewPainter, PaintCollector$$Lambda$2.lambdaFactory$(latch)));
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    private static /* synthetic */ int lambda$static$366(GlassScene o1, GlassScene o2) {
        int i1 = o1.isSynchronous() ? 1 : 0;
        int i2 = o2.isSynchronous() ? 1 : 0;
        return i1 - i2;
    }

    static {
        DIRTY_SCENE_SORTER = PaintCollector$$Lambda$3.lambdaFactory$();
    }

    static /* synthetic */ Object access$lambda$0(QuantumToolkit quantumToolkit, ViewPainter viewPainter, CountDownLatch countDownLatch) {
        return PaintCollector.lambda$liveRepaintRenderJob$368(quantumToolkit, viewPainter, countDownLatch);
    }

    static /* synthetic */ void access$lambda$1(CountDownLatch countDownLatch, RenderJob renderJob) {
        countDownLatch.countDown();
    }

    static /* synthetic */ int access$lambda$2(GlassScene glassScene, GlassScene glassScene2) {
        return PaintCollector.lambda$static$366(glassScene, glassScene2);
    }
}

