/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmedia.locator;

import com.sun.media.jfxmedia.MediaException;
import com.sun.media.jfxmedia.MediaManager;
import com.sun.media.jfxmedia.locator.ConnectionHolder;
import com.sun.media.jfxmedia.locator.Locator$$Lambda$1;
import com.sun.media.jfxmedia.locator.LocatorCache;
import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmediaimpl.HostUtils;
import com.sun.media.jfxmediaimpl.MediaUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;

public class Locator {
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private static final int MAX_CONNECTION_ATTEMPTS = 5;
    private static final long CONNECTION_RETRY_INTERVAL = 1000L;
    protected String contentType = "application/octet-stream";
    protected long contentLength = -1L;
    protected URI uri;
    private Map<String, Object> connectionProperties;
    private final Object propertyLock = new Object();
    private String uriString = null;
    private String scheme = null;
    private String protocol = null;
    private LocatorCache.CacheReference cacheEntry = null;
    private boolean canBlock = false;
    private CountDownLatch readySignal = new CountDownLatch(1);
    private boolean isIpod;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocatorConnection getConnection(URI uri, String requestMethod) throws MalformedURLException, IOException {
        LocatorConnection locatorConnection = new LocatorConnection();
        HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection();
        connection.setRequestMethod(requestMethod);
        Object object = this.propertyLock;
        synchronized (object) {
            if (this.connectionProperties != null) {
                for (String key : this.connectionProperties.keySet()) {
                    Object value = this.connectionProperties.get(key);
                    if (!(value instanceof String)) continue;
                    connection.setRequestProperty(key, (String)value);
                }
            }
        }
        locatorConnection.responseCode = connection.getResponseCode();
        if (connection.getResponseCode() == 200) {
            locatorConnection.connection = connection;
        } else {
            Locator.closeConnection(connection);
            locatorConnection.connection = null;
        }
        return locatorConnection;
    }

    private static long getContentLengthLong(URLConnection connection) {
        Method method = (Method)AccessController.doPrivileged(Locator$$Lambda$1.lambdaFactory$(connection));
        try {
            if (method != null) {
                return (Long)method.invoke((Object)connection, new Object[0]);
            }
            return connection.getContentLength();
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            return -1L;
        }
    }

    public Locator(URI uri) throws URISyntaxException {
        if (uri == null) {
            throw new NullPointerException("uri == null!");
        }
        this.uriString = uri.toASCIIString();
        this.scheme = uri.getScheme();
        if (this.scheme == null) {
            throw new IllegalArgumentException("uri.getScheme() == null! uri == '" + uri + "'");
        }
        this.scheme = this.scheme.toLowerCase();
        if (this.scheme.equals("jar")) {
            URI subURI = new URI(this.uriString.substring(4));
            this.protocol = subURI.getScheme();
            if (this.protocol == null) {
                throw new IllegalArgumentException("uri.getScheme() == null! subURI == '" + subURI + "'");
            }
            this.protocol = this.protocol.toLowerCase();
        } else {
            this.protocol = this.scheme;
        }
        if (HostUtils.isIOS() && this.protocol.equals("ipod-library")) {
            this.isIpod = true;
        }
        if (!(this.isIpod || this.protocol.equals("file") || this.protocol.equals("http"))) {
            throw new UnsupportedOperationException("Unsupported protocol \"" + this.protocol + "\"");
        }
        if (this.protocol.equals("http")) {
            this.canBlock = true;
        }
        this.uri = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getInputStream(URI uri) throws MalformedURLException, IOException {
        URL url = uri.toURL();
        URLConnection connection = url.openConnection();
        Object object = this.propertyLock;
        synchronized (object) {
            if (this.connectionProperties != null) {
                for (String key : this.connectionProperties.keySet()) {
                    Object value = this.connectionProperties.get(key);
                    if (!(value instanceof String)) continue;
                    connection.setRequestProperty(key, (String)value);
                }
            }
        }
        InputStream inputStream = url.openStream();
        this.contentLength = Locator.getContentLengthLong(connection);
        return inputStream;
    }

    public void cacheMedia() {
        LocatorCache.CacheReference ref = LocatorCache.locatorCache().fetchURICache(this.uri);
        if (null == ref) {
            InputStream is;
            try {
                is = this.getInputStream(this.uri);
            }
            catch (Throwable t) {
                return;
            }
            ByteBuffer cacheBuffer = ByteBuffer.allocateDirect((int)this.contentLength);
            byte[] readBuf = new byte[8192];
            int total = 0;
            while ((long)total < this.contentLength) {
                int count;
                try {
                    count = is.read(readBuf);
                }
                catch (IOException ioe) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (Logger.canLog(1)) {
                        Logger.logMsg(1, "IOException trying to preload media: " + ioe);
                    }
                    return;
                }
                if (count == -1) break;
                cacheBuffer.put(readBuf, 0, count);
            }
            try {
                is.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.cacheEntry = LocatorCache.locatorCache().registerURICache(this.uri, cacheBuffer, this.contentType);
            this.canBlock = false;
        }
    }

    public boolean canBlock() {
        return this.canBlock;
    }

    public void init() throws URISyntaxException, IOException, FileNotFoundException {
        try {
            int index;
            int firstSlash = this.uriString.indexOf("/");
            if (firstSlash != -1 && this.uriString.charAt(firstSlash + 1) != '/') {
                if (this.protocol.equals("file")) {
                    this.uriString = this.uriString.replaceFirst("/", "///");
                } else if (this.protocol.equals("http")) {
                    this.uriString = this.uriString.replaceFirst("/", "//");
                }
            }
            if (System.getProperty("os.name").toLowerCase().indexOf("win") == -1 && this.protocol.equals("file") && (index = this.uriString.indexOf("/~/")) != -1) {
                this.uriString = this.uriString.substring(0, index) + System.getProperty("user.home") + this.uriString.substring(index + 2);
            }
            this.uri = new URI(this.uriString);
            this.cacheEntry = LocatorCache.locatorCache().fetchURICache(this.uri);
            if (null != this.cacheEntry) {
                this.contentType = this.cacheEntry.getMIMEType();
                this.contentLength = this.cacheEntry.getBuffer().capacity();
                if (Logger.canLog(1)) {
                    Logger.logMsg(1, "Locator init cache hit:\n    uri " + this.uri + "\n    type " + this.contentType + "\n    length " + this.contentLength);
                }
                return;
            }
            boolean isConnected = false;
            boolean isMediaUnAvailable = false;
            boolean isMediaSupported = true;
            if (!this.isIpod) {
                for (int numConnectionAttempts = 0; numConnectionAttempts < 5; ++numConnectionAttempts) {
                    block38: {
                        try {
                            if (this.scheme.equals("http")) {
                                LocatorConnection locatorConnection = this.getConnection(this.uri, "HEAD");
                                if (locatorConnection == null || locatorConnection.connection == null) {
                                    locatorConnection = this.getConnection(this.uri, "GET");
                                }
                                if (locatorConnection != null && locatorConnection.connection != null) {
                                    isConnected = true;
                                    this.contentType = locatorConnection.connection.getContentType();
                                    this.contentLength = Locator.getContentLengthLong(locatorConnection.connection);
                                    Locator.closeConnection(locatorConnection.connection);
                                    locatorConnection.connection = null;
                                } else if (locatorConnection != null && locatorConnection.responseCode == 404) {
                                    isMediaUnAvailable = true;
                                }
                            } else if (this.scheme.equals("file") || this.scheme.equals("jar")) {
                                InputStream stream = this.getInputStream(this.uri);
                                stream.close();
                                isConnected = true;
                                this.contentType = MediaUtils.filenameToContentType(this.uriString);
                            }
                            if (!isConnected) break block38;
                            if ("audio/x-wav".equals(this.contentType)) {
                                this.contentType = this.getContentTypeFromFileSignature(this.uri);
                                if (!MediaManager.canPlayContentType(this.contentType)) {
                                    isMediaSupported = false;
                                }
                            } else if (this.contentType == null || !MediaManager.canPlayContentType(this.contentType)) {
                                this.contentType = MediaUtils.filenameToContentType(this.uriString);
                                if (DEFAULT_CONTENT_TYPE.equals(this.contentType)) {
                                    this.contentType = this.getContentTypeFromFileSignature(this.uri);
                                }
                                if (!MediaManager.canPlayContentType(this.contentType)) {
                                    isMediaSupported = false;
                                }
                            }
                            break;
                        }
                        catch (IOException ioe) {
                            if (numConnectionAttempts + 1 < 5) break block38;
                            throw ioe;
                        }
                    }
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            } else {
                this.contentType = MediaUtils.filenameToContentType(this.uriString);
            }
            if (!this.isIpod && !isConnected) {
                if (isMediaUnAvailable) {
                    throw new FileNotFoundException("media is unavailable (" + this.uri.toString() + ")");
                }
                throw new IOException("could not connect to media (" + this.uri.toString() + ")");
            }
            if (!isMediaSupported) {
                throw new MediaException("media type not supported (" + this.uri.toString() + ")");
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (MediaException e) {
            throw e;
        }
        finally {
            this.readySignal.countDown();
        }
    }

    public String getContentType() {
        try {
            this.readySignal.await();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.contentType;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public long getContentLength() {
        try {
            this.readySignal.await();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.contentLength;
    }

    public void waitForReadySignal() {
        try {
            this.readySignal.await();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public String toString() {
        if (LocatorCache.locatorCache().isCached(this.uri)) {
            return "{LocatorURI uri: " + this.uri.toString() + " (media cached)}";
        }
        return "{LocatorURI uri: " + this.uri.toString() + "}";
    }

    public String getStringLocation() {
        return this.uri.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionProperty(String property, Object value) {
        Object object = this.propertyLock;
        synchronized (object) {
            if (this.connectionProperties == null) {
                this.connectionProperties = new TreeMap<String, Object>();
            }
            this.connectionProperties.put(property, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionHolder createConnectionHolder() throws IOException {
        ConnectionHolder holder;
        if (null != this.cacheEntry) {
            if (Logger.canLog(1)) {
                Logger.logMsg(1, "Locator.createConnectionHolder: media cached, creating memory connection holder");
            }
            return ConnectionHolder.createMemoryConnectionHolder(this.cacheEntry.getBuffer());
        }
        if ("file".equals(this.scheme)) {
            holder = ConnectionHolder.createFileConnectionHolder(this.uri);
        } else if (this.uri.toString().endsWith(".m3u8") || this.uri.toString().endsWith(".m3u")) {
            holder = ConnectionHolder.createHLSConnectionHolder(this.uri);
        } else {
            Object object = this.propertyLock;
            synchronized (object) {
                holder = ConnectionHolder.createURIConnectionHolder(this.uri, this.connectionProperties);
            }
        }
        return holder;
    }

    private String getContentTypeFromFileSignature(URI uri) throws MalformedURLException, IOException {
        InputStream stream = this.getInputStream(uri);
        byte[] signature = new byte[22];
        int size = stream.read(signature);
        stream.close();
        return MediaUtils.fileSignatureToContentType(signature, size);
    }

    static void closeConnection(URLConnection connection) {
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            try {
                if (httpConnection.getResponseCode() < 400 && httpConnection.getInputStream() != null) {
                    httpConnection.getInputStream().close();
                }
            }
            catch (IOException ex) {
                try {
                    if (httpConnection.getErrorStream() != null) {
                        httpConnection.getErrorStream().close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private static /* synthetic */ Method lambda$getContentLengthLong$1(URLConnection connection) {
        try {
            return connection.getClass().getMethod("getContentLengthLong", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    static /* synthetic */ Method access$lambda$0(URLConnection uRLConnection) {
        return Locator.lambda$getContentLengthLong$1(uRLConnection);
    }

    private static class LocatorConnection {
        public HttpURLConnection connection = null;
        public int responseCode = 200;

        private LocatorConnection() {
        }
    }
}

