/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl;

import com.sun.media.jfxmedia.MediaManager;
import com.sun.media.jfxmedia.MediaPlayer;
import com.sun.media.jfxmedia.events.MediaErrorListener;
import com.sun.media.jfxmedia.events.PlayerStateEvent;
import com.sun.media.jfxmedia.events.PlayerStateListener;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmediaimpl.NativeMediaAudioClip;
import com.sun.media.jfxmediaimpl.NativeMediaAudioClipPlayer$Enthreaderator$$Lambda$1;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

final class NativeMediaAudioClipPlayer
implements PlayerStateListener,
MediaErrorListener {
    private MediaPlayer mediaPlayer;
    private int playCount;
    private int loopCount;
    private boolean playing;
    private boolean ready;
    private NativeMediaAudioClip sourceClip;
    private double volume;
    private double balance;
    private double pan;
    private double rate;
    private int priority;
    private final ReentrantLock playerStateLock = new ReentrantLock();
    private static final int MAX_PLAYER_COUNT = 16;
    private static final List<NativeMediaAudioClipPlayer> activePlayers = new ArrayList<NativeMediaAudioClipPlayer>(16);
    private static final ReentrantLock playerListLock = new ReentrantLock();
    private static final LinkedBlockingQueue<SchedulerEntry> schedule = new LinkedBlockingQueue();

    public static int getPlayerLimit() {
        return 16;
    }

    public static int getPlayerCount() {
        return activePlayers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clipScheduler() {
        while (true) {
            SchedulerEntry entry = null;
            try {
                entry = schedule.take();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (null == entry) continue;
            if (entry.getCommand() == 0) {
                NativeMediaAudioClipPlayer player = entry.getPlayer();
                if (null != player) {
                    if (NativeMediaAudioClipPlayer.addPlayer(player)) {
                        player.play();
                    } else {
                        player.sourceClip.playFinished();
                    }
                }
            } else if (entry.getCommand() == 1) {
                URI sourceURI = entry.getClipURI();
                playerListLock.lock();
                try {
                    NativeMediaAudioClipPlayer[] players = new NativeMediaAudioClipPlayer[16];
                    players = activePlayers.toArray(players);
                    if (null != players) {
                        for (int index = 0; index < players.length; ++index) {
                            if (null == players[index] || null != sourceURI && !players[index].source().getURI().equals(sourceURI)) continue;
                            players[index].invalidate();
                        }
                    }
                }
                finally {
                    playerListLock.unlock();
                }
                boolean clearSchedule = null == sourceURI;
                for (SchedulerEntry killEntry : schedule) {
                    NativeMediaAudioClipPlayer player = killEntry.getPlayer();
                    if (!clearSchedule && (null == player || !player.sourceClip.getLocator().getURI().equals(sourceURI))) continue;
                    schedule.remove(killEntry);
                    player.sourceClip.playFinished();
                }
            } else if (entry.getCommand() == 2) {
                entry.getMediaPlayer().dispose();
            }
            entry.signal();
        }
    }

    public static void playClip(NativeMediaAudioClip clip, double volume, double balance, double rate, double pan, int loopCount, int priority) {
        Enthreaderator.getSchedulerThread();
        NativeMediaAudioClipPlayer newPlayer = new NativeMediaAudioClipPlayer(clip, volume, balance, rate, pan, loopCount, priority);
        SchedulerEntry entry = new SchedulerEntry(newPlayer);
        boolean scheduled = schedule.contains(entry);
        if (scheduled || !schedule.offer(entry)) {
            if (Logger.canLog(1) && !scheduled) {
                Logger.logMsg(1, "AudioClip could not be scheduled for playback!");
            }
            clip.playFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addPlayer(NativeMediaAudioClipPlayer newPlayer) {
        playerListLock.lock();
        try {
            int priority = newPlayer.priority();
            while (activePlayers.size() >= 16) {
                NativeMediaAudioClipPlayer target = null;
                for (NativeMediaAudioClipPlayer player : activePlayers) {
                    if (player.priority() > priority || target != null && (!target.isReady() || player.priority() >= target.priority())) continue;
                    target = player;
                }
                if (null == target) {
                    boolean bl = false;
                    return bl;
                }
                target.invalidate();
            }
            activePlayers.add(newPlayer);
        }
        finally {
            playerListLock.unlock();
        }
        return true;
    }

    public static void stopPlayers(Locator source) {
        CountDownLatch stopSignal;
        SchedulerEntry entry;
        URI sourceURI;
        URI uRI = sourceURI = source != null ? source.getURI() : null;
        if (null != Enthreaderator.getSchedulerThread() && schedule.offer(entry = new SchedulerEntry(sourceURI, stopSignal = new CountDownLatch(1)))) {
            try {
                stopSignal.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private NativeMediaAudioClipPlayer(NativeMediaAudioClip clip, double volume, double balance, double rate, double pan, int loopCount, int priority) {
        this.sourceClip = clip;
        this.volume = volume;
        this.balance = balance;
        this.pan = pan;
        this.rate = rate;
        this.loopCount = loopCount;
        this.priority = priority;
        this.ready = false;
    }

    private Locator source() {
        return this.sourceClip.getLocator();
    }

    public double volume() {
        return this.volume;
    }

    public void setVolume(double volume) {
        this.volume = volume;
    }

    public double balance() {
        return this.balance;
    }

    public void setBalance(double balance) {
        this.balance = balance;
    }

    public double pan() {
        return this.pan;
    }

    public void setPan(double pan) {
        this.pan = pan;
    }

    public double playbackRate() {
        return this.rate;
    }

    public void setPlaybackRate(double rate) {
        this.rate = rate;
    }

    public int priority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int loopCount() {
        return this.loopCount;
    }

    public void setLoopCount(int loopCount) {
        this.loopCount = loopCount;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    private boolean isReady() {
        return this.ready;
    }

    public synchronized void play() {
        this.playerStateLock.lock();
        try {
            this.playing = true;
            this.playCount = 0;
            if (null == this.mediaPlayer) {
                this.mediaPlayer = MediaManager.getPlayer(this.source());
                this.mediaPlayer.addMediaPlayerListener(this);
                this.mediaPlayer.addMediaErrorListener(this);
            } else {
                this.mediaPlayer.play();
            }
        }
        finally {
            this.playerStateLock.unlock();
        }
    }

    public void stop() {
        this.invalidate();
    }

    public synchronized void invalidate() {
        this.playerStateLock.lock();
        playerListLock.lock();
        try {
            this.playing = false;
            this.playCount = 0;
            this.ready = false;
            activePlayers.remove(this);
            this.sourceClip.playFinished();
            if (null != this.mediaPlayer) {
                this.mediaPlayer.removeMediaPlayerListener(this);
                this.mediaPlayer.setMute(true);
                SchedulerEntry entry = new SchedulerEntry(this.mediaPlayer);
                if (!schedule.offer(entry)) {
                    this.mediaPlayer.dispose();
                }
                this.mediaPlayer = null;
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            playerListLock.unlock();
            this.playerStateLock.unlock();
        }
    }

    @Override
    public void onReady(PlayerStateEvent evt) {
        this.playerStateLock.lock();
        try {
            this.ready = true;
            if (this.playing) {
                this.mediaPlayer.setVolume((float)this.volume);
                this.mediaPlayer.setBalance((float)this.balance);
                this.mediaPlayer.setRate((float)this.rate);
                this.mediaPlayer.play();
            }
        }
        finally {
            this.playerStateLock.unlock();
        }
    }

    @Override
    public void onPlaying(PlayerStateEvent evt) {
    }

    @Override
    public void onPause(PlayerStateEvent evt) {
    }

    @Override
    public void onStop(PlayerStateEvent evt) {
        this.invalidate();
    }

    @Override
    public void onStall(PlayerStateEvent evt) {
    }

    @Override
    public void onFinish(PlayerStateEvent evt) {
        this.playerStateLock.lock();
        try {
            if (this.playing) {
                if (this.loopCount != -1) {
                    ++this.playCount;
                    if (this.playCount <= this.loopCount) {
                        this.mediaPlayer.seek(0.0);
                    } else {
                        this.invalidate();
                    }
                } else {
                    this.mediaPlayer.seek(0.0);
                }
            }
        }
        finally {
            this.playerStateLock.unlock();
        }
    }

    @Override
    public void onHalt(PlayerStateEvent evt) {
        this.invalidate();
    }

    public void onWarning(Object source, String message) {
    }

    @Override
    public void onError(Object source, int errorCode, String message) {
        if (Logger.canLog(4)) {
            Logger.logMsg(4, "Error with AudioClip player: code " + errorCode + " : " + message);
        }
        this.invalidate();
    }

    public boolean equals(Object that) {
        if (that == this) {
            return true;
        }
        if (that instanceof NativeMediaAudioClipPlayer) {
            URI otherURI;
            NativeMediaAudioClipPlayer otherPlayer = (NativeMediaAudioClipPlayer)that;
            URI myURI = this.sourceClip.getLocator().getURI();
            return myURI.equals(otherURI = otherPlayer.sourceClip.getLocator().getURI()) && this.priority == otherPlayer.priority && this.loopCount == otherPlayer.loopCount && Double.compare(this.volume, otherPlayer.volume) == 0 && Double.compare(this.balance, otherPlayer.balance) == 0 && Double.compare(this.rate, otherPlayer.rate) == 0 && Double.compare(this.pan, otherPlayer.pan) == 0;
        }
        return false;
    }

    private static class SchedulerEntry {
        private final int command;
        private final NativeMediaAudioClipPlayer player;
        private final URI clipURI;
        private final CountDownLatch commandSignal;
        private final MediaPlayer mediaPlayer;

        public SchedulerEntry(NativeMediaAudioClipPlayer player) {
            this.command = 0;
            this.player = player;
            this.clipURI = null;
            this.commandSignal = null;
            this.mediaPlayer = null;
        }

        public SchedulerEntry(URI sourceURI, CountDownLatch signal) {
            this.command = 1;
            this.player = null;
            this.clipURI = sourceURI;
            this.commandSignal = signal;
            this.mediaPlayer = null;
        }

        public SchedulerEntry(MediaPlayer mediaPlayer) {
            this.command = 2;
            this.player = null;
            this.clipURI = null;
            this.commandSignal = null;
            this.mediaPlayer = mediaPlayer;
        }

        public int getCommand() {
            return this.command;
        }

        public NativeMediaAudioClipPlayer getPlayer() {
            return this.player;
        }

        public URI getClipURI() {
            return this.clipURI;
        }

        public MediaPlayer getMediaPlayer() {
            return this.mediaPlayer;
        }

        public void signal() {
            if (null != this.commandSignal) {
                this.commandSignal.countDown();
            }
        }

        public boolean equals(Object other) {
            if (other instanceof SchedulerEntry && null != this.player) {
                return this.player.equals(((SchedulerEntry)other).getPlayer());
            }
            return false;
        }
    }

    private static class Enthreaderator {
        private static final Thread schedulerThread = new Thread(NativeMediaAudioClipPlayer$Enthreaderator$$Lambda$1.lambdaFactory$());

        private Enthreaderator() {
        }

        public static Thread getSchedulerThread() {
            return schedulerThread;
        }

        private static /* synthetic */ void lambda$static$4() {
            NativeMediaAudioClipPlayer.clipScheduler();
        }

        static {
            schedulerThread.setDaemon(true);
            schedulerThread.start();
        }

        static /* synthetic */ void access$lambda$0() {
            Enthreaderator.lambda$static$4();
        }
    }
}

