/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.javafx.PlatformUtil;
import com.sun.prism.Image;
import com.sun.prism.MediaFrame;
import com.sun.prism.MultiTexture;
import com.sun.prism.PixelFormat;
import com.sun.prism.Texture;
import com.sun.prism.es2.ES2Context;
import com.sun.prism.es2.ES2Pipeline;
import com.sun.prism.es2.ES2TextureData;
import com.sun.prism.es2.ES2TextureResource;
import com.sun.prism.es2.ES2VramPool;
import com.sun.prism.es2.GLContext;
import com.sun.prism.impl.BaseTexture;
import com.sun.prism.impl.BufferUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

class ES2Texture<T extends ES2TextureData>
extends BaseTexture<ES2TextureResource<T>> {
    final ES2Context context;

    ES2Texture(ES2Context context, ES2TextureResource<T> resource, PixelFormat format, Texture.WrapMode wrapMode, int physicalWidth, int physicalHeight, int contentX, int contentY, int contentWidth, int contentHeight, boolean useMipmap) {
        super(resource, format, wrapMode, physicalWidth, physicalHeight, contentX, contentY, contentWidth, contentHeight, useMipmap);
        this.context = context;
    }

    ES2Texture(ES2Context context, ES2TextureResource<T> resource, PixelFormat format, Texture.WrapMode wrapMode, int physicalWidth, int physicalHeight, int contentX, int contentY, int contentWidth, int contentHeight, int maxContentWidth, int maxContentHeight, boolean useMipmap) {
        super(resource, format, wrapMode, physicalWidth, physicalHeight, contentX, contentY, contentWidth, contentHeight, maxContentWidth, maxContentHeight, useMipmap);
        this.context = context;
    }

    private ES2Texture(ES2Texture sharedTex, Texture.WrapMode newMode) {
        super(sharedTex, newMode, false);
        this.context = sharedTex.context;
    }

    @Override
    protected Texture createSharedTexture(Texture.WrapMode newMode) {
        return new ES2Texture<T>(this, newMode);
    }

    static int nextPowerOfTwo(int val, int max) {
        int i;
        if (val > max) {
            return 0;
        }
        for (i = 1; i < val; i *= 2) {
        }
        return i;
    }

    static ES2Texture create(ES2Context context, PixelFormat format, Texture.WrapMode wrapMode, int w, int h, boolean useMipmap) {
        long size;
        ES2VramPool pool;
        int texHeight;
        int texWidth;
        int contentY;
        int contentX;
        if (!context.getResourceFactory().isFormatSupported(format)) {
            throw new UnsupportedOperationException("Pixel format " + (Object)((Object)format) + " not supported on this device");
        }
        if (format == PixelFormat.MULTI_YCbCr_420) {
            throw new IllegalArgumentException("Format requires multitexturing: " + (Object)((Object)format));
        }
        GLContext glCtx = context.getGLContext();
        switch (wrapMode) {
            case CLAMP_TO_ZERO: {
                if (glCtx.canClampToZero()) break;
                wrapMode = wrapMode.simulatedVersion();
                break;
            }
            case CLAMP_TO_EDGE: 
            case REPEAT: {
                if (glCtx.canCreateNonPowTwoTextures() || (w & w - 1) == 0 && (h & h - 1) == 0) break;
                wrapMode = wrapMode.simulatedVersion();
                break;
            }
            case CLAMP_NOT_NEEDED: {
                break;
            }
            case CLAMP_TO_EDGE_SIMULATED: 
            case CLAMP_TO_ZERO_SIMULATED: 
            case REPEAT_SIMULATED: {
                throw new IllegalArgumentException("Cannot request simulated wrap mode: " + (Object)((Object)wrapMode));
            }
        }
        int maxSize = glCtx.getMaxTextureSize();
        int contentW = w;
        int contentH = h;
        switch (wrapMode) {
            case CLAMP_TO_ZERO_SIMULATED: {
                contentX = 1;
                contentY = 1;
                texWidth = contentW + 2;
                texHeight = contentH + 2;
                break;
            }
            case CLAMP_TO_EDGE_SIMULATED: 
            case REPEAT_SIMULATED: {
                contentX = 0;
                contentY = 0;
                texWidth = contentW;
                texHeight = contentH;
                if ((w & w - 1) != 0) {
                    ++texWidth;
                }
                if ((h & h - 1) == 0) break;
                ++texHeight;
                break;
            }
            default: {
                contentX = 0;
                contentY = 0;
                texWidth = contentW;
                texHeight = contentH;
            }
        }
        if (texWidth > maxSize || texHeight > maxSize) {
            throw new RuntimeException("Requested texture dimensions (" + w + "x" + h + ") " + "require dimensions (" + texWidth + "x" + texHeight + ") " + "that exceed maximum texture size (" + maxSize + ")");
        }
        if (!glCtx.canCreateNonPowTwoTextures()) {
            texWidth = ES2Texture.nextPowerOfTwo(texWidth, maxSize);
            texHeight = ES2Texture.nextPowerOfTwo(texHeight, maxSize);
        }
        if (!(pool = ES2VramPool.instance).prepareForAllocation(size = pool.estimateTextureSize(texWidth, texHeight, format))) {
            return null;
        }
        int savedTex = glCtx.getBoundTexture();
        ES2TextureData texData = new ES2TextureData(context, glCtx.genAndBindTexture(), texWidth, texHeight, size);
        ES2TextureResource<ES2TextureData> texRes = new ES2TextureResource<ES2TextureData>(texData);
        boolean result = ES2Texture.uploadPixels(glCtx, 50, null, format, texWidth, texHeight, contentX, contentY, 0, 0, contentW, contentH, 0, true, useMipmap);
        glCtx.texParamsMinMax(53, useMipmap);
        glCtx.setBoundTexture(savedTex);
        if (!result) {
            return null;
        }
        return new ES2Texture<ES2TextureData>(context, texRes, format, wrapMode, texWidth, texHeight, contentX, contentY, contentW, contentH, useMipmap);
    }

    public static Texture create(ES2Context context, MediaFrame frame) {
        long size;
        ES2VramPool pool;
        frame.holdFrame();
        PixelFormat format = frame.getPixelFormat();
        if (frame.getPixelFormat() == PixelFormat.MULTI_YCbCr_420) {
            int width = frame.getEncodedWidth();
            int height = frame.getEncodedHeight();
            int planeCount = frame.planeCount();
            MultiTexture tex = new MultiTexture(format, Texture.WrapMode.CLAMP_TO_EDGE, frame.getWidth(), frame.getHeight());
            for (int index = 0; index < planeCount; ++index) {
                ES2Texture subTex;
                int subWidth = width;
                int subHeight = height;
                if (index == 2 || index == 1) {
                    subWidth /= 2;
                    subHeight /= 2;
                }
                if ((subTex = ES2Texture.create(context, PixelFormat.BYTE_ALPHA, Texture.WrapMode.CLAMP_TO_EDGE, subWidth, subHeight, false)) == null) continue;
                tex.setTexture(subTex, index);
            }
            frame.releaseFrame();
            return tex;
        }
        GLContext glCtx = context.getGLContext();
        int maxSize = glCtx.getMaxTextureSize();
        int encodedHeight = frame.getEncodedHeight();
        int texWidth = frame.getEncodedWidth();
        int texHeight = encodedHeight;
        format = frame.getPixelFormat();
        if (!glCtx.canCreateNonPowTwoTextures()) {
            texWidth = ES2Texture.nextPowerOfTwo(texWidth, maxSize);
            texHeight = ES2Texture.nextPowerOfTwo(texHeight, maxSize);
        }
        if (!(pool = ES2VramPool.instance).prepareForAllocation(size = pool.estimateTextureSize(texWidth, texHeight, format))) {
            return null;
        }
        int savedTex = glCtx.getBoundTexture();
        ES2TextureData texData = new ES2TextureData(context, glCtx.genAndBindTexture(), texWidth, texHeight, size);
        ES2TextureResource<ES2TextureData> texRes = new ES2TextureResource<ES2TextureData>(texData);
        boolean result = ES2Texture.uploadPixels(context.getGLContext(), 50, frame, texWidth, texHeight, true);
        glCtx.texParamsMinMax(53, false);
        glCtx.setBoundTexture(savedTex);
        ES2Texture<ES2TextureData> tex = null;
        if (result) {
            tex = new ES2Texture<ES2TextureData>(context, texRes, format, Texture.WrapMode.CLAMP_TO_EDGE, texWidth, texHeight, 0, 0, frame.getWidth(), frame.getHeight(), false);
        }
        frame.releaseFrame();
        return tex;
    }

    private static boolean uploadPixels(GLContext glCtx, int target, Buffer pixels, PixelFormat format, int texw, int texh, int dstx, int dsty, int srcx, int srcy, int srcw, int srch, int srcscan, boolean create, boolean useMipmap) {
        int pixelType;
        int pixelFormat;
        int internalFormat;
        int alignment = 1;
        boolean isGL2 = ES2Pipeline.glFactory.isGL2();
        switch (format) {
            case BYTE_BGRA_PRE: 
            case INT_ARGB_PRE: {
                alignment = 4;
                internalFormat = 40;
                pixelFormat = 41;
                if (!isGL2) {
                    if (!PlatformUtil.isIOS()) {
                        if (ES2Pipeline.glFactory.isGLExtensionSupported("GL_EXT_texture_format_BGRA8888")) {
                            pixelFormat = 41;
                            internalFormat = 41;
                        } else {
                            pixelFormat = 40;
                        }
                    }
                    pixelType = 21;
                    break;
                }
                pixelType = 22;
                break;
            }
            case BYTE_RGB: {
                internalFormat = isGL2 ? 40 : 42;
                pixelFormat = 42;
                pixelType = 21;
                break;
            }
            case BYTE_GRAY: {
                internalFormat = 43;
                pixelFormat = 43;
                pixelType = 21;
                break;
            }
            case BYTE_ALPHA: {
                internalFormat = 44;
                pixelFormat = 44;
                pixelType = 21;
                break;
            }
            case FLOAT_XYZW: {
                alignment = 4;
                internalFormat = isGL2 ? 45 : 40;
                pixelFormat = 40;
                pixelType = 20;
                break;
            }
            case BYTE_APPLE_422: {
                alignment = 2;
                internalFormat = 42;
                pixelFormat = 46;
                pixelType = 24;
                break;
            }
            default: {
                throw new InternalError("Image format not supported: " + (Object)((Object)format));
            }
        }
        if (!isGL2 && internalFormat != pixelFormat && !PlatformUtil.isIOS()) {
            throw new InternalError("On ES 2.0 device, internalFormat must match pixelFormat");
        }
        boolean result = true;
        if (create) {
            glCtx.pixelStorei(60, 1);
            if (format == PixelFormat.FLOAT_XYZW && internalFormat == 40) {
                result = glCtx.texImage2D(target, 0, 40, texw, texh, 0, pixelFormat, pixelType, null, useMipmap);
            } else {
                int initBytesPerPixel;
                int initPixelType;
                int initPixelFormat;
                if (isGL2) {
                    initPixelFormat = 44;
                    initPixelType = 21;
                    initBytesPerPixel = 1;
                } else {
                    initPixelFormat = pixelFormat;
                    initPixelType = pixelType;
                    initBytesPerPixel = format.getBytesPerPixelUnit();
                }
                ByteBuffer initBuf = null;
                if (srcw != texw || srch != texh) {
                    int initSize = texw * texh * initBytesPerPixel;
                    initBuf = BufferUtil.newByteBuffer(initSize);
                }
                if (isGL2) {
                    glCtx.pixelStorei(61, 0);
                    glCtx.pixelStorei(62, 0);
                    glCtx.pixelStorei(63, 0);
                    glCtx.pixelStorei(60, alignment);
                }
                result = glCtx.texImage2D(target, 0, internalFormat, texw, texh, 0, initPixelFormat, initPixelType, initBuf, useMipmap);
            }
        }
        if (pixels != null) {
            int rowLength = srcscan / format.getBytesPerPixelUnit();
            if (!(isGL2 || srcx == 0 && srcy == 0 && srcw == rowLength)) {
                pixels = Image.createPackedBuffer(pixels, format, srcx, srcy, srcw, srch, srcscan);
                srcy = 0;
                srcx = 0;
                srcscan = srcw;
                rowLength = srcscan / format.getBytesPerPixelUnit();
            }
            glCtx.pixelStorei(60, alignment);
            if (isGL2) {
                if (srcw == rowLength) {
                    glCtx.pixelStorei(61, 0);
                } else {
                    glCtx.pixelStorei(61, rowLength);
                }
            }
            int pos = pixels.position();
            int bufferElementSizeLog = ES2Texture.getBufferElementSizeLog(pixels);
            int elementsInPixel = format.getBytesPerPixelUnit() >> bufferElementSizeLog;
            pixels.position(srcx * elementsInPixel + srcy * (srcscan >> bufferElementSizeLog));
            glCtx.texSubImage2D(target, 0, dstx, dsty, srcw, srch, pixelFormat, pixelType, pixels);
            pixels.position(pos);
        }
        return result;
    }

    private static boolean uploadPixels(GLContext glCtx, int target, MediaFrame frame, int texw, int texh, boolean create) {
        int pixelType;
        int pixelFormat;
        int internalFormat;
        int srch;
        frame.holdFrame();
        int alignment = 1;
        int srcw = frame.getEncodedWidth();
        int adjHeight = srch = frame.getEncodedHeight();
        ByteBuffer pixels = frame.getBufferForPlane(0);
        switch (frame.getPixelFormat()) {
            case INT_ARGB_PRE: {
                alignment = 4;
                internalFormat = 40;
                pixelFormat = 41;
                if (pixels.order() == ByteOrder.LITTLE_ENDIAN) {
                    pixelType = 22;
                    break;
                }
                pixelType = 23;
                break;
            }
            case BYTE_APPLE_422: {
                alignment = 2;
                internalFormat = 42;
                pixelFormat = 46;
                pixelType = 24;
                break;
            }
            default: {
                frame.releaseFrame();
                throw new InternalError("Invalid video image format " + (Object)((Object)frame.getPixelFormat()));
            }
        }
        boolean result = true;
        if (create) {
            glCtx.pixelStorei(60, 1);
            ByteBuffer initBuf = null;
            if (srcw != texw || adjHeight != texh) {
                int initSize = texw * texh;
                initBuf = BufferUtil.newByteBuffer(initSize);
            }
            result = glCtx.texImage2D(target, 0, internalFormat, texw, texh, 0, 44, 21, initBuf, false);
        }
        if (pixels != null) {
            glCtx.pixelStorei(60, alignment);
            glCtx.pixelStorei(61, frame.strideForPlane(0) / alignment);
            glCtx.texSubImage2D(target, 0, 0, 0, srcw, frame.getHeight(), pixelFormat, pixelType, pixels);
        }
        frame.releaseFrame();
        return result;
    }

    public static int getBufferElementSizeLog(Buffer b) {
        if (b instanceof ByteBuffer) {
            return 0;
        }
        if (b instanceof IntBuffer || b instanceof FloatBuffer) {
            return 2;
        }
        throw new InternalError("Unsupported Buffer type: " + b.getClass());
    }

    void updateWrapState() {
        Texture.WrapMode cWrapMode = this.getWrapMode();
        ES2TextureData texData = (ES2TextureData)((ES2TextureResource)this.resource).getResource();
        if (texData.getWrapMode() != cWrapMode) {
            int texID;
            GLContext glCtx = this.context.getGLContext();
            int savedTex = glCtx.getBoundTexture();
            if (savedTex != (texID = texData.getTexID())) {
                glCtx.setBoundTexture(texID);
            }
            glCtx.updateWrapState(texID, cWrapMode);
            if (savedTex != texID) {
                glCtx.setBoundTexture(savedTex);
            }
            texData.setWrapMode(cWrapMode);
        }
    }

    void updateFilterState() {
        boolean cLFM = this.getLinearFiltering();
        ES2TextureData texData = (ES2TextureData)((ES2TextureResource)this.resource).getResource();
        if (texData.isFiltered() != cLFM) {
            int texID;
            GLContext glCtx = this.context.getGLContext();
            int savedTex = glCtx.getBoundTexture();
            if (savedTex != (texID = texData.getTexID())) {
                glCtx.setBoundTexture(texID);
            }
            glCtx.updateFilterState(texID, cLFM);
            if (savedTex != texID) {
                glCtx.setBoundTexture(savedTex);
            }
            texData.setFiltered(cLFM);
        }
    }

    public int getNativeSourceHandle() {
        return ((ES2TextureData)((ES2TextureResource)this.resource).getResource()).getTexID();
    }

    @Override
    public void update(Buffer pixels, PixelFormat format, int dstx, int dsty, int srcx, int srcy, int srcw, int srch, int srcscan, boolean skipFlush) {
        int texID;
        this.checkUpdateParams(pixels, format, dstx, dsty, srcx, srcy, srcw, srch, srcscan);
        if (!skipFlush) {
            this.context.flushVertexBuffer();
        }
        if ((texID = this.getNativeSourceHandle()) != 0) {
            GLContext glCtx = this.context.getGLContext();
            int savedUnit = glCtx.getActiveTextureUnit();
            int savedTex = glCtx.getBoundTexture();
            boolean alreadyBound = false;
            for (int i = 0; i < 2; ++i) {
                if (glCtx.getBoundTexture(i) != texID) continue;
                alreadyBound = true;
                if (savedUnit == i) break;
                glCtx.setActiveTextureUnit(i);
                break;
            }
            if (!alreadyBound) {
                glCtx.setBoundTexture(texID);
            }
            int contentX = this.getContentX();
            int contentY = this.getContentY();
            int contentW = this.getContentWidth();
            int contentH = this.getContentHeight();
            int texWidth = this.getPhysicalWidth();
            int texHeight = this.getPhysicalHeight();
            boolean useMipmap = this.getUseMipmap();
            ES2Texture.uploadPixels(glCtx, 50, pixels, format, texWidth, texHeight, contentX + dstx, contentY + dsty, srcx, srcy, srcw, srch, srcscan, false, useMipmap);
            switch (this.getWrapMode()) {
                case CLAMP_TO_EDGE: {
                    break;
                }
                case CLAMP_TO_EDGE_SIMULATED: {
                    boolean copyL;
                    boolean copyR = contentW < texWidth && dstx + srcw == contentW;
                    boolean bl = copyL = contentH < texHeight && dsty + srch == contentH;
                    if (copyR) {
                        ES2Texture.uploadPixels(glCtx, 50, pixels, format, texWidth, texHeight, contentX + contentW, contentY + dsty, srcx + srcw - 1, srcy, 1, srch, srcscan, false, useMipmap);
                    }
                    if (!copyL) break;
                    ES2Texture.uploadPixels(glCtx, 50, pixels, format, texWidth, texHeight, contentX + dstx, contentY + contentH, srcx, srcy + srch - 1, srcw, 1, srcscan, false, useMipmap);
                    if (!copyR) break;
                    ES2Texture.uploadPixels(glCtx, 50, pixels, format, texWidth, texHeight, contentX + contentW, contentY + contentH, srcx + srcw - 1, srcy + srch - 1, 1, 1, srcscan, false, useMipmap);
                    break;
                }
                case REPEAT: {
                    break;
                }
                case REPEAT_SIMULATED: {
                    boolean repeatT;
                    boolean repeatL = contentW < texWidth && dstx == 0;
                    boolean bl = repeatT = contentH < texHeight && dsty == 0;
                    if (repeatL) {
                        ES2Texture.uploadPixels(glCtx, 50, pixels, format, texWidth, texHeight, contentX + contentW, contentY + dsty, srcx, srcy, 1, srch, srcscan, false, useMipmap);
                    }
                    if (!repeatT) break;
                    ES2Texture.uploadPixels(glCtx, 50, pixels, format, texWidth, texHeight, contentX + dstx, contentY + contentH, srcx, srcy, srcw, 1, srcscan, false, useMipmap);
                    if (!repeatL) break;
                    ES2Texture.uploadPixels(glCtx, 50, pixels, format, texWidth, texHeight, contentX + contentW, contentY + contentH, srcx, srcy, 1, 1, srcscan, false, useMipmap);
                    break;
                }
            }
            if (savedUnit != glCtx.getActiveTextureUnit()) {
                glCtx.setActiveTextureUnit(savedUnit);
            }
            if (savedTex != glCtx.getBoundTexture()) {
                glCtx.setBoundTexture(savedTex);
            }
        }
    }

    @Override
    public void update(MediaFrame frame, boolean skipFlush) {
        int texID;
        if (!skipFlush) {
            this.context.flushVertexBuffer();
        }
        if ((texID = this.getNativeSourceHandle()) != 0) {
            GLContext glCtx = this.context.getGLContext();
            int savedUnit = glCtx.getActiveTextureUnit();
            int savedTex = glCtx.getBoundTexture();
            boolean alreadyBound = false;
            for (int i = 0; i < 2; ++i) {
                if (glCtx.getBoundTexture(i) != texID) continue;
                alreadyBound = true;
                if (savedUnit == i) break;
                glCtx.setActiveTextureUnit(i);
                break;
            }
            if (!alreadyBound) {
                glCtx.setBoundTexture(texID);
            }
            ES2Texture.uploadPixels(glCtx, 50, frame, this.getPhysicalWidth(), this.getPhysicalHeight(), false);
            if (savedUnit != glCtx.getActiveTextureUnit()) {
                glCtx.setActiveTextureUnit(savedUnit);
            }
            if (savedTex != glCtx.getBoundTexture()) {
                glCtx.setBoundTexture(savedTex);
            }
        }
    }
}

