/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.prism.impl.BufferUtil$$Lambda$1;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.security.AccessController;

public class BufferUtil {
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_DOUBLE = 8;
    private static boolean isCDCFP;
    private static Class byteOrderClass;
    private static Object nativeOrderObject;
    private static Method orderMethod;

    private BufferUtil() {
    }

    public static void nativeOrder(ByteBuffer buf) {
        if (!isCDCFP) {
            try {
                if (byteOrderClass == null) {
                    byteOrderClass = (Class)AccessController.doPrivileged(BufferUtil$$Lambda$1.lambdaFactory$());
                    orderMethod = ByteBuffer.class.getMethod("order", byteOrderClass);
                    Method nativeOrderMethod = byteOrderClass.getMethod("nativeOrder", null);
                    nativeOrderObject = nativeOrderMethod.invoke(null, (Object[])null);
                }
            }
            catch (Throwable t) {
                isCDCFP = true;
            }
            if (!isCDCFP) {
                try {
                    orderMethod.invoke((Object)buf, nativeOrderObject);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public static ByteBuffer newByteBuffer(int numElements) {
        ByteBuffer bb = ByteBuffer.allocateDirect(numElements);
        BufferUtil.nativeOrder(bb);
        return bb;
    }

    public static DoubleBuffer newDoubleBuffer(int numElements) {
        ByteBuffer bb = BufferUtil.newByteBuffer(numElements * 8);
        return bb.asDoubleBuffer();
    }

    public static FloatBuffer newFloatBuffer(int numElements) {
        ByteBuffer bb = BufferUtil.newByteBuffer(numElements * 4);
        return bb.asFloatBuffer();
    }

    public static IntBuffer newIntBuffer(int numElements) {
        ByteBuffer bb = BufferUtil.newByteBuffer(numElements * 4);
        return bb.asIntBuffer();
    }

    public static ShortBuffer newShortBuffer(int numElements) {
        ByteBuffer bb = BufferUtil.newByteBuffer(numElements * 2);
        return bb.asShortBuffer();
    }

    private static /* synthetic */ Object lambda$nativeOrder$449() throws Exception {
        return Class.forName("java.nio.ByteOrder", true, null);
    }

    static /* synthetic */ Object access$lambda$0() {
        return BufferUtil.lambda$nativeOrder$449();
    }
}

