/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.javafx.geom.Vec3f;
import com.sun.prism.impl.MeshTempState;
import com.sun.prism.impl.MeshUtil;

class MeshVertex {
    int smGroup;
    int pVert;
    int tVert;
    int fIdx;
    int index;
    Vec3f[] norm = new Vec3f[3];
    MeshVertex next = null;
    static final int IDX_UNDEFINED = -1;
    static final int IDX_SET_SMOOTH = -2;
    static final int IDX_UNITE = -3;

    MeshVertex() {
        for (int i = 0; i < this.norm.length; ++i) {
            this.norm[i] = new Vec3f();
        }
    }

    static void avgSmNormals(MeshVertex v) {
        Vec3f normalSum = MeshTempState.getInstance().vec3f1;
        while (v != null) {
            if (v.index == -1) {
                normalSum.set(v.norm[0]);
                int sm = v.smGroup;
                MeshVertex i = v.next;
                while (i != null) {
                    if (i.smGroup == sm) {
                        assert (i.index == -1);
                        i.index = -2;
                        normalSum.add(i.norm[0]);
                    }
                    i = i.next;
                }
                if (MeshUtil.isNormalOkAfterWeld(normalSum)) {
                    normalSum.normalize();
                    i = v;
                    while (i != null) {
                        if (i.smGroup == sm) {
                            i.norm[0].set(normalSum);
                        }
                        i = i.next;
                    }
                }
            }
            v = v.next;
        }
    }

    static boolean okToWeldVertsTB(MeshVertex a, MeshVertex b) {
        return a.tVert == b.tVert && MeshUtil.isTangentOk(a.norm, b.norm);
    }

    static int weldWithTB(MeshVertex v, int index) {
        Vec3f[] nSum = MeshTempState.getInstance().triNormals;
        while (v != null) {
            if (v.index < 0) {
                int nuLocal = 0;
                for (int i = 0; i < 3; ++i) {
                    nSum[i].set(v.norm[i]);
                }
                MeshVertex i = v.next;
                while (i != null) {
                    if (i.index < 0 && MeshVertex.okToWeldVertsTB(v, i)) {
                        i.index = -3;
                        ++nuLocal;
                        for (int j = 0; j < 3; ++j) {
                            nSum[j].add(i.norm[j]);
                        }
                    }
                    i = i.next;
                }
                if (nuLocal != 0) {
                    if (MeshUtil.isTangentOK(nSum)) {
                        MeshUtil.fixTSpace(nSum);
                        v.index = index;
                        for (int i2 = 0; i2 < 3; ++i2) {
                            v.norm[i2].set(nSum[i2]);
                        }
                        i = v.next;
                        while (i != null) {
                            if (i.index == -3) {
                                i.index = index;
                                i.norm[0].set(0.0f, 0.0f, 0.0f);
                            }
                            i = i.next;
                        }
                    } else {
                        nuLocal = 0;
                    }
                }
                if (nuLocal == 0) {
                    MeshUtil.fixTSpace(v.norm);
                    v.index = index;
                }
                ++index;
            }
            v = v.next;
        }
        return index;
    }

    static void mergeSmIndexes(MeshVertex n) {
        MeshVertex l = n;
        while (l != null) {
            boolean change = false;
            MeshVertex i = l.next;
            while (i != null) {
                if ((l.smGroup & i.smGroup) != 0 && l.smGroup != i.smGroup) {
                    i.smGroup = l.smGroup = i.smGroup | l.smGroup;
                    change = true;
                }
                i = i.next;
            }
            if (change) continue;
            l = l.next;
        }
    }

    static void correctSmNormals(MeshVertex n) {
        MeshVertex l = n;
        while (l != null) {
            if (l.smGroup != 0) {
                MeshVertex i = l.next;
                while (i != null) {
                    if ((i.smGroup & l.smGroup) != 0 && MeshUtil.isOppositeLookingNormals(i.norm, l.norm)) {
                        l.smGroup = 0;
                        i.smGroup = 0;
                        break;
                    }
                    i = i.next;
                }
            }
            l = l.next;
        }
    }

    static int processVertices(MeshVertex[] pVerts, int nVertex, boolean allHardEdges, boolean allSameSmoothing) {
        int nNewVerts = 0;
        Vec3f normalSum = MeshTempState.getInstance().vec3f1;
        for (int i = 0; i < nVertex; ++i) {
            if (pVerts[i] == null) continue;
            if (!allHardEdges) {
                if (allSameSmoothing) {
                    normalSum.set(pVerts[i].norm[0]);
                    MeshVertex v = pVerts[i].next;
                    while (v != null) {
                        normalSum.add(v.norm[0]);
                        v = v.next;
                    }
                    if (MeshUtil.isNormalOkAfterWeld(normalSum)) {
                        normalSum.normalize();
                        v = pVerts[i];
                        while (v != null) {
                            v.norm[0].set(normalSum);
                            v = v.next;
                        }
                    }
                } else {
                    MeshVertex.mergeSmIndexes(pVerts[i]);
                    MeshVertex.avgSmNormals(pVerts[i]);
                }
            }
            nNewVerts = MeshVertex.weldWithTB(pVerts[i], nNewVerts);
        }
        return nNewVerts;
    }

    public String toString() {
        return "MeshVertex : " + this.getClass().getName() + "@0x" + Integer.toHexString(this.hashCode()) + ":: smGroup = " + this.smGroup + "\n" + "\tnorm[0] = " + this.norm[0] + "\n" + "\tnorm[1] = " + this.norm[1] + "\n" + "\tnorm[2] = " + this.norm[2] + "\n" + "\ttIndex = " + this.tVert + ", fIndex = " + this.fIdx + "\n" + "\tpIdx = " + this.index + "\n" + "\tnext = " + (this.next == null ? this.next : this.next.getClass().getName() + "@0x" + Integer.toHexString(this.next.hashCode())) + "\n";
    }

    static void dumpInfo(MeshVertex v) {
        System.err.println("** dumpInfo: ");
        MeshVertex q = v;
        while (q != null) {
            System.err.println(q);
            q = q.next;
        }
        System.err.println("***********************************");
    }
}

