/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit;

import com.sun.webkit.LoadListenerClient;
import com.sun.webkit.WebPage;
import com.sun.webkit.event.WCChangeEvent;
import com.sun.webkit.event.WCChangeListener;
import com.sun.webkit.graphics.WCImage;
import com.sun.webkit.network.URLs;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public final class BackForwardList {
    private final WebPage page;
    private final List<WCChangeListener> listenerList = new LinkedList<WCChangeListener>();

    BackForwardList(WebPage page) {
        this.page = page;
        page.addLoadListenerClient(new LoadListenerClient(){

            @Override
            public void dispatchLoadEvent(long frame, int state, String url, String contentType, double progress, int errorCode) {
                Entry entry;
                if (state == 14 && (entry = BackForwardList.this.getCurrentEntry()) != null) {
                    entry.updateLastVisitedDate();
                }
            }

            @Override
            public void dispatchResourceLoadEvent(long frame, int state, String url, String contentType, double progress, int errorCode) {
            }
        });
    }

    public int size() {
        return 0;
    }

    public int getMaximumSize() {
        return 0;
    }

    public void setMaximumSize(int size) {
    }

    public int getCurrentIndex() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public void setEnabled(boolean flag) {
    }

    public boolean isEnabled() {
        return false;
    }

    public Entry get(int index) {
        return null;
    }

    public Entry getCurrentEntry() {
        return this.get(this.getCurrentIndex());
    }

    public int indexOf(Entry e) {
        return 0;
    }

    public boolean contains(Entry e) {
        return this.indexOf(e) >= 0;
    }

    public Entry[] toArray() {
        int size = this.size();
        Entry[] entries = new Entry[size];
        for (int i = 0; i < size; ++i) {
            entries[i] = this.get(i);
        }
        return entries;
    }

    public void setCurrentIndex(int index) {
    }

    private boolean canGoBack(int index) {
        return index > 0;
    }

    public boolean canGoBack() {
        return this.canGoBack(this.getCurrentIndex());
    }

    public boolean goBack() {
        int index = this.getCurrentIndex();
        if (this.canGoBack(index)) {
            this.setCurrentIndex(index - 1);
            return true;
        }
        return false;
    }

    private boolean canGoForward(int index) {
        return index < this.size() - 1;
    }

    public boolean canGoForward() {
        return this.canGoForward(this.getCurrentIndex());
    }

    public boolean goForward() {
        int index = this.getCurrentIndex();
        if (this.canGoForward(index)) {
            this.setCurrentIndex(index + 1);
            return true;
        }
        return false;
    }

    public void addChangeListener(WCChangeListener l) {
        if (l == null) {
            return;
        }
        if (this.listenerList.isEmpty()) {
            // empty if block
        }
        this.listenerList.add(l);
    }

    public void removeChangeListener(WCChangeListener l) {
        if (l == null) {
            return;
        }
        this.listenerList.remove(l);
        if (this.listenerList.isEmpty()) {
            // empty if block
        }
    }

    public WCChangeListener[] getChangeListeners() {
        return this.listenerList.toArray(new WCChangeListener[0]);
    }

    private void notifyChanged() {
        for (WCChangeListener l : this.listenerList) {
            l.stateChanged(new WCChangeEvent(this));
        }
    }

    public static final class Entry {
        private long pitem = 0L;
        private long ppage = 0L;
        private Entry[] children;
        private URL url;
        private String title;
        private Date lastVisitedDate;
        private WCImage icon;
        private String target;
        private boolean isTargetItem;
        private final List<WCChangeListener> listenerList = new LinkedList<WCChangeListener>();

        private Entry(long pitem, long ppage) {
            this.pitem = pitem;
            this.ppage = ppage;
            this.getURL();
            this.getTitle();
            this.getLastVisitedDate();
            this.getIcon();
            this.getTarget();
            this.isTargetItem();
            this.getChildren();
        }

        private void notifyItemDestroyed() {
            this.pitem = 0L;
        }

        private void notifyItemChanged() {
            for (WCChangeListener l : this.listenerList) {
                l.stateChanged(new WCChangeEvent(this));
            }
        }

        public URL getURL() {
            try {
                return this.pitem == 0L ? this.url : (this.url = URLs.newURL(""));
            }
            catch (MalformedURLException ex) {
                this.url = null;
                return null;
            }
        }

        public String getTitle() {
            return this.pitem == 0L ? this.title : (this.title = "");
        }

        public WCImage getIcon() {
            return this.pitem == 0L ? this.icon : (this.icon = null);
        }

        public String getTarget() {
            return this.pitem == 0L ? this.target : (this.target = "");
        }

        public Date getLastVisitedDate() {
            return this.lastVisitedDate == null ? null : (Date)this.lastVisitedDate.clone();
        }

        private void updateLastVisitedDate() {
            this.lastVisitedDate = new Date(System.currentTimeMillis());
            this.notifyItemChanged();
        }

        public boolean isTargetItem() {
            return this.pitem == 0L ? this.isTargetItem : (this.isTargetItem = false);
        }

        public Entry[] getChildren() {
            Entry[] entryArray;
            if (this.pitem == 0L) {
                entryArray = this.children;
            } else {
                this.children = null;
                entryArray = this.children;
            }
            return entryArray;
        }

        public String toString() {
            return "url=" + this.getURL() + ",title=" + this.getTitle() + ",date=" + this.getLastVisitedDate();
        }

        public void addChangeListener(WCChangeListener l) {
            if (l == null) {
                return;
            }
            this.listenerList.add(l);
        }

        public void removeChangeListener(WCChangeListener l) {
            if (l == null) {
                return;
            }
            this.listenerList.remove(l);
        }
    }
}

