/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.property;

import com.sun.javafx.binding.MapExpressionHelper;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.property.SimpleMapProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;

public class ReadOnlyMapWrapper<K, V>
extends SimpleMapProperty<K, V> {
    private ReadOnlyPropertyImpl readOnlyProperty;

    public ReadOnlyMapWrapper() {
    }

    public ReadOnlyMapWrapper(ObservableMap<K, V> initialValue) {
        super(initialValue);
    }

    public ReadOnlyMapWrapper(Object bean, String name) {
        super(bean, name);
    }

    public ReadOnlyMapWrapper(Object bean, String name, ObservableMap<K, V> initialValue) {
        super(bean, name, initialValue);
    }

    public ReadOnlyMapProperty<K, V> getReadOnlyProperty() {
        if (this.readOnlyProperty == null) {
            this.readOnlyProperty = new ReadOnlyPropertyImpl();
        }
        return this.readOnlyProperty;
    }

    @Override
    public void addListener(InvalidationListener listener) {
        this.getReadOnlyProperty().addListener(listener);
    }

    @Override
    public void removeListener(InvalidationListener listener) {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.removeListener(listener);
        }
    }

    @Override
    public void addListener(ChangeListener<? super ObservableMap<K, V>> listener) {
        this.getReadOnlyProperty().addListener(listener);
    }

    @Override
    public void removeListener(ChangeListener<? super ObservableMap<K, V>> listener) {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.removeListener(listener);
        }
    }

    @Override
    public void addListener(MapChangeListener<? super K, ? super V> listener) {
        this.getReadOnlyProperty().addListener(listener);
    }

    @Override
    public void removeListener(MapChangeListener<? super K, ? super V> listener) {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.removeListener(listener);
        }
    }

    @Override
    protected void fireValueChangedEvent() {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.fireValueChangedEvent();
        }
    }

    @Override
    protected void fireValueChangedEvent(MapChangeListener.Change<? extends K, ? extends V> change) {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.fireValueChangedEvent(change);
        }
    }

    private class ReadOnlyPropertyImpl
    extends ReadOnlyMapProperty<K, V> {
        private MapExpressionHelper<K, V> helper = null;

        private ReadOnlyPropertyImpl() {
        }

        @Override
        public ObservableMap<K, V> get() {
            return ReadOnlyMapWrapper.this.get();
        }

        @Override
        public void addListener(InvalidationListener listener) {
            this.helper = MapExpressionHelper.addListener(this.helper, this, listener);
        }

        @Override
        public void removeListener(InvalidationListener listener) {
            this.helper = MapExpressionHelper.removeListener(this.helper, listener);
        }

        @Override
        public void addListener(ChangeListener<? super ObservableMap<K, V>> listener) {
            this.helper = MapExpressionHelper.addListener(this.helper, this, listener);
        }

        @Override
        public void removeListener(ChangeListener<? super ObservableMap<K, V>> listener) {
            this.helper = MapExpressionHelper.removeListener(this.helper, listener);
        }

        @Override
        public void addListener(MapChangeListener<? super K, ? super V> listener) {
            this.helper = MapExpressionHelper.addListener(this.helper, this, listener);
        }

        @Override
        public void removeListener(MapChangeListener<? super K, ? super V> listener) {
            this.helper = MapExpressionHelper.removeListener(this.helper, listener);
        }

        private void fireValueChangedEvent() {
            MapExpressionHelper.fireValueChangedEvent(this.helper);
        }

        private void fireValueChangedEvent(MapChangeListener.Change<? extends K, ? extends V> change) {
            MapExpressionHelper.fireValueChangedEvent(this.helper, change);
        }

        @Override
        public Object getBean() {
            return ReadOnlyMapWrapper.this.getBean();
        }

        @Override
        public String getName() {
            return ReadOnlyMapWrapper.this.getName();
        }

        @Override
        public ReadOnlyIntegerProperty sizeProperty() {
            return ReadOnlyMapWrapper.this.sizeProperty();
        }

        @Override
        public ReadOnlyBooleanProperty emptyProperty() {
            return ReadOnlyMapWrapper.this.emptyProperty();
        }
    }
}

