/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.property;

import com.sun.javafx.binding.ExpressionHelper;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;

public class ReadOnlyObjectWrapper<T>
extends SimpleObjectProperty<T> {
    private ReadOnlyPropertyImpl readOnlyProperty;

    public ReadOnlyObjectWrapper() {
    }

    public ReadOnlyObjectWrapper(T initialValue) {
        super(initialValue);
    }

    public ReadOnlyObjectWrapper(Object bean, String name) {
        super(bean, name);
    }

    public ReadOnlyObjectWrapper(Object bean, String name, T initialValue) {
        super(bean, name, initialValue);
    }

    public ReadOnlyObjectProperty<T> getReadOnlyProperty() {
        if (this.readOnlyProperty == null) {
            this.readOnlyProperty = new ReadOnlyPropertyImpl();
        }
        return this.readOnlyProperty;
    }

    @Override
    public void addListener(InvalidationListener listener) {
        this.getReadOnlyProperty().addListener(listener);
    }

    @Override
    public void removeListener(InvalidationListener listener) {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.removeListener(listener);
        }
    }

    @Override
    public void addListener(ChangeListener<? super T> listener) {
        this.getReadOnlyProperty().addListener(listener);
    }

    @Override
    public void removeListener(ChangeListener<? super T> listener) {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.removeListener(listener);
        }
    }

    @Override
    protected void fireValueChangedEvent() {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.fireValueChangedEvent();
        }
    }

    private class ReadOnlyPropertyImpl
    extends ReadOnlyObjectProperty<T> {
        private ExpressionHelper<T> helper = null;

        private ReadOnlyPropertyImpl() {
        }

        @Override
        public T get() {
            return ReadOnlyObjectWrapper.this.get();
        }

        @Override
        public void addListener(InvalidationListener listener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, listener);
        }

        @Override
        public void removeListener(InvalidationListener listener) {
            this.helper = ExpressionHelper.removeListener(this.helper, listener);
        }

        @Override
        public void addListener(ChangeListener<? super T> listener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, listener);
        }

        @Override
        public void removeListener(ChangeListener<? super T> listener) {
            this.helper = ExpressionHelper.removeListener(this.helper, listener);
        }

        protected void fireValueChangedEvent() {
            ExpressionHelper.fireValueChangedEvent(this.helper);
        }

        @Override
        public Object getBean() {
            return ReadOnlyObjectWrapper.this.getBean();
        }

        @Override
        public String getName() {
            return ReadOnlyObjectWrapper.this.getName();
        }
    }
}

