/*
 * Decompiled with CFR 0.152.
 */
package javafx.collections;

import com.sun.javafx.collections.ListListenerHelper;
import com.sun.javafx.collections.MapAdapterChange;
import com.sun.javafx.collections.MapListenerHelper;
import com.sun.javafx.collections.ObservableFloatArrayImpl;
import com.sun.javafx.collections.ObservableIntegerArrayImpl;
import com.sun.javafx.collections.ObservableListWrapper;
import com.sun.javafx.collections.ObservableMapWrapper;
import com.sun.javafx.collections.ObservableSequentialListWrapper;
import com.sun.javafx.collections.ObservableSetWrapper;
import com.sun.javafx.collections.SetAdapterChange;
import com.sun.javafx.collections.SetListenerHelper;
import com.sun.javafx.collections.SortableList;
import com.sun.javafx.collections.SourceAdapterChange;
import com.sun.javafx.collections.UnmodifiableObservableMap;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.FXCollections$CheckedObservableList$$Lambda$1;
import javafx.collections.FXCollections$CheckedObservableMap$$Lambda$1;
import javafx.collections.FXCollections$CheckedObservableSet$$Lambda$1;
import javafx.collections.FXCollections$SynchronizedObservableList$$Lambda$1;
import javafx.collections.FXCollections$SynchronizedObservableMap$$Lambda$1;
import javafx.collections.FXCollections$SynchronizedObservableSet$$Lambda$1;
import javafx.collections.FXCollections$UnmodifiableObservableListImpl$$Lambda$1;
import javafx.collections.FXCollections$UnmodifiableObservableSet$$Lambda$1;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableFloatArray;
import javafx.collections.ObservableIntegerArray;
import javafx.collections.ObservableList;
import javafx.collections.ObservableListBase;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.collections.WeakMapChangeListener;
import javafx.collections.WeakSetChangeListener;
import javafx.util.Callback;

public class FXCollections {
    private static ObservableMap EMPTY_OBSERVABLE_MAP = new EmptyObservableMap();
    private static ObservableList EMPTY_OBSERVABLE_LIST = new EmptyObservableList();
    private static ObservableSet EMPTY_OBSERVABLE_SET = new EmptyObservableSet();
    private static Random r;

    private FXCollections() {
    }

    public static <E> ObservableList<E> observableList(List<E> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        return list instanceof RandomAccess ? new ObservableListWrapper<E>(list) : new ObservableSequentialListWrapper<E>(list);
    }

    public static <E> ObservableList<E> observableList(List<E> list, Callback<E, Observable[]> extractor) {
        if (list == null || extractor == null) {
            throw new NullPointerException();
        }
        return list instanceof RandomAccess ? new ObservableListWrapper<E>(list, extractor) : new ObservableSequentialListWrapper<E>(list, extractor);
    }

    public static <K, V> ObservableMap<K, V> observableMap(Map<K, V> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        return new ObservableMapWrapper<K, V>(map);
    }

    public static <E> ObservableSet<E> observableSet(Set<E> set) {
        if (set == null) {
            throw new NullPointerException();
        }
        return new ObservableSetWrapper<E>(set);
    }

    public static <E> ObservableSet<E> observableSet(E ... elements) {
        if (elements == null) {
            throw new NullPointerException();
        }
        HashSet set = new HashSet(elements.length);
        Collections.addAll(set, elements);
        return new ObservableSetWrapper(set);
    }

    public static <K, V> ObservableMap<K, V> unmodifiableObservableMap(ObservableMap<K, V> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableObservableMap<K, V>(map);
    }

    public static <K, V> ObservableMap<K, V> checkedObservableMap(ObservableMap<K, V> map, Class<K> keyType, Class<V> valueType) {
        if (map == null || keyType == null || valueType == null) {
            throw new NullPointerException();
        }
        return new CheckedObservableMap<K, V>(map, keyType, valueType);
    }

    public static <K, V> ObservableMap<K, V> synchronizedObservableMap(ObservableMap<K, V> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        return new SynchronizedObservableMap<K, V>(map);
    }

    public static <K, V> ObservableMap<K, V> emptyObservableMap() {
        return EMPTY_OBSERVABLE_MAP;
    }

    public static ObservableIntegerArray observableIntegerArray() {
        return new ObservableIntegerArrayImpl();
    }

    public static ObservableIntegerArray observableIntegerArray(int ... values) {
        return new ObservableIntegerArrayImpl(values);
    }

    public static ObservableIntegerArray observableIntegerArray(ObservableIntegerArray array) {
        return new ObservableIntegerArrayImpl(array);
    }

    public static ObservableFloatArray observableFloatArray() {
        return new ObservableFloatArrayImpl();
    }

    public static ObservableFloatArray observableFloatArray(float ... values) {
        return new ObservableFloatArrayImpl(values);
    }

    public static ObservableFloatArray observableFloatArray(ObservableFloatArray array) {
        return new ObservableFloatArrayImpl(array);
    }

    public static <E> ObservableList<E> observableArrayList() {
        return FXCollections.observableList(new ArrayList());
    }

    public static <E> ObservableList<E> observableArrayList(Callback<E, Observable[]> extractor) {
        return FXCollections.observableList(new ArrayList(), extractor);
    }

    public static <E> ObservableList<E> observableArrayList(E ... items) {
        ObservableList<E> list = FXCollections.observableArrayList();
        list.addAll(items);
        return list;
    }

    public static <E> ObservableList<E> observableArrayList(Collection<? extends E> col) {
        ObservableList<? extends E> list = FXCollections.observableArrayList();
        list.addAll(col);
        return list;
    }

    public static <K, V> ObservableMap<K, V> observableHashMap() {
        return FXCollections.observableMap(new HashMap());
    }

    public static <E> ObservableList<E> concat(ObservableList<E> ... lists) {
        if (lists.length == 0) {
            return FXCollections.observableArrayList();
        }
        if (lists.length == 1) {
            return FXCollections.observableArrayList(lists[0]);
        }
        ArrayList<E> backingList = new ArrayList<E>();
        for (ObservableList<E> s : lists) {
            backingList.addAll(s);
        }
        return FXCollections.observableList(backingList);
    }

    public static <E> ObservableList<E> unmodifiableObservableList(ObservableList<E> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableObservableListImpl<E>(list);
    }

    public static <E> ObservableList<E> checkedObservableList(ObservableList<E> list, Class<E> type) {
        if (list == null) {
            throw new NullPointerException();
        }
        return new CheckedObservableList<E>(list, type);
    }

    public static <E> ObservableList<E> synchronizedObservableList(ObservableList<E> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        return new SynchronizedObservableList<E>(list);
    }

    public static <E> ObservableList<E> emptyObservableList() {
        return EMPTY_OBSERVABLE_LIST;
    }

    public static <E> ObservableList<E> singletonObservableList(E e) {
        return new SingletonObservableList<E>(e);
    }

    public static <E> ObservableSet<E> unmodifiableObservableSet(ObservableSet<E> set) {
        if (set == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableObservableSet<E>(set);
    }

    public static <E> ObservableSet<E> checkedObservableSet(ObservableSet<E> set, Class<E> type) {
        if (set == null) {
            throw new NullPointerException();
        }
        return new CheckedObservableSet<E>(set, type);
    }

    public static <E> ObservableSet<E> synchronizedObservableSet(ObservableSet<E> set) {
        if (set == null) {
            throw new NullPointerException();
        }
        return new SynchronizedObservableSet<E>(set);
    }

    public static <E> ObservableSet<E> emptyObservableSet() {
        return EMPTY_OBSERVABLE_SET;
    }

    public static <T> void copy(ObservableList<? super T> dest, List<? extends T> src) {
        int srcSize = src.size();
        if (srcSize > dest.size()) {
            throw new IndexOutOfBoundsException("Source does not fit in dest");
        }
        Object[] destArray = dest.toArray();
        System.arraycopy(src.toArray(), 0, destArray, 0, srcSize);
        dest.setAll(destArray);
    }

    public static <T> void fill(ObservableList<? super T> list, T obj) {
        Object[] newContent = new Object[list.size()];
        Arrays.fill(newContent, obj);
        list.setAll(newContent);
    }

    public static <T> boolean replaceAll(ObservableList<T> list, T oldVal, T newVal) {
        Object[] newContent = list.toArray();
        boolean modified = false;
        for (int i = 0; i < newContent.length; ++i) {
            if (!newContent[i].equals(oldVal)) continue;
            newContent[i] = newVal;
            modified = true;
        }
        if (modified) {
            list.setAll(newContent);
        }
        return modified;
    }

    public static void reverse(ObservableList list) {
        Object[] newContent = list.toArray();
        for (int i = 0; i < newContent.length / 2; ++i) {
            Object tmp = newContent[i];
            newContent[i] = newContent[newContent.length - i - 1];
            newContent[newContent.length - i - 1] = tmp;
        }
        list.setAll(newContent);
    }

    public static void rotate(ObservableList list, int distance) {
        Object[] newContent = list.toArray();
        int size = list.size();
        if ((distance %= size) < 0) {
            distance += size;
        }
        if (distance == 0) {
            return;
        }
        int cycleStart = 0;
        int nMoved = 0;
        while (nMoved != size) {
            Object displaced = newContent[cycleStart];
            int i = cycleStart;
            do {
                if ((i += distance) >= size) {
                    i -= size;
                }
                Object tmp = newContent[i];
                newContent[i] = displaced;
                displaced = tmp;
                ++nMoved;
            } while (i != cycleStart);
            ++cycleStart;
        }
        list.setAll(newContent);
    }

    public static void shuffle(ObservableList<?> list) {
        if (r == null) {
            r = new Random();
        }
        FXCollections.shuffle(list, r);
    }

    public static void shuffle(ObservableList list, Random rnd) {
        Object[] newContent = list.toArray();
        for (int i = list.size(); i > 1; --i) {
            FXCollections.swap(newContent, i - 1, rnd.nextInt(i));
        }
        list.setAll(newContent);
    }

    private static void swap(Object[] arr, int i, int j) {
        Object tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static <T extends Comparable<? super T>> void sort(ObservableList<T> list) {
        if (list instanceof SortableList) {
            ((SortableList)((Object)list)).sort();
        } else {
            ArrayList<T> newContent = new ArrayList<T>(list);
            Collections.sort(newContent);
            list.setAll((Collection<T>)newContent);
        }
    }

    public static <T> void sort(ObservableList<T> list, Comparator<? super T> c) {
        if (list instanceof SortableList) {
            ((SortableList)((Object)list)).sort(c);
        } else {
            ArrayList<T> newContent = new ArrayList<T>(list);
            Collections.sort(newContent, c);
            list.setAll((Collection<T>)newContent);
        }
    }

    private static class SynchronizedObservableMap<K, V>
    extends SynchronizedMap<K, V>
    implements ObservableMap<K, V> {
        private final ObservableMap<K, V> backingMap;
        private MapListenerHelper listenerHelper;
        private final MapChangeListener<K, V> listener;

        SynchronizedObservableMap(ObservableMap<K, V> map, Object mutex) {
            super(map, mutex);
            this.backingMap = map;
            this.listener = FXCollections$SynchronizedObservableMap$$Lambda$1.lambdaFactory$(this);
            this.backingMap.addListener(new WeakMapChangeListener<K, V>(this.listener));
        }

        SynchronizedObservableMap(ObservableMap<K, V> map) {
            this(map, new Object());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListener(InvalidationListener listener) {
            Object object = this.mutex;
            synchronized (object) {
                this.listenerHelper = MapListenerHelper.addListener(this.listenerHelper, listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeListener(InvalidationListener listener) {
            Object object = this.mutex;
            synchronized (object) {
                this.listenerHelper = MapListenerHelper.removeListener(this.listenerHelper, listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListener(MapChangeListener<? super K, ? super V> listener) {
            Object object = this.mutex;
            synchronized (object) {
                this.listenerHelper = MapListenerHelper.addListener(this.listenerHelper, listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeListener(MapChangeListener<? super K, ? super V> listener) {
            Object object = this.mutex;
            synchronized (object) {
                this.listenerHelper = MapListenerHelper.removeListener(this.listenerHelper, listener);
            }
        }

        private /* synthetic */ void lambda$new$57(MapChangeListener.Change c) {
            MapListenerHelper.fireValueChangedEvent(this.listenerHelper, new MapAdapterChange(this, c));
        }

        static /* synthetic */ void access$lambda$0(SynchronizedObservableMap synchronizedObservableMap, MapChangeListener.Change change) {
            synchronizedObservableMap.lambda$new$57(change);
        }
    }

    private static class SynchronizedCollection<E>
    implements Collection<E> {
        private final Collection<E> backingCollection;
        final Object mutex;

        SynchronizedCollection(Collection<E> c, Object mutex) {
            this.backingCollection = c;
            this.mutex = mutex;
        }

        SynchronizedCollection(Collection<E> c) {
            this(c, new Object());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingCollection.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingCollection.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingCollection.contains(o);
            }
        }

        @Override
        public Iterator<E> iterator() {
            return this.backingCollection.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingCollection.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingCollection.toArray(a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E e) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingCollection.add(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingCollection.remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingCollection.containsAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingCollection.addAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingCollection.removeAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingCollection.retainAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.backingCollection.clear();
            }
        }
    }

    private static class SynchronizedMap<K, V>
    implements Map<K, V> {
        final Object mutex;
        private final Map<K, V> backingMap;
        private transient Set<K> keySet = null;
        private transient Set<Map.Entry<K, V>> entrySet = null;
        private transient Collection<V> values = null;

        SynchronizedMap(Map<K, V> map, Object mutex) {
            this.backingMap = map;
            this.mutex = mutex;
        }

        SynchronizedMap(Map<K, V> map) {
            this(map, new Object());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingMap.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingMap.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingMap.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingMap.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingMap.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V put(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingMap.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V remove(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingMap.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            Object object = this.mutex;
            synchronized (object) {
                this.backingMap.putAll(m);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.backingMap.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<K> keySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.keySet == null) {
                    this.keySet = new SynchronizedSet<K>(this.backingMap.keySet(), this.mutex);
                }
                return this.keySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> values() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.values == null) {
                    this.values = new SynchronizedCollection<V>(this.backingMap.values(), this.mutex);
                }
                return this.values;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.entrySet == null) {
                    this.entrySet = new SynchronizedSet<Map.Entry<K, V>>(this.backingMap.entrySet(), this.mutex);
                }
                return this.entrySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            Object object = this.mutex;
            synchronized (object) {
                return this.backingMap.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingMap.hashCode();
            }
        }
    }

    private static class CheckedObservableMap<K, V>
    extends AbstractMap<K, V>
    implements ObservableMap<K, V> {
        private final ObservableMap<K, V> backingMap;
        private final Class<K> keyType;
        private final Class<V> valueType;
        private MapListenerHelper listenerHelper;
        private final MapChangeListener<K, V> listener;
        private transient Set<Map.Entry<K, V>> entrySet = null;

        CheckedObservableMap(ObservableMap<K, V> map, Class<K> keyType, Class<V> valueType) {
            this.backingMap = map;
            this.keyType = keyType;
            this.valueType = valueType;
            this.listener = FXCollections$CheckedObservableMap$$Lambda$1.lambdaFactory$(this);
            this.backingMap.addListener(new WeakMapChangeListener<K, V>(this.listener));
        }

        private void callObservers(MapChangeListener.Change<? extends K, ? extends V> c) {
            MapListenerHelper.fireValueChangedEvent(this.listenerHelper, c);
        }

        void typeCheck(Object key, Object value) {
            if (key != null && !this.keyType.isInstance(key)) {
                throw new ClassCastException("Attempt to insert " + key.getClass() + " key into map with key type " + this.keyType);
            }
            if (value != null && !this.valueType.isInstance(value)) {
                throw new ClassCastException("Attempt to insert " + value.getClass() + " value into map with value type " + this.valueType);
            }
        }

        @Override
        public void addListener(InvalidationListener listener) {
            this.listenerHelper = MapListenerHelper.addListener(this.listenerHelper, listener);
        }

        @Override
        public void removeListener(InvalidationListener listener) {
            this.listenerHelper = MapListenerHelper.removeListener(this.listenerHelper, listener);
        }

        @Override
        public void addListener(MapChangeListener<? super K, ? super V> listener) {
            this.listenerHelper = MapListenerHelper.addListener(this.listenerHelper, listener);
        }

        @Override
        public void removeListener(MapChangeListener<? super K, ? super V> listener) {
            this.listenerHelper = MapListenerHelper.removeListener(this.listenerHelper, listener);
        }

        @Override
        public int size() {
            return this.backingMap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.backingMap.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.backingMap.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.backingMap.containsValue(value);
        }

        @Override
        public V get(Object key) {
            return this.backingMap.get(key);
        }

        @Override
        public V put(K key, V value) {
            this.typeCheck(key, value);
            return this.backingMap.put(key, value);
        }

        @Override
        public V remove(Object key) {
            return this.backingMap.remove(key);
        }

        @Override
        public void putAll(Map t) {
            Object[] entries = t.entrySet().toArray();
            ArrayList checked = new ArrayList(entries.length);
            for (Object o : entries) {
                Map.Entry e = (Map.Entry)o;
                Object k = e.getKey();
                Object v = e.getValue();
                this.typeCheck(k, v);
                checked.add(new AbstractMap.SimpleImmutableEntry(k, v));
            }
            for (Map.Entry entry : checked) {
                this.backingMap.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void clear() {
            this.backingMap.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.backingMap.keySet();
        }

        @Override
        public Collection<V> values() {
            return this.backingMap.values();
        }

        @Override
        public Set entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new CheckedEntrySet(this.backingMap.entrySet(), this.valueType);
            }
            return this.entrySet;
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.backingMap.equals(o);
        }

        @Override
        public int hashCode() {
            return this.backingMap.hashCode();
        }

        private /* synthetic */ void lambda$new$56(MapChangeListener.Change c) {
            this.callObservers(new MapAdapterChange(this, c));
        }

        static /* synthetic */ void access$lambda$0(CheckedObservableMap checkedObservableMap, MapChangeListener.Change change) {
            checkedObservableMap.lambda$new$56(change);
        }

        static class CheckedEntrySet<K, V>
        implements Set<Map.Entry<K, V>> {
            private final Set<Map.Entry<K, V>> s;
            private final Class<V> valueType;

            CheckedEntrySet(Set<Map.Entry<K, V>> s, Class<V> valueType) {
                this.s = s;
                this.valueType = valueType;
            }

            @Override
            public int size() {
                return this.s.size();
            }

            @Override
            public boolean isEmpty() {
                return this.s.isEmpty();
            }

            public String toString() {
                return this.s.toString();
            }

            @Override
            public int hashCode() {
                return this.s.hashCode();
            }

            @Override
            public void clear() {
                this.s.clear();
            }

            @Override
            public boolean add(Map.Entry<K, V> e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<K, V>> coll) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator<Map.Entry<K, V>> i = this.s.iterator();
                final Class<V> valueType = this.valueType;
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public void remove() {
                        i.remove();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return CheckedEntrySet.checkedEntry((Map.Entry)i.next(), valueType);
                    }
                };
            }

            @Override
            public Object[] toArray() {
                Object[] source = this.s.toArray();
                Object[] dest = CheckedEntry.class.isInstance(source.getClass().getComponentType()) ? source : new Object[source.length];
                for (int i = 0; i < source.length; ++i) {
                    dest[i] = CheckedEntrySet.checkedEntry((Map.Entry)source[i], this.valueType);
                }
                return dest;
            }

            @Override
            public <T> T[] toArray(T[] a) {
                T[] arr = this.s.toArray(a.length == 0 ? a : Arrays.copyOf(a, 0));
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = CheckedEntrySet.checkedEntry((Map.Entry)arr[i], this.valueType);
                }
                if (arr.length > a.length) {
                    return arr;
                }
                System.arraycopy(arr, 0, a, 0, arr.length);
                if (a.length > arr.length) {
                    a[arr.length] = null;
                }
                return a;
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                CheckedEntry<K, V, V> e = (CheckedEntry<K, V, V>)o;
                return this.s.contains(e instanceof CheckedEntry ? e : CheckedEntrySet.checkedEntry(e, this.valueType));
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                for (Object o : c) {
                    if (this.contains(o)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                return this.s.remove(new AbstractMap.SimpleImmutableEntry((Map.Entry)o));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                return this.batchRemove(c, false);
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                return this.batchRemove(c, true);
            }

            private boolean batchRemove(Collection<?> c, boolean complement) {
                boolean modified = false;
                Iterator<Map.Entry<K, V>> it = this.iterator();
                while (it.hasNext()) {
                    if (c.contains(it.next()) == complement) continue;
                    it.remove();
                    modified = true;
                }
                return modified;
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Set)) {
                    return false;
                }
                Set that = (Set)o;
                return that.size() == this.s.size() && this.containsAll(that);
            }

            static <K, V, T> CheckedEntry<K, V, T> checkedEntry(Map.Entry<K, V> e, Class<T> valueType) {
                return new CheckedEntry<K, V, T>(e, valueType);
            }

            private static class CheckedEntry<K, V, T>
            implements Map.Entry<K, V> {
                private final Map.Entry<K, V> e;
                private final Class<T> valueType;

                CheckedEntry(Map.Entry<K, V> e, Class<T> valueType) {
                    this.e = e;
                    this.valueType = valueType;
                }

                @Override
                public K getKey() {
                    return this.e.getKey();
                }

                @Override
                public V getValue() {
                    return this.e.getValue();
                }

                @Override
                public int hashCode() {
                    return this.e.hashCode();
                }

                public String toString() {
                    return this.e.toString();
                }

                @Override
                public V setValue(V value) {
                    if (value != null && !this.valueType.isInstance(value)) {
                        throw new ClassCastException(this.badValueMsg(value));
                    }
                    return this.e.setValue(value);
                }

                private String badValueMsg(Object value) {
                    return "Attempt to insert " + value.getClass() + " value into map with value type " + this.valueType;
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    return this.e.equals(new AbstractMap.SimpleImmutableEntry((Map.Entry)o));
                }
            }
        }
    }

    private static class EmptyObservableMap<K, V>
    extends AbstractMap<K, V>
    implements ObservableMap<K, V> {
        @Override
        public void addListener(InvalidationListener listener) {
        }

        @Override
        public void removeListener(InvalidationListener listener) {
        }

        @Override
        public void addListener(MapChangeListener<? super K, ? super V> listener) {
        }

        @Override
        public void removeListener(MapChangeListener<? super K, ? super V> listener) {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public V get(Object key) {
            return null;
        }

        @Override
        public Set<K> keySet() {
            return FXCollections.emptyObservableSet();
        }

        @Override
        public Collection<V> values() {
            return FXCollections.emptyObservableSet();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return FXCollections.emptyObservableSet();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Map && ((Map)o).isEmpty();
        }

        @Override
        public int hashCode() {
            return 0;
        }
    }

    private static class CheckedObservableSet<E>
    extends AbstractSet<E>
    implements ObservableSet<E> {
        private final ObservableSet<E> backingSet;
        private final Class<E> type;
        private SetListenerHelper listenerHelper;
        private final SetChangeListener<E> listener;

        CheckedObservableSet(ObservableSet<E> set, Class<E> type) {
            if (set == null || type == null) {
                throw new NullPointerException();
            }
            this.backingSet = set;
            this.type = type;
            this.listener = FXCollections$CheckedObservableSet$$Lambda$1.lambdaFactory$(this);
            this.backingSet.addListener(new WeakSetChangeListener<E>(this.listener));
        }

        private void callObservers(SetChangeListener.Change<? extends E> c) {
            SetListenerHelper.fireValueChangedEvent(this.listenerHelper, c);
        }

        void typeCheck(Object o) {
            if (o != null && !this.type.isInstance(o)) {
                throw new ClassCastException("Attempt to insert " + o.getClass() + " element into collection with element type " + this.type);
            }
        }

        @Override
        public void addListener(InvalidationListener listener) {
            this.listenerHelper = SetListenerHelper.addListener(this.listenerHelper, listener);
        }

        @Override
        public void removeListener(InvalidationListener listener) {
            this.listenerHelper = SetListenerHelper.removeListener(this.listenerHelper, listener);
        }

        @Override
        public void addListener(SetChangeListener<? super E> listener) {
            this.listenerHelper = SetListenerHelper.addListener(this.listenerHelper, listener);
        }

        @Override
        public void removeListener(SetChangeListener<? super E> listener) {
            this.listenerHelper = SetListenerHelper.removeListener(this.listenerHelper, listener);
        }

        @Override
        public int size() {
            return this.backingSet.size();
        }

        @Override
        public boolean isEmpty() {
            return this.backingSet.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.backingSet.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.backingSet.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.backingSet.toArray(a);
        }

        @Override
        public boolean add(E e) {
            this.typeCheck(e);
            return this.backingSet.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.backingSet.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.backingSet.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            Object[] a = null;
            try {
                a = c.toArray((Object[])Array.newInstance(this.type, 0));
            }
            catch (ArrayStoreException e) {
                throw new ClassCastException();
            }
            return this.backingSet.addAll(Arrays.asList(a));
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.backingSet.retainAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.backingSet.removeAll(c);
        }

        @Override
        public void clear() {
            this.backingSet.clear();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.backingSet.equals(o);
        }

        @Override
        public int hashCode() {
            return this.backingSet.hashCode();
        }

        @Override
        public Iterator<E> iterator() {
            final Iterator it = this.backingSet.iterator();
            return new Iterator<E>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public E next() {
                    return it.next();
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
        }

        private /* synthetic */ void lambda$new$55(SetChangeListener.Change c) {
            this.callObservers(new SetAdapterChange(this, c));
        }

        static /* synthetic */ void access$lambda$0(CheckedObservableSet checkedObservableSet, SetChangeListener.Change change) {
            checkedObservableSet.lambda$new$55(change);
        }
    }

    private static class SynchronizedObservableSet<E>
    extends SynchronizedSet<E>
    implements ObservableSet<E> {
        private final ObservableSet<E> backingSet;
        private SetListenerHelper listenerHelper;
        private final SetChangeListener<E> listener;

        SynchronizedObservableSet(ObservableSet<E> set, Object mutex) {
            super(set, mutex);
            this.backingSet = set;
            this.listener = FXCollections$SynchronizedObservableSet$$Lambda$1.lambdaFactory$(this);
            this.backingSet.addListener(new WeakSetChangeListener<E>(this.listener));
        }

        SynchronizedObservableSet(ObservableSet<E> set) {
            this(set, new Object());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListener(InvalidationListener listener) {
            Object object = this.mutex;
            synchronized (object) {
                this.listenerHelper = SetListenerHelper.addListener(this.listenerHelper, listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeListener(InvalidationListener listener) {
            Object object = this.mutex;
            synchronized (object) {
                this.listenerHelper = SetListenerHelper.removeListener(this.listenerHelper, listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListener(SetChangeListener<? super E> listener) {
            Object object = this.mutex;
            synchronized (object) {
                this.listenerHelper = SetListenerHelper.addListener(this.listenerHelper, listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeListener(SetChangeListener<? super E> listener) {
            Object object = this.mutex;
            synchronized (object) {
                this.listenerHelper = SetListenerHelper.removeListener(this.listenerHelper, listener);
            }
        }

        private /* synthetic */ void lambda$new$54(SetChangeListener.Change c) {
            SetListenerHelper.fireValueChangedEvent(this.listenerHelper, new SetAdapterChange(this, c));
        }

        static /* synthetic */ void access$lambda$0(SynchronizedObservableSet synchronizedObservableSet, SetChangeListener.Change change) {
            synchronizedObservableSet.lambda$new$54(change);
        }
    }

    private static class SynchronizedSet<E>
    implements Set<E> {
        final Object mutex;
        private final Set<E> backingSet;

        SynchronizedSet(Set<E> set, Object mutex) {
            this.backingSet = set;
            this.mutex = mutex;
        }

        SynchronizedSet(Set<E> set) {
            this(set, new Object());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingSet.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingSet.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingSet.contains(o);
            }
        }

        @Override
        public Iterator<E> iterator() {
            return this.backingSet.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingSet.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <E> E[] toArray(E[] a) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingSet.toArray(a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E e) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingSet.add(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingSet.remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingSet.containsAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingSet.addAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingSet.retainAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingSet.removeAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.backingSet.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            Object object = this.mutex;
            synchronized (object) {
                return this.backingSet.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingSet.hashCode();
            }
        }
    }

    private static class UnmodifiableObservableSet<E>
    extends AbstractSet<E>
    implements ObservableSet<E> {
        private final ObservableSet<E> backingSet;
        private SetListenerHelper<E> listenerHelper;
        private SetChangeListener<E> listener;

        public UnmodifiableObservableSet(ObservableSet<E> backingSet) {
            this.backingSet = backingSet;
            this.listener = null;
        }

        private void initListener() {
            if (this.listener == null) {
                this.listener = FXCollections$UnmodifiableObservableSet$$Lambda$1.lambdaFactory$(this);
                this.backingSet.addListener(new WeakSetChangeListener<E>(this.listener));
            }
        }

        private void callObservers(SetChangeListener.Change<? extends E> change) {
            SetListenerHelper.fireValueChangedEvent(this.listenerHelper, change);
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private final Iterator<? extends E> i;
                {
                    this.i = UnmodifiableObservableSet.this.backingSet.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    return this.i.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.backingSet.size();
        }

        @Override
        public void addListener(InvalidationListener listener) {
            this.initListener();
            this.listenerHelper = SetListenerHelper.addListener(this.listenerHelper, listener);
        }

        @Override
        public void removeListener(InvalidationListener listener) {
            this.listenerHelper = SetListenerHelper.removeListener(this.listenerHelper, listener);
        }

        @Override
        public void addListener(SetChangeListener<? super E> listener) {
            this.initListener();
            this.listenerHelper = SetListenerHelper.addListener(this.listenerHelper, listener);
        }

        @Override
        public void removeListener(SetChangeListener<? super E> listener) {
            this.listenerHelper = SetListenerHelper.removeListener(this.listenerHelper, listener);
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        private /* synthetic */ void lambda$initListener$53(SetChangeListener.Change c) {
            this.callObservers(new SetAdapterChange(this, c));
        }

        static /* synthetic */ void access$lambda$0(UnmodifiableObservableSet unmodifiableObservableSet, SetChangeListener.Change change) {
            unmodifiableObservableSet.lambda$initListener$53(change);
        }
    }

    private static class EmptyObservableSet<E>
    extends AbstractSet<E>
    implements ObservableSet<E> {
        @Override
        public void addListener(InvalidationListener listener) {
        }

        @Override
        public void removeListener(InvalidationListener listener) {
        }

        @Override
        public void addListener(SetChangeListener<? super E> listener) {
        }

        @Override
        public void removeListener(SetChangeListener<? super E> listener) {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return c.isEmpty();
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public <E> E[] toArray(E[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class CheckedObservableList<T>
    extends ObservableListBase<T>
    implements ObservableList<T> {
        private final ObservableList<T> list;
        private final Class<T> type;
        private final ListChangeListener<T> listener;

        CheckedObservableList(ObservableList<T> list, Class<T> type) {
            if (list == null || type == null) {
                throw new NullPointerException();
            }
            this.list = list;
            this.type = type;
            this.listener = FXCollections$CheckedObservableList$$Lambda$1.lambdaFactory$(this);
            list.addListener(new WeakListChangeListener<T>(this.listener));
        }

        void typeCheck(Object o) {
            if (o != null && !this.type.isInstance(o)) {
                throw new ClassCastException("Attempt to insert " + o.getClass() + " element into collection with element type " + this.type);
            }
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.list.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.list.toArray(a);
        }

        @Override
        public String toString() {
            return this.list.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.list.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> coll) {
            return this.list.containsAll(coll);
        }

        @Override
        public boolean removeAll(Collection<?> coll) {
            return this.list.removeAll(coll);
        }

        @Override
        public boolean retainAll(Collection<?> coll) {
            return this.list.retainAll(coll);
        }

        @Override
        public boolean removeAll(T ... elements) {
            return this.list.removeAll(elements);
        }

        @Override
        public boolean retainAll(T ... elements) {
            return this.list.retainAll(elements);
        }

        @Override
        public void remove(int from, int to) {
            this.list.remove(from, to);
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.list.equals(o);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public T get(int index) {
            return (T)this.list.get(index);
        }

        @Override
        public T remove(int index) {
            return (T)this.list.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        public T set(int index, T element) {
            this.typeCheck(element);
            return this.list.set(index, element);
        }

        @Override
        public void add(int index, T element) {
            this.typeCheck(element);
            this.list.add(index, element);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            Object[] a = null;
            try {
                a = c.toArray((Object[])Array.newInstance(this.type, 0));
            }
            catch (ArrayStoreException e) {
                throw new ClassCastException();
            }
            return this.list.addAll(index, (Collection<T>)Arrays.asList(a));
        }

        @Override
        public boolean addAll(Collection<? extends T> coll) {
            Object[] a = null;
            try {
                a = coll.toArray((Object[])Array.newInstance(this.type, 0));
            }
            catch (ArrayStoreException e) {
                throw new ClassCastException();
            }
            return this.list.addAll((Collection<T>)Arrays.asList(a));
        }

        @Override
        public ListIterator<T> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<T> listIterator(final int index) {
            return new ListIterator<T>(){
                ListIterator<T> i;
                {
                    this.i = CheckedObservableList.this.list.listIterator(index);
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public T next() {
                    return this.i.next();
                }

                @Override
                public boolean hasPrevious() {
                    return this.i.hasPrevious();
                }

                @Override
                public T previous() {
                    return this.i.previous();
                }

                @Override
                public int nextIndex() {
                    return this.i.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return this.i.previousIndex();
                }

                @Override
                public void remove() {
                    this.i.remove();
                }

                @Override
                public void set(T e) {
                    CheckedObservableList.this.typeCheck(e);
                    this.i.set(e);
                }

                @Override
                public void add(T e) {
                    CheckedObservableList.this.typeCheck(e);
                    this.i.add(e);
                }
            };
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private final Iterator<T> it;
                {
                    this.it = CheckedObservableList.this.list.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public T next() {
                    return this.it.next();
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        @Override
        public boolean add(T e) {
            this.typeCheck(e);
            return this.list.add(e);
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            return Collections.checkedList(this.list.subList(fromIndex, toIndex), this.type);
        }

        @Override
        public boolean addAll(T ... elements) {
            try {
                Object[] array = (Object[])Array.newInstance(this.type, elements.length);
                System.arraycopy(elements, 0, array, 0, elements.length);
                return this.list.addAll(array);
            }
            catch (ArrayStoreException e) {
                throw new ClassCastException();
            }
        }

        @Override
        public boolean setAll(T ... elements) {
            try {
                Object[] array = (Object[])Array.newInstance(this.type, elements.length);
                System.arraycopy(elements, 0, array, 0, elements.length);
                return this.list.setAll(array);
            }
            catch (ArrayStoreException e) {
                throw new ClassCastException();
            }
        }

        @Override
        public boolean setAll(Collection<? extends T> col) {
            Object[] a = null;
            try {
                a = col.toArray((Object[])Array.newInstance(this.type, 0));
            }
            catch (ArrayStoreException e) {
                throw new ClassCastException();
            }
            return this.list.setAll((Collection<T>)Arrays.asList(a));
        }

        private /* synthetic */ void lambda$new$52(ListChangeListener.Change c) {
            this.fireChange(new SourceAdapterChange(this, c));
        }

        static /* synthetic */ void access$lambda$0(CheckedObservableList checkedObservableList, ListChangeListener.Change change) {
            checkedObservableList.lambda$new$52(change);
        }
    }

    private static class SynchronizedObservableList<T>
    extends SynchronizedList<T>
    implements ObservableList<T> {
        private ListListenerHelper helper;
        private final ObservableList<T> backingList;
        private final ListChangeListener<T> listener;

        SynchronizedObservableList(ObservableList<T> seq, Object mutex) {
            super(seq, mutex);
            this.backingList = seq;
            this.listener = FXCollections$SynchronizedObservableList$$Lambda$1.lambdaFactory$(this);
            this.backingList.addListener(new WeakListChangeListener<T>(this.listener));
        }

        SynchronizedObservableList(ObservableList<T> seq) {
            this(seq, new Object());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(T ... elements) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.addAll(elements);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setAll(T ... elements) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.setAll(elements);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(T ... elements) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.removeAll(elements);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(T ... elements) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.retainAll(elements);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(int from, int to) {
            Object object = this.mutex;
            synchronized (object) {
                this.backingList.remove(from, to);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setAll(Collection<? extends T> col) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.setAll(col);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void addListener(InvalidationListener listener) {
            Object object = this.mutex;
            synchronized (object) {
                this.helper = ListListenerHelper.addListener(this.helper, listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void removeListener(InvalidationListener listener) {
            Object object = this.mutex;
            synchronized (object) {
                this.helper = ListListenerHelper.removeListener(this.helper, listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListener(ListChangeListener<? super T> listener) {
            Object object = this.mutex;
            synchronized (object) {
                this.helper = ListListenerHelper.addListener(this.helper, listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeListener(ListChangeListener<? super T> listener) {
            Object object = this.mutex;
            synchronized (object) {
                this.helper = ListListenerHelper.removeListener(this.helper, listener);
            }
        }

        private /* synthetic */ void lambda$new$51(ListChangeListener.Change c) {
            ListListenerHelper.fireValueChangedEvent(this.helper, new SourceAdapterChange(this, c));
        }

        static /* synthetic */ void access$lambda$0(SynchronizedObservableList synchronizedObservableList, ListChangeListener.Change change) {
            synchronizedObservableList.lambda$new$51(change);
        }
    }

    private static class SynchronizedList<T>
    implements List<T> {
        final Object mutex;
        private final List<T> backingList;

        SynchronizedList(List<T> list, Object mutex) {
            this.backingList = list;
            this.mutex = mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.contains(o);
            }
        }

        @Override
        public Iterator<T> iterator() {
            return this.backingList.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.toArray(a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(T e) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.add(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.containsAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends T> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.addAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.addAll(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.removeAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.retainAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.backingList.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get(int index) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.get(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T set(int index, T element) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.set(index, element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int index, T element) {
            Object object = this.mutex;
            synchronized (object) {
                this.backingList.add(index, element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T remove(int index) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.remove(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.indexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.lastIndexOf(o);
            }
        }

        @Override
        public ListIterator<T> listIterator() {
            return this.backingList.listIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator<T> listIterator(int index) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.listIterator(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedList<T>(this.backingList.subList(fromIndex, toIndex), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.equals(o);
            }
        }
    }

    private static class UnmodifiableObservableListImpl<T>
    extends ObservableListBase<T>
    implements ObservableList<T> {
        private final ObservableList<T> backingList;
        private final ListChangeListener<T> listener;

        public UnmodifiableObservableListImpl(ObservableList<T> backingList) {
            this.backingList = backingList;
            this.listener = FXCollections$UnmodifiableObservableListImpl$$Lambda$1.lambdaFactory$(this);
            this.backingList.addListener(new WeakListChangeListener<T>(this.listener));
        }

        @Override
        public T get(int index) {
            return (T)this.backingList.get(index);
        }

        @Override
        public int size() {
            return this.backingList.size();
        }

        @Override
        public boolean addAll(T ... elements) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setAll(T ... elements) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setAll(Collection<? extends T> col) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(T ... elements) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(T ... elements) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(int from, int to) {
            throw new UnsupportedOperationException();
        }

        private /* synthetic */ void lambda$new$50(ListChangeListener.Change c) {
            this.fireChange(new SourceAdapterChange(this, c));
        }

        static /* synthetic */ void access$lambda$0(UnmodifiableObservableListImpl unmodifiableObservableListImpl, ListChangeListener.Change change) {
            unmodifiableObservableListImpl.lambda$new$50(change);
        }
    }

    private static class SingletonObservableList<E>
    extends AbstractList<E>
    implements ObservableList<E> {
        private final E element;

        public SingletonObservableList(E element) {
            if (element == null) {
                throw new NullPointerException();
            }
            this.element = element;
        }

        @Override
        public boolean addAll(E ... elements) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setAll(E ... elements) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setAll(Collection<? extends E> col) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(E ... elements) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(E ... elements) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(int from, int to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addListener(InvalidationListener listener) {
        }

        @Override
        public void removeListener(InvalidationListener listener) {
        }

        @Override
        public void addListener(ListChangeListener<? super E> o) {
        }

        @Override
        public void removeListener(ListChangeListener<? super E> o) {
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return this.element.equals(o);
        }

        @Override
        public E get(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.element;
        }
    }

    private static class EmptyObservableList<E>
    extends AbstractList<E>
    implements ObservableList<E> {
        private static final ListIterator iterator = new ListIterator(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Object next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasPrevious() {
                return false;
            }

            public Object previous() {
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return 0;
            }

            @Override
            public int previousIndex() {
                return -1;
            }

            public void set(Object e) {
                throw new UnsupportedOperationException();
            }

            public void add(Object e) {
                throw new UnsupportedOperationException();
            }
        };

        @Override
        public final void addListener(InvalidationListener listener) {
        }

        @Override
        public final void removeListener(InvalidationListener listener) {
        }

        @Override
        public void addListener(ListChangeListener<? super E> o) {
        }

        @Override
        public void removeListener(ListChangeListener<? super E> o) {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return iterator;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return c.isEmpty();
        }

        @Override
        public E get(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int indexOf(Object o) {
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return -1;
        }

        @Override
        public ListIterator<E> listIterator() {
            return iterator;
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return iterator;
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            if (fromIndex != 0 || toIndex != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }

        @Override
        public boolean addAll(E ... elements) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setAll(E ... elements) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setAll(Collection<? extends E> col) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(E ... elements) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(E ... elements) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(int from, int to) {
            throw new UnsupportedOperationException();
        }
    }
}

