/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.ChartLayoutAnimator;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Side;
import javafx.scene.chart.Axis;
import javafx.scene.chart.CategoryAxis$$Lambda$1;
import javafx.scene.chart.CategoryAxis$$Lambda$2;
import javafx.util.Duration;

public final class CategoryAxis
extends Axis<String> {
    private List<String> allDataCategories = new ArrayList<String>();
    private boolean changeIsLocal = false;
    private final DoubleProperty firstCategoryPos = new SimpleDoubleProperty(this, "firstCategoryPos", 0.0);
    private Object currentAnimationID;
    private final ChartLayoutAnimator animator = new ChartLayoutAnimator(this);
    private ListChangeListener<String> itemsListener;
    private DoubleProperty startMargin;
    private DoubleProperty endMargin;
    private BooleanProperty gapStartAndEnd;
    private ObjectProperty<ObservableList<String>> categories;
    private final ReadOnlyDoubleWrapper categorySpacing;

    public final double getStartMargin() {
        return this.startMargin.getValue();
    }

    public final void setStartMargin(double value) {
        this.startMargin.setValue(value);
    }

    public final DoubleProperty startMarginProperty() {
        return this.startMargin;
    }

    public final double getEndMargin() {
        return this.endMargin.getValue();
    }

    public final void setEndMargin(double value) {
        this.endMargin.setValue(value);
    }

    public final DoubleProperty endMarginProperty() {
        return this.endMargin;
    }

    public final boolean isGapStartAndEnd() {
        return this.gapStartAndEnd.getValue();
    }

    public final void setGapStartAndEnd(boolean value) {
        this.gapStartAndEnd.setValue(value);
    }

    public final BooleanProperty gapStartAndEndProperty() {
        return this.gapStartAndEnd;
    }

    public final void setCategories(ObservableList<String> value) {
        this.categories.set(value);
        if (!this.changeIsLocal) {
            this.setAutoRanging(false);
            this.allDataCategories.clear();
            this.allDataCategories.addAll(this.getCategories());
        }
        this.requestAxisLayout();
    }

    private void checkAndRemoveDuplicates(String category) {
        if (this.getDuplicate() != null) {
            this.getCategories().remove(category);
            throw new IllegalArgumentException("Duplicate category ; " + category + " already present");
        }
    }

    private String getDuplicate() {
        if (this.getCategories() != null) {
            for (int i = 0; i < this.getCategories().size(); ++i) {
                for (int j = 0; j < this.getCategories().size(); ++j) {
                    if (!((String)this.getCategories().get(i)).equals(this.getCategories().get(j)) || i == j) continue;
                    return (String)this.getCategories().get(i);
                }
            }
        }
        return null;
    }

    public final ObservableList<String> getCategories() {
        return (ObservableList)this.categories.get();
    }

    public final double getCategorySpacing() {
        return this.categorySpacing.get();
    }

    public final ReadOnlyDoubleProperty categorySpacingProperty() {
        return this.categorySpacing.getReadOnlyProperty();
    }

    public CategoryAxis() {
        this.itemsListener = CategoryAxis$$Lambda$1.lambdaFactory$(this);
        this.startMargin = new StyleableDoubleProperty(5.0){

            @Override
            protected void invalidated() {
                CategoryAxis.this.requestAxisLayout();
            }

            @Override
            public CssMetaData<CategoryAxis, Number> getCssMetaData() {
                return StyleableProperties.START_MARGIN;
            }

            @Override
            public Object getBean() {
                return CategoryAxis.this;
            }

            @Override
            public String getName() {
                return "startMargin";
            }
        };
        this.endMargin = new StyleableDoubleProperty(5.0){

            @Override
            protected void invalidated() {
                CategoryAxis.this.requestAxisLayout();
            }

            @Override
            public CssMetaData<CategoryAxis, Number> getCssMetaData() {
                return StyleableProperties.END_MARGIN;
            }

            @Override
            public Object getBean() {
                return CategoryAxis.this;
            }

            @Override
            public String getName() {
                return "endMargin";
            }
        };
        this.gapStartAndEnd = new StyleableBooleanProperty(true){

            @Override
            protected void invalidated() {
                CategoryAxis.this.requestAxisLayout();
            }

            @Override
            public CssMetaData<CategoryAxis, Boolean> getCssMetaData() {
                return StyleableProperties.GAP_START_AND_END;
            }

            @Override
            public Object getBean() {
                return CategoryAxis.this;
            }

            @Override
            public String getName() {
                return "gapStartAndEnd";
            }
        };
        this.categories = new ObjectPropertyBase<ObservableList<String>>(){
            ObservableList<String> old;

            @Override
            protected void invalidated() {
                if (CategoryAxis.this.getDuplicate() != null) {
                    throw new IllegalArgumentException("Duplicate category added; " + CategoryAxis.this.getDuplicate() + " already present");
                }
                ObservableList newItems = (ObservableList)this.get();
                if (this.old != newItems) {
                    if (this.old != null) {
                        this.old.removeListener(CategoryAxis.this.itemsListener);
                    }
                    if (newItems != null) {
                        newItems.addListener(CategoryAxis.this.itemsListener);
                    }
                    this.old = newItems;
                }
            }

            @Override
            public Object getBean() {
                return CategoryAxis.this;
            }

            @Override
            public String getName() {
                return "categories";
            }
        };
        this.categorySpacing = new ReadOnlyDoubleWrapper(this, "categorySpacing", 1.0);
        this.changeIsLocal = true;
        this.setCategories(FXCollections.observableArrayList());
        this.changeIsLocal = false;
    }

    public CategoryAxis(ObservableList<String> categories) {
        this.itemsListener = CategoryAxis$$Lambda$2.lambdaFactory$(this);
        this.startMargin = new /* invalid duplicate definition of identical inner class */;
        this.endMargin = new /* invalid duplicate definition of identical inner class */;
        this.gapStartAndEnd = new /* invalid duplicate definition of identical inner class */;
        this.categories = new /* invalid duplicate definition of identical inner class */;
        this.categorySpacing = new ReadOnlyDoubleWrapper(this, "categorySpacing", 1.0);
        this.setCategories(categories);
    }

    private double calculateNewSpacing(double length, List<String> categories) {
        Side side = this.getEffectiveSide();
        double newCategorySpacing = 1.0;
        if (categories != null) {
            double bVal = this.isGapStartAndEnd() ? categories.size() : categories.size() - 1;
            double d = newCategorySpacing = bVal == 0.0 ? 1.0 : (length - this.getStartMargin() - this.getEndMargin()) / bVal;
        }
        if (!this.isAutoRanging()) {
            this.categorySpacing.set(newCategorySpacing);
        }
        return newCategorySpacing;
    }

    private double calculateNewFirstPos(double length, double catSpacing) {
        Side side = this.getEffectiveSide();
        double newPos = 1.0;
        double offset = this.isGapStartAndEnd() ? catSpacing / 2.0 : 0.0;
        newPos = side.isHorizontal() ? 0.0 + this.getStartMargin() + offset : length - this.getStartMargin() - offset;
        if (!this.isAutoRanging()) {
            this.firstCategoryPos.set(newPos);
        }
        return newPos;
    }

    @Override
    protected Object getRange() {
        return new Object[]{this.getCategories(), this.categorySpacing.get(), this.firstCategoryPos.get(), this.getEffectiveTickLabelRotation()};
    }

    @Override
    protected void setRange(Object range, boolean animate) {
        Object[] rangeArray = (Object[])range;
        List categories = (List)rangeArray[0];
        double newCategorySpacing = (Double)rangeArray[1];
        double newFirstCategoryPos = (Double)rangeArray[2];
        this.setEffectiveTickLabelRotation((Double)rangeArray[3]);
        this.changeIsLocal = true;
        this.setCategories(FXCollections.observableArrayList(categories));
        this.changeIsLocal = false;
        if (animate) {
            this.animator.stop(this.currentAnimationID);
            this.currentAnimationID = this.animator.animate(new KeyFrame(Duration.ZERO, new KeyValue(this.firstCategoryPos, this.firstCategoryPos.get()), new KeyValue(this.categorySpacing, this.categorySpacing.get())), new KeyFrame(Duration.millis(1000.0), new KeyValue(this.firstCategoryPos, newFirstCategoryPos), new KeyValue(this.categorySpacing, newCategorySpacing)));
        } else {
            this.categorySpacing.set(newCategorySpacing);
            this.firstCategoryPos.set(newFirstCategoryPos);
        }
    }

    @Override
    protected Object autoRange(double length) {
        double requiredLengthToDisplay;
        Side side = this.getEffectiveSide();
        double newCategorySpacing = this.calculateNewSpacing(length, this.allDataCategories);
        double newFirstPos = this.calculateNewFirstPos(length, newCategorySpacing);
        double tickLabelRotation = this.getTickLabelRotation();
        if (length >= 0.0 && (requiredLengthToDisplay = this.calculateRequiredSize(side.isVertical(), tickLabelRotation)) > length) {
            tickLabelRotation = 90.0;
        }
        return new Object[]{this.allDataCategories, newCategorySpacing, newFirstPos, tickLabelRotation};
    }

    private double calculateRequiredSize(boolean axisVertical, double tickLabelRotation) {
        double requiredLengthToDisplay = Double.MAX_VALUE;
        double maxReqTickGap = 0.0;
        double last = 0.0;
        boolean first = true;
        for (String category : this.allDataCategories) {
            double size;
            Dimension2D textSize = this.measureTickMarkSize(category, tickLabelRotation);
            double d = size = axisVertical || tickLabelRotation != 0.0 ? textSize.getHeight() : textSize.getWidth();
            if (first) {
                first = false;
                last = size / 2.0;
                continue;
            }
            maxReqTickGap = Math.max(maxReqTickGap, last + 6.0 + size / 2.0);
        }
        return this.getStartMargin() + maxReqTickGap * (double)this.allDataCategories.size() + this.getEndMargin();
    }

    @Override
    protected List<String> calculateTickValues(double length, Object range) {
        Object[] rangeArray = (Object[])range;
        return (List)rangeArray[0];
    }

    @Override
    protected String getTickMarkLabel(String value) {
        return value;
    }

    @Override
    protected Dimension2D measureTickMarkSize(String value, Object range) {
        Object[] rangeArray = (Object[])range;
        double tickLabelRotation = (Double)rangeArray[3];
        return this.measureTickMarkSize(value, tickLabelRotation);
    }

    @Override
    public void invalidateRange(List<String> data) {
        super.invalidateRange(data);
        ArrayList<String> categoryNames = new ArrayList<String>();
        categoryNames.addAll(this.allDataCategories);
        for (String cat : this.allDataCategories) {
            if (data.contains(cat)) continue;
            categoryNames.remove(cat);
        }
        for (int i = 0; i < data.size(); ++i) {
            int len = categoryNames.size();
            if (categoryNames.contains(data.get(i))) continue;
            categoryNames.add(i > len ? len : i, data.get(i));
        }
        this.allDataCategories.clear();
        this.allDataCategories.addAll(categoryNames);
    }

    final List<String> getAllDataCategories() {
        return this.allDataCategories;
    }

    @Override
    public double getDisplayPosition(String value) {
        ObservableList<String> cat = this.getCategories();
        if (!cat.contains(value)) {
            return Double.NaN;
        }
        if (this.getEffectiveSide().isHorizontal()) {
            return this.firstCategoryPos.get() + (double)cat.indexOf(value) * this.categorySpacing.get();
        }
        return this.firstCategoryPos.get() + (double)cat.indexOf(value) * this.categorySpacing.get() * -1.0;
    }

    @Override
    public String getValueForDisplay(double displayPosition) {
        if (this.getEffectiveSide().isHorizontal()) {
            if (displayPosition < 0.0 || displayPosition > this.getWidth()) {
                return null;
            }
            double d = (displayPosition - this.firstCategoryPos.get()) / this.categorySpacing.get();
            return this.toRealValue(d);
        }
        if (displayPosition < 0.0 || displayPosition > this.getHeight()) {
            return null;
        }
        double d = (displayPosition - this.firstCategoryPos.get()) / (this.categorySpacing.get() * -1.0);
        return this.toRealValue(d);
    }

    @Override
    public boolean isValueOnAxis(String value) {
        return this.getCategories().indexOf("" + value) != -1;
    }

    @Override
    public double toNumericValue(String value) {
        return this.getCategories().indexOf(value);
    }

    @Override
    public String toRealValue(double value) {
        int index = (int)Math.round(value);
        ObservableList<String> categories = this.getCategories();
        if (index >= 0 && index < categories.size()) {
            return (String)this.getCategories().get(index);
        }
        return null;
    }

    @Override
    public double getZeroPosition() {
        return Double.NaN;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return CategoryAxis.getClassCssMetaData();
    }

    private /* synthetic */ void lambda$new$569(ListChangeListener.Change c) {
        while (c.next()) {
            if (!c.getAddedSubList().isEmpty()) {
                for (String addedStr : c.getAddedSubList()) {
                    this.checkAndRemoveDuplicates(addedStr);
                }
            }
            if (!this.isAutoRanging()) {
                this.allDataCategories.clear();
                this.allDataCategories.addAll(this.getCategories());
                this.rangeValid = false;
            }
            this.requestAxisLayout();
        }
    }

    static /* synthetic */ void access$lambda$0(CategoryAxis categoryAxis, ListChangeListener.Change change) {
        categoryAxis.lambda$new$569(change);
    }

    static /* synthetic */ void access$lambda$1(CategoryAxis categoryAxis, ListChangeListener.Change change) {
        categoryAxis.lambda$new$569(change);
    }

    private static class StyleableProperties {
        private static final CssMetaData<CategoryAxis, Number> START_MARGIN = new CssMetaData<CategoryAxis, Number>("-fx-start-margin", SizeConverter.getInstance(), (Number)5.0){

            @Override
            public boolean isSettable(CategoryAxis n) {
                return n.startMargin == null || !n.startMargin.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(CategoryAxis n) {
                return (StyleableProperty)((Object)n.startMarginProperty());
            }
        };
        private static final CssMetaData<CategoryAxis, Number> END_MARGIN = new CssMetaData<CategoryAxis, Number>("-fx-end-margin", SizeConverter.getInstance(), (Number)5.0){

            @Override
            public boolean isSettable(CategoryAxis n) {
                return n.endMargin == null || !n.endMargin.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(CategoryAxis n) {
                return (StyleableProperty)((Object)n.endMarginProperty());
            }
        };
        private static final CssMetaData<CategoryAxis, Boolean> GAP_START_AND_END = new CssMetaData<CategoryAxis, Boolean>("-fx-gap-start-and-end", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(CategoryAxis n) {
                return n.gapStartAndEnd == null || !n.gapStartAndEnd.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(CategoryAxis n) {
                return (StyleableProperty)((Object)n.gapStartAndEndProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Axis.getClassCssMetaData());
            styleables.add(START_MARGIN);
            styleables.add(END_MARGIN);
            styleables.add(GAP_START_AND_END);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

