/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.ChartLayoutAnimator;
import com.sun.javafx.css.converters.SizeConverter;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.Side;
import javafx.scene.chart.NumberAxis$DefaultFormatter$$Lambda$1;
import javafx.scene.chart.ValueAxis;
import javafx.util.Duration;
import javafx.util.StringConverter;

public final class NumberAxis
extends ValueAxis<Number> {
    private Object currentAnimationID;
    private final ChartLayoutAnimator animator = new ChartLayoutAnimator(this);
    private final StringProperty currentFormatterProperty = new SimpleStringProperty(this, "currentFormatter", "");
    private final DefaultFormatter defaultFormatter = new DefaultFormatter(this);
    private BooleanProperty forceZeroInRange = new BooleanPropertyBase(true){

        @Override
        protected void invalidated() {
            if (NumberAxis.this.isAutoRanging()) {
                NumberAxis.this.requestAxisLayout();
                NumberAxis.this.invalidateRange();
            }
        }

        @Override
        public Object getBean() {
            return NumberAxis.this;
        }

        @Override
        public String getName() {
            return "forceZeroInRange";
        }
    };
    private DoubleProperty tickUnit = new StyleableDoubleProperty(5.0){

        @Override
        protected void invalidated() {
            if (!NumberAxis.this.isAutoRanging()) {
                NumberAxis.this.invalidateRange();
                NumberAxis.this.requestAxisLayout();
            }
        }

        @Override
        public CssMetaData<NumberAxis, Number> getCssMetaData() {
            return StyleableProperties.TICK_UNIT;
        }

        @Override
        public Object getBean() {
            return NumberAxis.this;
        }

        @Override
        public String getName() {
            return "tickUnit";
        }
    };

    public final boolean isForceZeroInRange() {
        return this.forceZeroInRange.getValue();
    }

    public final void setForceZeroInRange(boolean value) {
        this.forceZeroInRange.setValue(value);
    }

    public final BooleanProperty forceZeroInRangeProperty() {
        return this.forceZeroInRange;
    }

    public final double getTickUnit() {
        return this.tickUnit.get();
    }

    public final void setTickUnit(double value) {
        this.tickUnit.set(value);
    }

    public final DoubleProperty tickUnitProperty() {
        return this.tickUnit;
    }

    public NumberAxis() {
    }

    public NumberAxis(double lowerBound, double upperBound, double tickUnit) {
        super(lowerBound, upperBound);
        this.setTickUnit(tickUnit);
    }

    public NumberAxis(String axisLabel, double lowerBound, double upperBound, double tickUnit) {
        super(lowerBound, upperBound);
        this.setTickUnit(tickUnit);
        this.setLabel(axisLabel);
    }

    @Override
    protected String getTickMarkLabel(Number value) {
        DefaultFormatter formatter = this.getTickLabelFormatter();
        if (formatter == null) {
            formatter = this.defaultFormatter;
        }
        return ((StringConverter)formatter).toString(value);
    }

    @Override
    protected Object getRange() {
        return new Object[]{this.getLowerBound(), this.getUpperBound(), this.getTickUnit(), this.getScale(), this.currentFormatterProperty.get()};
    }

    @Override
    protected void setRange(Object range, boolean animate) {
        Object[] rangeProps = (Object[])range;
        double lowerBound = (Double)rangeProps[0];
        double upperBound = (Double)rangeProps[1];
        double tickUnit = (Double)rangeProps[2];
        double scale = (Double)rangeProps[3];
        String formatter = (String)rangeProps[4];
        this.currentFormatterProperty.set(formatter);
        double oldLowerBound = this.getLowerBound();
        this.setLowerBound(lowerBound);
        this.setUpperBound(upperBound);
        this.setTickUnit(tickUnit);
        if (animate) {
            this.animator.stop(this.currentAnimationID);
            this.currentAnimationID = this.animator.animate(new KeyFrame(Duration.ZERO, new KeyValue(this.currentLowerBound, oldLowerBound), new KeyValue(this.scalePropertyImpl(), this.getScale())), new KeyFrame(Duration.millis(700.0), new KeyValue(this.currentLowerBound, lowerBound), new KeyValue(this.scalePropertyImpl(), scale)));
        } else {
            this.currentLowerBound.set(lowerBound);
            this.setScale(scale);
        }
    }

    @Override
    protected List<Number> calculateTickValues(double length, Object range) {
        Object[] rangeProps = (Object[])range;
        double lowerBound = (Double)rangeProps[0];
        double upperBound = (Double)rangeProps[1];
        double tickUnit = (Double)rangeProps[2];
        ArrayList<Number> tickValues = new ArrayList<Number>();
        if (lowerBound == upperBound) {
            tickValues.add(lowerBound);
        } else if (tickUnit <= 0.0) {
            tickValues.add(lowerBound);
            tickValues.add(upperBound);
        } else if (tickUnit > 0.0) {
            tickValues.add(lowerBound);
            if ((upperBound - lowerBound) / tickUnit > 2000.0) {
                System.err.println("Warning we tried to create more than 2000 major tick marks on a NumberAxis. Lower Bound=" + lowerBound + ", Upper Bound=" + upperBound + ", Tick Unit=" + tickUnit);
            } else if (lowerBound + tickUnit < upperBound) {
                double first;
                for (double major = first = Math.rint(tickUnit) == tickUnit ? Math.ceil(lowerBound) : lowerBound + tickUnit; major < upperBound; major += tickUnit) {
                    if (tickValues.contains(major)) continue;
                    tickValues.add(major);
                }
            }
            tickValues.add(upperBound);
        }
        return tickValues;
    }

    @Override
    protected List<Number> calculateMinorTickMarks() {
        ArrayList<Number> minorTickMarks = new ArrayList<Number>();
        double lowerBound = this.getLowerBound();
        double upperBound = this.getUpperBound();
        double tickUnit = this.getTickUnit();
        double minorUnit = tickUnit / (double)Math.max(1, this.getMinorTickCount());
        if (tickUnit > 0.0) {
            double major;
            boolean tickUnitIsInteger;
            if ((upperBound - lowerBound) / minorUnit > 10000.0) {
                System.err.println("Warning we tried to create more than 10000 minor tick marks on a NumberAxis. Lower Bound=" + this.getLowerBound() + ", Upper Bound=" + this.getUpperBound() + ", Tick Unit=" + tickUnit);
                return minorTickMarks;
            }
            boolean bl = tickUnitIsInteger = Math.rint(tickUnit) == tickUnit;
            if (tickUnitIsInteger) {
                for (double minor = Math.floor(lowerBound) + minorUnit; minor < Math.ceil(lowerBound); minor += minorUnit) {
                    if (!(minor > lowerBound)) continue;
                    minorTickMarks.add(minor);
                }
            }
            double d = major = tickUnitIsInteger ? Math.ceil(lowerBound) : lowerBound;
            while (major < upperBound) {
                double next = Math.min(major + tickUnit, upperBound);
                for (double minor = major + minorUnit; minor < next; minor += minorUnit) {
                    minorTickMarks.add(minor);
                }
                major += tickUnit;
            }
        }
        return minorTickMarks;
    }

    @Override
    protected Dimension2D measureTickMarkSize(Number value, Object range) {
        Object[] rangeProps = (Object[])range;
        String formatter = (String)rangeProps[4];
        return this.measureTickMarkSize(value, this.getTickLabelRotation(), formatter);
    }

    private Dimension2D measureTickMarkSize(Number value, double rotation, String numFormatter) {
        DefaultFormatter formatter = this.getTickLabelFormatter();
        if (formatter == null) {
            formatter = this.defaultFormatter;
        }
        String labelText = formatter instanceof DefaultFormatter ? formatter.toString(value, numFormatter) : ((StringConverter)formatter).toString(value);
        return this.measureTickMarkLabelSize(labelText, rotation);
    }

    @Override
    protected Object autoRange(double minValue, double maxValue, double length, double labelSize) {
        double range;
        Side side = this.getEffectiveSide();
        if (this.isForceZeroInRange()) {
            if (maxValue < 0.0) {
                maxValue = 0.0;
            } else if (minValue > 0.0) {
                minValue = 0.0;
            }
        }
        double paddedRange = (range = maxValue - minValue) == 0.0 ? 2.0 : Math.abs(range) * 1.02;
        double padding = (paddedRange - range) / 2.0;
        double paddedMin = minValue - padding;
        double paddedMax = maxValue + padding;
        if (paddedMin < 0.0 && minValue >= 0.0 || paddedMin > 0.0 && minValue <= 0.0) {
            paddedMin = 0.0;
        }
        if (paddedMax < 0.0 && maxValue >= 0.0 || paddedMax > 0.0 && maxValue <= 0.0) {
            paddedMax = 0.0;
        }
        int numOfTickMarks = (int)Math.floor(length / labelSize);
        numOfTickMarks = Math.max(numOfTickMarks, 2);
        double tickUnit = paddedRange / (double)numOfTickMarks;
        double tickUnitRounded = 0.0;
        double minRounded = 0.0;
        double maxRounded = 0.0;
        int count = 0;
        double reqLength = Double.MAX_VALUE;
        String formatter = "0.00000000";
        while (reqLength > length || count > 20) {
            double mant;
            int exp = (int)Math.floor(Math.log10(tickUnit));
            double ratio = mant = tickUnit / Math.pow(10.0, exp);
            if (mant > 5.0) {
                ++exp;
                ratio = 1.0;
            } else if (mant > 1.0) {
                double d = ratio = mant > 2.5 ? 5.0 : 2.5;
            }
            if (exp > 1) {
                formatter = "#,##0";
            } else if (exp == 1) {
                formatter = "0";
            } else {
                int n;
                boolean ratioHasFrac = Math.rint(ratio) != ratio;
                StringBuilder formatterB = new StringBuilder("0");
                int n2 = n = ratioHasFrac ? Math.abs(exp) + 1 : Math.abs(exp);
                if (n > 0) {
                    formatterB.append(".");
                }
                for (int i = 0; i < n; ++i) {
                    formatterB.append("0");
                }
                formatter = formatterB.toString();
            }
            tickUnitRounded = ratio * Math.pow(10.0, exp);
            minRounded = Math.floor(paddedMin / tickUnitRounded) * tickUnitRounded;
            maxRounded = Math.ceil(paddedMax / tickUnitRounded) * tickUnitRounded;
            double maxReqTickGap = 0.0;
            double last = 0.0;
            count = 0;
            double major = minRounded;
            while (major <= maxRounded) {
                double size;
                double d = size = side.isVertical() ? this.measureTickMarkSize(major, this.getTickLabelRotation(), formatter).getHeight() : this.measureTickMarkSize(major, this.getTickLabelRotation(), formatter).getWidth();
                if (major == minRounded) {
                    last = size / 2.0;
                } else {
                    maxReqTickGap = Math.max(maxReqTickGap, last + 6.0 + size / 2.0);
                }
                major += tickUnitRounded;
                ++count;
            }
            reqLength = (double)(count - 1) * maxReqTickGap;
            tickUnit = tickUnitRounded;
            if (numOfTickMarks == 2 && reqLength > length) break;
            if (!(reqLength > length) && count <= 20) continue;
            tickUnit *= 2.0;
        }
        double newScale = this.calculateNewScale(length, minRounded, maxRounded);
        return new Object[]{minRounded, maxRounded, tickUnitRounded, newScale, formatter};
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return NumberAxis.getClassCssMetaData();
    }

    public static class DefaultFormatter
    extends StringConverter<Number> {
        private DecimalFormat formatter;
        private String prefix = null;
        private String suffix = null;

        public DefaultFormatter(NumberAxis axis) {
            this.formatter = axis.isAutoRanging() ? new DecimalFormat((String)axis.currentFormatterProperty.get()) : new DecimalFormat();
            ChangeListener axisListener = NumberAxis$DefaultFormatter$$Lambda$1.lambdaFactory$(this, axis);
            axis.currentFormatterProperty.addListener(axisListener);
            axis.autoRangingProperty().addListener(axisListener);
        }

        public DefaultFormatter(NumberAxis axis, String prefix, String suffix) {
            this(axis);
            this.prefix = prefix;
            this.suffix = suffix;
        }

        @Override
        public String toString(Number object) {
            return this.toString(object, this.formatter);
        }

        private String toString(Number object, String numFormatter) {
            if (numFormatter == null || numFormatter.isEmpty()) {
                return this.toString(object, this.formatter);
            }
            return this.toString(object, new DecimalFormat(numFormatter));
        }

        private String toString(Number object, DecimalFormat formatter) {
            if (this.prefix != null && this.suffix != null) {
                return this.prefix + formatter.format(object) + this.suffix;
            }
            if (this.prefix != null) {
                return this.prefix + formatter.format(object);
            }
            if (this.suffix != null) {
                return formatter.format(object) + this.suffix;
            }
            return formatter.format(object);
        }

        @Override
        public Number fromString(String string) {
            try {
                int prefixLength = this.prefix == null ? 0 : this.prefix.length();
                int suffixLength = this.suffix == null ? 0 : this.suffix.length();
                return this.formatter.parse(string.substring(prefixLength, string.length() - suffixLength));
            }
            catch (ParseException e) {
                return null;
            }
        }

        private /* synthetic */ void lambda$new$470(NumberAxis axis, ObservableValue observable, Object oldValue, Object newValue) {
            this.formatter = axis.isAutoRanging() ? new DecimalFormat((String)axis.currentFormatterProperty.get()) : new DecimalFormat();
        }

        static /* synthetic */ void access$lambda$0(DefaultFormatter defaultFormatter, NumberAxis numberAxis, ObservableValue observableValue, Object object, Object object2) {
            defaultFormatter.lambda$new$470(numberAxis, observableValue, object, object2);
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<NumberAxis, Number> TICK_UNIT = new CssMetaData<NumberAxis, Number>("-fx-tick-unit", SizeConverter.getInstance(), (Number)5.0){

            @Override
            public boolean isSettable(NumberAxis n) {
                return n.tickUnit == null || !n.tickUnit.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(NumberAxis n) {
                return (StyleableProperty)((Object)n.tickUnitProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(ValueAxis.getClassCssMetaData());
            styleables.add(TICK_UNIT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

