/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.CheckBoxTreeItem$$Lambda$1;
import javafx.scene.control.TreeItem;

public class CheckBoxTreeItem<T>
extends TreeItem<T> {
    private static final EventType<? extends Event> CHECK_BOX_SELECTION_CHANGED_EVENT = new EventType<Event>(TreeModificationEvent.ANY, "checkBoxSelectionChangedEvent");
    private final ChangeListener<Boolean> stateChangeListener = CheckBoxTreeItem$$Lambda$1.lambdaFactory$(this);
    private final BooleanProperty selected = new SimpleBooleanProperty(this, "selected", false){

        @Override
        protected void invalidated() {
            super.invalidated();
            CheckBoxTreeItem.this.fireEvent(CheckBoxTreeItem.this, true);
        }
    };
    private final BooleanProperty indeterminate = new SimpleBooleanProperty(this, "indeterminate", false){

        @Override
        protected void invalidated() {
            super.invalidated();
            CheckBoxTreeItem.this.fireEvent(CheckBoxTreeItem.this, false);
        }
    };
    private final BooleanProperty independent = new SimpleBooleanProperty(this, "independent", false);
    private static boolean updateLock = false;

    public static <T> EventType<TreeModificationEvent<T>> checkBoxSelectionChangedEvent() {
        return CHECK_BOX_SELECTION_CHANGED_EVENT;
    }

    public CheckBoxTreeItem() {
        this(null);
    }

    public CheckBoxTreeItem(T value) {
        this(value, null, false);
    }

    public CheckBoxTreeItem(T value, Node graphic) {
        this(value, graphic, false);
    }

    public CheckBoxTreeItem(T value, Node graphic, boolean selected) {
        this(value, graphic, selected, false);
    }

    public CheckBoxTreeItem(T value, Node graphic, boolean selected, boolean independent) {
        super(value, graphic);
        this.setSelected(selected);
        this.setIndependent(independent);
        this.selectedProperty().addListener(this.stateChangeListener);
        this.indeterminateProperty().addListener(this.stateChangeListener);
    }

    public final void setSelected(boolean value) {
        this.selectedProperty().setValue(value);
    }

    public final boolean isSelected() {
        return this.selected.getValue();
    }

    public final BooleanProperty selectedProperty() {
        return this.selected;
    }

    public final void setIndeterminate(boolean value) {
        this.indeterminateProperty().setValue(value);
    }

    public final boolean isIndeterminate() {
        return this.indeterminate.getValue();
    }

    public final BooleanProperty indeterminateProperty() {
        return this.indeterminate;
    }

    public final BooleanProperty independentProperty() {
        return this.independent;
    }

    public final void setIndependent(boolean value) {
        this.independentProperty().setValue(value);
    }

    public final boolean isIndependent() {
        return this.independent.getValue();
    }

    private void updateState() {
        if (this.isIndependent()) {
            return;
        }
        boolean firstLock = !updateLock;
        updateLock = true;
        this.updateUpwards();
        if (firstLock) {
            updateLock = false;
        }
        if (updateLock) {
            return;
        }
        this.updateDownwards();
    }

    private void updateUpwards() {
        if (!(this.getParent() instanceof CheckBoxTreeItem)) {
            return;
        }
        CheckBoxTreeItem parent = (CheckBoxTreeItem)this.getParent();
        int selectCount = 0;
        int indeterminateCount = 0;
        for (TreeItem treeItem : parent.getChildren()) {
            if (!(treeItem instanceof CheckBoxTreeItem)) continue;
            CheckBoxTreeItem cbti = (CheckBoxTreeItem)treeItem;
            selectCount += cbti.isSelected() && !cbti.isIndeterminate() ? 1 : 0;
            indeterminateCount += cbti.isIndeterminate() ? 1 : 0;
        }
        if (selectCount == parent.getChildren().size()) {
            parent.setSelected(true);
            parent.setIndeterminate(false);
        } else if (selectCount == 0 && indeterminateCount == 0) {
            parent.setSelected(false);
            parent.setIndeterminate(false);
        } else {
            parent.setIndeterminate(true);
        }
    }

    private void updateDownwards() {
        if (!this.isLeaf()) {
            for (TreeItem treeItem : this.getChildren()) {
                if (!(treeItem instanceof CheckBoxTreeItem)) continue;
                CheckBoxTreeItem cbti = (CheckBoxTreeItem)treeItem;
                cbti.setSelected(this.isSelected());
            }
        }
    }

    private void fireEvent(CheckBoxTreeItem<T> item, boolean selectionChanged) {
        TreeModificationEvent<T> evt = new TreeModificationEvent<T>(CHECK_BOX_SELECTION_CHANGED_EVENT, item, selectionChanged);
        Event.fireEvent(this, evt);
    }

    private /* synthetic */ void lambda$new$606(ObservableValue ov, Boolean oldVal, Boolean newVal) {
        this.updateState();
    }

    static /* synthetic */ void access$lambda$0(CheckBoxTreeItem checkBoxTreeItem, ObservableValue observableValue, Boolean bl, Boolean bl2) {
        checkBoxTreeItem.lambda$new$606(observableValue, bl, bl2);
    }

    public static class TreeModificationEvent<T>
    extends Event {
        private static final long serialVersionUID = -8445355590698862999L;
        private final transient CheckBoxTreeItem<T> treeItem;
        private final boolean selectionChanged;
        public static final EventType<Event> ANY = new EventType<Event>(Event.ANY, "TREE_MODIFICATION");

        public TreeModificationEvent(EventType<? extends Event> eventType, CheckBoxTreeItem<T> treeItem, boolean selectionChanged) {
            super(eventType);
            this.treeItem = treeItem;
            this.selectionChanged = selectionChanged;
        }

        public CheckBoxTreeItem<T> getTreeItem() {
            return this.treeItem;
        }

        public boolean wasSelectionChanged() {
            return this.selectionChanged;
        }

        public boolean wasIndeterminateChanged() {
            return !this.selectionChanged;
        }
    }
}

