/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceDialog$$Lambda$1;
import javafx.scene.control.ChoiceDialog$$Lambda$2;
import javafx.scene.control.ChoiceDialog$$Lambda$3;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;

public class ChoiceDialog<T>
extends Dialog<T> {
    private final GridPane grid;
    private final Label label;
    private final ComboBox<T> comboBox;
    private final T defaultChoice;

    public ChoiceDialog() {
        this(null, (Object[])null);
    }

    public ChoiceDialog(T defaultChoice, T ... choices) {
        this(defaultChoice, choices == null ? Collections.emptyList() : Arrays.asList(choices));
    }

    public ChoiceDialog(T defaultChoice, Collection<T> choices) {
        DialogPane dialogPane = this.getDialogPane();
        this.grid = new GridPane();
        this.grid.setHgap(10.0);
        this.grid.setMaxWidth(Double.MAX_VALUE);
        this.grid.setAlignment(Pos.CENTER_LEFT);
        this.label = DialogPane.createContentLabel(dialogPane.getContentText());
        this.label.setPrefWidth(-1.0);
        this.label.textProperty().bind(dialogPane.contentTextProperty());
        dialogPane.contentTextProperty().addListener(ChoiceDialog$$Lambda$1.lambdaFactory$(this));
        this.setTitle(ControlResources.getString("Dialog.confirm.title"));
        dialogPane.setHeaderText(ControlResources.getString("Dialog.confirm.header"));
        dialogPane.getStyleClass().add("choice-dialog");
        dialogPane.getButtonTypes().addAll((ButtonType[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        double MIN_WIDTH = 150.0;
        this.comboBox = new ComboBox();
        this.comboBox.setMinWidth(150.0);
        if (choices != null) {
            this.comboBox.getItems().addAll(choices);
        }
        this.comboBox.setMaxWidth(Double.MAX_VALUE);
        GridPane.setHgrow(this.comboBox, Priority.ALWAYS);
        GridPane.setFillWidth(this.comboBox, true);
        Object object = this.defaultChoice = this.comboBox.getItems().contains(defaultChoice) ? defaultChoice : null;
        if (defaultChoice == null) {
            this.comboBox.getSelectionModel().selectFirst();
        } else {
            this.comboBox.getSelectionModel().select(defaultChoice);
        }
        this.updateGrid();
        this.setResultConverter(ChoiceDialog$$Lambda$2.lambdaFactory$(this));
    }

    public final T getSelectedItem() {
        return this.comboBox.getSelectionModel().getSelectedItem();
    }

    public final ReadOnlyObjectProperty<T> selectedItemProperty() {
        return this.comboBox.getSelectionModel().selectedItemProperty();
    }

    public final void setSelectedItem(T item) {
        this.comboBox.getSelectionModel().select(item);
    }

    public final ObservableList<T> getItems() {
        return this.comboBox.getItems();
    }

    public final T getDefaultChoice() {
        return this.defaultChoice;
    }

    private void updateGrid() {
        this.grid.getChildren().clear();
        this.grid.add(this.label, 0, 0);
        this.grid.add(this.comboBox, 1, 0);
        this.getDialogPane().setContent(this.grid);
        Platform.runLater(ChoiceDialog$$Lambda$3.lambdaFactory$(this));
    }

    private /* synthetic */ void lambda$updateGrid$609() {
        this.comboBox.requestFocus();
    }

    private /* synthetic */ Object lambda$new$608(ButtonType dialogButton) {
        ButtonBar.ButtonData data = dialogButton == null ? null : dialogButton.getButtonData();
        return data == ButtonBar.ButtonData.OK_DONE ? this.getSelectedItem() : null;
    }

    private /* synthetic */ void lambda$new$607(Observable o) {
        this.updateGrid();
    }

    static /* synthetic */ void access$lambda$0(ChoiceDialog choiceDialog, Observable observable) {
        choiceDialog.lambda$new$607(observable);
    }

    static /* synthetic */ Object access$lambda$1(ChoiceDialog choiceDialog, ButtonType buttonType) {
        return choiceDialog.lambda$new$608(buttonType);
    }

    static /* synthetic */ void access$lambda$2(ChoiceDialog choiceDialog) {
        choiceDialog.lambda$updateGrid$609();
    }
}

