/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.converters.StringConverter;
import com.sun.javafx.scene.control.skin.Utils;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.StyleableStringProperty;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane$$Lambda$1;
import javafx.scene.control.DialogPane$$Lambda$2;
import javafx.scene.control.DialogPane$$Lambda$3;
import javafx.scene.control.DialogPane$$Lambda$4;
import javafx.scene.control.DialogPane$$Lambda$5;
import javafx.scene.control.DialogPane$$Lambda$6;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

@DefaultProperty(value="buttonTypes")
public class DialogPane
extends Pane {
    private final GridPane headerTextPanel;
    private final Label contentLabel;
    private final StackPane graphicContainer;
    private final Node buttonBar;
    private final ObservableList<ButtonType> buttons = FXCollections.observableArrayList();
    private final Map<ButtonType, Node> buttonNodes = new WeakHashMap<ButtonType, Node>();
    private Node detailsButton;
    private Dialog<?> dialog;
    private final ObjectProperty<Node> graphicProperty = new StyleableObjectProperty<Node>(){
        WeakReference<Node> graphicRef = new WeakReference<Object>(null);

        @Override
        public CssMetaData getCssMetaData() {
            return StyleableProperties.GRAPHIC;
        }

        @Override
        public Object getBean() {
            return DialogPane.this;
        }

        @Override
        public String getName() {
            return "graphic";
        }

        @Override
        protected void invalidated() {
            Node oldGraphic = (Node)this.graphicRef.get();
            if (oldGraphic != null) {
                DialogPane.this.getChildren().remove(oldGraphic);
            }
            Node newGraphic = DialogPane.this.getGraphic();
            this.graphicRef = new WeakReference<Node>(newGraphic);
            DialogPane.this.updateHeaderArea();
        }
    };
    private StyleableStringProperty imageUrl = null;
    private final ObjectProperty<Node> header = new SimpleObjectProperty<Node>(null){
        WeakReference<Node> headerRef;
        {
            this.headerRef = new WeakReference<Object>(null);
        }

        @Override
        protected void invalidated() {
            Node oldHeader = (Node)this.headerRef.get();
            if (oldHeader != null) {
                DialogPane.this.getChildren().remove(oldHeader);
            }
            Node newHeader = DialogPane.this.getHeader();
            this.headerRef = new WeakReference<Node>(newHeader);
            DialogPane.this.updateHeaderArea();
        }
    };
    private final StringProperty headerText = new SimpleStringProperty(this, "headerText"){

        @Override
        protected void invalidated() {
            DialogPane.this.updateHeaderArea();
            DialogPane.this.requestLayout();
        }
    };
    private final ObjectProperty<Node> content = new SimpleObjectProperty<Node>(null){
        WeakReference<Node> contentRef;
        {
            this.contentRef = new WeakReference<Object>(null);
        }

        @Override
        protected void invalidated() {
            Node oldContent = (Node)this.contentRef.get();
            if (oldContent != null) {
                DialogPane.this.getChildren().remove(oldContent);
            }
            Node newContent = DialogPane.this.getContent();
            this.contentRef = new WeakReference<Node>(newContent);
            DialogPane.this.updateContentArea();
        }
    };
    private final StringProperty contentText = new SimpleStringProperty(this, "contentText"){

        @Override
        protected void invalidated() {
            DialogPane.this.updateContentArea();
            DialogPane.this.requestLayout();
        }
    };
    private final ObjectProperty<Node> expandableContentProperty = new SimpleObjectProperty<Node>(null){
        WeakReference<Node> expandableContentRef;
        {
            this.expandableContentRef = new WeakReference<Object>(null);
        }

        @Override
        protected void invalidated() {
            Node oldExpandableContent = (Node)this.expandableContentRef.get();
            if (oldExpandableContent != null) {
                DialogPane.this.getChildren().remove(oldExpandableContent);
            }
            Node newExpandableContent = DialogPane.this.getExpandableContent();
            this.expandableContentRef = new WeakReference<Node>(newExpandableContent);
            if (newExpandableContent != null) {
                newExpandableContent.setVisible(DialogPane.this.isExpanded());
                newExpandableContent.setManaged(DialogPane.this.isExpanded());
                if (!newExpandableContent.getStyleClass().contains("expandable-content")) {
                    newExpandableContent.getStyleClass().add("expandable-content");
                }
                DialogPane.this.getChildren().add(newExpandableContent);
            }
        }
    };
    private final BooleanProperty expandedProperty = new SimpleBooleanProperty(this, "expanded", false){

        @Override
        protected void invalidated() {
            Node expandableContent = DialogPane.this.getExpandableContent();
            if (expandableContent != null) {
                expandableContent.setVisible(DialogPane.this.isExpanded());
            }
            DialogPane.this.requestLayout();
        }
    };
    private double oldHeight = -1.0;

    static Label createContentLabel(String text) {
        Label label = new Label(text);
        label.setMaxWidth(Double.MAX_VALUE);
        label.setMaxHeight(Double.MAX_VALUE);
        label.getStyleClass().add("content");
        label.setWrapText(true);
        label.setPrefWidth(360.0);
        return label;
    }

    public DialogPane() {
        this.getStyleClass().add("dialog-pane");
        this.headerTextPanel = new GridPane();
        this.getChildren().add(this.headerTextPanel);
        this.graphicContainer = new StackPane();
        this.contentLabel = DialogPane.createContentLabel("");
        this.getChildren().add(this.contentLabel);
        this.buttonBar = this.createButtonBar();
        if (this.buttonBar != null) {
            this.getChildren().add(this.buttonBar);
        }
        this.buttons.addListener(DialogPane$$Lambda$1.lambdaFactory$(this));
    }

    public final ObjectProperty<Node> graphicProperty() {
        return this.graphicProperty;
    }

    public final Node getGraphic() {
        return (Node)this.graphicProperty.get();
    }

    public final void setGraphic(Node graphic) {
        this.graphicProperty.set(graphic);
    }

    private StyleableStringProperty imageUrlProperty() {
        if (this.imageUrl == null) {
            this.imageUrl = new StyleableStringProperty(){
                StyleOrigin origin = StyleOrigin.USER;

                @Override
                public void applyStyle(StyleOrigin origin, String v) {
                    this.origin = origin;
                    if (DialogPane.this.graphicProperty == null || !DialogPane.this.graphicProperty.isBound()) {
                        super.applyStyle(origin, v);
                    }
                    this.origin = StyleOrigin.USER;
                }

                @Override
                protected void invalidated() {
                    String url = super.get();
                    if (url == null) {
                        ((StyleableProperty)((Object)DialogPane.this.graphicProperty())).applyStyle(this.origin, null);
                    } else {
                        String imageViewUrl;
                        ImageView imageView;
                        Image image;
                        Node graphicNode = DialogPane.this.getGraphic();
                        if (graphicNode instanceof ImageView && (image = (imageView = (ImageView)graphicNode).getImage()) != null && url.equals(imageViewUrl = image.impl_getUrl())) {
                            return;
                        }
                        Image img = StyleManager.getInstance().getCachedImage(url);
                        if (img != null) {
                            ((StyleableProperty)((Object)DialogPane.this.graphicProperty())).applyStyle(this.origin, new ImageView(img));
                        }
                    }
                }

                @Override
                public String get() {
                    Image image;
                    Node graphic = DialogPane.this.getGraphic();
                    if (graphic instanceof ImageView && (image = ((ImageView)graphic).getImage()) != null) {
                        return image.impl_getUrl();
                    }
                    return null;
                }

                @Override
                public StyleOrigin getStyleOrigin() {
                    return DialogPane.this.graphicProperty != null ? ((StyleableProperty)((Object)DialogPane.this.graphicProperty)).getStyleOrigin() : null;
                }

                @Override
                public Object getBean() {
                    return DialogPane.this;
                }

                @Override
                public String getName() {
                    return "imageUrl";
                }

                @Override
                public CssMetaData<DialogPane, String> getCssMetaData() {
                    return StyleableProperties.GRAPHIC;
                }
            };
        }
        return this.imageUrl;
    }

    public final Node getHeader() {
        return (Node)this.header.get();
    }

    public final void setHeader(Node header) {
        this.header.setValue(header);
    }

    public final ObjectProperty<Node> headerProperty() {
        return this.header;
    }

    public final void setHeaderText(String headerText) {
        this.headerText.set(headerText);
    }

    public final String getHeaderText() {
        return (String)this.headerText.get();
    }

    public final StringProperty headerTextProperty() {
        return this.headerText;
    }

    public final Node getContent() {
        return (Node)this.content.get();
    }

    public final void setContent(Node content) {
        this.content.setValue(content);
    }

    public final ObjectProperty<Node> contentProperty() {
        return this.content;
    }

    public final void setContentText(String contentText) {
        this.contentText.set(contentText);
    }

    public final String getContentText() {
        return (String)this.contentText.get();
    }

    public final StringProperty contentTextProperty() {
        return this.contentText;
    }

    public final ObjectProperty<Node> expandableContentProperty() {
        return this.expandableContentProperty;
    }

    public final Node getExpandableContent() {
        return (Node)this.expandableContentProperty.get();
    }

    public final void setExpandableContent(Node content) {
        this.expandableContentProperty.set(content);
    }

    public final BooleanProperty expandedProperty() {
        return this.expandedProperty;
    }

    public final boolean isExpanded() {
        return this.expandedProperty().get();
    }

    public final void setExpanded(boolean value) {
        this.expandedProperty().set(value);
    }

    public final ObservableList<ButtonType> getButtonTypes() {
        return this.buttons;
    }

    public final Node lookupButton(ButtonType buttonType) {
        return this.buttonNodes.get(buttonType);
    }

    protected Node createButtonBar() {
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.setMaxWidth(Double.MAX_VALUE);
        this.updateButtons(buttonBar);
        this.getButtonTypes().addListener(DialogPane$$Lambda$2.lambdaFactory$(this, buttonBar));
        this.expandableContentProperty().addListener(DialogPane$$Lambda$3.lambdaFactory$(this, buttonBar));
        return buttonBar;
    }

    protected Node createButton(ButtonType buttonType) {
        Button button = new Button(buttonType.getText());
        ButtonBar.ButtonData buttonData = buttonType.getButtonData();
        ButtonBar.setButtonData(button, buttonData);
        button.setDefaultButton(buttonType != null && buttonData.isDefaultButton());
        button.setCancelButton(buttonType != null && buttonData.isCancelButton());
        button.addEventHandler(ActionEvent.ACTION, DialogPane$$Lambda$4.lambdaFactory$(this, buttonType));
        return button;
    }

    protected Node createDetailsButton() {
        Hyperlink detailsButton = new Hyperlink();
        String moreText = ControlResources.getString("Dialog.detail.button.more");
        String lessText = ControlResources.getString("Dialog.detail.button.less");
        InvalidationListener expandedListener = DialogPane$$Lambda$5.lambdaFactory$(this, detailsButton, lessText, moreText);
        expandedListener.invalidated(null);
        this.expandedProperty().addListener(expandedListener);
        detailsButton.setOnAction(DialogPane$$Lambda$6.lambdaFactory$(this));
        return detailsButton;
    }

    @Override
    protected void layoutChildren() {
        double expandableContentPrefHeight;
        double contentAndGraphicHeight;
        double contentAreaHeight;
        double h;
        double dialogHeight;
        boolean hasHeader = this.hasHeader();
        double w = Math.max(this.minWidth(-1.0), this.getWidth());
        double minHeight = this.minHeight(w);
        double prefHeight = this.prefHeight(w);
        double maxHeight = this.maxHeight(w);
        double currentHeight = this.getHeight();
        double d = dialogHeight = this.dialog == null ? 0.0 : this.dialog.dialog.getSceneHeight();
        if (prefHeight > currentHeight && prefHeight > minHeight && (prefHeight <= dialogHeight || dialogHeight == 0.0)) {
            h = prefHeight;
            this.resize(w, h);
        } else {
            boolean isDialogGrowing;
            boolean bl = isDialogGrowing = currentHeight > this.oldHeight;
            if (isDialogGrowing) {
                double _h = currentHeight < prefHeight ? Math.min(prefHeight, currentHeight) : Math.max(prefHeight, dialogHeight);
                h = Utils.boundedSize(_h, minHeight, maxHeight);
            } else {
                h = Utils.boundedSize(Math.min(currentHeight, dialogHeight), minHeight, maxHeight);
            }
            this.resize(w, h);
        }
        this.oldHeight = h -= this.snappedTopInset() + this.snappedBottomInset();
        double leftPadding = this.snappedLeftInset();
        double topPadding = this.snappedTopInset();
        double rightPadding = this.snappedRightInset();
        double bottomPadding = this.snappedBottomInset();
        Node header = this.getActualHeader();
        Node content = this.getActualContent();
        Node graphic = this.getActualGraphic();
        Node expandableContent = this.getExpandableContent();
        double graphicPrefWidth = hasHeader || graphic == null ? 0.0 : graphic.prefWidth(-1.0);
        double headerPrefHeight = hasHeader ? header.prefHeight(w) : 0.0;
        double buttonBarPrefHeight = this.buttonBar == null ? 0.0 : this.buttonBar.prefHeight(w);
        double graphicPrefHeight = hasHeader || graphic == null ? 0.0 : graphic.prefHeight(-1.0);
        double availableContentWidth = w - graphicPrefWidth - leftPadding - rightPadding;
        if (this.isExpanded()) {
            contentAreaHeight = this.isExpanded() ? content.prefHeight(availableContentWidth) : 0.0;
            contentAndGraphicHeight = hasHeader ? contentAreaHeight : Math.max(graphicPrefHeight, contentAreaHeight);
            expandableContentPrefHeight = h - (headerPrefHeight + contentAndGraphicHeight + buttonBarPrefHeight);
        } else {
            expandableContentPrefHeight = this.isExpanded() ? expandableContent.prefHeight(w) : 0.0;
            contentAreaHeight = h - (headerPrefHeight + expandableContentPrefHeight + buttonBarPrefHeight);
            contentAndGraphicHeight = hasHeader ? contentAreaHeight : Math.max(graphicPrefHeight, contentAreaHeight);
        }
        double x = leftPadding;
        double y = topPadding;
        if (!hasHeader) {
            if (graphic != null) {
                graphic.resizeRelocate(x, y, graphicPrefWidth, graphicPrefHeight);
                x += graphicPrefWidth;
            }
        } else {
            header.resizeRelocate(x, y, w - (leftPadding + rightPadding), headerPrefHeight);
            y += headerPrefHeight;
        }
        content.resizeRelocate(x, y, availableContentWidth, contentAreaHeight);
        y += hasHeader ? contentAreaHeight : contentAndGraphicHeight;
        if (expandableContent != null) {
            expandableContent.resizeRelocate(leftPadding, y, w - rightPadding, expandableContentPrefHeight);
            y += expandableContentPrefHeight;
        }
        if (this.buttonBar != null) {
            this.buttonBar.resizeRelocate(leftPadding, y, w - (leftPadding + rightPadding), buttonBarPrefHeight);
        }
    }

    @Override
    protected double computeMinWidth(double height) {
        double headerMinWidth = this.hasHeader() ? this.getActualHeader().minWidth(height) + 10.0 : 0.0;
        double contentMinWidth = this.getActualContent().minWidth(height);
        double buttonBarMinWidth = this.buttonBar == null ? 0.0 : this.buttonBar.minWidth(height);
        double graphicMinWidth = this.getActualGraphic().minWidth(height);
        double expandableContentMinWidth = 0.0;
        Node expandableContent = this.getExpandableContent();
        if (this.isExpanded() && expandableContent != null) {
            expandableContentMinWidth = expandableContent.minWidth(height);
        }
        double minWidth = this.snappedLeftInset() + (this.hasHeader() ? 0.0 : graphicMinWidth) + Math.max(Math.max(headerMinWidth, expandableContentMinWidth), Math.max(contentMinWidth, buttonBarMinWidth)) + this.snappedRightInset();
        return this.snapSize(minWidth);
    }

    @Override
    protected double computeMinHeight(double width) {
        boolean hasHeader = this.hasHeader();
        double headerMinHeight = hasHeader ? this.getActualHeader().minHeight(width) : 0.0;
        double buttonBarMinHeight = this.buttonBar == null ? 0.0 : this.buttonBar.minHeight(width);
        Node graphic = this.getActualGraphic();
        double graphicMinWidth = hasHeader ? 0.0 : graphic.minWidth(-1.0);
        double graphicMinHeight = hasHeader ? 0.0 : graphic.minHeight(width);
        Node content = this.getActualContent();
        double contentAvailableWidth = width == -1.0 ? -1.0 : (hasHeader ? width : width - graphicMinWidth);
        double contentMinHeight = content.minHeight(contentAvailableWidth);
        double expandableContentMinHeight = 0.0;
        Node expandableContent = this.getExpandableContent();
        if (this.isExpanded() && expandableContent != null) {
            expandableContentMinHeight = expandableContent.minHeight(width);
        }
        double minHeight = this.snappedTopInset() + headerMinHeight + Math.max(graphicMinHeight, contentMinHeight) + expandableContentMinHeight + buttonBarMinHeight + this.snappedBottomInset();
        return this.snapSize(minHeight);
    }

    @Override
    protected double computePrefWidth(double height) {
        double headerPrefWidth = this.hasHeader() ? this.getActualHeader().prefWidth(height) + 10.0 : 0.0;
        double contentPrefWidth = this.getActualContent().prefWidth(height);
        double buttonBarPrefWidth = this.buttonBar == null ? 0.0 : this.buttonBar.prefWidth(height);
        double graphicPrefWidth = this.getActualGraphic().prefWidth(height);
        double expandableContentPrefWidth = 0.0;
        Node expandableContent = this.getExpandableContent();
        if (this.isExpanded() && expandableContent != null) {
            expandableContentPrefWidth = expandableContent.prefWidth(height);
        }
        double prefWidth = this.snappedLeftInset() + (this.hasHeader() ? 0.0 : graphicPrefWidth) + Math.max(Math.max(headerPrefWidth, expandableContentPrefWidth), Math.max(contentPrefWidth, buttonBarPrefWidth)) + this.snappedRightInset();
        return this.snapSize(prefWidth);
    }

    @Override
    protected double computePrefHeight(double width) {
        boolean hasHeader = this.hasHeader();
        double headerPrefHeight = hasHeader ? this.getActualHeader().prefHeight(width) : 0.0;
        double buttonBarPrefHeight = this.buttonBar == null ? 0.0 : this.buttonBar.prefHeight(width);
        Node graphic = this.getActualGraphic();
        double graphicPrefWidth = hasHeader ? 0.0 : graphic.prefWidth(-1.0);
        double graphicPrefHeight = hasHeader ? 0.0 : graphic.prefHeight(width);
        Node content = this.getActualContent();
        double contentAvailableWidth = width == -1.0 ? -1.0 : (hasHeader ? width : width - graphicPrefWidth);
        double contentPrefHeight = content.prefHeight(contentAvailableWidth);
        double expandableContentPrefHeight = 0.0;
        Node expandableContent = this.getExpandableContent();
        if (this.isExpanded() && expandableContent != null) {
            expandableContentPrefHeight = expandableContent.prefHeight(width);
        }
        double prefHeight = this.snappedTopInset() + headerPrefHeight + Math.max(graphicPrefHeight, contentPrefHeight) + expandableContentPrefHeight + buttonBarPrefHeight + this.snappedBottomInset();
        return this.snapSize(prefHeight);
    }

    private void updateButtons(ButtonBar buttonBar) {
        buttonBar.getButtons().clear();
        if (this.hasExpandableContent()) {
            if (this.detailsButton == null) {
                this.detailsButton = this.createDetailsButton();
            }
            ButtonBar.setButtonData(this.detailsButton, ButtonBar.ButtonData.HELP_2);
            buttonBar.getButtons().add(this.detailsButton);
            ButtonBar.setButtonUniformSize(this.detailsButton, false);
        }
        boolean hasDefault = false;
        for (ButtonType buttonType : this.getButtonTypes()) {
            Node newButtonNode;
            Node buttonNode = this.buttonNodes.get(buttonType);
            if (buttonNode == null && (newButtonNode = this.createButton(buttonType)) != null) {
                this.buttonNodes.put(buttonType, newButtonNode);
                buttonNode = newButtonNode;
            }
            if (buttonNode instanceof Button) {
                Button button = (Button)buttonNode;
                ButtonBar.ButtonData buttonData = buttonType.getButtonData();
                if (buttonData != null) {
                    button.setDefaultButton(!hasDefault && buttonData.isDefaultButton());
                    button.setCancelButton(buttonData.isCancelButton());
                    hasDefault |= buttonData.isDefaultButton();
                } else {
                    button.setDefaultButton(false);
                    button.setCancelButton(false);
                }
            }
            buttonBar.getButtons().add(buttonNode);
        }
    }

    private Node getActualContent() {
        Node content = this.getContent();
        return content == null ? this.contentLabel : content;
    }

    private Node getActualHeader() {
        Node header = this.getHeader();
        return header == null ? this.headerTextPanel : header;
    }

    private Node getActualGraphic() {
        return this.headerTextPanel;
    }

    private void updateHeaderArea() {
        Node header = this.getHeader();
        if (header != null) {
            if (!this.getChildren().contains(header)) {
                this.getChildren().add(header);
            }
            this.headerTextPanel.setVisible(false);
            this.headerTextPanel.setManaged(false);
        } else {
            Node graphic;
            String headerText = this.getHeaderText();
            this.headerTextPanel.getChildren().clear();
            this.headerTextPanel.getStyleClass().clear();
            this.headerTextPanel.setMaxWidth(Double.MAX_VALUE);
            if (headerText != null && !headerText.isEmpty()) {
                this.headerTextPanel.getStyleClass().add("header-panel");
            }
            Label headerLabel = new Label(headerText);
            headerLabel.setWrapText(true);
            headerLabel.setAlignment(Pos.CENTER_LEFT);
            headerLabel.setMaxWidth(Double.MAX_VALUE);
            headerLabel.setMaxHeight(Double.MAX_VALUE);
            this.headerTextPanel.add(headerLabel, 0, 0);
            this.graphicContainer.getChildren().clear();
            if (!this.graphicContainer.getStyleClass().contains("graphic-container")) {
                this.graphicContainer.getStyleClass().add("graphic-container");
            }
            if ((graphic = this.getGraphic()) != null) {
                this.graphicContainer.getChildren().add(graphic);
            }
            this.headerTextPanel.add(this.graphicContainer, 1, 0);
            ColumnConstraints textColumn = new ColumnConstraints();
            textColumn.setFillWidth(true);
            textColumn.setHgrow(Priority.ALWAYS);
            ColumnConstraints graphicColumn = new ColumnConstraints();
            graphicColumn.setFillWidth(false);
            graphicColumn.setHgrow(Priority.NEVER);
            this.headerTextPanel.getColumnConstraints().setAll((ColumnConstraints[])new ColumnConstraints[]{textColumn, graphicColumn});
            this.headerTextPanel.setVisible(true);
            this.headerTextPanel.setManaged(true);
        }
    }

    private void updateContentArea() {
        Node content = this.getContent();
        if (content != null) {
            if (!this.getChildren().contains(content)) {
                this.getChildren().add(content);
            }
            if (!content.getStyleClass().contains("content")) {
                content.getStyleClass().add("content");
            }
            this.contentLabel.setVisible(false);
            this.contentLabel.setManaged(false);
        } else {
            String contentText = this.getContentText();
            boolean visible = contentText != null && !contentText.isEmpty();
            this.contentLabel.setText(visible ? contentText : "");
            this.contentLabel.setVisible(visible);
            this.contentLabel.setManaged(visible);
        }
    }

    boolean hasHeader() {
        return this.getHeader() != null || this.isTextHeader();
    }

    private boolean isTextHeader() {
        String headerText = this.getHeaderText();
        return headerText != null && !headerText.isEmpty();
    }

    boolean hasExpandableContent() {
        return this.getExpandableContent() != null;
    }

    void setDialog(Dialog<?> dialog) {
        this.dialog = dialog;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return DialogPane.getClassCssMetaData();
    }

    private /* synthetic */ void lambda$createDetailsButton$605(ActionEvent ae) {
        this.setExpanded(!this.isExpanded());
    }

    private /* synthetic */ void lambda$createDetailsButton$604(Hyperlink detailsButton, String lessText, String moreText, Observable o) {
        boolean isExpanded = this.isExpanded();
        detailsButton.setText(isExpanded ? lessText : moreText);
        detailsButton.getStyleClass().setAll((String[])new String[]{"details-button", isExpanded ? "less" : "more"});
    }

    private /* synthetic */ void lambda$createButton$603(ButtonType buttonType, ActionEvent ae) {
        if (ae.isConsumed()) {
            return;
        }
        if (this.dialog != null) {
            this.dialog.impl_setResultAndClose(buttonType, true);
        }
    }

    private /* synthetic */ void lambda$createButtonBar$602(ButtonBar buttonBar, Observable o) {
        this.updateButtons(buttonBar);
    }

    private /* synthetic */ void lambda$createButtonBar$601(ButtonBar buttonBar, ListChangeListener.Change c) {
        this.updateButtons(buttonBar);
    }

    private /* synthetic */ void lambda$new$600(ListChangeListener.Change c) {
        while (c.next()) {
            if (c.wasRemoved()) {
                for (ButtonType buttonType : c.getRemoved()) {
                    this.buttonNodes.remove(buttonType);
                }
            }
            if (!c.wasAdded()) continue;
            for (ButtonType buttonType : c.getAddedSubList()) {
                if (this.buttonNodes.containsKey(buttonType)) continue;
                this.buttonNodes.put(buttonType, this.createButton(buttonType));
            }
        }
    }

    static /* synthetic */ void access$lambda$0(DialogPane dialogPane, ListChangeListener.Change change) {
        dialogPane.lambda$new$600(change);
    }

    static /* synthetic */ void access$lambda$1(DialogPane dialogPane, ButtonBar buttonBar, ListChangeListener.Change change) {
        dialogPane.lambda$createButtonBar$601(buttonBar, change);
    }

    static /* synthetic */ void access$lambda$2(DialogPane dialogPane, ButtonBar buttonBar, Observable observable) {
        dialogPane.lambda$createButtonBar$602(buttonBar, observable);
    }

    static /* synthetic */ void access$lambda$3(DialogPane dialogPane, ButtonType buttonType, ActionEvent actionEvent) {
        dialogPane.lambda$createButton$603(buttonType, actionEvent);
    }

    static /* synthetic */ void access$lambda$4(DialogPane dialogPane, Hyperlink hyperlink, String string, String string2, Observable observable) {
        dialogPane.lambda$createDetailsButton$604(hyperlink, string, string2, observable);
    }

    static /* synthetic */ void access$lambda$5(DialogPane dialogPane, ActionEvent actionEvent) {
        dialogPane.lambda$createDetailsButton$605(actionEvent);
    }

    private static class StyleableProperties {
        private static final CssMetaData<DialogPane, String> GRAPHIC = new CssMetaData<DialogPane, String>("-fx-graphic", StringConverter.getInstance()){

            @Override
            public boolean isSettable(DialogPane n) {
                return n.graphicProperty == null || !n.graphicProperty.isBound();
            }

            @Override
            public StyleableProperty<String> getStyleableProperty(DialogPane n) {
                return n.imageUrlProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Region.getClassCssMetaData());
            Collections.addAll(styleables, GRAPHIC);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

