/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.skin.ListCellSkin;
import java.lang.ref.WeakReference;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.control.ControlUtils;
import javafx.scene.control.FocusModel;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.ListCell$$Lambda$1;
import javafx.scene.control.ListCell$$Lambda$2;
import javafx.scene.control.ListCell$$Lambda$3;
import javafx.scene.control.ListCell$$Lambda$4;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.Skin;

public class ListCell<T>
extends IndexedCell<T> {
    private final InvalidationListener editingListener = ListCell$$Lambda$1.lambdaFactory$(this);
    private boolean updateEditingIndex = true;
    private final ListChangeListener<Integer> selectedListener = ListCell$$Lambda$2.lambdaFactory$(this);
    private final ChangeListener<MultipleSelectionModel<T>> selectionModelPropertyListener = new ChangeListener<MultipleSelectionModel<T>>(){

        @Override
        public void changed(ObservableValue<? extends MultipleSelectionModel<T>> observable, MultipleSelectionModel<T> oldValue, MultipleSelectionModel<T> newValue) {
            if (oldValue != null) {
                oldValue.getSelectedIndices().removeListener(ListCell.this.weakSelectedListener);
            }
            if (newValue != null) {
                newValue.getSelectedIndices().addListener(ListCell.this.weakSelectedListener);
            }
            ListCell.this.updateSelection();
        }
    };
    private final ListChangeListener<T> itemsListener = ListCell$$Lambda$3.lambdaFactory$(this);
    private final ChangeListener<ObservableList<T>> itemsPropertyListener = new ChangeListener<ObservableList<T>>(){

        @Override
        public void changed(ObservableValue<? extends ObservableList<T>> observable, ObservableList<T> oldValue, ObservableList<T> newValue) {
            if (oldValue != null) {
                oldValue.removeListener(ListCell.this.weakItemsListener);
            }
            if (newValue != null) {
                newValue.addListener(ListCell.this.weakItemsListener);
            }
            ListCell.this.updateItem(-1);
        }
    };
    private final InvalidationListener focusedListener = ListCell$$Lambda$4.lambdaFactory$(this);
    private final ChangeListener<FocusModel<T>> focusModelPropertyListener = new ChangeListener<FocusModel<T>>(){

        @Override
        public void changed(ObservableValue<? extends FocusModel<T>> observable, FocusModel<T> oldValue, FocusModel<T> newValue) {
            if (oldValue != null) {
                oldValue.focusedIndexProperty().removeListener(ListCell.this.weakFocusedListener);
            }
            if (newValue != null) {
                newValue.focusedIndexProperty().addListener(ListCell.this.weakFocusedListener);
            }
            ListCell.this.updateFocus();
        }
    };
    private final WeakInvalidationListener weakEditingListener = new WeakInvalidationListener(this.editingListener);
    private final WeakListChangeListener<Integer> weakSelectedListener = new WeakListChangeListener<Integer>(this.selectedListener);
    private final WeakChangeListener<MultipleSelectionModel<T>> weakSelectionModelPropertyListener = new WeakChangeListener<MultipleSelectionModel<MultipleSelectionModel<T>>>(this.selectionModelPropertyListener);
    private final WeakListChangeListener<T> weakItemsListener = new WeakListChangeListener<T>(this.itemsListener);
    private final WeakChangeListener<ObservableList<T>> weakItemsPropertyListener = new WeakChangeListener<ObservableList<ObservableList<T>>>(this.itemsPropertyListener);
    private final WeakInvalidationListener weakFocusedListener = new WeakInvalidationListener(this.focusedListener);
    private final WeakChangeListener<FocusModel<T>> weakFocusModelPropertyListener = new WeakChangeListener<FocusModel<FocusModel<T>>>(this.focusModelPropertyListener);
    private ReadOnlyObjectWrapper<ListView<T>> listView = new ReadOnlyObjectWrapper<ListView<T>>(this, "listView"){
        private WeakReference<ListView<T>> weakListViewRef;
        {
            this.weakListViewRef = new WeakReference<Object>(null);
        }

        @Override
        protected void invalidated() {
            ObservableList items;
            FocusModel fm;
            MultipleSelectionModel sm;
            ListView oldListView;
            ListView currentListView = (ListView)this.get();
            if (currentListView == (oldListView = (ListView)this.weakListViewRef.get())) {
                return;
            }
            if (oldListView != null) {
                sm = oldListView.getSelectionModel();
                if (sm != null) {
                    sm.getSelectedIndices().removeListener(ListCell.this.weakSelectedListener);
                }
                if ((fm = oldListView.getFocusModel()) != null) {
                    fm.focusedIndexProperty().removeListener(ListCell.this.weakFocusedListener);
                }
                if ((items = oldListView.getItems()) != null) {
                    items.removeListener(ListCell.this.weakItemsListener);
                }
                oldListView.editingIndexProperty().removeListener(ListCell.this.weakEditingListener);
                oldListView.itemsProperty().removeListener(ListCell.this.weakItemsPropertyListener);
                oldListView.focusModelProperty().removeListener(ListCell.this.weakFocusModelPropertyListener);
                oldListView.selectionModelProperty().removeListener(ListCell.this.weakSelectionModelPropertyListener);
            }
            if (currentListView != null) {
                sm = currentListView.getSelectionModel();
                if (sm != null) {
                    sm.getSelectedIndices().addListener(ListCell.this.weakSelectedListener);
                }
                if ((fm = currentListView.getFocusModel()) != null) {
                    fm.focusedIndexProperty().addListener(ListCell.this.weakFocusedListener);
                }
                if ((items = currentListView.getItems()) != null) {
                    items.addListener(ListCell.this.weakItemsListener);
                }
                currentListView.editingIndexProperty().addListener(ListCell.this.weakEditingListener);
                currentListView.itemsProperty().addListener(ListCell.this.weakItemsPropertyListener);
                currentListView.focusModelProperty().addListener(ListCell.this.weakFocusModelPropertyListener);
                currentListView.selectionModelProperty().addListener(ListCell.this.weakSelectionModelPropertyListener);
                this.weakListViewRef = new WeakReference<ListView>(currentListView);
            }
            ListCell.this.updateItem(-1);
            ListCell.this.updateSelection();
            ListCell.this.updateFocus();
            ListCell.this.requestLayout();
        }
    };
    private boolean firstRun = true;
    private static final String DEFAULT_STYLE_CLASS = "list-cell";

    public ListCell() {
        this.getStyleClass().addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.LIST_ITEM);
    }

    private void setListView(ListView<T> value) {
        this.listView.set(value);
    }

    public final ListView<T> getListView() {
        return (ListView)this.listView.get();
    }

    public final ReadOnlyObjectProperty<ListView<T>> listViewProperty() {
        return this.listView.getReadOnlyProperty();
    }

    @Override
    void indexChanged(int oldIndex, int newIndex) {
        super.indexChanged(oldIndex, newIndex);
        if (!this.isEditing() || newIndex != oldIndex) {
            this.updateItem(oldIndex);
            this.updateSelection();
            this.updateFocus();
        }
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new ListCellSkin(this);
    }

    @Override
    public void startEdit() {
        ListView<T> list = this.getListView();
        if (!this.isEditable() || list != null && !list.isEditable()) {
            return;
        }
        super.startEdit();
        if (list != null) {
            list.fireEvent(new ListView.EditEvent<Object>(list, ListView.editStartEvent(), null, list.getEditingIndex()));
            list.edit(this.getIndex());
            list.requestFocus();
        }
    }

    @Override
    public void commitEdit(T newValue) {
        if (!this.isEditing()) {
            return;
        }
        ListView<T> list = this.getListView();
        if (list != null) {
            list.fireEvent(new ListView.EditEvent<T>(list, ListView.editCommitEvent(), newValue, list.getEditingIndex()));
        }
        super.commitEdit(newValue);
        this.updateItem(newValue, false);
        if (list != null) {
            list.edit(-1);
            ControlUtils.requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(list);
        }
    }

    @Override
    public void cancelEdit() {
        if (!this.isEditing()) {
            return;
        }
        ListView<T> list = this.getListView();
        super.cancelEdit();
        if (list != null) {
            int editingIndex = list.getEditingIndex();
            if (this.updateEditingIndex) {
                list.edit(-1);
            }
            ControlUtils.requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(list);
            list.fireEvent(new ListView.EditEvent<Object>(list, ListView.editCancelEvent(), null, editingIndex));
        }
    }

    private void updateItem(int oldIndex) {
        ListView<T> lv = this.getListView();
        ObservableList<T> items = lv == null ? null : lv.getItems();
        int index = this.getIndex();
        int itemCount = items == null ? -1 : items.size();
        boolean valid = items != null && index >= 0 && index < itemCount;
        Object oldValue = this.getItem();
        boolean isEmpty = this.isEmpty();
        if (valid) {
            Object newValue = items.get(index);
            if (oldIndex != index || this.isItemChanged(oldValue, newValue)) {
                this.updateItem(newValue, false);
            }
        } else if (!isEmpty && oldValue != null || this.firstRun) {
            this.updateItem(null, true);
            this.firstRun = false;
        }
    }

    public final void updateListView(ListView<T> listView) {
        this.setListView(listView);
    }

    private void updateSelection() {
        if (this.isEmpty()) {
            return;
        }
        int index = this.getIndex();
        ListView<T> listView = this.getListView();
        if (index == -1 || listView == null) {
            return;
        }
        MultipleSelectionModel<T> sm = listView.getSelectionModel();
        if (sm == null) {
            this.updateSelected(false);
            return;
        }
        boolean isSelected = sm.isSelected(index);
        if (this.isSelected() == isSelected) {
            return;
        }
        this.updateSelected(isSelected);
    }

    private void updateFocus() {
        int index = this.getIndex();
        ListView<T> listView = this.getListView();
        if (index == -1 || listView == null) {
            return;
        }
        FocusModel<T> fm = listView.getFocusModel();
        if (fm == null) {
            this.setFocused(false);
            return;
        }
        this.setFocused(fm.isFocused(index));
    }

    private void updateEditing() {
        int index = this.getIndex();
        ListView<T> list = this.getListView();
        int editIndex = list == null ? -1 : list.getEditingIndex();
        boolean editing = this.isEditing();
        if (index != -1 && list != null) {
            if (index == editIndex && !editing) {
                this.startEdit();
            } else if (index != editIndex && editing) {
                this.updateEditingIndex = false;
                this.cancelEdit();
                this.updateEditingIndex = true;
            }
        }
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case INDEX: {
                return this.getIndex();
            }
            case SELECTED: {
                return this.isSelected();
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
        switch (action) {
            case REQUEST_FOCUS: {
                FocusModel<T> fm;
                ListView<T> listView = this.getListView();
                if (listView == null || (fm = listView.getFocusModel()) == null) break;
                fm.focus(this.getIndex());
                break;
            }
            default: {
                super.executeAccessibleAction(action, parameters);
            }
        }
    }

    private /* synthetic */ void lambda$new$161(Observable value) {
        this.updateFocus();
    }

    private /* synthetic */ void lambda$new$160(ListChangeListener.Change c) {
        boolean doUpdate = false;
        while (c.next()) {
            int currentIndex = this.getIndex();
            ListView<T> lv = this.getListView();
            ObservableList<T> items = lv == null ? null : lv.getItems();
            int itemCount = items == null ? 0 : items.size();
            boolean indexAfterChangeFromIndex = currentIndex >= c.getFrom();
            boolean indexBeforeChangeToIndex = currentIndex < c.getTo() || currentIndex == itemCount;
            boolean indexInRange = indexAfterChangeFromIndex && indexBeforeChangeToIndex;
            doUpdate = indexInRange || indexAfterChangeFromIndex && !c.wasReplaced() && (c.wasRemoved() || c.wasAdded());
        }
        if (doUpdate) {
            this.updateItem(-1);
        }
    }

    private /* synthetic */ void lambda$new$159(ListChangeListener.Change c) {
        this.updateSelection();
    }

    private /* synthetic */ void lambda$new$158(Observable value) {
        this.updateEditing();
    }

    static /* synthetic */ void access$lambda$0(ListCell listCell, Observable observable) {
        listCell.lambda$new$158(observable);
    }

    static /* synthetic */ void access$lambda$1(ListCell listCell, ListChangeListener.Change change) {
        listCell.lambda$new$159(change);
    }

    static /* synthetic */ void access$lambda$2(ListCell listCell, ListChangeListener.Change change) {
        listCell.lambda$new$160(change);
    }

    static /* synthetic */ void access$lambda$3(ListCell listCell, Observable observable) {
        listCell.lambda$new$161(observable);
    }
}

