/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.scene.control.behavior.TreeCellBehavior;
import com.sun.javafx.scene.control.skin.TreeViewSkin;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.DefaultProperty;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.event.WeakEventHandler;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.control.Control;
import javafx.scene.control.ControlUtils;
import javafx.scene.control.FocusModel;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.MultipleSelectionModelBase;
import javafx.scene.control.ScrollToEvent;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeUtil;
import javafx.scene.control.TreeView$$Lambda$1;
import javafx.scene.control.TreeView$TreeViewBitSetSelectionModel$$Lambda$1;
import javafx.scene.control.TreeView$TreeViewBitSetSelectionModel$$Lambda$2;
import javafx.scene.control.TreeView$TreeViewBitSetSelectionModel$$Lambda$3;
import javafx.scene.control.TreeView$TreeViewFocusModel$$Lambda$1;
import javafx.scene.control.TreeView$TreeViewFocusModel$$Lambda$2;
import javafx.scene.control.TreeView$TreeViewFocusModel$1$$Lambda$1;
import javafx.util.Callback;

@DefaultProperty(value="root")
public class TreeView<T>
extends Control {
    private static final EventType<?> EDIT_ANY_EVENT = new EventType<Event>(Event.ANY, "TREE_VIEW_EDIT");
    private static final EventType<?> EDIT_START_EVENT = new EventType(TreeView.editAnyEvent(), "EDIT_START");
    private static final EventType<?> EDIT_CANCEL_EVENT = new EventType(TreeView.editAnyEvent(), "EDIT_CANCEL");
    private static final EventType<?> EDIT_COMMIT_EVENT = new EventType(TreeView.editAnyEvent(), "EDIT_COMMIT");
    private boolean expandedItemCountDirty = true;
    private Map<Integer, SoftReference<TreeItem<T>>> treeItemCacheMap = new HashMap<Integer, SoftReference<TreeItem<T>>>();
    private final EventHandler<TreeItem.TreeModificationEvent<T>> rootEvent = TreeView$$Lambda$1.lambdaFactory$(this);
    private WeakEventHandler<TreeItem.TreeModificationEvent<T>> weakRootEventListener;
    private ObjectProperty<Callback<TreeView<T>, TreeCell<T>>> cellFactory;
    private ObjectProperty<TreeItem<T>> root = new SimpleObjectProperty<TreeItem<T>>(this, "root"){
        private WeakReference<TreeItem<T>> weakOldItem;

        @Override
        protected void invalidated() {
            TreeItem root;
            TreeItem oldTreeItem;
            TreeItem treeItem = oldTreeItem = this.weakOldItem == null ? null : (TreeItem)this.weakOldItem.get();
            if (oldTreeItem != null && TreeView.this.weakRootEventListener != null) {
                oldTreeItem.removeEventHandler(TreeItem.treeNotificationEvent(), TreeView.this.weakRootEventListener);
            }
            if ((root = TreeView.this.getRoot()) != null) {
                TreeView.this.weakRootEventListener = new WeakEventHandler(TreeView.this.rootEvent);
                TreeView.this.getRoot().addEventHandler(TreeItem.treeNotificationEvent(), TreeView.this.weakRootEventListener);
                this.weakOldItem = new WeakReference(root);
            }
            TreeView.this.edit(null);
            TreeView.this.expandedItemCountDirty = true;
            TreeView.this.updateRootExpanded();
        }
    };
    private BooleanProperty showRoot;
    private ObjectProperty<MultipleSelectionModel<TreeItem<T>>> selectionModel;
    private ObjectProperty<FocusModel<TreeItem<T>>> focusModel;
    private ReadOnlyIntegerWrapper expandedItemCount = new ReadOnlyIntegerWrapper(this, "expandedItemCount", 0);
    private DoubleProperty fixedCellSize;
    private BooleanProperty editable;
    private ReadOnlyObjectWrapper<TreeItem<T>> editingItem;
    private ObjectProperty<EventHandler<EditEvent<T>>> onEditStart;
    private ObjectProperty<EventHandler<EditEvent<T>>> onEditCommit;
    private ObjectProperty<EventHandler<EditEvent<T>>> onEditCancel;
    private ObjectProperty<EventHandler<ScrollToEvent<Integer>>> onScrollTo;
    private static final String DEFAULT_STYLE_CLASS = "tree-view";

    public static <T> EventType<EditEvent<T>> editAnyEvent() {
        return EDIT_ANY_EVENT;
    }

    public static <T> EventType<EditEvent<T>> editStartEvent() {
        return EDIT_START_EVENT;
    }

    public static <T> EventType<EditEvent<T>> editCancelEvent() {
        return EDIT_CANCEL_EVENT;
    }

    public static <T> EventType<EditEvent<T>> editCommitEvent() {
        return EDIT_COMMIT_EVENT;
    }

    @Deprecated
    public static int getNodeLevel(TreeItem<?> node) {
        if (node == null) {
            return -1;
        }
        int level = 0;
        for (TreeItem<?> parent = node.getParent(); parent != null; parent = parent.getParent()) {
            ++level;
        }
        return level;
    }

    public TreeView() {
        this(null);
    }

    public TreeView(TreeItem<T> root) {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.TREE_VIEW);
        this.setRoot(root);
        this.updateExpandedItemCount(root);
        TreeViewBitSetSelectionModel sm = new TreeViewBitSetSelectionModel(this);
        this.setSelectionModel(sm);
        this.setFocusModel(new TreeViewFocusModel(this));
    }

    public final void setCellFactory(Callback<TreeView<T>, TreeCell<T>> value) {
        this.cellFactoryProperty().set(value);
    }

    public final Callback<TreeView<T>, TreeCell<T>> getCellFactory() {
        return this.cellFactory == null ? null : (Callback)this.cellFactory.get();
    }

    public final ObjectProperty<Callback<TreeView<T>, TreeCell<T>>> cellFactoryProperty() {
        if (this.cellFactory == null) {
            this.cellFactory = new SimpleObjectProperty<Callback<TreeView<T>, TreeCell<T>>>(this, "cellFactory");
        }
        return this.cellFactory;
    }

    public final void setRoot(TreeItem<T> value) {
        this.rootProperty().set(value);
    }

    public final TreeItem<T> getRoot() {
        return this.root == null ? null : (TreeItem)this.root.get();
    }

    public final ObjectProperty<TreeItem<T>> rootProperty() {
        return this.root;
    }

    public final void setShowRoot(boolean value) {
        this.showRootProperty().set(value);
    }

    public final boolean isShowRoot() {
        return this.showRoot == null ? true : this.showRoot.get();
    }

    public final BooleanProperty showRootProperty() {
        if (this.showRoot == null) {
            this.showRoot = new SimpleBooleanProperty(this, "showRoot", true){

                @Override
                protected void invalidated() {
                    TreeView.this.updateRootExpanded();
                    TreeView.this.updateExpandedItemCount(TreeView.this.getRoot());
                }
            };
        }
        return this.showRoot;
    }

    public final void setSelectionModel(MultipleSelectionModel<TreeItem<T>> value) {
        this.selectionModelProperty().set(value);
    }

    public final MultipleSelectionModel<TreeItem<T>> getSelectionModel() {
        return this.selectionModel == null ? null : (MultipleSelectionModel)this.selectionModel.get();
    }

    public final ObjectProperty<MultipleSelectionModel<TreeItem<T>>> selectionModelProperty() {
        if (this.selectionModel == null) {
            this.selectionModel = new SimpleObjectProperty<MultipleSelectionModel<TreeItem<T>>>(this, "selectionModel");
        }
        return this.selectionModel;
    }

    public final void setFocusModel(FocusModel<TreeItem<T>> value) {
        this.focusModelProperty().set(value);
    }

    public final FocusModel<TreeItem<T>> getFocusModel() {
        return this.focusModel == null ? null : (FocusModel)this.focusModel.get();
    }

    public final ObjectProperty<FocusModel<TreeItem<T>>> focusModelProperty() {
        if (this.focusModel == null) {
            this.focusModel = new SimpleObjectProperty<FocusModel<TreeItem<T>>>(this, "focusModel");
        }
        return this.focusModel;
    }

    public final ReadOnlyIntegerProperty expandedItemCountProperty() {
        return this.expandedItemCount.getReadOnlyProperty();
    }

    private void setExpandedItemCount(int value) {
        this.expandedItemCount.set(value);
    }

    public final int getExpandedItemCount() {
        if (this.expandedItemCountDirty) {
            this.updateExpandedItemCount(this.getRoot());
        }
        return this.expandedItemCount.get();
    }

    public final void setFixedCellSize(double value) {
        this.fixedCellSizeProperty().set(value);
    }

    public final double getFixedCellSize() {
        return this.fixedCellSize == null ? -1.0 : this.fixedCellSize.get();
    }

    public final DoubleProperty fixedCellSizeProperty() {
        if (this.fixedCellSize == null) {
            this.fixedCellSize = new StyleableDoubleProperty(-1.0){

                @Override
                public CssMetaData<TreeView<?>, Number> getCssMetaData() {
                    return StyleableProperties.FIXED_CELL_SIZE;
                }

                @Override
                public Object getBean() {
                    return TreeView.this;
                }

                @Override
                public String getName() {
                    return "fixedCellSize";
                }
            };
        }
        return this.fixedCellSize;
    }

    public final void setEditable(boolean value) {
        this.editableProperty().set(value);
    }

    public final boolean isEditable() {
        return this.editable == null ? false : this.editable.get();
    }

    public final BooleanProperty editableProperty() {
        if (this.editable == null) {
            this.editable = new SimpleBooleanProperty(this, "editable", false);
        }
        return this.editable;
    }

    private void setEditingItem(TreeItem<T> value) {
        this.editingItemPropertyImpl().set(value);
    }

    public final TreeItem<T> getEditingItem() {
        return this.editingItem == null ? null : (TreeItem)this.editingItem.get();
    }

    public final ReadOnlyObjectProperty<TreeItem<T>> editingItemProperty() {
        return this.editingItemPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<TreeItem<T>> editingItemPropertyImpl() {
        if (this.editingItem == null) {
            this.editingItem = new ReadOnlyObjectWrapper(this, "editingItem");
        }
        return this.editingItem;
    }

    public final void setOnEditStart(EventHandler<EditEvent<T>> value) {
        this.onEditStartProperty().set(value);
    }

    public final EventHandler<EditEvent<T>> getOnEditStart() {
        return this.onEditStart == null ? null : (EventHandler)this.onEditStart.get();
    }

    public final ObjectProperty<EventHandler<EditEvent<T>>> onEditStartProperty() {
        if (this.onEditStart == null) {
            this.onEditStart = new SimpleObjectProperty<EventHandler<EditEvent<T>>>(this, "onEditStart"){

                @Override
                protected void invalidated() {
                    TreeView.this.setEventHandler(TreeView.editStartEvent(), (EventHandler)this.get());
                }
            };
        }
        return this.onEditStart;
    }

    public final void setOnEditCommit(EventHandler<EditEvent<T>> value) {
        this.onEditCommitProperty().set(value);
    }

    public final EventHandler<EditEvent<T>> getOnEditCommit() {
        return this.onEditCommit == null ? null : (EventHandler)this.onEditCommit.get();
    }

    public final ObjectProperty<EventHandler<EditEvent<T>>> onEditCommitProperty() {
        if (this.onEditCommit == null) {
            this.onEditCommit = new SimpleObjectProperty<EventHandler<EditEvent<T>>>(this, "onEditCommit"){

                @Override
                protected void invalidated() {
                    TreeView.this.setEventHandler(TreeView.editCommitEvent(), (EventHandler)this.get());
                }
            };
        }
        return this.onEditCommit;
    }

    public final void setOnEditCancel(EventHandler<EditEvent<T>> value) {
        this.onEditCancelProperty().set(value);
    }

    public final EventHandler<EditEvent<T>> getOnEditCancel() {
        return this.onEditCancel == null ? null : (EventHandler)this.onEditCancel.get();
    }

    public final ObjectProperty<EventHandler<EditEvent<T>>> onEditCancelProperty() {
        if (this.onEditCancel == null) {
            this.onEditCancel = new SimpleObjectProperty<EventHandler<EditEvent<T>>>(this, "onEditCancel"){

                @Override
                protected void invalidated() {
                    TreeView.this.setEventHandler(TreeView.editCancelEvent(), (EventHandler)this.get());
                }
            };
        }
        return this.onEditCancel;
    }

    @Override
    protected void layoutChildren() {
        if (this.expandedItemCountDirty) {
            this.updateExpandedItemCount(this.getRoot());
        }
        super.layoutChildren();
    }

    public void edit(TreeItem<T> item) {
        if (!this.isEditable()) {
            return;
        }
        this.setEditingItem(item);
    }

    public void scrollTo(int index) {
        ControlUtils.scrollToIndex(this, index);
    }

    public void setOnScrollTo(EventHandler<ScrollToEvent<Integer>> value) {
        this.onScrollToProperty().set(value);
    }

    public EventHandler<ScrollToEvent<Integer>> getOnScrollTo() {
        if (this.onScrollTo != null) {
            return (EventHandler)this.onScrollTo.get();
        }
        return null;
    }

    public ObjectProperty<EventHandler<ScrollToEvent<Integer>>> onScrollToProperty() {
        if (this.onScrollTo == null) {
            this.onScrollTo = new ObjectPropertyBase<EventHandler<ScrollToEvent<Integer>>>(){

                @Override
                protected void invalidated() {
                    TreeView.this.setEventHandler(ScrollToEvent.scrollToTopIndex(), (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return TreeView.this;
                }

                @Override
                public String getName() {
                    return "onScrollTo";
                }
            };
        }
        return this.onScrollTo;
    }

    public int getRow(TreeItem<T> item) {
        return TreeUtil.getRow(item, this.getRoot(), this.expandedItemCountDirty, this.isShowRoot());
    }

    public TreeItem<T> getTreeItem(int row) {
        SoftReference<TreeItem<T>> treeItemRef;
        TreeItem<T> treeItem;
        int _row;
        if (row < 0) {
            return null;
        }
        int n = _row = this.isShowRoot() ? row : row + 1;
        if (this.expandedItemCountDirty) {
            this.updateExpandedItemCount(this.getRoot());
        } else if (this.treeItemCacheMap.containsKey(_row) && (treeItem = (treeItemRef = this.treeItemCacheMap.get(_row)).get()) != null) {
            return treeItem;
        }
        TreeItem<T> treeItem2 = TreeUtil.getItem(this.getRoot(), _row, this.expandedItemCountDirty);
        this.treeItemCacheMap.put(_row, new SoftReference<TreeItem<T>>(treeItem2));
        return treeItem2;
    }

    public int getTreeItemLevel(TreeItem<?> node) {
        TreeItem<T> root = this.getRoot();
        if (node == null) {
            return -1;
        }
        if (node == root) {
            return 0;
        }
        int level = 0;
        for (TreeItem<?> parent = node.getParent(); parent != null; parent = parent.getParent()) {
            ++level;
            if (parent == root) break;
        }
        return level;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TreeViewSkin(this);
    }

    public void refresh() {
        this.getProperties().put("treeRecreateKey", Boolean.TRUE);
    }

    private void updateExpandedItemCount(TreeItem<T> treeItem) {
        this.setExpandedItemCount(TreeUtil.updateExpandedItemCount(treeItem, this.expandedItemCountDirty, this.isShowRoot()));
        if (this.expandedItemCountDirty) {
            this.treeItemCacheMap.clear();
        }
        this.expandedItemCountDirty = false;
    }

    private void updateRootExpanded() {
        if (!this.isShowRoot() && this.getRoot() != null && !this.getRoot().isExpanded()) {
            this.getRoot().setExpanded(true);
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return TreeView.getClassCssMetaData();
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case MULTIPLE_SELECTION: {
                MultipleSelectionModel<TreeItem<T>> sm = this.getSelectionModel();
                return sm != null && sm.getSelectionMode() == SelectionMode.MULTIPLE;
            }
            case ROW_COUNT: {
                return this.getExpandedItemCount();
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    private /* synthetic */ void lambda$new$261(TreeItem.TreeModificationEvent e) {
        boolean match = false;
        for (EventType<? extends Event> eventType = e.getEventType(); eventType != null; eventType = eventType.getSuperType()) {
            if (!eventType.equals(TreeItem.expandedItemCountChangeEvent())) continue;
            match = true;
            break;
        }
        if (match) {
            this.expandedItemCountDirty = true;
            this.requestLayout();
        }
    }

    static /* synthetic */ EventType access$1200() {
        return EDIT_ANY_EVENT;
    }

    static /* synthetic */ void access$lambda$0(TreeView treeView, TreeItem.TreeModificationEvent treeModificationEvent) {
        treeView.lambda$new$261(treeModificationEvent);
    }

    static class TreeViewFocusModel<T>
    extends FocusModel<TreeItem<T>> {
        private final TreeView<T> treeView;
        private final ChangeListener<TreeItem<T>> rootPropertyListener = TreeView$TreeViewFocusModel$$Lambda$1.lambdaFactory$(this);
        private final WeakChangeListener<TreeItem<T>> weakRootPropertyListener = new WeakChangeListener<TreeItem<TreeItem<T>>>(this.rootPropertyListener);
        private EventHandler<TreeItem.TreeModificationEvent<T>> treeItemListener = new EventHandler<TreeItem.TreeModificationEvent<T>>(){

            @Override
            public void handle(TreeItem.TreeModificationEvent<T> e) {
                int newFocus;
                if (TreeViewFocusModel.this.getFocusedIndex() == -1) {
                    return;
                }
                int row = TreeViewFocusModel.this.treeView.getRow(e.getTreeItem());
                int shift = 0;
                if (e.getChange() != null) {
                    e.getChange().next();
                }
                do {
                    if (e.wasExpanded()) {
                        if (row >= TreeViewFocusModel.this.getFocusedIndex()) continue;
                        shift += e.getTreeItem().getExpandedDescendentCount(false) - 1;
                        continue;
                    }
                    if (e.wasCollapsed()) {
                        if (row >= TreeViewFocusModel.this.getFocusedIndex()) continue;
                        shift += -e.getTreeItem().previousExpandedDescendentCount + 1;
                        continue;
                    }
                    if (e.wasAdded()) {
                        TreeItem eventTreeItem = e.getTreeItem();
                        if (!eventTreeItem.isExpanded()) continue;
                        for (int i = 0; i < e.getAddedChildren().size(); ++i) {
                            TreeItem item = e.getAddedChildren().get(i);
                            row = TreeViewFocusModel.this.treeView.getRow(item);
                            if (item == null || row > TreeViewFocusModel.this.getFocusedIndex()) continue;
                            shift += item.getExpandedDescendentCount(false);
                        }
                    } else {
                        if (!e.wasRemoved()) continue;
                        row += e.getFrom() + 1;
                        for (int i = 0; i < e.getRemovedChildren().size(); ++i) {
                            TreeItem item = e.getRemovedChildren().get(i);
                            if (item == null || !item.equals(TreeViewFocusModel.this.getFocusedItem())) continue;
                            TreeViewFocusModel.this.focus(Math.max(0, TreeViewFocusModel.this.getFocusedIndex() - 1));
                            return;
                        }
                        if (row > TreeViewFocusModel.this.getFocusedIndex()) continue;
                        shift += e.getTreeItem().isExpanded() ? -e.getRemovedSize() : 0;
                    }
                } while (e.getChange() != null && e.getChange().next());
                if (shift != 0 && (newFocus = TreeViewFocusModel.this.getFocusedIndex() + shift) >= 0) {
                    Platform.runLater(TreeView$TreeViewFocusModel$1$$Lambda$1.lambdaFactory$(this, newFocus));
                }
            }

            private /* synthetic */ void lambda$handle$267(int newFocus) {
                TreeViewFocusModel.this.focus(newFocus);
            }

            static /* synthetic */ void access$lambda$0(1 var0, int n) {
                var0.lambda$handle$267(n);
            }
        };
        private WeakEventHandler<TreeItem.TreeModificationEvent<T>> weakTreeItemListener;

        public TreeViewFocusModel(TreeView<T> treeView) {
            this.treeView = treeView;
            this.treeView.rootProperty().addListener(this.weakRootPropertyListener);
            this.updateTreeEventListener(null, treeView.getRoot());
            if (treeView.getExpandedItemCount() > 0) {
                this.focus(0);
            }
            treeView.showRootProperty().addListener(TreeView$TreeViewFocusModel$$Lambda$2.lambdaFactory$(this));
        }

        private void updateTreeEventListener(TreeItem<T> oldRoot, TreeItem<T> newRoot) {
            if (oldRoot != null && this.weakTreeItemListener != null) {
                oldRoot.removeEventHandler(TreeItem.expandedItemCountChangeEvent(), this.weakTreeItemListener);
            }
            if (newRoot != null) {
                this.weakTreeItemListener = new WeakEventHandler<TreeItem.TreeModificationEvent<TreeItem.TreeModificationEvent<T>>>(this.treeItemListener);
                newRoot.addEventHandler(TreeItem.expandedItemCountChangeEvent(), this.weakTreeItemListener);
            }
        }

        @Override
        protected int getItemCount() {
            return this.treeView == null ? -1 : this.treeView.getExpandedItemCount();
        }

        @Override
        protected TreeItem<T> getModelItem(int index) {
            if (this.treeView == null) {
                return null;
            }
            if (index < 0 || index >= this.treeView.getExpandedItemCount()) {
                return null;
            }
            return this.treeView.getTreeItem(index);
        }

        @Override
        public void focus(int index) {
            if (((TreeView)this.treeView).expandedItemCountDirty) {
                ((TreeView)this.treeView).updateExpandedItemCount(this.treeView.getRoot());
            }
            super.focus(index);
        }

        private /* synthetic */ void lambda$new$266(ObservableValue observable, TreeItem oldValue, TreeItem newValue) {
            this.updateTreeEventListener(oldValue, newValue);
        }

        private /* synthetic */ void lambda$new$265(Observable o) {
            if (this.isFocused(0)) {
                this.focus(-1);
                this.focus(0);
            }
        }

        static /* synthetic */ void access$lambda$0(TreeViewFocusModel treeViewFocusModel, ObservableValue observableValue, TreeItem treeItem, TreeItem treeItem2) {
            treeViewFocusModel.lambda$new$266(observableValue, treeItem, treeItem2);
        }

        static /* synthetic */ void access$lambda$1(TreeViewFocusModel treeViewFocusModel, Observable observable) {
            treeViewFocusModel.lambda$new$265(observable);
        }
    }

    static class TreeViewBitSetSelectionModel<T>
    extends MultipleSelectionModelBase<TreeItem<T>> {
        private TreeView<T> treeView = null;
        private ChangeListener<TreeItem<T>> rootPropertyListener = TreeView$TreeViewBitSetSelectionModel$$Lambda$1.lambdaFactory$(this);
        private EventHandler<TreeItem.TreeModificationEvent<T>> treeItemListener = TreeView$TreeViewBitSetSelectionModel$$Lambda$2.lambdaFactory$(this);
        private WeakChangeListener<TreeItem<T>> weakRootPropertyListener = new WeakChangeListener<TreeItem<TreeItem<T>>>(this.rootPropertyListener);
        private WeakEventHandler<TreeItem.TreeModificationEvent<T>> weakTreeItemListener;

        public TreeViewBitSetSelectionModel(TreeView<T> treeView) {
            if (treeView == null) {
                throw new IllegalArgumentException("TreeView can not be null");
            }
            this.treeView = treeView;
            this.treeView.rootProperty().addListener(this.weakRootPropertyListener);
            this.treeView.showRootProperty().addListener(TreeView$TreeViewBitSetSelectionModel$$Lambda$3.lambdaFactory$(this, treeView));
            this.updateTreeEventListener(null, treeView.getRoot());
            this.updateDefaultSelection();
        }

        private void updateTreeEventListener(TreeItem<T> oldRoot, TreeItem<T> newRoot) {
            if (oldRoot != null && this.weakTreeItemListener != null) {
                oldRoot.removeEventHandler(TreeItem.expandedItemCountChangeEvent(), this.weakTreeItemListener);
            }
            if (newRoot != null) {
                this.weakTreeItemListener = new WeakEventHandler<TreeItem.TreeModificationEvent<TreeItem.TreeModificationEvent<T>>>(this.treeItemListener);
                newRoot.addEventHandler(TreeItem.expandedItemCountChangeEvent(), this.weakTreeItemListener);
            }
        }

        @Override
        public void selectAll() {
            int anchor = TreeCellBehavior.getAnchor(this.treeView, -1);
            super.selectAll();
            TreeCellBehavior.setAnchor(this.treeView, anchor, false);
        }

        @Override
        public void select(TreeItem<T> obj) {
            if (obj == null && this.getSelectionMode() == SelectionMode.SINGLE) {
                this.clearSelection();
                return;
            }
            if (obj != null) {
                for (TreeItem<T> item = obj.getParent(); item != null; item = item.getParent()) {
                    item.setExpanded(true);
                }
            }
            ((TreeView)this.treeView).updateExpandedItemCount(this.treeView.getRoot());
            int row = this.treeView.getRow(obj);
            if (row == -1) {
                this.setSelectedIndex(-1);
                this.setSelectedItem(obj);
            } else {
                this.select(row);
            }
        }

        @Override
        public void clearAndSelect(int row) {
            TreeCellBehavior.setAnchor(this.treeView, row, false);
            super.clearAndSelect(row);
        }

        @Override
        protected void focus(int itemIndex) {
            if (this.treeView.getFocusModel() != null) {
                this.treeView.getFocusModel().focus(itemIndex);
            }
            this.treeView.notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_ITEM);
        }

        @Override
        protected int getFocusedIndex() {
            if (this.treeView.getFocusModel() == null) {
                return -1;
            }
            return this.treeView.getFocusModel().getFocusedIndex();
        }

        @Override
        protected int getItemCount() {
            return this.treeView == null ? 0 : this.treeView.getExpandedItemCount();
        }

        @Override
        public TreeItem<T> getModelItem(int index) {
            if (this.treeView == null) {
                return null;
            }
            if (index < 0 || index >= this.treeView.getExpandedItemCount()) {
                return null;
            }
            return this.treeView.getTreeItem(index);
        }

        private void updateDefaultSelection() {
            this.clearSelection();
            this.focus(this.getItemCount() > 0 ? 0 : -1);
        }

        private /* synthetic */ void lambda$new$264(TreeItem.TreeModificationEvent e) {
            Integer anchor;
            if (this.getSelectedIndex() == -1 && this.getSelectedItem() == null) {
                return;
            }
            TreeItem treeItem = e.getTreeItem();
            if (treeItem == null) {
                return;
            }
            ((TreeView)this.treeView).expandedItemCountDirty = true;
            int startRow = this.treeView.getRow(treeItem);
            int shift = 0;
            ListChangeListener.Change change = e.getChange();
            if (change != null) {
                change.next();
            }
            do {
                int index;
                int selectedIndex;
                int removedSize;
                int addedSize = change == null ? 0 : change.getAddedSize();
                int n = removedSize = change == null ? 0 : change.getRemovedSize();
                if (e.wasExpanded()) {
                    shift += treeItem.getExpandedDescendentCount(false) - 1;
                    ++startRow;
                    continue;
                }
                if (e.wasCollapsed()) {
                    treeItem.getExpandedDescendentCount(false);
                    int count = treeItem.previousExpandedDescendentCount;
                    selectedIndex = this.getSelectedIndex();
                    boolean wasPrimarySelectionInChild = selectedIndex >= startRow + 1 && selectedIndex < startRow + count;
                    boolean wasAnyChildSelected = false;
                    this.startAtomic();
                    int from = startRow + 1;
                    int to = startRow + count;
                    ArrayList<Integer> removed = new ArrayList<Integer>();
                    for (int i = from; i < to; ++i) {
                        if (!this.isSelected(i)) continue;
                        wasAnyChildSelected = true;
                        this.clearSelection(i);
                        removed.add(i);
                    }
                    this.stopAtomic();
                    if (wasPrimarySelectionInChild && wasAnyChildSelected) {
                        this.select(startRow);
                    } else {
                        NonIterableChange.GenericAddRemoveChange newChange = new NonIterableChange.GenericAddRemoveChange(from, from, removed, this.selectedIndicesSeq);
                        this.selectedIndicesSeq.callObservers(newChange);
                    }
                    shift += -count + 1;
                    ++startRow;
                    continue;
                }
                if (e.wasPermutated()) continue;
                if (e.wasAdded()) {
                    shift += treeItem.isExpanded() ? addedSize : 0;
                    startRow = this.treeView.getRow(e.getChange().getAddedSubList().get(0));
                    continue;
                }
                if (!e.wasRemoved()) continue;
                shift += treeItem.isExpanded() ? -removedSize : 0;
                startRow += e.getFrom() + 1;
                ObservableList<Integer> selectedIndices1 = this.getSelectedIndices();
                selectedIndex = this.getSelectedIndex();
                ObservableList selectedItems = this.getSelectedItems();
                TreeItem selectedItem = (TreeItem)this.getSelectedItem();
                List removedChildren = e.getChange().getRemoved();
                for (int i = 0; i < selectedIndices1.size() && !selectedItems.isEmpty() && (index = ((Integer)selectedIndices1.get(i)).intValue()) <= selectedItems.size(); ++i) {
                    int previousRow;
                    Object newSelectedItem;
                    if (removedChildren.size() != 1 || selectedItems.size() != 1 || selectedItem == null || !selectedItem.equals(removedChildren.get(0)) || selectedIndex >= this.getItemCount() || selectedItem.equals(newSelectedItem = this.getModelItem(previousRow = selectedIndex == 0 ? 0 : selectedIndex - 1))) continue;
                    this.select((TreeItem<T>)newSelectedItem);
                }
            } while (e.getChange() != null && e.getChange().next());
            this.shiftSelection(startRow, shift, null);
            if ((e.wasAdded() || e.wasRemoved()) && (anchor = (Integer)TreeCellBehavior.getAnchor(this.treeView, null)) != null && this.isSelected(anchor + shift)) {
                TreeCellBehavior.setAnchor(this.treeView, anchor + shift, false);
            }
        }

        private /* synthetic */ void lambda$new$263(ObservableValue observable, TreeItem oldValue, TreeItem newValue) {
            this.updateDefaultSelection();
            this.updateTreeEventListener(oldValue, newValue);
        }

        private /* synthetic */ void lambda$new$262(TreeView treeView, Observable o) {
            this.shiftSelection(0, treeView.isShowRoot() ? 1 : -1, null);
        }

        static /* synthetic */ void access$lambda$0(TreeViewBitSetSelectionModel treeViewBitSetSelectionModel, ObservableValue observableValue, TreeItem treeItem, TreeItem treeItem2) {
            treeViewBitSetSelectionModel.lambda$new$263(observableValue, treeItem, treeItem2);
        }

        static /* synthetic */ void access$lambda$1(TreeViewBitSetSelectionModel treeViewBitSetSelectionModel, TreeItem.TreeModificationEvent treeModificationEvent) {
            treeViewBitSetSelectionModel.lambda$new$264(treeModificationEvent);
        }

        static /* synthetic */ void access$lambda$2(TreeViewBitSetSelectionModel treeViewBitSetSelectionModel, TreeView treeView, Observable observable) {
            treeViewBitSetSelectionModel.lambda$new$262(treeView, observable);
        }
    }

    public static class EditEvent<T>
    extends Event {
        private static final long serialVersionUID = -4437033058917528976L;
        public static final EventType<?> ANY = TreeView.access$1200();
        private final T oldValue;
        private final T newValue;
        private final transient TreeItem<T> treeItem;

        public EditEvent(TreeView<T> source, EventType<? extends EditEvent> eventType, TreeItem<T> treeItem, T oldValue, T newValue) {
            super(source, Event.NULL_SOURCE_TARGET, eventType);
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.treeItem = treeItem;
        }

        @Override
        public TreeView<T> getSource() {
            return (TreeView)super.getSource();
        }

        public TreeItem<T> getTreeItem() {
            return this.treeItem;
        }

        public T getNewValue() {
            return this.newValue;
        }

        public T getOldValue() {
            return this.oldValue;
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<TreeView<?>, Number> FIXED_CELL_SIZE = new CssMetaData<TreeView<?>, Number>("-fx-fixed-cell-size", SizeConverter.getInstance(), -1.0){

            @Override
            public Double getInitialValue(TreeView<?> node) {
                return node.getFixedCellSize();
            }

            @Override
            public boolean isSettable(TreeView<?> n) {
                return ((TreeView)n).fixedCellSize == null || !((TreeView)n).fixedCellSize.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(TreeView<?> n) {
                return (StyleableProperty)((Object)n.fixedCellSizeProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            styleables.add(FIXED_CELL_SIZE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

