/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.cell;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.cell.CellUtils;
import javafx.scene.control.cell.ChoiceBoxTableCell$$Lambda$1;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class ChoiceBoxTableCell<S, T>
extends TableCell<S, T> {
    private final ObservableList<T> items;
    private ChoiceBox<T> choiceBox;
    private ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty<StringConverter<T>>(this, "converter");

    @SafeVarargs
    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(T ... items) {
        return ChoiceBoxTableCell.forTableColumn(null, items);
    }

    @SafeVarargs
    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(StringConverter<T> converter, T ... items) {
        return ChoiceBoxTableCell.forTableColumn(converter, FXCollections.observableArrayList(items));
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(ObservableList<T> items) {
        return ChoiceBoxTableCell.forTableColumn(null, items);
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(StringConverter<T> converter, ObservableList<T> items) {
        return ChoiceBoxTableCell$$Lambda$1.lambdaFactory$(converter, items);
    }

    public ChoiceBoxTableCell() {
        this(FXCollections.observableArrayList());
    }

    @SafeVarargs
    public ChoiceBoxTableCell(T ... items) {
        this(FXCollections.observableArrayList(items));
    }

    @SafeVarargs
    public ChoiceBoxTableCell(StringConverter<T> converter, T ... items) {
        this(converter, FXCollections.observableArrayList(items));
    }

    public ChoiceBoxTableCell(ObservableList<T> items) {
        this((StringConverter<T>)null, items);
    }

    public ChoiceBoxTableCell(StringConverter<T> converter, ObservableList<T> items) {
        this.getStyleClass().add("choice-box-table-cell");
        this.items = items;
        this.setConverter(converter != null ? converter : CellUtils.defaultStringConverter());
    }

    public final ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> value) {
        this.converterProperty().set(value);
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public ObservableList<T> getItems() {
        return this.items;
    }

    @Override
    public void startEdit() {
        if (!(this.isEditable() && this.getTableView().isEditable() && this.getTableColumn().isEditable())) {
            return;
        }
        if (this.choiceBox == null) {
            this.choiceBox = CellUtils.createChoiceBox(this, this.items, this.converterProperty());
        }
        this.choiceBox.getSelectionModel().select(this.getItem());
        super.startEdit();
        this.setText(null);
        this.setGraphic(this.choiceBox);
    }

    @Override
    public void cancelEdit() {
        super.cancelEdit();
        this.setText(this.getConverter().toString(this.getItem()));
        this.setGraphic(null);
    }

    @Override
    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        CellUtils.updateItem(this, this.getConverter(), null, null, this.choiceBox);
    }

    private static /* synthetic */ TableCell lambda$forTableColumn$629(StringConverter converter, ObservableList items, TableColumn list) {
        return new ChoiceBoxTableCell(converter, items);
    }

    static /* synthetic */ TableCell access$lambda$0(StringConverter stringConverter, ObservableList observableList, TableColumn tableColumn) {
        return ChoiceBoxTableCell.lambda$forTableColumn$629(stringConverter, observableList, tableColumn);
    }
}

