/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.cell;

import java.lang.ref.WeakReference;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.scene.Node;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.cell.DefaultTreeCell$$Lambda$1;
import javafx.scene.layout.HBox;

class DefaultTreeCell<T>
extends TreeCell<T> {
    private HBox hbox;
    private WeakReference<TreeItem<T>> treeItemRef;
    private InvalidationListener treeItemGraphicListener = DefaultTreeCell$$Lambda$1.lambdaFactory$(this);
    private InvalidationListener treeItemListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TreeItem newTreeItem;
            TreeItem oldTreeItem;
            TreeItem treeItem = oldTreeItem = DefaultTreeCell.this.treeItemRef == null ? null : (TreeItem)DefaultTreeCell.this.treeItemRef.get();
            if (oldTreeItem != null) {
                oldTreeItem.graphicProperty().removeListener(DefaultTreeCell.this.weakTreeItemGraphicListener);
            }
            if ((newTreeItem = DefaultTreeCell.this.getTreeItem()) != null) {
                newTreeItem.graphicProperty().addListener(DefaultTreeCell.this.weakTreeItemGraphicListener);
                DefaultTreeCell.this.treeItemRef = new WeakReference(newTreeItem);
            }
        }
    };
    private WeakInvalidationListener weakTreeItemGraphicListener = new WeakInvalidationListener(this.treeItemGraphicListener);
    private WeakInvalidationListener weakTreeItemListener = new WeakInvalidationListener(this.treeItemListener);

    public DefaultTreeCell() {
        this.treeItemProperty().addListener(this.weakTreeItemListener);
        if (this.getTreeItem() != null) {
            this.getTreeItem().graphicProperty().addListener(this.weakTreeItemGraphicListener);
        }
    }

    void updateDisplay(T item, boolean empty) {
        if (item == null || empty) {
            this.hbox = null;
            this.setText(null);
            this.setGraphic(null);
        } else {
            TreeItem treeItem = this.getTreeItem();
            if (treeItem != null && treeItem.getGraphic() != null) {
                if (item instanceof Node) {
                    this.setText(null);
                    if (this.hbox == null) {
                        this.hbox = new HBox(3.0);
                    }
                    this.hbox.getChildren().setAll((Node[])new Node[]{treeItem.getGraphic(), (Node)item});
                    this.setGraphic(this.hbox);
                } else {
                    this.hbox = null;
                    this.setText(item.toString());
                    this.setGraphic(treeItem.getGraphic());
                }
            } else {
                this.hbox = null;
                if (item instanceof Node) {
                    this.setText(null);
                    this.setGraphic((Node)item);
                } else {
                    this.setText(item.toString());
                    this.setGraphic(null);
                }
            }
        }
    }

    @Override
    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        this.updateDisplay(item, empty);
    }

    private /* synthetic */ void lambda$new$623(Observable observable) {
        this.updateDisplay(this.getItem(), this.isEmpty());
    }

    static /* synthetic */ void access$lambda$0(DefaultTreeCell defaultTreeCell, Observable observable) {
        defaultTreeCell.lambda$new$623(observable);
    }
}

