/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.cell;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.cell.CellUtils;
import javafx.scene.control.cell.TextFieldTreeTableCell$$Lambda$1;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;

public class TextFieldTreeTableCell<S, T>
extends TreeTableCell<S, T> {
    private TextField textField;
    private ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty<StringConverter<T>>(this, "converter");

    public static <S> Callback<TreeTableColumn<S, String>, TreeTableCell<S, String>> forTreeTableColumn() {
        return TextFieldTreeTableCell.forTreeTableColumn(new DefaultStringConverter());
    }

    public static <S, T> Callback<TreeTableColumn<S, T>, TreeTableCell<S, T>> forTreeTableColumn(StringConverter<T> converter) {
        return TextFieldTreeTableCell$$Lambda$1.lambdaFactory$(converter);
    }

    public TextFieldTreeTableCell() {
        this((StringConverter<T>)null);
    }

    public TextFieldTreeTableCell(StringConverter<T> converter) {
        this.getStyleClass().add("text-field-tree-table-cell");
        this.setConverter(converter);
    }

    public final ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> value) {
        this.converterProperty().set(value);
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    @Override
    public void startEdit() {
        if (!(this.isEditable() && this.getTreeTableView().isEditable() && this.getTableColumn().isEditable())) {
            return;
        }
        super.startEdit();
        if (this.isEditing()) {
            if (this.textField == null) {
                this.textField = CellUtils.createTextField(this, this.getConverter());
            }
            CellUtils.startEdit(this, this.getConverter(), null, null, this.textField);
        }
    }

    @Override
    public void cancelEdit() {
        super.cancelEdit();
        CellUtils.cancelEdit(this, this.getConverter(), null);
    }

    @Override
    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        CellUtils.updateItem(this, this.getConverter(), null, null, this.textField);
    }

    private static /* synthetic */ TreeTableCell lambda$forTreeTableColumn$641(StringConverter converter, TreeTableColumn list) {
        return new TextFieldTreeTableCell(converter);
    }

    static /* synthetic */ TreeTableCell access$lambda$0(StringConverter stringConverter, TreeTableColumn treeTableColumn) {
        return TextFieldTreeTableCell.lambda$forTreeTableColumn$641(stringConverter, treeTableColumn);
    }
}

