/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.media;

import com.sun.javafx.tk.TKPulseListener;
import com.sun.javafx.tk.Toolkit;
import com.sun.media.jfxmedia.MediaManager;
import com.sun.media.jfxmedia.control.VideoDataBuffer;
import com.sun.media.jfxmedia.events.AudioSpectrumEvent;
import com.sun.media.jfxmedia.events.BufferListener;
import com.sun.media.jfxmedia.events.BufferProgressEvent;
import com.sun.media.jfxmedia.events.MarkerEvent;
import com.sun.media.jfxmedia.events.MarkerListener;
import com.sun.media.jfxmedia.events.MediaErrorListener;
import com.sun.media.jfxmedia.events.NewFrameEvent;
import com.sun.media.jfxmedia.events.PlayerStateEvent;
import com.sun.media.jfxmedia.events.PlayerStateListener;
import com.sun.media.jfxmedia.events.PlayerTimeListener;
import com.sun.media.jfxmedia.events.VideoRendererListener;
import com.sun.media.jfxmedia.events.VideoTrackSizeListener;
import com.sun.media.jfxmedia.locator.Locator;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.event.EventHandler;
import javafx.scene.media.AudioEqualizer;
import javafx.scene.media.AudioSpectrumListener;
import javafx.scene.media.Media;
import javafx.scene.media.MediaException;
import javafx.scene.media.MediaMarkerEvent;
import javafx.scene.media.MediaPlayer$$Lambda$1;
import javafx.scene.media.MediaPlayer$$Lambda$2;
import javafx.scene.media.MediaPlayer$$Lambda$3;
import javafx.scene.media.MediaPlayer$_BufferListener$$Lambda$1;
import javafx.scene.media.MediaPlayer$_MarkerListener$$Lambda$1;
import javafx.scene.media.MediaPlayer$_PlayerStateListener$$Lambda$1;
import javafx.scene.media.MediaPlayer$_PlayerStateListener$$Lambda$2;
import javafx.scene.media.MediaPlayer$_PlayerStateListener$$Lambda$3;
import javafx.scene.media.MediaPlayer$_PlayerStateListener$$Lambda$4;
import javafx.scene.media.MediaPlayer$_PlayerStateListener$$Lambda$5;
import javafx.scene.media.MediaPlayer$_PlayerStateListener$$Lambda$6;
import javafx.scene.media.MediaPlayer$_PlayerStateListener$$Lambda$7;
import javafx.scene.media.MediaPlayer$_PlayerStateListener$$Lambda$8;
import javafx.scene.media.MediaPlayer$_PlayerTimeListener$$Lambda$1;
import javafx.scene.media.MediaPlayer$_SpectrumListener$$Lambda$1;
import javafx.scene.media.MediaPlayer$_VideoTrackSizeListener$$Lambda$1;
import javafx.scene.media.MediaPlayerShutdownHook;
import javafx.scene.media.MediaTimerTask;
import javafx.scene.media.MediaView;
import javafx.util.Duration;
import javafx.util.Pair;

public final class MediaPlayer {
    public static final int INDEFINITE = -1;
    private static final double RATE_MIN = 0.0;
    private static final double RATE_MAX = 8.0;
    private static final int AUDIOSPECTRUM_THRESHOLD_MAX = 0;
    private static final double AUDIOSPECTRUM_INTERVAL_MIN = 1.0E-9;
    private static final int AUDIOSPECTRUM_NUMBANDS_MIN = 2;
    private com.sun.media.jfxmedia.MediaPlayer jfxPlayer;
    private MapChangeListener<String, Duration> markerMapListener = null;
    private MarkerListener markerEventListener = null;
    private PlayerStateListener stateListener = null;
    private PlayerTimeListener timeListener = null;
    private VideoTrackSizeListener sizeListener = null;
    private MediaErrorListener errorListener = null;
    private BufferListener bufferListener = null;
    private com.sun.media.jfxmedia.events.AudioSpectrumListener spectrumListener = null;
    private RendererListener rendererListener = null;
    private boolean rateChangeRequested = false;
    private boolean volumeChangeRequested = false;
    private boolean balanceChangeRequested = false;
    private boolean startTimeChangeRequested = false;
    private boolean stopTimeChangeRequested = false;
    private boolean muteChangeRequested = false;
    private boolean playRequested = false;
    private boolean audioSpectrumNumBandsChangeRequested = false;
    private boolean audioSpectrumIntervalChangeRequested = false;
    private boolean audioSpectrumThresholdChangeRequested = false;
    private boolean audioSpectrumEnabledChangeRequested = false;
    private MediaTimerTask mediaTimerTask = null;
    private double prevTimeMs = -1.0;
    private boolean isUpdateTimeEnabled = false;
    private BufferProgressEvent lastBufferEvent = null;
    private Duration startTimeAtStop = null;
    private boolean isEOS = false;
    private final Object disposeLock = new Object();
    private static final int DEFAULT_SPECTRUM_BAND_COUNT = 128;
    private static final double DEFAULT_SPECTRUM_INTERVAL = 0.1;
    private static final int DEFAULT_SPECTRUM_THRESHOLD = -60;
    private final Set<WeakReference<MediaView>> viewRefs = new HashSet<WeakReference<MediaView>>();
    private AudioEqualizer audioEqualizer;
    private ReadOnlyObjectWrapper<MediaException> error;
    private ObjectProperty<Runnable> onError;
    private Media media;
    private BooleanProperty autoPlay;
    private boolean playerReady;
    private DoubleProperty rate;
    private ReadOnlyDoubleWrapper currentRate;
    private DoubleProperty volume;
    private DoubleProperty balance;
    private ObjectProperty<Duration> startTime;
    private ObjectProperty<Duration> stopTime;
    private ReadOnlyObjectWrapper<Duration> cycleDuration;
    private ReadOnlyObjectWrapper<Duration> totalDuration;
    private ReadOnlyObjectWrapper<Duration> currentTime;
    private ReadOnlyObjectWrapper<Status> status;
    private ReadOnlyObjectWrapper<Duration> bufferProgressTime;
    private IntegerProperty cycleCount;
    private ReadOnlyIntegerWrapper currentCount;
    private BooleanProperty mute;
    private ObjectProperty<EventHandler<MediaMarkerEvent>> onMarker;
    private ObjectProperty<Runnable> onEndOfMedia;
    private ObjectProperty<Runnable> onReady;
    private ObjectProperty<Runnable> onPlaying;
    private ObjectProperty<Runnable> onPaused;
    private ObjectProperty<Runnable> onStopped;
    private ObjectProperty<Runnable> onHalted;
    private ObjectProperty<Runnable> onRepeat;
    private ObjectProperty<Runnable> onStalled;
    private IntegerProperty audioSpectrumNumBands;
    private DoubleProperty audioSpectrumInterval;
    private IntegerProperty audioSpectrumThreshold;
    private ObjectProperty<AudioSpectrumListener> audioSpectrumListener;
    private final Object renderLock = new Object();
    private VideoDataBuffer currentRenderFrame;
    private VideoDataBuffer nextRenderFrame;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    com.sun.media.jfxmedia.MediaPlayer retrieveJfxPlayer() {
        Object object = this.disposeLock;
        synchronized (object) {
            return this.jfxPlayer;
        }
    }

    private static double clamp(double dvalue, double dmin, double dmax) {
        if (dmin != Double.MIN_VALUE && dvalue < dmin) {
            return dmin;
        }
        if (dmax != Double.MAX_VALUE && dvalue > dmax) {
            return dmax;
        }
        return dvalue;
    }

    private static int clamp(int ivalue, int imin, int imax) {
        if (imin != Integer.MIN_VALUE && ivalue < imin) {
            return imin;
        }
        if (imax != Integer.MAX_VALUE && ivalue > imax) {
            return imax;
        }
        return ivalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AudioEqualizer getAudioEqualizer() {
        Object object = this.disposeLock;
        synchronized (object) {
            if (this.getStatus() == Status.DISPOSED) {
                return null;
            }
            if (this.audioEqualizer == null) {
                this.audioEqualizer = new AudioEqualizer();
                if (this.jfxPlayer != null) {
                    this.audioEqualizer.setAudioEqualizer(this.jfxPlayer.getEqualizer());
                }
                this.audioEqualizer.setEnabled(true);
            }
            return this.audioEqualizer;
        }
    }

    public MediaPlayer(@NamedArg(value="media") Media media) {
        if (null == media) {
            throw new NullPointerException("media == null!");
        }
        this.media = media;
        this.errorListener = new _MediaErrorListener();
        MediaManager.addMediaErrorListener(this.errorListener);
        try {
            Locator locator = media.retrieveJfxLocator();
            if (locator.canBlock()) {
                InitMediaPlayer initMediaPlayer = new InitMediaPlayer();
                Thread t = new Thread(initMediaPlayer);
                t.setDaemon(true);
                t.start();
            } else {
                this.init();
            }
        }
        catch (com.sun.media.jfxmedia.MediaException e) {
            throw MediaException.exceptionToMediaException(e);
        }
        catch (MediaException e) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerListeners() {
        Object object = this.disposeLock;
        synchronized (object) {
            if (this.getStatus() == Status.DISPOSED) {
                return;
            }
            if (this.jfxPlayer != null) {
                MediaManager.registerMediaPlayerForDispose(this, this.jfxPlayer);
                this.jfxPlayer.addMediaErrorListener(this.errorListener);
                this.jfxPlayer.addMediaTimeListener(this.timeListener);
                this.jfxPlayer.addVideoTrackSizeListener(this.sizeListener);
                this.jfxPlayer.addBufferListener(this.bufferListener);
                this.jfxPlayer.addMarkerListener(this.markerEventListener);
                this.jfxPlayer.addAudioSpectrumListener(this.spectrumListener);
                this.jfxPlayer.getVideoRenderControl().addVideoRendererListener(this.rendererListener);
                this.jfxPlayer.addMediaPlayerListener(this.stateListener);
            }
            if (null != this.rendererListener) {
                Toolkit.getToolkit().addStageTkPulseListener(this.rendererListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws MediaException {
        try {
            Locator locator = this.media.retrieveJfxLocator();
            locator.waitForReadySignal();
            Object object = this.disposeLock;
            synchronized (object) {
                if (this.getStatus() == Status.DISPOSED) {
                    return;
                }
                this.jfxPlayer = MediaManager.getPlayer(locator);
                if (this.jfxPlayer != null) {
                    MediaPlayerShutdownHook.addMediaPlayer(this);
                    this.jfxPlayer.setBalance((float)this.getBalance());
                    this.jfxPlayer.setMute(this.isMute());
                    this.jfxPlayer.setVolume((float)this.getVolume());
                    this.sizeListener = new _VideoTrackSizeListener();
                    this.stateListener = new _PlayerStateListener();
                    this.timeListener = new _PlayerTimeListener();
                    this.bufferListener = new _BufferListener();
                    this.markerEventListener = new _MarkerListener();
                    this.spectrumListener = new _SpectrumListener();
                    this.rendererListener = new RendererListener();
                }
                this.markerMapListener = new MarkerMapChangeListener();
                ObservableMap<String, Duration> markers = this.media.getMarkers();
                markers.addListener(this.markerMapListener);
                com.sun.media.jfxmedia.Media jfxMedia = this.jfxPlayer.getMedia();
                for (Map.Entry entry : markers.entrySet()) {
                    double msec;
                    Duration markerTime;
                    String markerName = (String)entry.getKey();
                    if (markerName == null || (markerTime = (Duration)entry.getValue()) == null || !((msec = markerTime.toMillis()) >= 0.0)) continue;
                    jfxMedia.addMarker(markerName, msec / 1000.0);
                }
            }
        }
        catch (com.sun.media.jfxmedia.MediaException e) {
            throw MediaException.exceptionToMediaException(e);
        }
        Platform.runLater(MediaPlayer$$Lambda$1.lambdaFactory$(this));
    }

    private void setError(MediaException value) {
        if (this.getError() == null) {
            this.errorPropertyImpl().set(value);
        }
    }

    public final MediaException getError() {
        return this.error == null ? null : (MediaException)this.error.get();
    }

    public ReadOnlyObjectProperty<MediaException> errorProperty() {
        return this.errorPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<MediaException> errorPropertyImpl() {
        if (this.error == null) {
            this.error = new ReadOnlyObjectWrapper<MediaException>(){

                @Override
                protected void invalidated() {
                    if (MediaPlayer.this.getOnError() != null) {
                        Platform.runLater(MediaPlayer.this.getOnError());
                    }
                }

                @Override
                public Object getBean() {
                    return MediaPlayer.this;
                }

                @Override
                public String getName() {
                    return "error";
                }
            };
        }
        return this.error;
    }

    public final void setOnError(Runnable value) {
        this.onErrorProperty().set(value);
    }

    public final Runnable getOnError() {
        return this.onError == null ? null : (Runnable)this.onError.get();
    }

    public ObjectProperty<Runnable> onErrorProperty() {
        if (this.onError == null) {
            this.onError = new ObjectPropertyBase<Runnable>(){

                @Override
                protected void invalidated() {
                    if (this.get() != null && MediaPlayer.this.getError() != null) {
                        Platform.runLater((Runnable)this.get());
                    }
                }

                @Override
                public Object getBean() {
                    return MediaPlayer.this;
                }

                @Override
                public String getName() {
                    return "onError";
                }
            };
        }
        return this.onError;
    }

    public final Media getMedia() {
        return this.media;
    }

    public final void setAutoPlay(boolean value) {
        this.autoPlayProperty().set(value);
    }

    public final boolean isAutoPlay() {
        return this.autoPlay == null ? false : this.autoPlay.get();
    }

    public BooleanProperty autoPlayProperty() {
        if (this.autoPlay == null) {
            this.autoPlay = new BooleanPropertyBase(){

                @Override
                protected void invalidated() {
                    if (MediaPlayer.this.autoPlay.get()) {
                        MediaPlayer.this.play();
                    } else {
                        MediaPlayer.this.playRequested = false;
                    }
                }

                @Override
                public Object getBean() {
                    return MediaPlayer.this;
                }

                @Override
                public String getName() {
                    return "autoPlay";
                }
            };
        }
        return this.autoPlay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play() {
        Object object = this.disposeLock;
        synchronized (object) {
            if (this.getStatus() != Status.DISPOSED) {
                if (this.playerReady) {
                    this.jfxPlayer.play();
                } else {
                    this.playRequested = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.disposeLock;
        synchronized (object) {
            if (this.getStatus() != Status.DISPOSED) {
                if (this.playerReady) {
                    this.jfxPlayer.pause();
                } else {
                    this.playRequested = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.disposeLock;
        synchronized (object) {
            if (this.getStatus() != Status.DISPOSED) {
                if (this.playerReady) {
                    this.jfxPlayer.stop();
                    this.setCurrentCount(0);
                    this.destroyMediaTimer();
                } else {
                    this.playRequested = false;
                }
            }
        }
    }

    public final void setRate(double value) {
        this.rateProperty().set(value);
    }

    public final double getRate() {
        return this.rate == null ? 1.0 : this.rate.get();
    }

    public DoubleProperty rateProperty() {
        if (this.rate == null) {
            this.rate = new DoublePropertyBase(1.0){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void invalidated() {
                    Object object = MediaPlayer.this.disposeLock;
                    synchronized (object) {
                        if (MediaPlayer.this.getStatus() != Status.DISPOSED) {
                            if (MediaPlayer.this.playerReady) {
                                if (MediaPlayer.this.jfxPlayer.getDuration() != Double.POSITIVE_INFINITY) {
                                    MediaPlayer.this.jfxPlayer.setRate((float)MediaPlayer.clamp(MediaPlayer.this.rate.get(), 0.0, 8.0));
                                }
                            } else {
                                MediaPlayer.this.rateChangeRequested = true;
                            }
                        }
                    }
                }

                @Override
                public Object getBean() {
                    return MediaPlayer.this;
                }

                @Override
                public String getName() {
                    return "rate";
                }
            };
        }
        return this.rate;
    }

    private void setCurrentRate(double value) {
        this.currentRatePropertyImpl().set(value);
    }

    public final double getCurrentRate() {
        return this.currentRate == null ? 0.0 : this.currentRate.get();
    }

    public ReadOnlyDoubleProperty currentRateProperty() {
        return this.currentRatePropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper currentRatePropertyImpl() {
        if (this.currentRate == null) {
            this.currentRate = new ReadOnlyDoubleWrapper(this, "currentRate");
        }
        return this.currentRate;
    }

    public final void setVolume(double value) {
        this.volumeProperty().set(value);
    }

    public final double getVolume() {
        return this.volume == null ? 1.0 : this.volume.get();
    }

    public DoubleProperty volumeProperty() {
        if (this.volume == null) {
            this.volume = new DoublePropertyBase(1.0){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void invalidated() {
                    Object object = MediaPlayer.this.disposeLock;
                    synchronized (object) {
                        if (MediaPlayer.this.getStatus() != Status.DISPOSED) {
                            if (MediaPlayer.this.playerReady) {
                                MediaPlayer.this.jfxPlayer.setVolume((float)MediaPlayer.clamp(MediaPlayer.this.volume.get(), 0.0, 1.0));
                            } else {
                                MediaPlayer.this.volumeChangeRequested = true;
                            }
                        }
                    }
                }

                @Override
                public Object getBean() {
                    return MediaPlayer.this;
                }

                @Override
                public String getName() {
                    return "volume";
                }
            };
        }
        return this.volume;
    }

    public final void setBalance(double value) {
        this.balanceProperty().set(value);
    }

    public final double getBalance() {
        return this.balance == null ? 0.0 : this.balance.get();
    }

    public DoubleProperty balanceProperty() {
        if (this.balance == null) {
            this.balance = new DoublePropertyBase(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void invalidated() {
                    Object object = MediaPlayer.this.disposeLock;
                    synchronized (object) {
                        if (MediaPlayer.this.getStatus() != Status.DISPOSED) {
                            if (MediaPlayer.this.playerReady) {
                                MediaPlayer.this.jfxPlayer.setBalance((float)MediaPlayer.clamp(MediaPlayer.this.balance.get(), -1.0, 1.0));
                            } else {
                                MediaPlayer.this.balanceChangeRequested = true;
                            }
                        }
                    }
                }

                @Override
                public Object getBean() {
                    return MediaPlayer.this;
                }

                @Override
                public String getName() {
                    return "balance";
                }
            };
        }
        return this.balance;
    }

    private double[] calculateStartStopTimes(Duration startValue, Duration stopValue) {
        double actualStop;
        double newStart = startValue == null || startValue.lessThan(Duration.ZERO) || startValue.equals(Duration.UNKNOWN) ? 0.0 : (startValue.equals(Duration.INDEFINITE) ? Double.MAX_VALUE : startValue.toMillis() / 1000.0);
        double newStop = stopValue == null || stopValue.equals(Duration.UNKNOWN) || stopValue.equals(Duration.INDEFINITE) ? Double.MAX_VALUE : (stopValue.lessThan(Duration.ZERO) ? 0.0 : stopValue.toMillis() / 1000.0);
        Duration mediaDuration = this.media.getDuration();
        double duration = mediaDuration == Duration.UNKNOWN ? Double.MAX_VALUE : mediaDuration.toMillis() / 1000.0;
        double actualStart = MediaPlayer.clamp(newStart, 0.0, duration);
        if (actualStart > (actualStop = MediaPlayer.clamp(newStop, 0.0, duration))) {
            actualStop = actualStart;
        }
        return new double[]{actualStart, actualStop};
    }

    private void setStartStopTimes(Duration startValue, boolean isStartValueSet, Duration stopValue, boolean isStopValueSet) {
        if (this.jfxPlayer.getDuration() == Double.POSITIVE_INFINITY) {
            return;
        }
        double[] startStop = this.calculateStartStopTimes(startValue, stopValue);
        if (isStartValueSet) {
            this.jfxPlayer.setStartTime(startStop[0]);
            if (this.getStatus() == Status.READY || this.getStatus() == Status.PAUSED) {
                Platform.runLater(MediaPlayer$$Lambda$2.lambdaFactory$(this));
            }
        }
        if (isStopValueSet) {
            this.jfxPlayer.setStopTime(startStop[1]);
        }
    }

    public final void setStartTime(Duration value) {
        this.startTimeProperty().set(value);
    }

    public final Duration getStartTime() {
        return this.startTime == null ? Duration.ZERO : (Duration)this.startTime.get();
    }

    public ObjectProperty<Duration> startTimeProperty() {
        if (this.startTime == null) {
            this.startTime = new ObjectPropertyBase<Duration>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void invalidated() {
                    Object object = MediaPlayer.this.disposeLock;
                    synchronized (object) {
                        if (MediaPlayer.this.getStatus() != Status.DISPOSED) {
                            if (MediaPlayer.this.playerReady) {
                                MediaPlayer.this.setStartStopTimes((Duration)MediaPlayer.this.startTime.get(), true, MediaPlayer.this.getStopTime(), false);
                            } else {
                                MediaPlayer.this.startTimeChangeRequested = true;
                            }
                            MediaPlayer.this.calculateCycleDuration();
                        }
                    }
                }

                @Override
                public Object getBean() {
                    return MediaPlayer.this;
                }

                @Override
                public String getName() {
                    return "startTime";
                }
            };
        }
        return this.startTime;
    }

    public final void setStopTime(Duration value) {
        this.stopTimeProperty().set(value);
    }

    public final Duration getStopTime() {
        return this.stopTime == null ? this.media.getDuration() : (Duration)this.stopTime.get();
    }

    public ObjectProperty<Duration> stopTimeProperty() {
        if (this.stopTime == null) {
            this.stopTime = new ObjectPropertyBase<Duration>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void invalidated() {
                    Object object = MediaPlayer.this.disposeLock;
                    synchronized (object) {
                        if (MediaPlayer.this.getStatus() != Status.DISPOSED) {
                            if (MediaPlayer.this.playerReady) {
                                MediaPlayer.this.setStartStopTimes(MediaPlayer.this.getStartTime(), false, (Duration)MediaPlayer.this.stopTime.get(), true);
                            } else {
                                MediaPlayer.this.stopTimeChangeRequested = true;
                            }
                            MediaPlayer.this.calculateCycleDuration();
                        }
                    }
                }

                @Override
                public Object getBean() {
                    return MediaPlayer.this;
                }

                @Override
                public String getName() {
                    return "stopTime";
                }
            };
        }
        return this.stopTime;
    }

    private void setCycleDuration(Duration value) {
        this.cycleDurationPropertyImpl().set(value);
    }

    public final Duration getCycleDuration() {
        return this.cycleDuration == null ? Duration.UNKNOWN : (Duration)this.cycleDuration.get();
    }

    public ReadOnlyObjectProperty<Duration> cycleDurationProperty() {
        return this.cycleDurationPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Duration> cycleDurationPropertyImpl() {
        if (this.cycleDuration == null) {
            this.cycleDuration = new ReadOnlyObjectWrapper(this, "cycleDuration");
        }
        return this.cycleDuration;
    }

    private void calculateCycleDuration() {
        Duration mediaDuration = this.media.getDuration();
        Duration endTime = !this.getStopTime().isUnknown() ? this.getStopTime() : mediaDuration;
        if (endTime.greaterThan(mediaDuration)) {
            endTime = mediaDuration;
        }
        if ((endTime.isUnknown() || this.getStartTime().isUnknown() || this.getStartTime().isIndefinite()) && !this.getCycleDuration().isUnknown()) {
            this.setCycleDuration(Duration.UNKNOWN);
        }
        this.setCycleDuration(endTime.subtract(this.getStartTime()));
        this.calculateTotalDuration();
    }

    private void setTotalDuration(Duration value) {
        this.totalDurationPropertyImpl().set(value);
    }

    public final Duration getTotalDuration() {
        return this.totalDuration == null ? Duration.UNKNOWN : (Duration)this.totalDuration.get();
    }

    public ReadOnlyObjectProperty<Duration> totalDurationProperty() {
        return this.totalDurationPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Duration> totalDurationPropertyImpl() {
        if (this.totalDuration == null) {
            this.totalDuration = new ReadOnlyObjectWrapper(this, "totalDuration");
        }
        return this.totalDuration;
    }

    private void calculateTotalDuration() {
        if (this.getCycleCount() == -1) {
            this.setTotalDuration(Duration.INDEFINITE);
        } else if (this.getCycleDuration().isUnknown()) {
            this.setTotalDuration(Duration.UNKNOWN);
        } else {
            this.setTotalDuration(this.getCycleDuration().multiply(this.getCycleCount()));
        }
    }

    private void setCurrentTime(Duration value) {
        this.currentTimePropertyImpl().set(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Duration getCurrentTime() {
        Object object = this.disposeLock;
        synchronized (object) {
            double timeSeconds;
            if (this.getStatus() == Status.DISPOSED) {
                return Duration.ZERO;
            }
            if (this.getStatus() == Status.STOPPED) {
                return Duration.millis(this.getStartTime().toMillis());
            }
            if (this.isEOS) {
                Duration duration = this.media.getDuration();
                Duration stopTime = this.getStopTime();
                if (stopTime != Duration.UNKNOWN && duration != Duration.UNKNOWN) {
                    if (stopTime.greaterThan(duration)) {
                        return Duration.millis(duration.toMillis());
                    }
                    return Duration.millis(stopTime.toMillis());
                }
            }
            Duration theCurrentTime = (Duration)this.currentTimeProperty().get();
            if (this.playerReady && (timeSeconds = this.jfxPlayer.getPresentationTime()) >= 0.0) {
                theCurrentTime = Duration.seconds(timeSeconds);
            }
            return theCurrentTime;
        }
    }

    public ReadOnlyObjectProperty<Duration> currentTimeProperty() {
        return this.currentTimePropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Duration> currentTimePropertyImpl() {
        if (this.currentTime == null) {
            this.currentTime = new ReadOnlyObjectWrapper(this, "currentTime");
            this.currentTime.setValue(Duration.ZERO);
            this.updateTime();
        }
        return this.currentTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seek(Duration seekTime) {
        Object object = this.disposeLock;
        synchronized (object) {
            if (this.getStatus() == Status.DISPOSED) {
                return;
            }
            if (this.playerReady && seekTime != null && !seekTime.isUnknown()) {
                Status playerStatus;
                double seekSeconds;
                if (this.jfxPlayer.getDuration() == Double.POSITIVE_INFINITY) {
                    return;
                }
                if (seekTime.isIndefinite()) {
                    Duration duration = this.media.getDuration();
                    if (duration == null || duration.isUnknown() || duration.isIndefinite()) {
                        duration = Duration.millis(Double.MAX_VALUE);
                    }
                    seekSeconds = duration.toMillis() / 1000.0;
                } else {
                    double[] startStop;
                    seekSeconds = seekTime.toMillis() / 1000.0;
                    if (seekSeconds < (startStop = this.calculateStartStopTimes(this.getStartTime(), this.getStopTime()))[0]) {
                        seekSeconds = startStop[0];
                    } else if (seekSeconds > startStop[1]) {
                        seekSeconds = startStop[1];
                    }
                }
                if (!this.isUpdateTimeEnabled && ((playerStatus = this.getStatus()) == Status.PLAYING || playerStatus == Status.PAUSED) && this.getStartTime().toSeconds() <= seekSeconds && seekSeconds <= this.getStopTime().toSeconds()) {
                    this.isEOS = false;
                    this.isUpdateTimeEnabled = true;
                    this.setCurrentRate(this.getRate());
                }
                this.jfxPlayer.seek(seekSeconds);
            }
        }
    }

    private void setStatus(Status value) {
        this.statusPropertyImpl().set(value);
    }

    public final Status getStatus() {
        return this.status == null ? Status.UNKNOWN : (Status)((Object)this.status.get());
    }

    public ReadOnlyObjectProperty<Status> statusProperty() {
        return this.statusPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Status> statusPropertyImpl() {
        if (this.status == null) {
            this.status = new ReadOnlyObjectWrapper<Status>(){

                @Override
                protected void invalidated() {
                    if (this.get() == Status.PLAYING) {
                        MediaPlayer.this.setCurrentRate(MediaPlayer.this.getRate());
                    } else {
                        MediaPlayer.this.setCurrentRate(0.0);
                    }
                    if (this.get() == Status.READY) {
                        if (MediaPlayer.this.getOnReady() != null) {
                            Platform.runLater(MediaPlayer.this.getOnReady());
                        }
                    } else if (this.get() == Status.PLAYING) {
                        if (MediaPlayer.this.getOnPlaying() != null) {
                            Platform.runLater(MediaPlayer.this.getOnPlaying());
                        }
                    } else if (this.get() == Status.PAUSED) {
                        if (MediaPlayer.this.getOnPaused() != null) {
                            Platform.runLater(MediaPlayer.this.getOnPaused());
                        }
                    } else if (this.get() == Status.STOPPED) {
                        if (MediaPlayer.this.getOnStopped() != null) {
                            Platform.runLater(MediaPlayer.this.getOnStopped());
                        }
                    } else if (this.get() == Status.STALLED && MediaPlayer.this.getOnStalled() != null) {
                        Platform.runLater(MediaPlayer.this.getOnStalled());
                    }
                }

                @Override
                public Object getBean() {
                    return MediaPlayer.this;
                }

                @Override
                public String getName() {
                    return "status";
                }
            };
        }
        return this.status;
    }

    private void setBufferProgressTime(Duration value) {
        this.bufferProgressTimePropertyImpl().set(value);
    }

    public final Duration getBufferProgressTime() {
        return this.bufferProgressTime == null ? null : (Duration)this.bufferProgressTime.get();
    }

    public ReadOnlyObjectProperty<Duration> bufferProgressTimeProperty() {
        return this.bufferProgressTimePropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Duration> bufferProgressTimePropertyImpl() {
        if (this.bufferProgressTime == null) {
            this.bufferProgressTime = new ReadOnlyObjectWrapper(this, "bufferProgressTime");
        }
        return this.bufferProgressTime;
    }

    public final void setCycleCount(int value) {
        this.cycleCountProperty().set(value);
    }

    public final int getCycleCount() {
        return this.cycleCount == null ? 1 : this.cycleCount.get();
    }

    public IntegerProperty cycleCountProperty() {
        if (this.cycleCount == null) {
            this.cycleCount = new IntegerPropertyBase(1){

                @Override
                public Object getBean() {
                    return MediaPlayer.this;
                }

                @Override
                public String getName() {
                    return "cycleCount";
                }
            };
        }
        return this.cycleCount;
    }

    private void setCurrentCount(int value) {
        this.currentCountPropertyImpl().set(value);
    }

    public final int getCurrentCount() {
        return this.currentCount == null ? 0 : this.currentCount.get();
    }

    public ReadOnlyIntegerProperty currentCountProperty() {
        return this.currentCountPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyIntegerWrapper currentCountPropertyImpl() {
        if (this.currentCount == null) {
            this.currentCount = new ReadOnlyIntegerWrapper(this, "currentCount");
        }
        return this.currentCount;
    }

    public final void setMute(boolean value) {
        this.muteProperty().set(value);
    }

    public final boolean isMute() {
        return this.mute == null ? false : this.mute.get();
    }

    public BooleanProperty muteProperty() {
        if (this.mute == null) {
            this.mute = new BooleanPropertyBase(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void invalidated() {
                    Object object = MediaPlayer.this.disposeLock;
                    synchronized (object) {
                        if (MediaPlayer.this.getStatus() != Status.DISPOSED) {
                            if (MediaPlayer.this.playerReady) {
                                MediaPlayer.this.jfxPlayer.setMute(this.get());
                            } else {
                                MediaPlayer.this.muteChangeRequested = true;
                            }
                        }
                    }
                }

                @Override
                public Object getBean() {
                    return MediaPlayer.this;
                }

                @Override
                public String getName() {
                    return "mute";
                }
            };
        }
        return this.mute;
    }

    public final void setOnMarker(EventHandler<MediaMarkerEvent> onMarker) {
        this.onMarkerProperty().set(onMarker);
    }

    public final EventHandler<MediaMarkerEvent> getOnMarker() {
        return this.onMarker == null ? null : (EventHandler)this.onMarker.get();
    }

    public ObjectProperty<EventHandler<MediaMarkerEvent>> onMarkerProperty() {
        if (this.onMarker == null) {
            this.onMarker = new SimpleObjectProperty<EventHandler<MediaMarkerEvent>>(this, "onMarker");
        }
        return this.onMarker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addView(MediaView view) {
        WeakReference<MediaView> vref = new WeakReference<MediaView>(view);
        Set<WeakReference<MediaView>> set = this.viewRefs;
        synchronized (set) {
            this.viewRefs.add(vref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeView(MediaView view) {
        Set<WeakReference<MediaView>> set = this.viewRefs;
        synchronized (set) {
            for (WeakReference<MediaView> vref : this.viewRefs) {
                MediaView v = (MediaView)vref.get();
                if (v == null || !v.equals(view)) continue;
                this.viewRefs.remove(vref);
            }
        }
    }

    void handleError(MediaException error) {
        Platform.runLater(MediaPlayer$$Lambda$3.lambdaFactory$(this, error));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createMediaTimer() {
        Object object = MediaTimerTask.timerLock;
        synchronized (object) {
            if (this.mediaTimerTask == null) {
                this.mediaTimerTask = new MediaTimerTask(this);
                this.mediaTimerTask.start();
            }
            this.isUpdateTimeEnabled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroyMediaTimer() {
        Object object = MediaTimerTask.timerLock;
        synchronized (object) {
            if (this.mediaTimerTask != null) {
                this.isUpdateTimeEnabled = false;
                this.mediaTimerTask.stop();
                this.mediaTimerTask = null;
            }
        }
    }

    void updateTime() {
        double newTimeMs;
        double timeSeconds;
        if (this.playerReady && this.isUpdateTimeEnabled && this.jfxPlayer != null && (timeSeconds = this.jfxPlayer.getPresentationTime()) >= 0.0 && Double.compare(newTimeMs = timeSeconds * 1000.0, this.prevTimeMs) != 0) {
            this.setCurrentTime(Duration.millis(newTimeMs));
            this.prevTimeMs = newTimeMs;
        }
    }

    void loopPlayback() {
        this.seek(this.getStartTime());
    }

    void handleRequestedChanges() {
        if (this.rateChangeRequested) {
            if (this.jfxPlayer.getDuration() != Double.POSITIVE_INFINITY) {
                this.jfxPlayer.setRate((float)MediaPlayer.clamp(this.getRate(), 0.0, 8.0));
            }
            this.rateChangeRequested = false;
        }
        if (this.volumeChangeRequested) {
            this.jfxPlayer.setVolume((float)MediaPlayer.clamp(this.getVolume(), 0.0, 1.0));
            this.volumeChangeRequested = false;
        }
        if (this.balanceChangeRequested) {
            this.jfxPlayer.setBalance((float)MediaPlayer.clamp(this.getBalance(), -1.0, 1.0));
            this.balanceChangeRequested = false;
        }
        if (this.startTimeChangeRequested || this.stopTimeChangeRequested) {
            this.setStartStopTimes(this.getStartTime(), this.startTimeChangeRequested, this.getStopTime(), this.stopTimeChangeRequested);
            this.stopTimeChangeRequested = false;
            this.startTimeChangeRequested = false;
        }
        if (this.muteChangeRequested) {
            this.jfxPlayer.setMute(this.isMute());
            this.muteChangeRequested = false;
        }
        if (this.audioSpectrumNumBandsChangeRequested) {
            this.jfxPlayer.getAudioSpectrum().setBandCount(MediaPlayer.clamp(this.getAudioSpectrumNumBands(), 2, Integer.MAX_VALUE));
            this.audioSpectrumNumBandsChangeRequested = false;
        }
        if (this.audioSpectrumIntervalChangeRequested) {
            this.jfxPlayer.getAudioSpectrum().setInterval(MediaPlayer.clamp(this.getAudioSpectrumInterval(), 1.0E-9, Double.MAX_VALUE));
            this.audioSpectrumIntervalChangeRequested = false;
        }
        if (this.audioSpectrumThresholdChangeRequested) {
            this.jfxPlayer.getAudioSpectrum().setSensitivityThreshold(MediaPlayer.clamp(this.getAudioSpectrumThreshold(), Integer.MIN_VALUE, 0));
            this.audioSpectrumThresholdChangeRequested = false;
        }
        if (this.audioSpectrumEnabledChangeRequested) {
            boolean enabled = this.getAudioSpectrumListener() != null;
            this.jfxPlayer.getAudioSpectrum().setEnabled(enabled);
            this.audioSpectrumEnabledChangeRequested = false;
        }
        if (this.playRequested) {
            this.jfxPlayer.play();
            this.playRequested = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preReady() {
        double durationSeconds;
        Set<WeakReference<MediaView>> set = this.viewRefs;
        synchronized (set) {
            for (WeakReference<MediaView> vref : this.viewRefs) {
                MediaView v = (MediaView)vref.get();
                if (v == null) continue;
                v._mediaPlayerOnReady();
            }
        }
        if (this.audioEqualizer != null) {
            this.audioEqualizer.setAudioEqualizer(this.jfxPlayer.getEqualizer());
        }
        Duration duration = (durationSeconds = this.jfxPlayer.getDuration()) >= 0.0 && !Double.isNaN(durationSeconds) ? Duration.millis(durationSeconds * 1000.0) : Duration.UNKNOWN;
        this.playerReady = true;
        this.media.setDuration(duration);
        this.media._updateMedia(this.jfxPlayer.getMedia());
        this.handleRequestedChanges();
        this.calculateCycleDuration();
        if (this.lastBufferEvent != null && duration.toMillis() > 0.0) {
            double position = this.lastBufferEvent.getBufferPosition();
            double stop = this.lastBufferEvent.getBufferStop();
            double bufferedTime = position / stop * duration.toMillis();
            this.lastBufferEvent = null;
            this.setBufferProgressTime(Duration.millis(bufferedTime));
        }
        this.setStatus(Status.READY);
    }

    public final void setOnEndOfMedia(Runnable value) {
        this.onEndOfMediaProperty().set(value);
    }

    public final Runnable getOnEndOfMedia() {
        return this.onEndOfMedia == null ? null : (Runnable)this.onEndOfMedia.get();
    }

    public ObjectProperty<Runnable> onEndOfMediaProperty() {
        if (this.onEndOfMedia == null) {
            this.onEndOfMedia = new SimpleObjectProperty<Runnable>(this, "onEndOfMedia");
        }
        return this.onEndOfMedia;
    }

    public final void setOnReady(Runnable value) {
        this.onReadyProperty().set(value);
    }

    public final Runnable getOnReady() {
        return this.onReady == null ? null : (Runnable)this.onReady.get();
    }

    public ObjectProperty<Runnable> onReadyProperty() {
        if (this.onReady == null) {
            this.onReady = new SimpleObjectProperty<Runnable>(this, "onReady");
        }
        return this.onReady;
    }

    public final void setOnPlaying(Runnable value) {
        this.onPlayingProperty().set(value);
    }

    public final Runnable getOnPlaying() {
        return this.onPlaying == null ? null : (Runnable)this.onPlaying.get();
    }

    public ObjectProperty<Runnable> onPlayingProperty() {
        if (this.onPlaying == null) {
            this.onPlaying = new SimpleObjectProperty<Runnable>(this, "onPlaying");
        }
        return this.onPlaying;
    }

    public final void setOnPaused(Runnable value) {
        this.onPausedProperty().set(value);
    }

    public final Runnable getOnPaused() {
        return this.onPaused == null ? null : (Runnable)this.onPaused.get();
    }

    public ObjectProperty<Runnable> onPausedProperty() {
        if (this.onPaused == null) {
            this.onPaused = new SimpleObjectProperty<Runnable>(this, "onPaused");
        }
        return this.onPaused;
    }

    public final void setOnStopped(Runnable value) {
        this.onStoppedProperty().set(value);
    }

    public final Runnable getOnStopped() {
        return this.onStopped == null ? null : (Runnable)this.onStopped.get();
    }

    public ObjectProperty<Runnable> onStoppedProperty() {
        if (this.onStopped == null) {
            this.onStopped = new SimpleObjectProperty<Runnable>(this, "onStopped");
        }
        return this.onStopped;
    }

    public final void setOnHalted(Runnable value) {
        this.onHaltedProperty().set(value);
    }

    public final Runnable getOnHalted() {
        return this.onHalted == null ? null : (Runnable)this.onHalted.get();
    }

    public ObjectProperty<Runnable> onHaltedProperty() {
        if (this.onHalted == null) {
            this.onHalted = new SimpleObjectProperty<Runnable>(this, "onHalted");
        }
        return this.onHalted;
    }

    public final void setOnRepeat(Runnable value) {
        this.onRepeatProperty().set(value);
    }

    public final Runnable getOnRepeat() {
        return this.onRepeat == null ? null : (Runnable)this.onRepeat.get();
    }

    public ObjectProperty<Runnable> onRepeatProperty() {
        if (this.onRepeat == null) {
            this.onRepeat = new SimpleObjectProperty<Runnable>(this, "onRepeat");
        }
        return this.onRepeat;
    }

    public final void setOnStalled(Runnable value) {
        this.onStalledProperty().set(value);
    }

    public final Runnable getOnStalled() {
        return this.onStalled == null ? null : (Runnable)this.onStalled.get();
    }

    public ObjectProperty<Runnable> onStalledProperty() {
        if (this.onStalled == null) {
            this.onStalled = new SimpleObjectProperty<Runnable>(this, "onStalled");
        }
        return this.onStalled;
    }

    public final void setAudioSpectrumNumBands(int value) {
        this.audioSpectrumNumBandsProperty().setValue(value);
    }

    public final int getAudioSpectrumNumBands() {
        return this.audioSpectrumNumBandsProperty().getValue();
    }

    public IntegerProperty audioSpectrumNumBandsProperty() {
        if (this.audioSpectrumNumBands == null) {
            this.audioSpectrumNumBands = new IntegerPropertyBase(128){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void invalidated() {
                    Object object = MediaPlayer.this.disposeLock;
                    synchronized (object) {
                        if (MediaPlayer.this.getStatus() != Status.DISPOSED) {
                            if (MediaPlayer.this.playerReady) {
                                MediaPlayer.this.jfxPlayer.getAudioSpectrum().setBandCount(MediaPlayer.clamp(MediaPlayer.this.audioSpectrumNumBands.get(), 2, Integer.MAX_VALUE));
                            } else {
                                MediaPlayer.this.audioSpectrumNumBandsChangeRequested = true;
                            }
                        }
                    }
                }

                @Override
                public Object getBean() {
                    return MediaPlayer.this;
                }

                @Override
                public String getName() {
                    return "audioSpectrumNumBands";
                }
            };
        }
        return this.audioSpectrumNumBands;
    }

    public final void setAudioSpectrumInterval(double value) {
        this.audioSpectrumIntervalProperty().set(value);
    }

    public final double getAudioSpectrumInterval() {
        return this.audioSpectrumIntervalProperty().get();
    }

    public DoubleProperty audioSpectrumIntervalProperty() {
        if (this.audioSpectrumInterval == null) {
            this.audioSpectrumInterval = new DoublePropertyBase(0.1){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void invalidated() {
                    Object object = MediaPlayer.this.disposeLock;
                    synchronized (object) {
                        if (MediaPlayer.this.getStatus() != Status.DISPOSED) {
                            if (MediaPlayer.this.playerReady) {
                                MediaPlayer.this.jfxPlayer.getAudioSpectrum().setInterval(MediaPlayer.clamp(MediaPlayer.this.audioSpectrumInterval.get(), 1.0E-9, Double.MAX_VALUE));
                            } else {
                                MediaPlayer.this.audioSpectrumIntervalChangeRequested = true;
                            }
                        }
                    }
                }

                @Override
                public Object getBean() {
                    return MediaPlayer.this;
                }

                @Override
                public String getName() {
                    return "audioSpectrumInterval";
                }
            };
        }
        return this.audioSpectrumInterval;
    }

    public final void setAudioSpectrumThreshold(int value) {
        this.audioSpectrumThresholdProperty().set(value);
    }

    public final int getAudioSpectrumThreshold() {
        return this.audioSpectrumThresholdProperty().get();
    }

    public IntegerProperty audioSpectrumThresholdProperty() {
        if (this.audioSpectrumThreshold == null) {
            this.audioSpectrumThreshold = new IntegerPropertyBase(-60){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void invalidated() {
                    Object object = MediaPlayer.this.disposeLock;
                    synchronized (object) {
                        if (MediaPlayer.this.getStatus() != Status.DISPOSED) {
                            if (MediaPlayer.this.playerReady) {
                                MediaPlayer.this.jfxPlayer.getAudioSpectrum().setSensitivityThreshold(MediaPlayer.clamp(MediaPlayer.this.audioSpectrumThreshold.get(), Integer.MIN_VALUE, 0));
                            } else {
                                MediaPlayer.this.audioSpectrumThresholdChangeRequested = true;
                            }
                        }
                    }
                }

                @Override
                public Object getBean() {
                    return MediaPlayer.this;
                }

                @Override
                public String getName() {
                    return "audioSpectrumThreshold";
                }
            };
        }
        return this.audioSpectrumThreshold;
    }

    public final void setAudioSpectrumListener(AudioSpectrumListener listener) {
        this.audioSpectrumListenerProperty().set(listener);
    }

    public final AudioSpectrumListener getAudioSpectrumListener() {
        return (AudioSpectrumListener)this.audioSpectrumListenerProperty().get();
    }

    public ObjectProperty<AudioSpectrumListener> audioSpectrumListenerProperty() {
        if (this.audioSpectrumListener == null) {
            this.audioSpectrumListener = new ObjectPropertyBase<AudioSpectrumListener>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void invalidated() {
                    Object object = MediaPlayer.this.disposeLock;
                    synchronized (object) {
                        if (MediaPlayer.this.getStatus() != Status.DISPOSED) {
                            if (MediaPlayer.this.playerReady) {
                                boolean enabled = MediaPlayer.this.audioSpectrumListener.get() != null;
                                MediaPlayer.this.jfxPlayer.getAudioSpectrum().setEnabled(enabled);
                            } else {
                                MediaPlayer.this.audioSpectrumEnabledChangeRequested = true;
                            }
                        }
                    }
                }

                @Override
                public Object getBean() {
                    return MediaPlayer.this;
                }

                @Override
                public String getName() {
                    return "audioSpectrumListener";
                }
            };
        }
        return this.audioSpectrumListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        Object object = this.disposeLock;
        synchronized (object) {
            this.setStatus(Status.DISPOSED);
            this.destroyMediaTimer();
            if (this.audioEqualizer != null) {
                this.audioEqualizer.setAudioEqualizer(null);
                this.audioEqualizer = null;
            }
            if (this.jfxPlayer != null) {
                this.jfxPlayer.dispose();
                Object object2 = this.renderLock;
                synchronized (object2) {
                    if (this.rendererListener != null) {
                        Toolkit.getToolkit().removeStageTkPulseListener(this.rendererListener);
                        this.rendererListener = null;
                    }
                }
                this.jfxPlayer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public VideoDataBuffer impl_getLatestFrame() {
        Object object = this.renderLock;
        synchronized (object) {
            if (null != this.currentRenderFrame) {
                this.currentRenderFrame.holdFrame();
            }
            return this.currentRenderFrame;
        }
    }

    private /* synthetic */ void lambda$handleError$13(MediaException error) {
        this.setError(error);
        if (error.getType() == MediaException.Type.MEDIA_CORRUPTED || error.getType() == MediaException.Type.MEDIA_UNSUPPORTED || error.getType() == MediaException.Type.MEDIA_INACCESSIBLE || error.getType() == MediaException.Type.MEDIA_UNAVAILABLE) {
            this.media._setError(error.getType(), error.getMessage());
        }
    }

    private /* synthetic */ void lambda$setStartStopTimes$12() {
        this.setCurrentTime(this.getStartTime());
    }

    private /* synthetic */ void lambda$init$11() {
        this.registerListeners();
    }

    static /* synthetic */ void access$lambda$0(MediaPlayer mediaPlayer) {
        mediaPlayer.lambda$init$11();
    }

    static /* synthetic */ void access$lambda$1(MediaPlayer mediaPlayer) {
        mediaPlayer.lambda$setStartStopTimes$12();
    }

    static /* synthetic */ void access$lambda$2(MediaPlayer mediaPlayer, MediaException mediaException) {
        mediaPlayer.lambda$handleError$13(mediaException);
    }

    private class RendererListener
    implements VideoRendererListener,
    TKPulseListener {
        boolean updateMediaViews;

        private RendererListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void videoFrameUpdated(NewFrameEvent nfe) {
            VideoDataBuffer vdb = nfe.getFrameData();
            if (null != vdb) {
                Duration frameTS = new Duration(vdb.getTimestamp() * 1000.0);
                Duration stopTime = MediaPlayer.this.getStopTime();
                if (frameTS.greaterThanOrEqualTo(MediaPlayer.this.getStartTime()) && (stopTime.isUnknown() || frameTS.lessThanOrEqualTo(stopTime))) {
                    this.updateMediaViews = true;
                    Object object = MediaPlayer.this.renderLock;
                    synchronized (object) {
                        vdb.holdFrame();
                        if (null != MediaPlayer.this.nextRenderFrame) {
                            MediaPlayer.this.nextRenderFrame.releaseFrame();
                        }
                        MediaPlayer.this.nextRenderFrame = vdb;
                    }
                    Toolkit.getToolkit().requestNextPulse();
                } else {
                    vdb.releaseFrame();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void releaseVideoFrames() {
            Object object = MediaPlayer.this.renderLock;
            synchronized (object) {
                if (null != MediaPlayer.this.currentRenderFrame) {
                    MediaPlayer.this.currentRenderFrame.releaseFrame();
                    MediaPlayer.this.currentRenderFrame = null;
                }
                if (null != MediaPlayer.this.nextRenderFrame) {
                    MediaPlayer.this.nextRenderFrame.releaseFrame();
                    MediaPlayer.this.nextRenderFrame = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pulse() {
            if (this.updateMediaViews) {
                this.updateMediaViews = false;
                Object object = MediaPlayer.this.renderLock;
                synchronized (object) {
                    if (null != MediaPlayer.this.nextRenderFrame) {
                        if (null != MediaPlayer.this.currentRenderFrame) {
                            MediaPlayer.this.currentRenderFrame.releaseFrame();
                        }
                        MediaPlayer.this.currentRenderFrame = MediaPlayer.this.nextRenderFrame;
                        MediaPlayer.this.nextRenderFrame = null;
                    }
                }
                object = MediaPlayer.this.viewRefs;
                synchronized (object) {
                    Iterator iter = MediaPlayer.this.viewRefs.iterator();
                    while (iter.hasNext()) {
                        MediaView view = (MediaView)((WeakReference)iter.next()).get();
                        if (null != view) {
                            view.notifyMediaFrameUpdated();
                            continue;
                        }
                        iter.remove();
                    }
                }
            }
        }
    }

    private class _SpectrumListener
    implements com.sun.media.jfxmedia.events.AudioSpectrumListener {
        private float[] magnitudes;
        private float[] phases;

        private _SpectrumListener() {
        }

        @Override
        public void onAudioSpectrumEvent(AudioSpectrumEvent evt) {
            Platform.runLater(MediaPlayer$_SpectrumListener$$Lambda$1.lambdaFactory$(this, evt));
        }

        private /* synthetic */ void lambda$onAudioSpectrumEvent$26(AudioSpectrumEvent evt) {
            AudioSpectrumListener listener = MediaPlayer.this.getAudioSpectrumListener();
            if (listener != null) {
                this.magnitudes = evt.getSource().getMagnitudes(this.magnitudes);
                this.phases = evt.getSource().getPhases(this.phases);
                listener.spectrumDataUpdate(evt.getTimestamp(), evt.getDuration(), this.magnitudes, this.phases);
            }
        }

        static /* synthetic */ void access$lambda$0(_SpectrumListener _SpectrumListener2, AudioSpectrumEvent audioSpectrumEvent) {
            _SpectrumListener2.lambda$onAudioSpectrumEvent$26(audioSpectrumEvent);
        }
    }

    private class _BufferListener
    implements BufferListener {
        double bufferedTime;

        private _BufferListener() {
        }

        @Override
        public void onBufferProgress(BufferProgressEvent evt) {
            if (MediaPlayer.this.media != null) {
                if (evt.getDuration() > 0.0) {
                    double position = evt.getBufferPosition();
                    double stop = evt.getBufferStop();
                    this.bufferedTime = position / stop * evt.getDuration() * 1000.0;
                    MediaPlayer.this.lastBufferEvent = null;
                    Platform.runLater(MediaPlayer$_BufferListener$$Lambda$1.lambdaFactory$(this));
                } else {
                    MediaPlayer.this.lastBufferEvent = evt;
                }
            }
        }

        private /* synthetic */ void lambda$onBufferProgress$25() {
            MediaPlayer.this.setBufferProgressTime(Duration.millis(this.bufferedTime));
        }

        static /* synthetic */ void access$lambda$0(_BufferListener _BufferListener2) {
            _BufferListener2.lambda$onBufferProgress$25();
        }
    }

    private class _MediaErrorListener
    implements MediaErrorListener {
        private _MediaErrorListener() {
        }

        @Override
        public void onError(Object source, int errorCode, String message) {
            MediaException error = MediaException.getMediaException(source, errorCode, message);
            MediaPlayer.this.handleError(error);
        }
    }

    private class _VideoTrackSizeListener
    implements VideoTrackSizeListener {
        int trackWidth;
        int trackHeight;

        private _VideoTrackSizeListener() {
        }

        @Override
        public void onSizeChanged(int width, int height) {
            Platform.runLater(MediaPlayer$_VideoTrackSizeListener$$Lambda$1.lambdaFactory$(this, width, height));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setSize() {
            MediaPlayer.this.media.setWidth(this.trackWidth);
            MediaPlayer.this.media.setHeight(this.trackHeight);
            Set set = MediaPlayer.this.viewRefs;
            synchronized (set) {
                for (WeakReference vref : MediaPlayer.this.viewRefs) {
                    MediaView v = (MediaView)vref.get();
                    if (v == null) continue;
                    v.notifyMediaSizeChange();
                }
            }
        }

        private /* synthetic */ void lambda$onSizeChanged$24(int width, int height) {
            if (MediaPlayer.this.media != null) {
                this.trackWidth = width;
                this.trackHeight = height;
                this.setSize();
            }
        }

        static /* synthetic */ void access$lambda$0(_VideoTrackSizeListener _VideoTrackSizeListener2, int n, int n2) {
            _VideoTrackSizeListener2.lambda$onSizeChanged$24(n, n2);
        }
    }

    private class _PlayerTimeListener
    implements PlayerTimeListener {
        double theDuration;

        private _PlayerTimeListener() {
        }

        void handleDurationChanged() {
            MediaPlayer.this.media.setDuration(Duration.millis(this.theDuration * 1000.0));
        }

        @Override
        public void onDurationChanged(double duration) {
            Platform.runLater(MediaPlayer$_PlayerTimeListener$$Lambda$1.lambdaFactory$(this, duration));
        }

        private /* synthetic */ void lambda$onDurationChanged$23(double duration) {
            this.theDuration = duration;
            this.handleDurationChanged();
        }

        static /* synthetic */ void access$lambda$0(_PlayerTimeListener _PlayerTimeListener2, double d) {
            _PlayerTimeListener2.lambda$onDurationChanged$23(d);
        }
    }

    private class _PlayerStateListener
    implements PlayerStateListener {
        private _PlayerStateListener() {
        }

        @Override
        public void onReady(PlayerStateEvent evt) {
            Platform.runLater(MediaPlayer$_PlayerStateListener$$Lambda$1.lambdaFactory$(this));
        }

        @Override
        public void onPlaying(PlayerStateEvent evt) {
            MediaPlayer.this.startTimeAtStop = null;
            Platform.runLater(MediaPlayer$_PlayerStateListener$$Lambda$2.lambdaFactory$(this));
        }

        @Override
        public void onPause(PlayerStateEvent evt) {
            Platform.runLater(MediaPlayer$_PlayerStateListener$$Lambda$3.lambdaFactory$(this));
            if (MediaPlayer.this.startTimeAtStop != null && MediaPlayer.this.startTimeAtStop != MediaPlayer.this.getStartTime()) {
                MediaPlayer.this.startTimeAtStop = null;
                Platform.runLater(MediaPlayer$_PlayerStateListener$$Lambda$4.lambdaFactory$(this));
            }
        }

        @Override
        public void onStop(PlayerStateEvent evt) {
            Platform.runLater(MediaPlayer$_PlayerStateListener$$Lambda$5.lambdaFactory$(this));
        }

        @Override
        public void onStall(PlayerStateEvent evt) {
            Platform.runLater(MediaPlayer$_PlayerStateListener$$Lambda$6.lambdaFactory$(this));
        }

        void handleFinish() {
            MediaPlayer.this.setCurrentCount(MediaPlayer.this.getCurrentCount() + 1);
            if (MediaPlayer.this.getCurrentCount() < MediaPlayer.this.getCycleCount() || MediaPlayer.this.getCycleCount() == -1) {
                if (MediaPlayer.this.getOnEndOfMedia() != null) {
                    Platform.runLater(MediaPlayer.this.getOnEndOfMedia());
                }
                MediaPlayer.this.loopPlayback();
                if (MediaPlayer.this.getOnRepeat() != null) {
                    Platform.runLater(MediaPlayer.this.getOnRepeat());
                }
            } else {
                MediaPlayer.this.isUpdateTimeEnabled = false;
                MediaPlayer.this.setCurrentRate(0.0);
                MediaPlayer.this.isEOS = true;
                if (MediaPlayer.this.getOnEndOfMedia() != null) {
                    Platform.runLater(MediaPlayer.this.getOnEndOfMedia());
                }
            }
        }

        @Override
        public void onFinish(PlayerStateEvent evt) {
            MediaPlayer.this.startTimeAtStop = null;
            Platform.runLater(MediaPlayer$_PlayerStateListener$$Lambda$7.lambdaFactory$(this));
        }

        @Override
        public void onHalt(PlayerStateEvent evt) {
            Platform.runLater(MediaPlayer$_PlayerStateListener$$Lambda$8.lambdaFactory$(this, evt));
        }

        private /* synthetic */ void lambda$onHalt$22(PlayerStateEvent evt) {
            MediaPlayer.this.setStatus(Status.HALTED);
            MediaPlayer.this.handleError(MediaException.haltException(evt.getMessage()));
            MediaPlayer.this.isUpdateTimeEnabled = false;
        }

        private /* synthetic */ void lambda$onFinish$21() {
            this.handleFinish();
        }

        private /* synthetic */ void lambda$onStall$20() {
            MediaPlayer.this.isUpdateTimeEnabled = false;
            MediaPlayer.this.setStatus(Status.STALLED);
        }

        private /* synthetic */ void lambda$onStop$19() {
            MediaPlayer.this.destroyMediaTimer();
            MediaPlayer.this.startTimeAtStop = MediaPlayer.this.getStartTime();
            MediaPlayer.this.setCurrentTime(MediaPlayer.this.getStartTime());
            MediaPlayer.this.setStatus(Status.STOPPED);
        }

        private /* synthetic */ void lambda$onPause$18() {
            MediaPlayer.this.setCurrentTime(MediaPlayer.this.getStartTime());
        }

        private /* synthetic */ void lambda$onPause$17() {
            MediaPlayer.this.isUpdateTimeEnabled = false;
            MediaPlayer.this.setStatus(Status.PAUSED);
        }

        private /* synthetic */ void lambda$onPlaying$16() {
            MediaPlayer.this.createMediaTimer();
            MediaPlayer.this.setStatus(Status.PLAYING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private /* synthetic */ void lambda$onReady$15() {
            Object object = MediaPlayer.this.disposeLock;
            synchronized (object) {
                if (MediaPlayer.this.getStatus() == Status.DISPOSED) {
                    return;
                }
                MediaPlayer.this.preReady();
            }
        }

        static /* synthetic */ void access$lambda$0(_PlayerStateListener _PlayerStateListener2) {
            _PlayerStateListener2.lambda$onReady$15();
        }

        static /* synthetic */ void access$lambda$1(_PlayerStateListener _PlayerStateListener2) {
            _PlayerStateListener2.lambda$onPlaying$16();
        }

        static /* synthetic */ void access$lambda$2(_PlayerStateListener _PlayerStateListener2) {
            _PlayerStateListener2.lambda$onPause$17();
        }

        static /* synthetic */ void access$lambda$3(_PlayerStateListener _PlayerStateListener2) {
            _PlayerStateListener2.lambda$onPause$18();
        }

        static /* synthetic */ void access$lambda$4(_PlayerStateListener _PlayerStateListener2) {
            _PlayerStateListener2.lambda$onStop$19();
        }

        static /* synthetic */ void access$lambda$5(_PlayerStateListener _PlayerStateListener2) {
            _PlayerStateListener2.lambda$onStall$20();
        }

        static /* synthetic */ void access$lambda$6(_PlayerStateListener _PlayerStateListener2) {
            _PlayerStateListener2.lambda$onFinish$21();
        }

        static /* synthetic */ void access$lambda$7(_PlayerStateListener _PlayerStateListener2, PlayerStateEvent playerStateEvent) {
            _PlayerStateListener2.lambda$onHalt$22(playerStateEvent);
        }
    }

    private class _MarkerListener
    implements MarkerListener {
        private _MarkerListener() {
        }

        @Override
        public void onMarker(MarkerEvent evt) {
            Platform.runLater(MediaPlayer$_MarkerListener$$Lambda$1.lambdaFactory$(this, evt));
        }

        private /* synthetic */ void lambda$onMarker$14(MarkerEvent evt) {
            Duration markerTime = Duration.millis(evt.getPresentationTime() * 1000.0);
            if (MediaPlayer.this.getOnMarker() != null) {
                MediaPlayer.this.getOnMarker().handle(new MediaMarkerEvent(new Pair<String, Duration>(evt.getMarkerName(), markerTime)));
            }
        }

        static /* synthetic */ void access$lambda$0(_MarkerListener _MarkerListener2, MarkerEvent markerEvent) {
            _MarkerListener2.lambda$onMarker$14(markerEvent);
        }
    }

    private class MarkerMapChangeListener
    implements MapChangeListener<String, Duration> {
        private MarkerMapChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChanged(MapChangeListener.Change<? extends String, ? extends Duration> change) {
            Object object = MediaPlayer.this.disposeLock;
            synchronized (object) {
                if (MediaPlayer.this.getStatus() != Status.DISPOSED) {
                    String key = change.getKey();
                    if (key == null) {
                        return;
                    }
                    com.sun.media.jfxmedia.Media jfxMedia = MediaPlayer.this.jfxPlayer.getMedia();
                    if (change.wasAdded()) {
                        Duration value;
                        if (change.wasRemoved()) {
                            jfxMedia.removeMarker(key);
                        }
                        if ((value = change.getValueAdded()) != null && value.greaterThanOrEqualTo(Duration.ZERO)) {
                            jfxMedia.addMarker(key, change.getValueAdded().toMillis() / 1000.0);
                        }
                    } else if (change.wasRemoved()) {
                        jfxMedia.removeMarker(key);
                    }
                }
            }
        }
    }

    private class InitMediaPlayer
    implements Runnable {
        private InitMediaPlayer() {
        }

        @Override
        public void run() {
            try {
                MediaPlayer.this.init();
            }
            catch (com.sun.media.jfxmedia.MediaException e) {
                MediaPlayer.this.handleError(MediaException.exceptionToMediaException(e));
            }
            catch (MediaException e) {
                MediaPlayer.this.handleError(e);
            }
            catch (Exception e) {
                MediaPlayer.this.handleError(new MediaException(MediaException.Type.UNKNOWN, e.getMessage()));
            }
        }
    }

    public static enum Status {
        UNKNOWN,
        READY,
        PAUSED,
        PLAYING,
        STOPPED,
        STALLED,
        HALTED,
        DISPOSED;

    }
}

