/*
 * Decompiled with CFR 0.152.
 */
package javafx.util.converter;

import com.sun.javafx.binding.Logging;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DecimalStyle;
import java.time.format.FormatStyle;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import javafx.util.StringConverter;

public class LocalDateTimeStringConverter
extends StringConverter<LocalDateTime> {
    LdtConverter<LocalDateTime> ldtConverter;

    public LocalDateTimeStringConverter() {
        this.ldtConverter = new LdtConverter<LocalDateTime>(LocalDateTime.class, null, null, null, null, null, null);
    }

    public LocalDateTimeStringConverter(FormatStyle dateStyle, FormatStyle timeStyle) {
        this.ldtConverter = new LdtConverter<LocalDateTime>(LocalDateTime.class, null, null, dateStyle, timeStyle, null, null);
    }

    public LocalDateTimeStringConverter(DateTimeFormatter formatter, DateTimeFormatter parser) {
        this.ldtConverter = new LdtConverter<LocalDateTime>(LocalDateTime.class, formatter, parser, null, null, null, null);
    }

    public LocalDateTimeStringConverter(FormatStyle dateStyle, FormatStyle timeStyle, Locale locale, Chronology chronology) {
        this.ldtConverter = new LdtConverter<LocalDateTime>(LocalDateTime.class, null, null, dateStyle, timeStyle, locale, chronology);
    }

    @Override
    public LocalDateTime fromString(String value) {
        return (LocalDateTime)this.ldtConverter.fromString(value);
    }

    @Override
    public String toString(LocalDateTime value) {
        return this.ldtConverter.toString(value);
    }

    static class LdtConverter<T extends Temporal>
    extends StringConverter<T> {
        private Class<T> type;
        Locale locale;
        Chronology chronology;
        DateTimeFormatter formatter;
        DateTimeFormatter parser;
        FormatStyle dateStyle;
        FormatStyle timeStyle;

        LdtConverter(Class<T> type, DateTimeFormatter formatter, DateTimeFormatter parser, FormatStyle dateStyle, FormatStyle timeStyle, Locale locale, Chronology chronology) {
            this.type = type;
            this.formatter = formatter;
            this.parser = parser != null ? parser : formatter;
            this.locale = locale != null ? locale : Locale.getDefault();
            Chronology chronology2 = this.chronology = chronology != null ? chronology : IsoChronology.INSTANCE;
            if (type == LocalDate.class || type == LocalDateTime.class) {
                FormatStyle formatStyle = this.dateStyle = dateStyle != null ? dateStyle : FormatStyle.SHORT;
            }
            if (type == LocalTime.class || type == LocalDateTime.class) {
                this.timeStyle = timeStyle != null ? timeStyle : FormatStyle.SHORT;
            }
        }

        @Override
        public T fromString(String text) {
            if (text == null || text.isEmpty()) {
                return null;
            }
            text = text.trim();
            if (this.parser == null) {
                this.parser = this.getDefaultParser();
            }
            TemporalAccessor temporal = this.parser.parse(text);
            if (this.type == LocalDate.class) {
                return (T)LocalDate.from(this.chronology.date(temporal));
            }
            if (this.type == LocalTime.class) {
                return (T)LocalTime.from(temporal);
            }
            return (T)LocalDateTime.from(this.chronology.localDateTime(temporal));
        }

        @Override
        public String toString(T value) {
            if (value == null) {
                return "";
            }
            if (this.formatter == null) {
                this.formatter = this.getDefaultFormatter();
            }
            if (value instanceof LocalDate) {
                ChronoLocalDate cDate;
                try {
                    cDate = this.chronology.date((TemporalAccessor)value);
                }
                catch (DateTimeException ex) {
                    Logging.getLogger().warning("Converting LocalDate " + value + " to " + this.chronology + " failed, falling back to IsoChronology.", ex);
                    this.chronology = IsoChronology.INSTANCE;
                    cDate = (LocalDate)value;
                }
                return this.formatter.format(cDate);
            }
            if (value instanceof LocalDateTime) {
                LocalDateTime cDateTime;
                try {
                    cDateTime = this.chronology.localDateTime((TemporalAccessor)value);
                }
                catch (DateTimeException ex) {
                    Logging.getLogger().warning("Converting LocalDateTime " + value + " to " + this.chronology + " failed, falling back to IsoChronology.", ex);
                    this.chronology = IsoChronology.INSTANCE;
                    cDateTime = (LocalDateTime)value;
                }
                return this.formatter.format(cDateTime);
            }
            return this.formatter.format((TemporalAccessor)value);
        }

        private DateTimeFormatter getDefaultParser() {
            String pattern = DateTimeFormatterBuilder.getLocalizedDateTimePattern(this.dateStyle, this.timeStyle, this.chronology, this.locale);
            return new DateTimeFormatterBuilder().parseLenient().appendPattern(pattern).toFormatter().withChronology(this.chronology).withDecimalStyle(DecimalStyle.of(this.locale));
        }

        private DateTimeFormatter getDefaultFormatter() {
            DateTimeFormatter formatter = this.dateStyle != null && this.timeStyle != null ? DateTimeFormatter.ofLocalizedDateTime(this.dateStyle, this.timeStyle) : (this.dateStyle != null ? DateTimeFormatter.ofLocalizedDate(this.dateStyle) : DateTimeFormatter.ofLocalizedTime(this.timeStyle));
            formatter = formatter.withLocale(this.locale).withChronology(this.chronology).withDecimalStyle(DecimalStyle.of(this.locale));
            if (this.dateStyle != null) {
                formatter = this.fixFourDigitYear(formatter, this.dateStyle, this.timeStyle, this.chronology, this.locale);
            }
            return formatter;
        }

        private DateTimeFormatter fixFourDigitYear(DateTimeFormatter formatter, FormatStyle dateStyle, FormatStyle timeStyle, Chronology chronology, Locale locale) {
            String pattern = DateTimeFormatterBuilder.getLocalizedDateTimePattern(dateStyle, timeStyle, chronology, locale);
            if (pattern.contains("yy") && !pattern.contains("yyy")) {
                String newPattern = pattern.replace("yy", "yyyy");
                formatter = DateTimeFormatter.ofPattern(newPattern).withDecimalStyle(DecimalStyle.of(locale));
            }
            return formatter;
        }
    }
}

