/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.stream.writers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.xerces.util.XMLChar;

public final class UTF8OutputStreamWriter
extends Writer {
    OutputStream out;
    int lastUTF16CodePoint = 0;

    public UTF8OutputStreamWriter(OutputStream out) {
        this.out = out;
    }

    public String getEncoding() {
        return "UTF-8";
    }

    @Override
    public void write(int c) throws IOException {
        if (this.lastUTF16CodePoint != 0) {
            int uc = ((this.lastUTF16CodePoint & 0x3FF) << 10 | c & 0x3FF) + 65536;
            if (uc < 0 || uc >= 0x200000) {
                throw new IOException("Atttempting to write invalid Unicode code point '" + uc + "'");
            }
            this.out.write(0xF0 | uc >> 18);
            this.out.write(0x80 | uc >> 12 & 0x3F);
            this.out.write(0x80 | uc >> 6 & 0x3F);
            this.out.write(0x80 | uc & 0x3F);
            this.lastUTF16CodePoint = 0;
            return;
        }
        if (c < 128) {
            this.out.write(c);
        } else if (c < 2048) {
            this.out.write(0xC0 | c >> 6);
            this.out.write(0x80 | c & 0x3F);
        } else if (c <= 65535) {
            if (!XMLChar.isHighSurrogate(c) && !XMLChar.isLowSurrogate(c)) {
                this.out.write(0xE0 | c >> 12);
                this.out.write(0x80 | c >> 6 & 0x3F);
                this.out.write(0x80 | c & 0x3F);
            } else {
                this.lastUTF16CodePoint = c;
            }
        }
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        for (int i = 0; i < cbuf.length; ++i) {
            this.write(cbuf[i]);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(cbuf[off + i]);
        }
    }

    @Override
    public void write(String str) throws IOException {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            this.write(str.charAt(i));
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(str.charAt(off + i));
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.lastUTF16CodePoint != 0) {
            throw new IllegalStateException("Attempting to close a UTF8OutputStreamWriter while awaiting for a UTF-16 code unit");
        }
        this.out.close();
    }
}

