/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.lens;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.lens.LensApplication;
import com.sun.glass.ui.lens.LensCursor;
import com.sun.glass.ui.lens.LensLogger;
import com.sun.glass.ui.lens.LensView;
import java.util.List;

final class LensWindow
extends Window {
    protected LensWindow(Window owner, Screen screen, int styleMask) {
        super(owner, screen, styleMask);
    }

    protected LensWindow(long parent) {
        super(parent);
    }

    @Override
    protected void _toFront(long ptr) {
        List<Window> list = LensWindow.getWindowsClone();
        this.raiseOwnedWindows(list);
    }

    @Override
    protected void _toBack(long ptr) {
        LensWindow.remove(this);
        LensWindow.addFirst(this);
        this._toBackImpl(ptr);
    }

    private void raiseOwnedWindows(List<Window> list) {
        LensWindow.remove(this);
        LensWindow.add(this);
        this._toFrontImpl(this.getRawHandle());
        for (Window w : list) {
            if (!this.equals(w.getOwner())) continue;
            ((LensWindow)w).raiseOwnedWindows(list);
        }
    }

    @Override
    protected void _setBounds(long nativeWindowPointer, int x, int y, boolean xSet, boolean ySet, int w, int h, int cw, int ch, float xGravity, float yGravity) {
        int height;
        int width;
        boolean isContentSize = false;
        boolean needToUpdatePosition = xSet || ySet;
        boolean needResize = false;
        if (!xSet && !ySet && w < 0 && h < 0 && cw < 0 && ch < 0) {
            return;
        }
        LensLogger.getLogger().fine("_setBounds x=" + x + " y=" + y + " xSet=" + xSet + " ySet=" + ySet + " w=" + w + " h=" + h + " cw=" + cw + " ch=" + ch + " xGravity=" + xGravity + " yGravity=" + yGravity);
        if (needToUpdatePosition) {
            if (!xSet) {
                x = this.getX();
            }
            if (!ySet) {
                y = this.getY();
            }
        }
        if (w > 0) {
            width = w;
            needResize = true;
        } else if (cw > 0) {
            width = cw;
            isContentSize = true;
            needResize = true;
        } else {
            width = this.getWidth();
        }
        if (h > 0) {
            height = h;
            needResize = true;
        } else if (cw > 0) {
            height = ch;
            isContentSize = true;
            needResize = true;
        } else {
            height = this.getHeight();
        }
        this.setBoundsImpl(nativeWindowPointer, x, y, width, height, needToUpdatePosition, needResize, isContentSize);
    }

    @Override
    protected native long _createWindow(long var1, long var3, int var5);

    @Override
    protected native long _createChildWindow(long var1);

    @Override
    protected native boolean _close(long var1);

    private native boolean attachViewToWindow(long var1, long var3);

    @Override
    protected boolean _setView(long nativeWindowPointer, View view) {
        boolean result = false;
        LensLogger.getLogger().info("set view " + view + ", visible=" + this.isVisible());
        long nativeViewPtr = view == null ? 0L : view.getNativeView();
        result = this.attachViewToWindow(nativeWindowPointer, nativeViewPtr);
        if (view != null && result) {
            ((LensView)view)._notifyResize(this.getWidth(), this.getHeight());
        }
        return result;
    }

    @Override
    public long getNativeWindow() {
        return this._getNativeWindowImpl(super.getNativeWindow());
    }

    private native long _getNativeWindowImpl(long var1);

    @Override
    protected boolean _setMenubar(long ptr, long menubarPtr) {
        return true;
    }

    @Override
    protected native boolean _minimize(long var1, boolean var3);

    @Override
    protected native boolean _maximize(long var1, boolean var3, boolean var4);

    private native void setBoundsImpl(long var1, int var3, int var4, int var5, int var6, boolean var7, boolean var8, boolean var9);

    @Override
    protected native boolean _setVisible(long var1, boolean var3);

    @Override
    protected native boolean _setResizable(long var1, boolean var3);

    @Override
    protected native boolean _requestFocus(long var1, int var3);

    @Override
    protected native void _setFocusable(long var1, boolean var3);

    @Override
    protected native boolean _setTitle(long var1, String var3);

    @Override
    protected native void _setLevel(long var1, int var3);

    @Override
    protected native void _setAlpha(long var1, float var3);

    @Override
    protected native boolean _setBackground(long var1, float var3, float var4, float var5);

    @Override
    protected native void _setEnabled(long var1, boolean var3);

    @Override
    protected native boolean _setMinimumSize(long var1, int var3, int var4);

    @Override
    protected native boolean _setMaximumSize(long var1, int var3, int var4);

    @Override
    protected native void _setIcon(long var1, Pixels var3);

    private native void _toFrontImpl(long var1);

    private native void _toBackImpl(long var1);

    @Override
    protected native boolean _grabFocus(long var1);

    @Override
    protected native void _ungrabFocus(long var1);

    @Override
    protected void _enterModal(long ptr) {
        LensLogger.getLogger().severe("Platform modality not supported");
    }

    @Override
    protected void _enterModalWithWindow(long dialog, long window) {
        LensLogger.getLogger().severe("Platform modality not supported");
    }

    @Override
    protected void _exitModal(long ptr) {
        LensLogger.getLogger().severe("Platform modality not supported");
    }

    protected void _notifyClose() {
        this.notifyClose();
        this.close();
    }

    protected void _notifyDestroy() {
        this.notifyDestroy();
    }

    protected void _notifyFocus(int event) {
        this.notifyFocus(event);
    }

    protected void _notifyMove(int x, int y) {
        this.notifyMove(x, y);
    }

    protected void _notifyResize(int type, int width, int height) {
        this.notifyResize(type, width, height);
        LensView view = (LensView)this.getView();
        if (view != null) {
            view._notifyResize(width, height);
        }
    }

    protected void _notifyExpose(int x, int y, int width, int height) {
        LensView view = (LensView)this.getView();
        if (view != null) {
            view._notifyRepaint(x, y, width, height);
        }
    }

    protected void _notifyFocusUngrab() {
        this.notifyFocusUngrab();
    }

    protected void _notifyFocusDisabled() {
        this.notifyFocusDisabled();
    }

    protected void nativeExpose(int x, int y, int width, int height) {
        if (Application.isEventThread()) {
            this._notifyExpose(x, y, width, height);
        } else {
            ((LensApplication)Application.GetApplication()).windowExpose(this, x, y, width, height);
        }
    }

    protected void nativeConfigure(int type, int x, int y, int width, int height) {
        LensApplication app = (LensApplication)Application.GetApplication();
        if (Application.isEventThread()) {
            if (x != this.getX() || y != this.getY()) {
                this._notifyMove(x, y);
            }
            if (width != this.getWidth() || height != this.getHeight()) {
                this._notifyResize(type, width, height);
            }
        } else {
            if (x != this.getX() || y != this.getY()) {
                app.notifyWindowMove(this, x, y);
            }
            if (width != this.getWidth() || height != this.getHeight()) {
                app.notifyWindowResize(this, type, width, height);
            }
        }
    }

    protected void nativeClose() {
        LensApplication lensApp = (LensApplication)Application.GetApplication();
        lensApp.notifyWindowEvent(this, 521);
    }

    @Override
    protected void _setCursor(long ptr, Cursor cursor) {
        ((LensCursor)cursor).set();
    }

    @Override
    protected int _getEmbeddedX(long ptr) {
        return 0;
    }

    @Override
    protected int _getEmbeddedY(long ptr) {
        return 0;
    }

    @Override
    protected void _requestInput(long ptr, String text, int type, double width, double height, double Mxx, double Mxy, double Mxz, double Mxt, double Myx, double Myy, double Myz, double Myt, double Mzx, double Mzy, double Mzz, double Mzt, double fontSize) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void _releaseInput(long ptr) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

