/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.EGL;
import com.sun.glass.ui.monocle.GLException;
import com.sun.glass.ui.monocle.LinuxSystem;
import com.sun.glass.ui.monocle.NativeScreen;

public class AcceleratedScreen {
    private static long glesLibraryHandle;
    private static long eglLibraryHandle;
    private static boolean initialized;
    private long eglSurface;
    private long eglContext;
    private long eglDisplay;
    private long nativeWindow;
    protected static final LinuxSystem ls;
    private EGL egl;
    long[] eglConfigs = new long[]{0L};

    protected long platformGetNativeDisplay() {
        return 0L;
    }

    protected long platformGetNativeWindow() {
        return 0L;
    }

    AcceleratedScreen(int[] attributes) throws GLException, UnsatisfiedLinkError {
        this.egl = EGL.getEGL();
        this.initPlatformLibraries();
        int[] major = new int[]{0};
        int[] minor = new int[]{0};
        long nativeDisplay = this.platformGetNativeDisplay();
        this.nativeWindow = this.platformGetNativeWindow();
        if (nativeDisplay == -1L) {
            throw new GLException(0, "Could not get native display");
        }
        if (this.nativeWindow == -1L) {
            throw new GLException(0, "Could not get native window");
        }
        this.eglDisplay = this.egl.eglGetDisplay(nativeDisplay);
        if (this.eglDisplay == 0L) {
            throw new GLException(this.egl.eglGetError(), "Could not get EGL display");
        }
        if (!this.egl.eglInitialize(this.eglDisplay, major, minor)) {
            throw new GLException(this.egl.eglGetError(), "Error initializing EGL");
        }
        if (!this.egl.eglBindAPI(12448)) {
            throw new GLException(this.egl.eglGetError(), "Error binding OPENGL API");
        }
        int[] configCount = new int[]{0};
        if (!this.egl.eglChooseConfig(this.eglDisplay, attributes, this.eglConfigs, 1, configCount)) {
            throw new GLException(this.egl.eglGetError(), "Error choosing EGL config");
        }
        this.eglSurface = this.egl.eglCreateWindowSurface(this.eglDisplay, this.eglConfigs[0], this.nativeWindow, null);
        if (this.eglSurface == 0L) {
            throw new GLException(this.egl.eglGetError(), "Could not get EGL surface");
        }
        int[] emptyAttrArray = new int[]{};
        this.eglContext = this.egl.eglCreateContext(this.eglDisplay, this.eglConfigs[0], 0L, emptyAttrArray);
        if (this.eglContext == 0L) {
            throw new GLException(this.egl.eglGetError(), "Could not get EGL context");
        }
    }

    protected void createSurface() {
        this.nativeWindow = this.platformGetNativeWindow();
        if (this.nativeWindow != 0L) {
            this.eglSurface = this.egl._eglCreateWindowSurface(this.eglDisplay, this.eglConfigs[0], this.nativeWindow, null);
        } else {
            System.err.println("[AcceleratedScreen] Can't create surface when we have no native Window");
        }
    }

    public void enableRendering(boolean flag) {
        if (flag) {
            this.egl.eglMakeCurrent(this.eglDisplay, this.eglSurface, this.eglSurface, this.eglContext);
        } else {
            this.egl.eglMakeCurrent(this.eglDisplay, 0L, 0L, this.eglContext);
        }
    }

    boolean initPlatformLibraries() throws UnsatisfiedLinkError {
        if (!initialized) {
            glesLibraryHandle = ls.dlopen("libGLESv2.so", 257);
            if (glesLibraryHandle == 0L) {
                throw new UnsatisfiedLinkError("Error loading libGLESv2.so");
            }
            eglLibraryHandle = ls.dlopen("libEGL.so", 257);
            if (eglLibraryHandle == 0L) {
                throw new UnsatisfiedLinkError("Error loading libEGL.so");
            }
            initialized = true;
        }
        return true;
    }

    public long getGLHandle() {
        return glesLibraryHandle;
    }

    protected long getEGLHandle() {
        return eglLibraryHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean swapBuffers() {
        boolean result = false;
        Object object = NativeScreen.framebufferSwapLock;
        synchronized (object) {
            result = this.egl.eglSwapBuffers(this.eglDisplay, this.eglSurface);
            if (!result) {
                System.err.println("[WARNING] this shouldn't happen. swapBuffers failed with eglSurface " + this.eglSurface + ", recreate surface and try again.");
                this.createSurface();
                result = this.egl.eglSwapBuffers(this.eglDisplay, this.eglSurface);
            }
        }
        return result;
    }

    static {
        initialized = false;
        ls = LinuxSystem.getLinuxSystem();
    }
}

