/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Robot;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.monocle.InputDevice;
import com.sun.glass.ui.monocle.KeyInput;
import com.sun.glass.ui.monocle.MonocleApplication$$Lambda$1;
import com.sun.glass.ui.monocle.MonocleApplication$$Lambda$2;
import com.sun.glass.ui.monocle.MonocleApplication$$Lambda$3;
import com.sun.glass.ui.monocle.MonocleCursor;
import com.sun.glass.ui.monocle.MonoclePixels;
import com.sun.glass.ui.monocle.MonocleRobot;
import com.sun.glass.ui.monocle.MonocleTimer;
import com.sun.glass.ui.monocle.MonocleView;
import com.sun.glass.ui.monocle.MonocleWindow;
import com.sun.glass.ui.monocle.MouseInput;
import com.sun.glass.ui.monocle.MouseState;
import com.sun.glass.ui.monocle.NativeCursor;
import com.sun.glass.ui.monocle.NativePlatform;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.NativeScreen;
import com.sun.glass.ui.monocle.RunnableProcessor;
import java.io.File;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javafx.collections.SetChangeListener;

public final class MonocleApplication
extends Application {
    private final NativePlatform platform = NativePlatformFactory.getNativePlatform();
    private final RunnableProcessor runnableProcessor = this.platform.getRunnableProcessor();
    private static final int DEVICE_TOUCH = 0;
    private static final int DEVICE_MULTITOUCH = 1;
    private static final int DEVICE_POINTER = 2;
    private static final int DEVICE_5WAY = 3;
    private static final int DEVICE_PC_KEYBOARD = 4;
    private static final int DEVICE_MAX = 4;
    private int[] deviceFlags = new int[5];
    private Thread shutdownHookThread;
    private Runnable renderEndNotifier = MonocleApplication$$Lambda$1.lambdaFactory$(this);

    MonocleApplication() {
        for (InputDevice device : this.platform.getInputDeviceRegistry().getInputDevices()) {
            this.updateDeviceFlags(device, true);
        }
        this.platform.getInputDeviceRegistry().getInputDevices().addListener(MonocleApplication$$Lambda$2.lambdaFactory$(this));
    }

    private void updateDeviceFlags(InputDevice device, boolean added) {
        int modifier;
        int n = modifier = added ? 1 : -1;
        if (device.isTouch()) {
            this.deviceFlags[0] = this.deviceFlags[0] + modifier;
        }
        if (device.isMultiTouch()) {
            this.deviceFlags[1] = this.deviceFlags[1] + modifier;
        }
        if (device.isRelative()) {
            this.deviceFlags[2] = this.deviceFlags[2] + modifier;
            if (this.deviceFlags[2] >= 1 && added) {
                this.staticCursor_setVisible(true);
            } else if (this.deviceFlags[2] < 1 && !added) {
                this.staticCursor_setVisible(false);
            }
        }
        if (device.isFullKeyboard()) {
            this.deviceFlags[4] = this.deviceFlags[4] + modifier;
        }
        if (device.is5Way()) {
            this.deviceFlags[3] = this.deviceFlags[3] + modifier;
        }
    }

    @Override
    protected void runLoop(Runnable launchable) {
        this.runnableProcessor.invokeLater(launchable);
        long stackSize = (Long)AccessController.doPrivileged(MonocleApplication$$Lambda$3.lambdaFactory$());
        Thread t = new Thread(new ThreadGroup("Event"), this.runnableProcessor, "Event Thread", stackSize);
        MonocleApplication.setEventThread(t);
        t.start();
        this.shutdownHookThread = new Thread("Monocle shutdown hook"){

            @Override
            public void run() {
                MonocleApplication.this.platform.shutdown();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
    }

    @Override
    protected void _invokeAndWait(Runnable runnable) {
        this.runnableProcessor.invokeAndWait(runnable);
    }

    @Override
    protected void _invokeLater(Runnable runnable) {
        this.runnableProcessor.invokeLater(runnable);
    }

    @Override
    protected Object _enterNestedEventLoop() {
        return this.runnableProcessor.enterNestedEventLoop();
    }

    @Override
    protected void _leaveNestedEventLoop(Object retValue) {
        this.runnableProcessor.leaveNestedEventLoop(retValue);
    }

    @Override
    public Window createWindow(Window owner, Screen screen, int styleMask) {
        return new MonocleWindow(owner, screen, styleMask);
    }

    @Override
    public Window createWindow(long parent) {
        return new MonocleWindow(parent);
    }

    @Override
    public View createView() {
        NativeScreen ns = this.platform.getScreen();
        return new MonocleView(ns.getScale());
    }

    @Override
    public Cursor createCursor(int type) {
        return new MonocleCursor(type);
    }

    @Override
    public Cursor createCursor(int x, int y, Pixels pixels) {
        return new MonocleCursor(x, y, pixels);
    }

    @Override
    protected void staticCursor_setVisible(boolean visible) {
        NativeCursor cursor = NativePlatformFactory.getNativePlatform().getCursor();
        cursor.setVisibility(this.deviceFlags[2] >= 1 ? visible : false);
    }

    @Override
    protected Size staticCursor_getBestSize(int width, int height) {
        NativeCursor cursor = NativePlatformFactory.getNativePlatform().getCursor();
        return cursor.getBestSize();
    }

    @Override
    public Pixels createPixels(int width, int height, ByteBuffer data) {
        return new MonoclePixels(width, height, data);
    }

    @Override
    public Pixels createPixels(int width, int height, IntBuffer data) {
        return new MonoclePixels(width, height, data);
    }

    @Override
    public Pixels createPixels(int width, int height, IntBuffer data, float scale) {
        return new MonoclePixels(width, height, data, scale);
    }

    @Override
    protected int staticPixels_getNativeFormat() {
        return this.platform.getScreen().getNativeFormat();
    }

    @Override
    public Robot createRobot() {
        return new MonocleRobot();
    }

    @Override
    protected double staticScreen_getVideoRefreshPeriod() {
        return 0.0;
    }

    @Override
    protected Screen[] staticScreen_getScreens() {
        Screen screen = null;
        try {
            NativeScreen ns = this.platform.getScreen();
            Constructor c = AccessController.doPrivileged(new PrivilegedAction<Constructor>(){

                @Override
                public Constructor run() {
                    try {
                        Constructor c = Screen.class.getDeclaredConstructor(Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE);
                        c.setAccessible(true);
                        return c;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            });
            if (c != null) {
                screen = (Screen)c.newInstance(1L, ns.getDepth(), 0, 0, (int)((float)ns.getWidth() * ns.getScale()), (int)((float)ns.getHeight() * ns.getScale()), 0, 0, ns.getWidth(), ns.getHeight(), ns.getDPI(), ns.getDPI(), Float.valueOf(ns.getScale()), Float.valueOf(ns.getScale()));
                MouseState mouseState = new MouseState();
                mouseState.setX(ns.getWidth() / 2);
                mouseState.setY(ns.getHeight() / 2);
                MouseInput.getInstance().setState(mouseState, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
        }
        return new Screen[]{screen};
    }

    @Override
    public Timer createTimer(Runnable runnable) {
        return new MonocleTimer(runnable);
    }

    @Override
    protected int staticTimer_getMinPeriod() {
        return MonocleTimer.getMinPeriod_impl();
    }

    @Override
    protected int staticTimer_getMaxPeriod() {
        return MonocleTimer.getMaxPeriod_impl();
    }

    @Override
    public boolean hasWindowManager() {
        return false;
    }

    @Override
    protected CommonDialogs.FileChooserResult staticCommonDialogs_showFileChooser(Window owner, String folder, String filename, String title, int type, boolean multipleMode, CommonDialogs.ExtensionFilter[] extensionFilters, int defaultFilterIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected File staticCommonDialogs_showFolderChooser(Window owner, String folder, String title) {
        Thread.dumpStack();
        throw new UnsupportedOperationException();
    }

    @Override
    protected long staticView_getMultiClickTime() {
        return MonocleView._getMultiClickTime();
    }

    @Override
    protected int staticView_getMultiClickMaxX() {
        return MonocleView._getMultiClickMaxX();
    }

    @Override
    protected int staticView_getMultiClickMaxY() {
        return MonocleView._getMultiClickMaxY();
    }

    @Override
    protected boolean _supportsTransparentWindows() {
        return true;
    }

    @Override
    protected boolean _supportsUnifiedWindows() {
        return false;
    }

    @Override
    public boolean hasTwoLevelFocus() {
        return this.deviceFlags[4] == 0 && this.deviceFlags[3] > 0;
    }

    @Override
    public boolean hasVirtualKeyboard() {
        return this.deviceFlags[4] == 0 && this.deviceFlags[0] > 0;
    }

    @Override
    public boolean hasTouch() {
        return this.deviceFlags[0] > 0;
    }

    @Override
    public boolean hasMultiTouch() {
        return this.deviceFlags[1] > 0;
    }

    @Override
    public boolean hasPointer() {
        return this.deviceFlags[2] > 0;
    }

    @Override
    public void notifyRenderingFinished() {
        MonocleApplication.invokeLater(this.renderEndNotifier);
    }

    @Override
    protected void finishTerminating() {
        Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
        MonocleApplication.setEventThread(null);
        this.platform.shutdown();
        super.finishTerminating();
    }

    void enterDnDEventLoop() {
        this._enterNestedEventLoop();
    }

    void leaveDndEventLoop() {
        this._leaveNestedEventLoop(null);
    }

    @Override
    protected int _getKeyCodeForChar(char c) {
        return KeyInput.getInstance().getKeyCodeForChar(c);
    }

    private static /* synthetic */ Long lambda$runLoop$108() {
        return Long.getLong("monocle.stackSize", 0L);
    }

    private /* synthetic */ void lambda$new$107(SetChangeListener.Change change) {
        if (change.wasAdded()) {
            InputDevice device = (InputDevice)change.getElementAdded();
            this.updateDeviceFlags(device, true);
        } else if (change.wasRemoved()) {
            InputDevice device = (InputDevice)change.getElementRemoved();
            this.updateDeviceFlags(device, false);
        }
    }

    private /* synthetic */ void lambda$new$106() {
        this.platform.getScreen().swapBuffers();
    }

    static /* synthetic */ void access$lambda$0(MonocleApplication monocleApplication) {
        monocleApplication.lambda$new$106();
    }

    static /* synthetic */ void access$lambda$1(MonocleApplication monocleApplication, SetChangeListener.Change change) {
        monocleApplication.lambda$new$107(change);
    }

    static /* synthetic */ Long access$lambda$2() {
        return MonocleApplication.lambda$runLoop$108();
    }
}

