/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.CascadingStyle;
import com.sun.javafx.css.Declaration;
import com.sun.javafx.css.Match;
import com.sun.javafx.css.Rule;
import com.sun.javafx.css.Selector;
import com.sun.javafx.css.Style;
import com.sun.javafx.css.StyleMap$$Lambda$1;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class StyleMap {
    public static final StyleMap EMPTY_MAP = new StyleMap(-1, Collections.emptyList());
    private static final Comparator<CascadingStyle> cascadingStyleComparator = StyleMap$$Lambda$1.lambdaFactory$();
    private final int id;
    private List<Selector> selectors;
    private Map<String, List<CascadingStyle>> cascadingStyles;

    StyleMap(int id, List<Selector> selectors) {
        this.id = id;
        this.selectors = selectors;
    }

    public int getId() {
        return this.id;
    }

    public boolean isEmpty() {
        if (this.selectors != null) {
            return this.selectors.isEmpty();
        }
        if (this.cascadingStyles != null) {
            return this.cascadingStyles.isEmpty();
        }
        return true;
    }

    public Map<String, List<CascadingStyle>> getCascadingStyles() {
        if (this.cascadingStyles == null) {
            if (this.selectors == null || this.selectors.isEmpty()) {
                this.cascadingStyles = Collections.emptyMap();
                return this.cascadingStyles;
            }
            ArrayList<CascadingStyle> cascadingStyleList = new ArrayList<CascadingStyle>();
            int ordinal = 0;
            int iMax = this.selectors.size();
            for (int i = 0; i < iMax; ++i) {
                Selector selector = this.selectors.get(i);
                Match match = selector.createMatch();
                Rule rule = selector.getRule();
                int dmax = rule.getDeclarations().size();
                for (int d = 0; d < dmax; ++d) {
                    Declaration decl = (Declaration)rule.getDeclarations().get(d);
                    CascadingStyle s = new CascadingStyle(new Style(match.selector, decl), match.pseudoClasses, match.specificity, ordinal++);
                    cascadingStyleList.add(s);
                }
            }
            if (cascadingStyleList.isEmpty()) {
                this.cascadingStyles = Collections.emptyMap();
                return this.cascadingStyles;
            }
            Collections.sort(cascadingStyleList, cascadingStyleComparator);
            int nCascadingStyles = cascadingStyleList.size();
            this.cascadingStyles = new HashMap<String, List<CascadingStyle>>(nCascadingStyles);
            CascadingStyle cascadingStyle = (CascadingStyle)cascadingStyleList.get(0);
            String property = cascadingStyle.getProperty();
            int fromIndex = 0;
            while (fromIndex < nCascadingStyles) {
                List<CascadingStyle> value = this.cascadingStyles.get(property);
                if (value == null) {
                    int toIndex = fromIndex;
                    String currentProperty = property;
                    while (++toIndex < nCascadingStyles && (property = (cascadingStyle = (CascadingStyle)cascadingStyleList.get(toIndex)).getProperty()).equals(currentProperty)) {
                    }
                    this.cascadingStyles.put(currentProperty, cascadingStyleList.subList(fromIndex, toIndex));
                    fromIndex = toIndex;
                    continue;
                }
                assert (false);
            }
            this.selectors.clear();
            this.selectors = null;
        }
        return this.cascadingStyles;
    }

    private static /* synthetic */ int lambda$static$24(CascadingStyle o1, CascadingStyle o2) {
        String otherProperty;
        String thisProperty = o1.getProperty();
        int c = thisProperty.compareTo(otherProperty = o2.getProperty());
        if (c != 0) {
            return c;
        }
        return o1.compareTo(o2);
    }

    static /* synthetic */ int access$lambda$0(CascadingStyle cascadingStyle, CascadingStyle cascadingStyle2) {
        return StyleMap.lambda$static$24(cascadingStyle, cascadingStyle2);
    }
}

