/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.behavior.OrientedKeyBinding;
import com.sun.javafx.scene.control.behavior.ScrollBarBehavior$$Lambda$1;
import com.sun.javafx.scene.control.behavior.ScrollBarBehavior$$Lambda$2;
import com.sun.javafx.scene.control.behavior.ScrollBarBehavior$$Lambda$3;
import com.sun.javafx.util.Utils;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Duration;

public class ScrollBarBehavior
extends BehaviorBase<ScrollBar> {
    protected static final List<KeyBinding> SCROLL_BAR_BINDINGS = new ArrayList<KeyBinding>();
    Timeline timeline;

    public ScrollBarBehavior(ScrollBar scrollBar) {
        super(scrollBar, SCROLL_BAR_BINDINGS);
    }

    void home() {
        ((ScrollBar)this.getControl()).setValue(((ScrollBar)this.getControl()).getMin());
    }

    void decrementValue() {
        ((ScrollBar)this.getControl()).adjustValue(0.0);
    }

    void end() {
        ((ScrollBar)this.getControl()).setValue(((ScrollBar)this.getControl()).getMax());
    }

    void incrementValue() {
        ((ScrollBar)this.getControl()).adjustValue(1.0);
    }

    @Override
    protected String matchActionForEvent(KeyEvent e) {
        String action = super.matchActionForEvent(e);
        if (action != null) {
            if (e.getCode() == KeyCode.LEFT || e.getCode() == KeyCode.KP_LEFT) {
                if (((ScrollBar)this.getControl()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
                    action = ((ScrollBar)this.getControl()).getOrientation() == Orientation.HORIZONTAL ? "IncrementValue" : "DecrementValue";
                }
            } else if ((e.getCode() == KeyCode.RIGHT || e.getCode() == KeyCode.KP_RIGHT) && ((ScrollBar)this.getControl()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
                action = ((ScrollBar)this.getControl()).getOrientation() == Orientation.HORIZONTAL ? "DecrementValue" : "IncrementValue";
            }
        }
        return action;
    }

    @Override
    protected void callAction(String name) {
        if ("Home".equals(name)) {
            this.home();
        } else if ("End".equals(name)) {
            this.end();
        } else if ("IncrementValue".equals(name)) {
            this.incrementValue();
        } else if ("DecrementValue".equals(name)) {
            this.decrementValue();
        } else {
            super.callAction(name);
        }
        super.callAction(name);
    }

    public void trackPress(double position) {
        double pos;
        if (this.timeline != null) {
            return;
        }
        ScrollBar bar = (ScrollBar)this.getControl();
        if (!bar.isFocused() && bar.isFocusTraversable()) {
            bar.requestFocus();
        }
        boolean incrementing = (pos = position) > (bar.getValue() - bar.getMin()) / (bar.getMax() - bar.getMin());
        this.timeline = new Timeline();
        this.timeline.setCycleCount(-1);
        EventHandler step = ScrollBarBehavior$$Lambda$1.lambdaFactory$(this, pos, bar, incrementing);
        KeyFrame kf = new KeyFrame(Duration.millis(200.0), step, new KeyValue[0]);
        this.timeline.getKeyFrames().add(kf);
        this.timeline.play();
        step.handle(null);
    }

    public void trackRelease() {
        this.stopTimeline();
    }

    public void decButtonPressed() {
        ScrollBar bar = (ScrollBar)this.getControl();
        if (!bar.isFocused() && bar.isFocusTraversable()) {
            bar.requestFocus();
        }
        this.stopTimeline();
        this.timeline = new Timeline();
        this.timeline.setCycleCount(-1);
        EventHandler dec = ScrollBarBehavior$$Lambda$2.lambdaFactory$(this, bar);
        KeyFrame kf = new KeyFrame(Duration.millis(200.0), dec, new KeyValue[0]);
        this.timeline.getKeyFrames().add(kf);
        this.timeline.play();
        dec.handle(null);
    }

    public void decButtonReleased() {
        this.stopTimeline();
    }

    public void incButtonPressed() {
        ScrollBar bar = (ScrollBar)this.getControl();
        if (!bar.isFocused() && bar.isFocusTraversable()) {
            bar.requestFocus();
        }
        this.stopTimeline();
        this.timeline = new Timeline();
        this.timeline.setCycleCount(-1);
        EventHandler inc = ScrollBarBehavior$$Lambda$3.lambdaFactory$(this, bar);
        KeyFrame kf = new KeyFrame(Duration.millis(200.0), inc, new KeyValue[0]);
        this.timeline.getKeyFrames().add(kf);
        this.timeline.play();
        inc.handle(null);
    }

    public void incButtonReleased() {
        this.stopTimeline();
    }

    public void thumbDragged(double position) {
        double newValue;
        ScrollBar scrollbar = (ScrollBar)this.getControl();
        this.stopTimeline();
        if (!scrollbar.isFocused() && scrollbar.isFocusTraversable()) {
            scrollbar.requestFocus();
        }
        if (!Double.isNaN(newValue = position * (scrollbar.getMax() - scrollbar.getMin()) + scrollbar.getMin())) {
            scrollbar.setValue(Utils.clamp(scrollbar.getMin(), newValue, scrollbar.getMax()));
        }
    }

    private void stopTimeline() {
        if (this.timeline != null) {
            this.timeline.stop();
            this.timeline = null;
        }
    }

    private /* synthetic */ void lambda$incButtonPressed$208(ScrollBar bar, ActionEvent event) {
        if (bar.getValue() < bar.getMax()) {
            bar.increment();
        } else {
            this.stopTimeline();
        }
    }

    private /* synthetic */ void lambda$decButtonPressed$207(ScrollBar bar, ActionEvent event) {
        if (bar.getValue() > bar.getMin()) {
            bar.decrement();
        } else {
            this.stopTimeline();
        }
    }

    private /* synthetic */ void lambda$trackPress$206(double pos, ScrollBar bar, boolean incrementing, ActionEvent event) {
        boolean i;
        boolean bl = i = pos > (bar.getValue() - bar.getMin()) / (bar.getMax() - bar.getMin());
        if (incrementing == i) {
            bar.adjustValue(pos);
        } else {
            this.stopTimeline();
        }
    }

    static {
        SCROLL_BAR_BINDINGS.add(new KeyBinding(KeyCode.F4, "TraverseDebug").alt().ctrl().shift());
        SCROLL_BAR_BINDINGS.add(new ScrollBarKeyBinding(KeyCode.LEFT, "DecrementValue"));
        SCROLL_BAR_BINDINGS.add(new ScrollBarKeyBinding(KeyCode.KP_LEFT, "DecrementValue"));
        SCROLL_BAR_BINDINGS.add(new ScrollBarKeyBinding(KeyCode.UP, "DecrementValue").vertical());
        SCROLL_BAR_BINDINGS.add(new ScrollBarKeyBinding(KeyCode.KP_UP, "DecrementValue").vertical());
        SCROLL_BAR_BINDINGS.add(new ScrollBarKeyBinding(KeyCode.RIGHT, "IncrementValue"));
        SCROLL_BAR_BINDINGS.add(new ScrollBarKeyBinding(KeyCode.KP_RIGHT, "IncrementValue"));
        SCROLL_BAR_BINDINGS.add(new ScrollBarKeyBinding(KeyCode.DOWN, "IncrementValue").vertical());
        SCROLL_BAR_BINDINGS.add(new ScrollBarKeyBinding(KeyCode.KP_DOWN, "IncrementValue").vertical());
        SCROLL_BAR_BINDINGS.add(new KeyBinding(KeyCode.HOME, KeyEvent.KEY_RELEASED, "Home"));
        SCROLL_BAR_BINDINGS.add(new KeyBinding(KeyCode.END, KeyEvent.KEY_RELEASED, "End"));
    }

    static /* synthetic */ void access$lambda$0(ScrollBarBehavior scrollBarBehavior, double d, ScrollBar scrollBar, boolean bl, ActionEvent actionEvent) {
        scrollBarBehavior.lambda$trackPress$206(d, scrollBar, bl, actionEvent);
    }

    static /* synthetic */ void access$lambda$1(ScrollBarBehavior scrollBarBehavior, ScrollBar scrollBar, ActionEvent actionEvent) {
        scrollBarBehavior.lambda$decButtonPressed$207(scrollBar, actionEvent);
    }

    static /* synthetic */ void access$lambda$2(ScrollBarBehavior scrollBarBehavior, ScrollBar scrollBar, ActionEvent actionEvent) {
        scrollBarBehavior.lambda$incButtonPressed$208(scrollBar, actionEvent);
    }

    public static class ScrollBarKeyBinding
    extends OrientedKeyBinding {
        public ScrollBarKeyBinding(KeyCode code, String action) {
            super(code, action);
        }

        public ScrollBarKeyBinding(KeyCode code, EventType<KeyEvent> type, String action) {
            super(code, type, action);
        }

        @Override
        public boolean getVertical(Control control) {
            return ((ScrollBar)control).getOrientation() == Orientation.VERTICAL;
        }
    }
}

