/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.behavior.TreeCellBehavior;
import com.sun.javafx.scene.control.behavior.TreeViewBehavior$$Lambda$1;
import com.sun.javafx.scene.control.behavior.TreeViewBehavior$$Lambda$2;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.geometry.NodeOrientation;
import javafx.scene.control.FocusModel;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;

public class TreeViewBehavior<T>
extends BehaviorBase<TreeView<T>> {
    protected static final List<KeyBinding> TREE_VIEW_BINDINGS = new ArrayList<KeyBinding>();
    private boolean isShiftDown = false;
    private boolean isShortcutDown = false;
    private Callback<Boolean, Integer> onScrollPageUp;
    private Callback<Boolean, Integer> onScrollPageDown;
    private Runnable onSelectPreviousRow;
    private Runnable onSelectNextRow;
    private Runnable onMoveToFirstCell;
    private Runnable onMoveToLastCell;
    private Runnable onFocusPreviousRow;
    private Runnable onFocusNextRow;
    private boolean selectionChanging = false;
    private final ListChangeListener<Integer> selectedIndicesListener = TreeViewBehavior$$Lambda$1.lambdaFactory$(this);
    private final ChangeListener<MultipleSelectionModel<TreeItem<T>>> selectionModelListener = new ChangeListener<MultipleSelectionModel<TreeItem<T>>>(){

        @Override
        public void changed(ObservableValue<? extends MultipleSelectionModel<TreeItem<T>>> observable, MultipleSelectionModel<TreeItem<T>> oldValue, MultipleSelectionModel<TreeItem<T>> newValue) {
            if (oldValue != null) {
                oldValue.getSelectedIndices().removeListener(TreeViewBehavior.this.weakSelectedIndicesListener);
            }
            if (newValue != null) {
                newValue.getSelectedIndices().addListener(TreeViewBehavior.this.weakSelectedIndicesListener);
            }
        }
    };
    private final WeakListChangeListener<Integer> weakSelectedIndicesListener = new WeakListChangeListener<Integer>(this.selectedIndicesListener);
    private final WeakChangeListener<MultipleSelectionModel<TreeItem<T>>> weakSelectionModelListener = new WeakChangeListener<MultipleSelectionModel<TreeItem<MultipleSelectionModel<TreeItem<T>>>>>(this.selectionModelListener);

    @Override
    protected String matchActionForEvent(KeyEvent e) {
        String action = super.matchActionForEvent(e);
        if (((TreeView)this.getControl()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
            if ("CollapseRow".equals(action) && (e.getCode() == KeyCode.LEFT || e.getCode() == KeyCode.KP_LEFT)) {
                action = "ExpandRow";
            } else if ("ExpandRow".equals(action) && (e.getCode() == KeyCode.RIGHT || e.getCode() == KeyCode.KP_RIGHT)) {
                action = "CollapseRow";
            }
        }
        return action;
    }

    @Override
    protected void callAction(String name) {
        if ("SelectPreviousRow".equals(name)) {
            this.selectPreviousRow();
        } else if ("SelectNextRow".equals(name)) {
            this.selectNextRow();
        } else if ("SelectFirstRow".equals(name)) {
            this.selectFirstRow();
        } else if ("SelectLastRow".equals(name)) {
            this.selectLastRow();
        } else if ("SelectAllPageUp".equals(name)) {
            this.selectAllPageUp();
        } else if ("SelectAllPageDown".equals(name)) {
            this.selectAllPageDown();
        } else if ("SelectAllToFirstRow".equals(name)) {
            this.selectAllToFirstRow();
        } else if ("SelectAllToLastRow".equals(name)) {
            this.selectAllToLastRow();
        } else if ("AlsoSelectNextRow".equals(name)) {
            this.alsoSelectNextRow();
        } else if ("AlsoSelectPreviousRow".equals(name)) {
            this.alsoSelectPreviousRow();
        } else if ("ClearSelection".equals(name)) {
            this.clearSelection();
        } else if ("SelectAll".equals(name)) {
            this.selectAll();
        } else if ("ScrollUp".equals(name)) {
            this.scrollUp();
        } else if ("ScrollDown".equals(name)) {
            this.scrollDown();
        } else if ("ExpandRow".equals(name)) {
            this.expandRow();
        } else if ("CollapseRow".equals(name)) {
            this.collapseRow();
        } else if ("ExpandAll".equals(name)) {
            this.expandAll();
        } else if ("Edit".equals(name)) {
            this.edit();
        } else if ("CancelEdit".equals(name)) {
            this.cancelEdit();
        } else if ("FocusFirstRow".equals(name)) {
            this.focusFirstRow();
        } else if ("FocusLastRow".equals(name)) {
            this.focusLastRow();
        } else if ("toggleFocusOwnerSelection".equals(name)) {
            this.toggleFocusOwnerSelection();
        } else if ("SelectAllToFocus".equals(name)) {
            this.selectAllToFocus(false);
        } else if ("SelectAllToFocusAndSetAnchor".equals(name)) {
            this.selectAllToFocus(true);
        } else if ("FocusPageUp".equals(name)) {
            this.focusPageUp();
        } else if ("FocusPageDown".equals(name)) {
            this.focusPageDown();
        } else if ("FocusPreviousRow".equals(name)) {
            this.focusPreviousRow();
        } else if ("FocusNextRow".equals(name)) {
            this.focusNextRow();
        } else if ("DiscontinuousSelectNextRow".equals(name)) {
            this.discontinuousSelectNextRow();
        } else if ("DiscontinuousSelectPreviousRow".equals(name)) {
            this.discontinuousSelectPreviousRow();
        } else if ("DiscontinuousSelectPageUp".equals(name)) {
            this.discontinuousSelectPageUp();
        } else if ("DiscontinuousSelectPageDown".equals(name)) {
            this.discontinuousSelectPageDown();
        } else if ("DiscontinuousSelectAllToLastRow".equals(name)) {
            this.discontinuousSelectAllToLastRow();
        } else if ("DiscontinuousSelectAllToFirstRow".equals(name)) {
            this.discontinuousSelectAllToFirstRow();
        } else {
            super.callAction(name);
        }
    }

    @Override
    protected void callActionForEvent(KeyEvent e) {
        this.isShiftDown = e.getEventType() == KeyEvent.KEY_PRESSED && e.isShiftDown();
        this.isShortcutDown = e.getEventType() == KeyEvent.KEY_PRESSED && e.isShortcutDown();
        super.callActionForEvent(e);
    }

    public void setOnScrollPageUp(Callback<Boolean, Integer> c) {
        this.onScrollPageUp = c;
    }

    public void setOnScrollPageDown(Callback<Boolean, Integer> c) {
        this.onScrollPageDown = c;
    }

    public void setOnSelectPreviousRow(Runnable r) {
        this.onSelectPreviousRow = r;
    }

    public void setOnSelectNextRow(Runnable r) {
        this.onSelectNextRow = r;
    }

    public void setOnMoveToFirstCell(Runnable r) {
        this.onMoveToFirstCell = r;
    }

    public void setOnMoveToLastCell(Runnable r) {
        this.onMoveToLastCell = r;
    }

    public void setOnFocusPreviousRow(Runnable r) {
        this.onFocusPreviousRow = r;
    }

    public void setOnFocusNextRow(Runnable r) {
        this.onFocusNextRow = r;
    }

    public TreeViewBehavior(TreeView<T> control) {
        super(control, TREE_VIEW_BINDINGS);
        ((TreeView)this.getControl()).selectionModelProperty().addListener(this.weakSelectionModelListener);
        if (control.getSelectionModel() != null) {
            control.getSelectionModel().getSelectedIndices().addListener(this.weakSelectedIndicesListener);
        }
    }

    @Override
    public void dispose() {
        TreeCellBehavior.removeAnchor(this.getControl());
        super.dispose();
    }

    private void setAnchor(int anchor) {
        TreeCellBehavior.setAnchor(this.getControl(), anchor < 0 ? null : Integer.valueOf(anchor), false);
    }

    private int getAnchor() {
        return TreeCellBehavior.getAnchor(this.getControl(), ((TreeView)this.getControl()).getFocusModel().getFocusedIndex());
    }

    private boolean hasAnchor() {
        return TreeCellBehavior.hasNonDefaultAnchor(this.getControl());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        if (!e.isShiftDown()) {
            int index = ((TreeView)this.getControl()).getSelectionModel().getSelectedIndex();
            this.setAnchor(index);
        }
        if (!((TreeView)this.getControl()).isFocused() && ((TreeView)this.getControl()).isFocusTraversable()) {
            ((TreeView)this.getControl()).requestFocus();
        }
    }

    private void clearSelection() {
        ((TreeView)this.getControl()).getSelectionModel().clearSelection();
    }

    private void scrollUp() {
        int newSelectedIndex = -1;
        if (this.onScrollPageUp != null) {
            newSelectedIndex = this.onScrollPageUp.call(false);
        }
        if (newSelectedIndex == -1) {
            return;
        }
        MultipleSelectionModel sm = ((TreeView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        sm.clearAndSelect(newSelectedIndex);
    }

    private void scrollDown() {
        int newSelectedIndex = -1;
        if (this.onScrollPageDown != null) {
            newSelectedIndex = this.onScrollPageDown.call(false);
        }
        if (newSelectedIndex == -1) {
            return;
        }
        MultipleSelectionModel sm = ((TreeView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        sm.clearAndSelect(newSelectedIndex);
    }

    private void focusFirstRow() {
        FocusModel fm = ((TreeView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        fm.focus(0);
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    private void focusLastRow() {
        FocusModel fm = ((TreeView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        fm.focus(((TreeView)this.getControl()).getExpandedItemCount() - 1);
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    private void focusPreviousRow() {
        FocusModel fm = ((TreeView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        MultipleSelectionModel sm = ((TreeView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        fm.focusPrevious();
        if (!this.isShortcutDown || this.getAnchor() == -1) {
            this.setAnchor(fm.getFocusedIndex());
        }
        if (this.onFocusPreviousRow != null) {
            this.onFocusPreviousRow.run();
        }
    }

    private void focusNextRow() {
        FocusModel fm = ((TreeView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        MultipleSelectionModel sm = ((TreeView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        fm.focusNext();
        if (!this.isShortcutDown || this.getAnchor() == -1) {
            this.setAnchor(fm.getFocusedIndex());
        }
        if (this.onFocusNextRow != null) {
            this.onFocusNextRow.run();
        }
    }

    private void focusPageUp() {
        int newFocusIndex = this.onScrollPageUp.call(true);
        FocusModel fm = ((TreeView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        fm.focus(newFocusIndex);
    }

    private void focusPageDown() {
        int newFocusIndex = this.onScrollPageDown.call(true);
        FocusModel fm = ((TreeView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        fm.focus(newFocusIndex);
    }

    private void alsoSelectPreviousRow() {
        FocusModel fm = ((TreeView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        MultipleSelectionModel sm = ((TreeView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        if (this.isShiftDown && this.getAnchor() != -1) {
            int newRow = fm.getFocusedIndex() - 1;
            if (newRow < 0) {
                return;
            }
            int anchor = this.getAnchor();
            if (!this.hasAnchor()) {
                this.setAnchor(fm.getFocusedIndex());
            }
            if (sm.getSelectedIndices().size() > 1) {
                this.clearSelectionOutsideRange(anchor, newRow);
            }
            if (anchor > newRow) {
                sm.selectRange(anchor, newRow - 1);
            } else {
                sm.selectRange(anchor, newRow + 1);
            }
        } else {
            sm.selectPrevious();
        }
        this.onSelectPreviousRow.run();
    }

    private void alsoSelectNextRow() {
        FocusModel fm = ((TreeView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        MultipleSelectionModel sm = ((TreeView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        if (this.isShiftDown && this.getAnchor() != -1) {
            int newRow = fm.getFocusedIndex() + 1;
            int anchor = this.getAnchor();
            if (!this.hasAnchor()) {
                this.setAnchor(fm.getFocusedIndex());
            }
            if (sm.getSelectedIndices().size() > 1) {
                this.clearSelectionOutsideRange(anchor, newRow);
            }
            if (anchor > newRow) {
                sm.selectRange(anchor, newRow - 1);
            } else {
                sm.selectRange(anchor, newRow + 1);
            }
        } else {
            sm.selectNext();
        }
        this.onSelectNextRow.run();
    }

    private void clearSelectionOutsideRange(int start, int end) {
        MultipleSelectionModel sm = ((TreeView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        int min = Math.min(start, end);
        int max = Math.max(start, end);
        ArrayList<Integer> indices = new ArrayList<Integer>(sm.getSelectedIndices());
        this.selectionChanging = true;
        for (int i = 0; i < indices.size(); ++i) {
            int index = (Integer)indices.get(i);
            if (index >= min && index <= max) continue;
            sm.clearSelection(index);
        }
        this.selectionChanging = false;
    }

    private void selectPreviousRow() {
        FocusModel fm = ((TreeView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        int focusIndex = fm.getFocusedIndex();
        if (focusIndex <= 0) {
            return;
        }
        this.setAnchor(focusIndex - 1);
        ((TreeView)this.getControl()).getSelectionModel().clearAndSelect(focusIndex - 1);
        this.onSelectPreviousRow.run();
    }

    private void selectNextRow() {
        FocusModel fm = ((TreeView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        int focusIndex = fm.getFocusedIndex();
        if (focusIndex == ((TreeView)this.getControl()).getExpandedItemCount() - 1) {
            return;
        }
        this.setAnchor(focusIndex + 1);
        ((TreeView)this.getControl()).getSelectionModel().clearAndSelect(focusIndex + 1);
        this.onSelectNextRow.run();
    }

    private void selectFirstRow() {
        if (((TreeView)this.getControl()).getExpandedItemCount() > 0) {
            ((TreeView)this.getControl()).getSelectionModel().clearAndSelect(0);
            if (this.onMoveToFirstCell != null) {
                this.onMoveToFirstCell.run();
            }
        }
    }

    private void selectLastRow() {
        ((TreeView)this.getControl()).getSelectionModel().clearAndSelect(((TreeView)this.getControl()).getExpandedItemCount() - 1);
        this.onMoveToLastCell.run();
    }

    private void selectAllToFirstRow() {
        MultipleSelectionModel sm = ((TreeView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        FocusModel fm = ((TreeView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        int leadIndex = fm.getFocusedIndex();
        if (this.isShiftDown) {
            leadIndex = this.hasAnchor() ? this.getAnchor() : leadIndex;
        }
        sm.clearSelection();
        sm.selectRange(leadIndex, -1);
        fm.focus(0);
        if (this.isShiftDown) {
            this.setAnchor(leadIndex);
        }
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    private void selectAllToLastRow() {
        MultipleSelectionModel sm = ((TreeView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        FocusModel fm = ((TreeView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        int leadIndex = fm.getFocusedIndex();
        if (this.isShiftDown) {
            leadIndex = this.hasAnchor() ? this.getAnchor() : leadIndex;
        }
        sm.clearSelection();
        sm.selectRange(leadIndex, ((TreeView)this.getControl()).getExpandedItemCount());
        if (this.isShiftDown) {
            this.setAnchor(leadIndex);
        }
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    private void selectAll() {
        ((TreeView)this.getControl()).getSelectionModel().selectAll();
    }

    private void selectAllPageUp() {
        int leadSelectedIndex;
        FocusModel fm = ((TreeView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        int leadIndex = fm.getFocusedIndex();
        if (this.isShiftDown) {
            leadIndex = this.getAnchor() == -1 ? leadIndex : this.getAnchor();
            this.setAnchor(leadIndex);
        }
        int adjust = leadIndex < (leadSelectedIndex = this.onScrollPageUp.call(false).intValue()) ? 1 : -1;
        MultipleSelectionModel sm = ((TreeView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        this.selectionChanging = true;
        if (sm.getSelectionMode() == SelectionMode.SINGLE) {
            sm.select(leadSelectedIndex);
        } else {
            sm.clearSelection();
            sm.selectRange(leadIndex, leadSelectedIndex + adjust);
        }
        this.selectionChanging = false;
    }

    private void selectAllPageDown() {
        int leadSelectedIndex;
        FocusModel fm = ((TreeView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        int leadIndex = fm.getFocusedIndex();
        if (this.isShiftDown) {
            leadIndex = this.getAnchor() == -1 ? leadIndex : this.getAnchor();
            this.setAnchor(leadIndex);
        }
        int adjust = leadIndex < (leadSelectedIndex = this.onScrollPageDown.call(false).intValue()) ? 1 : -1;
        MultipleSelectionModel sm = ((TreeView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        this.selectionChanging = true;
        if (sm.getSelectionMode() == SelectionMode.SINGLE) {
            sm.select(leadSelectedIndex);
        } else {
            sm.clearSelection();
            sm.selectRange(leadIndex, leadSelectedIndex + adjust);
        }
        this.selectionChanging = false;
    }

    private void selectAllToFocus(boolean setAnchorToFocusIndex) {
        TreeView treeView = (TreeView)this.getControl();
        if (treeView.getEditingItem() != null) {
            return;
        }
        MultipleSelectionModel sm = treeView.getSelectionModel();
        if (sm == null) {
            return;
        }
        FocusModel fm = treeView.getFocusModel();
        if (fm == null) {
            return;
        }
        int focusIndex = fm.getFocusedIndex();
        int anchor = this.getAnchor();
        sm.clearSelection();
        int startPos = anchor;
        int endPos = anchor > focusIndex ? focusIndex - 1 : focusIndex + 1;
        sm.selectRange(startPos, endPos);
        this.setAnchor(setAnchorToFocusIndex ? focusIndex : anchor);
    }

    private void expandRow() {
        Callback getIndex = TreeViewBehavior$$Lambda$2.lambdaFactory$(this);
        TreeViewBehavior.expandRow(((TreeView)this.getControl()).getSelectionModel(), getIndex);
    }

    private void expandAll() {
        TreeViewBehavior.expandAll(((TreeView)this.getControl()).getRoot());
    }

    private void collapseRow() {
        TreeView control = (TreeView)this.getControl();
        TreeViewBehavior.collapseRow(control.getSelectionModel(), control.getRoot(), control.isShowRoot());
    }

    static <T> void expandRow(MultipleSelectionModel<TreeItem<T>> sm, Callback<TreeItem<T>, Integer> getIndex) {
        if (sm == null) {
            return;
        }
        TreeItem treeItem = (TreeItem)sm.getSelectedItem();
        if (treeItem == null || treeItem.isLeaf()) {
            return;
        }
        if (treeItem.isExpanded()) {
            ObservableList children = treeItem.getChildren();
            if (!children.isEmpty()) {
                sm.clearAndSelect(getIndex.call((TreeItem<T>)children.get(0)));
            }
        } else {
            treeItem.setExpanded(true);
        }
    }

    static <T> void expandAll(TreeItem<T> root) {
        if (root == null) {
            return;
        }
        root.setExpanded(true);
        TreeViewBehavior.expandChildren(root);
    }

    private static <T> void expandChildren(TreeItem<T> node) {
        if (node == null) {
            return;
        }
        ObservableList<TreeItem<T>> children = node.getChildren();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.size(); ++i) {
            TreeItem child = (TreeItem)children.get(i);
            if (child == null || child.isLeaf()) continue;
            child.setExpanded(true);
            TreeViewBehavior.expandChildren(child);
        }
    }

    static <T> void collapseRow(MultipleSelectionModel<TreeItem<T>> sm, TreeItem<T> root, boolean isShowRoot) {
        if (sm == null) {
            return;
        }
        TreeItem selectedItem = (TreeItem)sm.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        if (root == null) {
            return;
        }
        if (!isShowRoot && !selectedItem.isExpanded() && root.equals(selectedItem.getParent())) {
            return;
        }
        if (root.equals(selectedItem) && (!root.isExpanded() || root.getChildren().isEmpty())) {
            return;
        }
        if (selectedItem.isLeaf() || !selectedItem.isExpanded()) {
            sm.clearSelection();
            sm.select(selectedItem.getParent());
        } else {
            selectedItem.setExpanded(false);
        }
    }

    private void cancelEdit() {
        ((TreeView)this.getControl()).edit(null);
    }

    private void edit() {
        TreeItem treeItem = (TreeItem)((TreeView)this.getControl()).getSelectionModel().getSelectedItem();
        if (treeItem == null) {
            return;
        }
        ((TreeView)this.getControl()).edit(treeItem);
    }

    private void toggleFocusOwnerSelection() {
        MultipleSelectionModel sm = ((TreeView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        FocusModel fm = ((TreeView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        int focusedIndex = fm.getFocusedIndex();
        if (sm.isSelected(focusedIndex)) {
            sm.clearSelection(focusedIndex);
            fm.focus(focusedIndex);
        } else {
            sm.select(focusedIndex);
        }
        this.setAnchor(focusedIndex);
    }

    private void discontinuousSelectPreviousRow() {
        MultipleSelectionModel sm = ((TreeView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        if (sm.getSelectionMode() != SelectionMode.MULTIPLE) {
            this.selectPreviousRow();
            return;
        }
        FocusModel fm = ((TreeView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        int focusIndex = fm.getFocusedIndex();
        int newFocusIndex = focusIndex - 1;
        if (newFocusIndex < 0) {
            return;
        }
        int startIndex = focusIndex;
        if (this.isShiftDown) {
            startIndex = this.getAnchor() == -1 ? focusIndex : this.getAnchor();
        }
        sm.selectRange(newFocusIndex, startIndex + 1);
        fm.focus(newFocusIndex);
        if (this.onFocusPreviousRow != null) {
            this.onFocusPreviousRow.run();
        }
    }

    private void discontinuousSelectNextRow() {
        MultipleSelectionModel sm = ((TreeView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        if (sm.getSelectionMode() != SelectionMode.MULTIPLE) {
            this.selectNextRow();
            return;
        }
        FocusModel fm = ((TreeView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        int focusIndex = fm.getFocusedIndex();
        int newFocusIndex = focusIndex + 1;
        if (newFocusIndex >= ((TreeView)this.getControl()).getExpandedItemCount()) {
            return;
        }
        int startIndex = focusIndex;
        if (this.isShiftDown) {
            startIndex = this.getAnchor() == -1 ? focusIndex : this.getAnchor();
        }
        sm.selectRange(startIndex, newFocusIndex + 1);
        fm.focus(newFocusIndex);
        if (this.onFocusNextRow != null) {
            this.onFocusNextRow.run();
        }
    }

    private void discontinuousSelectPageUp() {
        MultipleSelectionModel sm = ((TreeView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        FocusModel fm = ((TreeView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        int anchor = this.getAnchor();
        int leadSelectedIndex = this.onScrollPageUp.call(false);
        sm.selectRange(anchor, leadSelectedIndex - 1);
    }

    private void discontinuousSelectPageDown() {
        MultipleSelectionModel sm = ((TreeView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        FocusModel fm = ((TreeView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        int anchor = this.getAnchor();
        int leadSelectedIndex = this.onScrollPageDown.call(false);
        sm.selectRange(anchor, leadSelectedIndex + 1);
    }

    private void discontinuousSelectAllToFirstRow() {
        MultipleSelectionModel sm = ((TreeView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        FocusModel fm = ((TreeView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        int index = fm.getFocusedIndex();
        sm.selectRange(0, index);
        fm.focus(0);
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    private void discontinuousSelectAllToLastRow() {
        MultipleSelectionModel sm = ((TreeView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        FocusModel fm = ((TreeView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        int index = fm.getFocusedIndex() + 1;
        sm.selectRange(index, ((TreeView)this.getControl()).getExpandedItemCount());
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    private /* synthetic */ Integer lambda$expandRow$267(TreeItem p) {
        return ((TreeView)this.getControl()).getRow(p);
    }

    private /* synthetic */ void lambda$new$266(ListChangeListener.Change c) {
        while (c.next()) {
            int addedSize;
            if (c.wasReplaced() && TreeCellBehavior.hasDefaultAnchor(this.getControl())) {
                TreeCellBehavior.removeAnchor(this.getControl());
            }
            int shift = c.wasPermutated() ? c.getTo() - c.getFrom() : 0;
            MultipleSelectionModel sm = ((TreeView)this.getControl()).getSelectionModel();
            if (!this.selectionChanging) {
                if (sm.isEmpty()) {
                    this.setAnchor(-1);
                } else if (this.hasAnchor() && !sm.isSelected(this.getAnchor() + shift)) {
                    this.setAnchor(-1);
                }
            }
            if ((addedSize = c.getAddedSize()) <= 0 || this.hasAnchor()) continue;
            List addedSubList = c.getAddedSubList();
            int index = (Integer)addedSubList.get(addedSize - 1);
            this.setAnchor(index);
        }
    }

    static {
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "SelectFirstRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "SelectLastRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "SelectAllToFirstRow").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "SelectAllToLastRow").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "SelectAllPageUp").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "SelectAllPageDown").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "SelectAllToFocus").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "SelectAllToFocusAndSetAnchor").shortcut().shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "FocusFirstRow").shortcut());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "FocusLastRow").shortcut());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "ScrollUp"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "ScrollDown"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "toggleFocusOwnerSelection"));
        if (PlatformUtil.isMac()) {
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "toggleFocusOwnerSelection").ctrl().shortcut());
        } else {
            TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "toggleFocusOwnerSelection").ctrl());
        }
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.A, "SelectAll").shortcut());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "FocusPageUp").shortcut());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "FocusPageDown").shortcut());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.UP, "FocusPreviousRow").shortcut());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "FocusNextRow").shortcut());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.UP, "DiscontinuousSelectPreviousRow").shortcut().shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "DiscontinuousSelectNextRow").shortcut().shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "DiscontinuousSelectPageUp").shortcut().shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "DiscontinuousSelectPageDown").shortcut().shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "DiscontinuousSelectAllToFirstRow").shortcut().shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "DiscontinuousSelectAllToLastRow").shortcut().shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.LEFT, "CollapseRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_LEFT, "CollapseRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, "ExpandRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_RIGHT, "ExpandRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.MULTIPLY, "ExpandAll"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.ADD, "ExpandRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SUBTRACT, "CollapseRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.UP, "SelectPreviousRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, "SelectPreviousRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "SelectNextRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, "SelectNextRow"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.UP, "AlsoSelectPreviousRow").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_UP, "AlsoSelectPreviousRow").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "AlsoSelectNextRow").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.KP_DOWN, "AlsoSelectNextRow").shift());
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.ENTER, "Edit"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.F2, "Edit"));
        TREE_VIEW_BINDINGS.add(new KeyBinding(KeyCode.ESCAPE, "CancelEdit"));
    }

    static /* synthetic */ void access$lambda$0(TreeViewBehavior treeViewBehavior, ListChangeListener.Change change) {
        treeViewBehavior.lambda$new$266(change);
    }

    static /* synthetic */ Integer access$lambda$1(TreeViewBehavior treeViewBehavior, TreeItem treeItem) {
        return treeViewBehavior.lambda$expandRow$267(treeItem);
    }
}

