/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.ComboBoxBaseBehavior;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.ComboBoxBaseSkin$$Lambda$1;
import com.sun.javafx.scene.control.skin.ComboBoxBaseSkin$$Lambda$2;
import com.sun.javafx.scene.control.skin.ComboBoxBaseSkin$$Lambda$3;
import com.sun.javafx.scene.control.skin.ComboBoxBaseSkin$$Lambda$4;
import com.sun.javafx.scene.control.skin.ComboBoxBaseSkin$$Lambda$5;
import com.sun.javafx.scene.control.skin.ComboBoxMode;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

public abstract class ComboBoxBaseSkin<T>
extends BehaviorSkinBase<ComboBoxBase<T>, ComboBoxBaseBehavior<T>> {
    private Node displayNode;
    protected StackPane arrowButton;
    protected Region arrow;
    private ComboBoxMode mode = ComboBoxMode.COMBOBOX;

    protected final ComboBoxMode getMode() {
        return this.mode;
    }

    protected final void setMode(ComboBoxMode value) {
        this.mode = value;
    }

    public ComboBoxBaseSkin(ComboBoxBase<T> comboBox, ComboBoxBaseBehavior<T> behavior) {
        super(comboBox, behavior);
        this.arrow = new Region();
        this.arrow.setFocusTraversable(false);
        this.arrow.getStyleClass().setAll((String[])new String[]{"arrow"});
        this.arrow.setId("arrow");
        this.arrow.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.arrow.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.arrow.setMouseTransparent(true);
        this.arrowButton = new StackPane();
        this.arrowButton.setFocusTraversable(false);
        this.arrowButton.setId("arrow-button");
        this.arrowButton.getStyleClass().setAll((String[])new String[]{"arrow-button"});
        this.arrowButton.getChildren().add(this.arrow);
        if (comboBox.isEditable()) {
            this.arrowButton.addEventHandler(MouseEvent.MOUSE_ENTERED, ComboBoxBaseSkin$$Lambda$1.lambdaFactory$(this));
            this.arrowButton.addEventHandler(MouseEvent.MOUSE_PRESSED, ComboBoxBaseSkin$$Lambda$2.lambdaFactory$(this));
            this.arrowButton.addEventHandler(MouseEvent.MOUSE_RELEASED, ComboBoxBaseSkin$$Lambda$3.lambdaFactory$(this));
            this.arrowButton.addEventHandler(MouseEvent.MOUSE_EXITED, ComboBoxBaseSkin$$Lambda$4.lambdaFactory$(this));
        }
        this.getChildren().add(this.arrowButton);
        ((ComboBoxBase)this.getSkinnable()).focusedProperty().addListener(ComboBoxBaseSkin$$Lambda$5.lambdaFactory$(this));
        this.registerChangeListener(comboBox.editableProperty(), "EDITABLE");
        this.registerChangeListener(comboBox.showingProperty(), "SHOWING");
        this.registerChangeListener(comboBox.focusedProperty(), "FOCUSED");
        this.registerChangeListener(comboBox.valueProperty(), "VALUE");
    }

    protected void focusLost() {
        ((ComboBoxBase)this.getSkinnable()).hide();
    }

    public abstract Node getDisplayNode();

    public abstract void show();

    public abstract void hide();

    @Override
    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("SHOWING".equals(p)) {
            if (((ComboBoxBase)this.getSkinnable()).isShowing()) {
                this.show();
            } else {
                this.hide();
            }
        } else if ("EDITABLE".equals(p)) {
            this.updateDisplayArea();
        } else if ("VALUE".equals(p)) {
            this.updateDisplayArea();
        }
    }

    protected void updateDisplayArea() {
        ObservableList<Node> children = this.getChildren();
        Node oldDisplayNode = this.displayNode;
        this.displayNode = this.getDisplayNode();
        if (oldDisplayNode != null && oldDisplayNode != this.displayNode) {
            children.remove(oldDisplayNode);
        }
        if (this.displayNode != null && !children.contains(this.displayNode)) {
            children.add(this.displayNode);
            this.displayNode.applyCss();
        }
    }

    private boolean isButton() {
        return this.getMode() == ComboBoxMode.BUTTON;
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        double arrowButtonWidth;
        if (this.displayNode == null) {
            this.updateDisplayArea();
        }
        double arrowWidth = this.snapSize(this.arrow.prefWidth(-1.0));
        double d = arrowButtonWidth = this.isButton() ? 0.0 : this.arrowButton.snappedLeftInset() + arrowWidth + this.arrowButton.snappedRightInset();
        if (this.displayNode != null) {
            this.displayNode.resizeRelocate(x, y, w - arrowButtonWidth, h);
        }
        this.arrowButton.setVisible(!this.isButton());
        if (!this.isButton()) {
            this.arrowButton.resize(arrowButtonWidth, h);
            this.positionInArea(this.arrowButton, x + w - arrowButtonWidth, y, arrowButtonWidth, h, 0.0, HPos.CENTER, VPos.CENTER);
        }
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.displayNode == null) {
            this.updateDisplayArea();
        }
        double arrowWidth = this.snapSize(this.arrow.prefWidth(-1.0));
        double arrowButtonWidth = this.isButton() ? 0.0 : this.arrowButton.snappedLeftInset() + arrowWidth + this.arrowButton.snappedRightInset();
        double displayNodeWidth = this.displayNode == null ? 0.0 : this.displayNode.prefWidth(height);
        double totalWidth = displayNodeWidth + arrowButtonWidth;
        return leftInset + totalWidth + rightInset;
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double ph;
        if (this.displayNode == null) {
            this.updateDisplayArea();
        }
        if (this.displayNode == null) {
            int DEFAULT_HEIGHT = 21;
            double arrowHeight = this.isButton() ? 0.0 : this.arrowButton.snappedTopInset() + this.arrow.prefHeight(-1.0) + this.arrowButton.snappedBottomInset();
            ph = Math.max(21.0, arrowHeight);
        } else {
            ph = this.displayNode.prefHeight(width);
        }
        return topInset + ph + bottomInset;
    }

    @Override
    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((ComboBoxBase)this.getSkinnable()).prefWidth(height);
    }

    @Override
    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((ComboBoxBase)this.getSkinnable()).prefHeight(width);
    }

    @Override
    protected double computeBaselineOffset(double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.displayNode == null) {
            this.updateDisplayArea();
        }
        if (this.displayNode != null) {
            return this.displayNode.getLayoutBounds().getMinY() + this.displayNode.getLayoutY() + this.displayNode.getBaselineOffset();
        }
        return super.computeBaselineOffset(topInset, rightInset, bottomInset, leftInset);
    }

    private /* synthetic */ void lambda$new$290(ObservableValue observable, Boolean oldValue, Boolean newValue) {
        if (!newValue.booleanValue()) {
            this.focusLost();
        }
    }

    private /* synthetic */ void lambda$new$289(MouseEvent e) {
        ((ComboBoxBaseBehavior)this.getBehavior()).mouseExited(e);
    }

    private /* synthetic */ void lambda$new$288(MouseEvent e) {
        ((ComboBoxBaseBehavior)this.getBehavior()).mouseReleased(e);
        e.consume();
    }

    private /* synthetic */ void lambda$new$287(MouseEvent e) {
        ((ComboBoxBaseBehavior)this.getBehavior()).mousePressed(e);
        e.consume();
    }

    private /* synthetic */ void lambda$new$286(MouseEvent e) {
        ((ComboBoxBaseBehavior)this.getBehavior()).mouseEntered(e);
    }

    static /* synthetic */ void access$lambda$0(ComboBoxBaseSkin comboBoxBaseSkin, MouseEvent mouseEvent) {
        comboBoxBaseSkin.lambda$new$286(mouseEvent);
    }

    static /* synthetic */ void access$lambda$1(ComboBoxBaseSkin comboBoxBaseSkin, MouseEvent mouseEvent) {
        comboBoxBaseSkin.lambda$new$287(mouseEvent);
    }

    static /* synthetic */ void access$lambda$2(ComboBoxBaseSkin comboBoxBaseSkin, MouseEvent mouseEvent) {
        comboBoxBaseSkin.lambda$new$288(mouseEvent);
    }

    static /* synthetic */ void access$lambda$3(ComboBoxBaseSkin comboBoxBaseSkin, MouseEvent mouseEvent) {
        comboBoxBaseSkin.lambda$new$289(mouseEvent);
    }

    static /* synthetic */ void access$lambda$4(ComboBoxBaseSkin comboBoxBaseSkin, ObservableValue observableValue, Boolean bl, Boolean bl2) {
        comboBoxBaseSkin.lambda$new$290(observableValue, bl, bl2);
    }
}

