/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.ComboBoxBaseBehavior;
import com.sun.javafx.scene.control.skin.ComboBoxBaseSkin;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl$$Lambda$1;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl$$Lambda$10;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl$$Lambda$2;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl$$Lambda$3;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl$$Lambda$4;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl$$Lambda$5;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl$$Lambda$6;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl$$Lambda$7;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl$$Lambda$8;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl$$Lambda$9;
import com.sun.javafx.scene.input.ExtendedInputMethodRequests;
import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.scene.traversal.TraversalContext;
import com.sun.javafx.util.Utils;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.control.Skinnable;
import javafx.scene.control.TextField;
import javafx.scene.input.DragEvent;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.stage.WindowEvent;
import javafx.util.StringConverter;

public abstract class ComboBoxPopupControl<T>
extends ComboBoxBaseSkin<T> {
    protected PopupControl popup;
    public static final String COMBO_BOX_STYLE_CLASS = "combo-box-popup";
    private boolean popupNeedsReconfiguring = true;
    private final ComboBoxBase<T> comboBoxBase;
    private TextField textField;
    private EventHandler<MouseEvent> textFieldMouseEventHandler = ComboBoxPopupControl$$Lambda$1.lambdaFactory$(this);
    private EventHandler<DragEvent> textFieldDragEventHandler = ComboBoxPopupControl$$Lambda$2.lambdaFactory$(this);
    private String initialTextFieldValue = null;
    private static PseudoClass CONTAINS_FOCUS_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("contains-focus");

    public ComboBoxPopupControl(ComboBoxBase<T> comboBoxBase, ComboBoxBaseBehavior<T> behavior) {
        super(comboBoxBase, behavior);
        this.comboBoxBase = comboBoxBase;
        TextField textField = this.textField = this.getEditor() != null ? this.getEditableInputNode() : null;
        if (this.textField != null) {
            this.getChildren().add(this.textField);
        }
        comboBoxBase.focusedProperty().addListener(ComboBoxPopupControl$$Lambda$3.lambdaFactory$(this));
        comboBoxBase.addEventFilter(KeyEvent.ANY, ComboBoxPopupControl$$Lambda$4.lambdaFactory$(this));
        if (comboBoxBase.getOnInputMethodTextChanged() == null) {
            comboBoxBase.setOnInputMethodTextChanged(ComboBoxPopupControl$$Lambda$5.lambdaFactory$(this, comboBoxBase));
        }
        comboBoxBase.setImpl_traversalEngine(new ParentTraversalEngine(comboBoxBase, new Algorithm(){

            @Override
            public Node select(Node owner, Direction dir, TraversalContext context) {
                return null;
            }

            @Override
            public Node selectFirst(TraversalContext context) {
                return null;
            }

            @Override
            public Node selectLast(TraversalContext context) {
                return null;
            }
        }));
        this.updateEditable();
    }

    protected abstract Node getPopupContent();

    protected PopupControl getPopup() {
        if (this.popup == null) {
            this.createPopup();
        }
        return this.popup;
    }

    @Override
    public void show() {
        if (this.getSkinnable() == null) {
            throw new IllegalStateException("ComboBox is null");
        }
        Node content = this.getPopupContent();
        if (content == null) {
            throw new IllegalStateException("Popup node is null");
        }
        if (this.getPopup().isShowing()) {
            return;
        }
        this.positionAndShowPopup();
    }

    @Override
    public void hide() {
        if (this.popup != null && this.popup.isShowing()) {
            this.popup.hide();
        }
    }

    private Point2D getPrefPopupPosition() {
        return Utils.pointRelativeTo((Node)((Object)this.getSkinnable()), this.getPopupContent(), HPos.CENTER, VPos.BOTTOM, 0.0, 0.0, true);
    }

    private void positionAndShowPopup() {
        PopupControl _popup = this.getPopup();
        _popup.getScene().setNodeOrientation(((ComboBoxBase)this.getSkinnable()).getEffectiveNodeOrientation());
        Node popupContent = this.getPopupContent();
        this.sizePopup();
        Point2D p = this.getPrefPopupPosition();
        this.popupNeedsReconfiguring = true;
        this.reconfigurePopup();
        ComboBoxBase comboBoxBase = (ComboBoxBase)this.getSkinnable();
        _popup.show(comboBoxBase.getScene().getWindow(), this.snapPosition(p.getX()), this.snapPosition(p.getY()));
        popupContent.requestFocus();
        this.sizePopup();
    }

    private void sizePopup() {
        Node popupContent = this.getPopupContent();
        if (popupContent instanceof Region) {
            Region r = (Region)popupContent;
            double prefHeight = this.snapSize(r.prefHeight(0.0));
            double minHeight = this.snapSize(r.minHeight(0.0));
            double maxHeight = this.snapSize(r.maxHeight(0.0));
            double h = this.snapSize(Math.min(Math.max(prefHeight, minHeight), Math.max(minHeight, maxHeight)));
            double prefWidth = this.snapSize(r.prefWidth(h));
            double minWidth = this.snapSize(r.minWidth(h));
            double maxWidth = this.snapSize(r.maxWidth(h));
            double w = this.snapSize(Math.min(Math.max(prefWidth, minWidth), Math.max(minWidth, maxWidth)));
            popupContent.resize(w, h);
        } else {
            popupContent.autosize();
        }
    }

    private void createPopup() {
        this.popup = new PopupControl(){
            {
                this.setSkin(new Skin<Skinnable>(){

                    @Override
                    public Skinnable getSkinnable() {
                        return ComboBoxPopupControl.this.getSkinnable();
                    }

                    @Override
                    public Node getNode() {
                        return ComboBoxPopupControl.this.getPopupContent();
                    }

                    @Override
                    public void dispose() {
                    }
                });
            }

            @Override
            public Styleable getStyleableParent() {
                return ComboBoxPopupControl.this.getSkinnable();
            }
        };
        this.popup.getStyleClass().add(COMBO_BOX_STYLE_CLASS);
        this.popup.setConsumeAutoHidingEvents(false);
        this.popup.setAutoHide(true);
        this.popup.setAutoFix(true);
        this.popup.setHideOnEscape(true);
        this.popup.setOnAutoHide(ComboBoxPopupControl$$Lambda$6.lambdaFactory$(this));
        this.popup.addEventHandler(MouseEvent.MOUSE_CLICKED, ComboBoxPopupControl$$Lambda$7.lambdaFactory$(this));
        this.popup.addEventHandler(WindowEvent.WINDOW_HIDDEN, ComboBoxPopupControl$$Lambda$8.lambdaFactory$(this));
        InvalidationListener layoutPosListener = ComboBoxPopupControl$$Lambda$9.lambdaFactory$(this);
        ((ComboBoxBase)this.getSkinnable()).layoutXProperty().addListener(layoutPosListener);
        ((ComboBoxBase)this.getSkinnable()).layoutYProperty().addListener(layoutPosListener);
        ((ComboBoxBase)this.getSkinnable()).widthProperty().addListener(layoutPosListener);
        ((ComboBoxBase)this.getSkinnable()).heightProperty().addListener(layoutPosListener);
        ((ComboBoxBase)this.getSkinnable()).sceneProperty().addListener(ComboBoxPopupControl$$Lambda$10.lambdaFactory$(this));
    }

    void reconfigurePopup() {
        double newHeight;
        if (this.popup == null) {
            return;
        }
        boolean isShowing = this.popup.isShowing();
        if (!isShowing) {
            return;
        }
        if (!this.popupNeedsReconfiguring) {
            return;
        }
        this.popupNeedsReconfiguring = false;
        Point2D p = this.getPrefPopupPosition();
        Node popupContent = this.getPopupContent();
        double minWidth = popupContent.prefWidth(-1.0);
        double minHeight = popupContent.prefHeight(-1.0);
        if (p.getX() > -1.0) {
            this.popup.setAnchorX(p.getX());
        }
        if (p.getY() > -1.0) {
            this.popup.setAnchorY(p.getY());
        }
        if (minWidth > -1.0) {
            this.popup.setMinWidth(minWidth);
        }
        if (minHeight > -1.0) {
            this.popup.setMinHeight(minHeight);
        }
        Bounds b = popupContent.getLayoutBounds();
        double currentWidth = b.getWidth();
        double currentHeight = b.getHeight();
        double newWidth = currentWidth < minWidth ? minWidth : currentWidth;
        double d = newHeight = currentHeight < minHeight ? minHeight : currentHeight;
        if (newWidth != currentWidth || newHeight != currentHeight) {
            popupContent.resize(newWidth, newHeight);
            if (popupContent instanceof Region) {
                ((Region)popupContent).setMinSize(newWidth, newHeight);
                ((Region)popupContent).setPrefSize(newWidth, newHeight);
            }
        }
    }

    protected abstract TextField getEditor();

    protected abstract StringConverter<T> getConverter();

    protected TextField getEditableInputNode() {
        if (this.textField == null && this.getEditor() != null) {
            this.textField = this.getEditor();
            this.textField.setFocusTraversable(false);
            this.textField.promptTextProperty().bind(this.comboBoxBase.promptTextProperty());
            this.textField.tooltipProperty().bind(this.comboBoxBase.tooltipProperty());
            this.initialTextFieldValue = this.textField.getText();
        }
        return this.textField;
    }

    protected void setTextFromTextFieldIntoComboBoxValue() {
        StringConverter<T> c;
        if (this.getEditor() != null && (c = this.getConverter()) != null) {
            T oldValue;
            T value = oldValue = this.comboBoxBase.getValue();
            String text = this.textField.getText();
            if (oldValue == null && (text == null || text.isEmpty())) {
                value = null;
            } else {
                try {
                    value = c.fromString(text);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!(value == null && oldValue == null || value != null && value.equals(oldValue))) {
                this.comboBoxBase.setValue(value);
            }
            this.updateDisplayNode();
        }
    }

    protected void updateDisplayNode() {
        if (this.textField != null && this.getEditor() != null) {
            T value = this.comboBoxBase.getValue();
            StringConverter<T> c = this.getConverter();
            if (this.initialTextFieldValue != null && !this.initialTextFieldValue.isEmpty()) {
                this.textField.setText(this.initialTextFieldValue);
                this.initialTextFieldValue = null;
            } else {
                String stringValue = c.toString(value);
                if (value == null || stringValue == null) {
                    this.textField.setText("");
                } else if (!stringValue.equals(this.textField.getText())) {
                    this.textField.setText(stringValue);
                }
            }
        }
    }

    private void handleKeyEvent(KeyEvent ke, boolean doConsume) {
        if (ke.getCode() == KeyCode.ENTER) {
            this.setTextFromTextFieldIntoComboBoxValue();
            if (doConsume && this.comboBoxBase.getOnAction() != null) {
                ke.consume();
            } else {
                this.forwardToParent(ke);
            }
        } else if (ke.getCode() == KeyCode.F4) {
            if (ke.getEventType() == KeyEvent.KEY_RELEASED) {
                if (this.comboBoxBase.isShowing()) {
                    this.comboBoxBase.hide();
                } else {
                    this.comboBoxBase.show();
                }
            }
            ke.consume();
        }
    }

    private void forwardToParent(KeyEvent event) {
        if (this.comboBoxBase.getParent() != null) {
            this.comboBoxBase.getParent().fireEvent(event);
        }
    }

    protected void updateEditable() {
        final TextField newTextField = this.getEditor();
        if (this.getEditor() == null) {
            if (this.textField != null) {
                this.textField.removeEventFilter(MouseEvent.DRAG_DETECTED, this.textFieldMouseEventHandler);
                this.textField.removeEventFilter(DragEvent.ANY, this.textFieldDragEventHandler);
                this.comboBoxBase.setInputMethodRequests(null);
            }
        } else if (newTextField != null) {
            newTextField.addEventFilter(MouseEvent.DRAG_DETECTED, this.textFieldMouseEventHandler);
            newTextField.addEventFilter(DragEvent.ANY, this.textFieldDragEventHandler);
            this.comboBoxBase.setInputMethodRequests(new ExtendedInputMethodRequests(){

                @Override
                public Point2D getTextLocation(int offset) {
                    return newTextField.getInputMethodRequests().getTextLocation(offset);
                }

                @Override
                public int getLocationOffset(int x, int y) {
                    return newTextField.getInputMethodRequests().getLocationOffset(x, y);
                }

                @Override
                public void cancelLatestCommittedText() {
                    newTextField.getInputMethodRequests().cancelLatestCommittedText();
                }

                @Override
                public String getSelectedText() {
                    return newTextField.getInputMethodRequests().getSelectedText();
                }

                @Override
                public int getInsertPositionOffset() {
                    return ((ExtendedInputMethodRequests)newTextField.getInputMethodRequests()).getInsertPositionOffset();
                }

                @Override
                public String getCommittedText(int begin, int end) {
                    return ((ExtendedInputMethodRequests)newTextField.getInputMethodRequests()).getCommittedText(begin, end);
                }

                @Override
                public int getCommittedTextLength() {
                    return ((ExtendedInputMethodRequests)newTextField.getInputMethodRequests()).getCommittedTextLength();
                }
            });
        }
        this.textField = newTextField;
    }

    private /* synthetic */ void lambda$new$300(DragEvent event) {
        ComboBoxBase comboBoxBase = (ComboBoxBase)this.getSkinnable();
        if (!event.getTarget().equals(comboBoxBase)) {
            comboBoxBase.fireEvent(event.copyFor(comboBoxBase, comboBoxBase));
            event.consume();
        }
    }

    private /* synthetic */ void lambda$new$299(MouseEvent event) {
        ComboBoxBase comboBoxBase = (ComboBoxBase)this.getSkinnable();
        if (!event.getTarget().equals(comboBoxBase)) {
            comboBoxBase.fireEvent(event.copyFor(comboBoxBase, comboBoxBase));
            event.consume();
        }
    }

    private /* synthetic */ void lambda$createPopup$298(Observable o) {
        if (((ObservableValue)o).getValue() == null) {
            this.hide();
        }
    }

    private /* synthetic */ void lambda$createPopup$297(Observable o) {
        this.popupNeedsReconfiguring = true;
        this.reconfigurePopup();
    }

    private /* synthetic */ void lambda$createPopup$296(WindowEvent t) {
        ((ComboBoxBase)this.getSkinnable()).notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_NODE);
    }

    private /* synthetic */ void lambda$createPopup$295(MouseEvent t) {
        ((ComboBoxBaseBehavior)this.getBehavior()).onAutoHide();
    }

    private /* synthetic */ void lambda$createPopup$294(Event e) {
        ((ComboBoxBaseBehavior)this.getBehavior()).onAutoHide();
    }

    private /* synthetic */ void lambda$new$293(ComboBoxBase comboBoxBase, InputMethodEvent event) {
        if (this.textField != null && this.getEditor() != null && comboBoxBase.getScene().getFocusOwner() == comboBoxBase && this.textField.getOnInputMethodTextChanged() != null) {
            this.textField.getOnInputMethodTextChanged().handle(event);
        }
    }

    private /* synthetic */ void lambda$new$292(KeyEvent ke) {
        if (this.textField == null || this.getEditor() == null) {
            this.handleKeyEvent(ke, false);
        } else {
            if (ke.getTarget().equals(this.textField)) {
                return;
            }
            switch (ke.getCode()) {
                case ESCAPE: 
                case F10: {
                    break;
                }
                case ENTER: {
                    this.handleKeyEvent(ke, true);
                    break;
                }
                default: {
                    this.textField.fireEvent(ke.copyFor(this.textField, this.textField));
                    ke.consume();
                }
            }
        }
    }

    private /* synthetic */ void lambda$new$291(ObservableValue ov, Boolean t, Boolean hasFocus) {
        if (this.getEditor() != null) {
            ((FakeFocusTextField)this.textField).setFakeFocus(hasFocus);
        }
    }

    static /* synthetic */ void access$lambda$0(ComboBoxPopupControl comboBoxPopupControl, MouseEvent mouseEvent) {
        comboBoxPopupControl.lambda$new$299(mouseEvent);
    }

    static /* synthetic */ void access$lambda$1(ComboBoxPopupControl comboBoxPopupControl, DragEvent dragEvent) {
        comboBoxPopupControl.lambda$new$300(dragEvent);
    }

    static /* synthetic */ void access$lambda$2(ComboBoxPopupControl comboBoxPopupControl, ObservableValue observableValue, Boolean bl, Boolean bl2) {
        comboBoxPopupControl.lambda$new$291(observableValue, bl, bl2);
    }

    static /* synthetic */ void access$lambda$3(ComboBoxPopupControl comboBoxPopupControl, KeyEvent keyEvent) {
        comboBoxPopupControl.lambda$new$292(keyEvent);
    }

    static /* synthetic */ void access$lambda$4(ComboBoxPopupControl comboBoxPopupControl, ComboBoxBase comboBoxBase, InputMethodEvent inputMethodEvent) {
        comboBoxPopupControl.lambda$new$293(comboBoxBase, inputMethodEvent);
    }

    static /* synthetic */ void access$lambda$5(ComboBoxPopupControl comboBoxPopupControl, Event event) {
        comboBoxPopupControl.lambda$createPopup$294(event);
    }

    static /* synthetic */ void access$lambda$6(ComboBoxPopupControl comboBoxPopupControl, MouseEvent mouseEvent) {
        comboBoxPopupControl.lambda$createPopup$295(mouseEvent);
    }

    static /* synthetic */ void access$lambda$7(ComboBoxPopupControl comboBoxPopupControl, WindowEvent windowEvent) {
        comboBoxPopupControl.lambda$createPopup$296(windowEvent);
    }

    static /* synthetic */ void access$lambda$8(ComboBoxPopupControl comboBoxPopupControl, Observable observable) {
        comboBoxPopupControl.lambda$createPopup$297(observable);
    }

    static /* synthetic */ void access$lambda$9(ComboBoxPopupControl comboBoxPopupControl, Observable observable) {
        comboBoxPopupControl.lambda$createPopup$298(observable);
    }

    public static final class FakeFocusTextField
    extends TextField {
        @Override
        public void requestFocus() {
            if (this.getParent() != null) {
                this.getParent().requestFocus();
            }
        }

        public void setFakeFocus(boolean b) {
            this.setFocused(b);
        }

        @Override
        public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
            switch (attribute) {
                case FOCUS_ITEM: {
                    return this.getParent();
                }
            }
            return super.queryAccessibleAttribute(attribute, parameters);
        }
    }
}

