/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.skin.ColorPickerSkin;
import com.sun.javafx.scene.control.skin.CustomColorDialog$$Lambda$1;
import com.sun.javafx.scene.control.skin.CustomColorDialog$ColorRectPane$$Lambda$1;
import com.sun.javafx.scene.control.skin.CustomColorDialog$ColorRectPane$$Lambda$2;
import com.sun.javafx.scene.control.skin.CustomColorDialog$ColorRectPane$$Lambda$3;
import com.sun.javafx.scene.control.skin.CustomColorDialog$ControlsPane$$Lambda$1;
import com.sun.javafx.scene.control.skin.CustomColorDialog$ControlsPane$$Lambda$2;
import com.sun.javafx.scene.control.skin.CustomColorDialog$ControlsPane$$Lambda$3;
import com.sun.javafx.scene.control.skin.CustomColorDialog$ControlsPane$$Lambda$4;
import com.sun.javafx.scene.control.skin.IntegerField;
import com.sun.javafx.scene.control.skin.IntegerFieldSkin;
import com.sun.javafx.scene.control.skin.WebColorField;
import com.sun.javafx.scene.control.skin.WebColorFieldSkin;
import com.sun.javafx.util.Utils;
import java.util.Collection;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class CustomColorDialog
extends HBox {
    private final Stage dialog = new Stage();
    private ColorRectPane colorRectPane;
    private ControlsPane controlsPane;
    private ObjectProperty<Color> currentColorProperty = new SimpleObjectProperty<Color>(Color.WHITE);
    private ObjectProperty<Color> customColorProperty = new SimpleObjectProperty<Color>(Color.TRANSPARENT);
    private Runnable onSave;
    private Runnable onUse;
    private Runnable onCancel;
    private WebColorField webField = null;
    private Scene customScene;
    private final EventHandler<KeyEvent> keyEventListener = CustomColorDialog$$Lambda$1.lambdaFactory$(this);
    private InvalidationListener positionAdjuster = new InvalidationListener(){

        @Override
        public void invalidated(Observable ignored) {
            if (Double.isNaN(CustomColorDialog.this.dialog.getWidth()) || Double.isNaN(CustomColorDialog.this.dialog.getHeight())) {
                return;
            }
            CustomColorDialog.this.dialog.widthProperty().removeListener(CustomColorDialog.this.positionAdjuster);
            CustomColorDialog.this.dialog.heightProperty().removeListener(CustomColorDialog.this.positionAdjuster);
            CustomColorDialog.this.fixPosition();
        }
    };

    public CustomColorDialog(Window owner) {
        this.getStyleClass().add("custom-color-dialog");
        if (owner != null) {
            this.dialog.initOwner(owner);
        }
        this.dialog.setTitle(ColorPickerSkin.getString("customColorDialogTitle"));
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initStyle(StageStyle.UTILITY);
        this.dialog.setResizable(false);
        this.colorRectPane = new ColorRectPane();
        this.controlsPane = new ControlsPane();
        CustomColorDialog.setHgrow(this.controlsPane, Priority.ALWAYS);
        this.customScene = new Scene(this);
        Scene ownerScene = owner.getScene();
        if (ownerScene != null) {
            if (ownerScene.getUserAgentStylesheet() != null) {
                this.customScene.setUserAgentStylesheet(ownerScene.getUserAgentStylesheet());
            }
            this.customScene.getStylesheets().addAll((Collection<String>)ownerScene.getStylesheets());
        }
        this.getChildren().addAll((Node[])new Node[]{this.colorRectPane, this.controlsPane});
        this.dialog.setScene(this.customScene);
        this.dialog.addEventHandler(KeyEvent.ANY, this.keyEventListener);
    }

    public void setCurrentColor(Color currentColor) {
        this.currentColorProperty.set(currentColor);
    }

    Color getCurrentColor() {
        return (Color)this.currentColorProperty.get();
    }

    ObjectProperty<Color> customColorProperty() {
        return this.customColorProperty;
    }

    void setCustomColor(Color color) {
        this.customColorProperty.set(color);
    }

    Color getCustomColor() {
        return (Color)this.customColorProperty.get();
    }

    public Runnable getOnSave() {
        return this.onSave;
    }

    public void setOnSave(Runnable onSave) {
        this.onSave = onSave;
    }

    public Runnable getOnUse() {
        return this.onUse;
    }

    public void setOnUse(Runnable onUse) {
        this.onUse = onUse;
    }

    public Runnable getOnCancel() {
        return this.onCancel;
    }

    public void setOnCancel(Runnable onCancel) {
        this.onCancel = onCancel;
    }

    public void setOnHidden(EventHandler<WindowEvent> onHidden) {
        this.dialog.setOnHidden(onHidden);
    }

    Stage getDialog() {
        return this.dialog;
    }

    public void show() {
        if (this.dialog.getOwner() != null) {
            this.dialog.widthProperty().addListener(this.positionAdjuster);
            this.dialog.heightProperty().addListener(this.positionAdjuster);
            this.positionAdjuster.invalidated(null);
        }
        if (this.dialog.getScene() == null) {
            this.dialog.setScene(this.customScene);
        }
        this.colorRectPane.updateValues();
        this.dialog.show();
    }

    private void fixPosition() {
        Window w = this.dialog.getOwner();
        Screen s = Utils.getScreen(w);
        Rectangle2D sb = s.getBounds();
        double xR = w.getX() + w.getWidth();
        double xL = w.getX() - this.dialog.getWidth();
        double x = sb.getMaxX() >= xR + this.dialog.getWidth() ? xR : (sb.getMinX() <= xL ? xL : Math.max(sb.getMinX(), sb.getMaxX() - this.dialog.getWidth()));
        double y = Math.max(sb.getMinY(), Math.min(sb.getMaxY() - this.dialog.getHeight(), w.getY()));
        this.dialog.setX(x);
        this.dialog.setY(y);
    }

    @Override
    public void layoutChildren() {
        super.layoutChildren();
        if (this.dialog.getMinWidth() > 0.0 && this.dialog.getMinHeight() > 0.0) {
            return;
        }
        double minWidth = Math.max(0.0, this.computeMinWidth(this.getHeight()) + (this.dialog.getWidth() - this.customScene.getWidth()));
        double minHeight = Math.max(0.0, this.computeMinHeight(this.getWidth()) + (this.dialog.getHeight() - this.customScene.getHeight()));
        this.dialog.setMinWidth(minWidth);
        this.dialog.setMinHeight(minHeight);
    }

    static double clamp(double value) {
        return value < 0.0 ? 0.0 : (value > 1.0 ? 1.0 : value);
    }

    private static LinearGradient createHueGradient() {
        Stop[] stops = new Stop[255];
        for (int y = 0; y < 255; ++y) {
            double offset = 1.0 - 0.00392156862745098 * (double)y;
            int h = (int)((double)y / 255.0 * 360.0);
            stops[y] = new Stop(offset, Color.hsb(h, 1.0, 1.0));
        }
        return new LinearGradient(0.0, 1.0, 0.0, 0.0, true, CycleMethod.NO_CYCLE, stops);
    }

    private static int doubleToInt(double value) {
        return (int)(value * 255.0 + 0.5);
    }

    private /* synthetic */ void lambda$new$314(KeyEvent e) {
        switch (e.getCode()) {
            case ESCAPE: {
                this.dialog.setScene(null);
                this.dialog.close();
            }
        }
    }

    static /* synthetic */ void access$lambda$0(CustomColorDialog customColorDialog, KeyEvent keyEvent) {
        customColorDialog.lambda$new$314(keyEvent);
    }

    private class ControlsPane
    extends VBox {
        private Label currentColorLabel;
        private Label newColorLabel;
        private Region currentColorRect;
        private Region newColorRect;
        private Region currentTransparent;
        private GridPane currentAndNewColor;
        private Region currentNewColorBorder;
        private ToggleButton hsbButton;
        private ToggleButton rgbButton;
        private ToggleButton webButton;
        private HBox hBox;
        private Label[] labels = new Label[4];
        private Slider[] sliders = new Slider[4];
        private IntegerField[] fields = new IntegerField[4];
        private Label[] units = new Label[4];
        private HBox buttonBox;
        private Region whiteBox;
        private GridPane settingsPane = new GridPane();
        private Property<Number>[] bindedProperties = new Property[4];

        public ControlsPane() {
            this.getStyleClass().add("controls-pane");
            this.currentNewColorBorder = new Region();
            this.currentNewColorBorder.setId("current-new-color-border");
            this.currentTransparent = new Region();
            this.currentTransparent.getStyleClass().addAll((String[])new String[]{"transparent-pattern"});
            this.currentColorRect = new Region();
            this.currentColorRect.getStyleClass().add("color-rect");
            this.currentColorRect.setId("current-color");
            this.currentColorRect.backgroundProperty().bind((ObservableValue<Background>)new ObjectBinding<Background>(){
                {
                    this.bind(CustomColorDialog.this.currentColorProperty);
                }

                @Override
                protected Background computeValue() {
                    return new Background(new BackgroundFill((Paint)CustomColorDialog.this.currentColorProperty.get(), CornerRadii.EMPTY, Insets.EMPTY));
                }
            });
            this.newColorRect = new Region();
            this.newColorRect.getStyleClass().add("color-rect");
            this.newColorRect.setId("new-color");
            this.newColorRect.backgroundProperty().bind((ObservableValue<Background>)new ObjectBinding<Background>(){
                {
                    this.bind(CustomColorDialog.this.customColorProperty);
                }

                @Override
                protected Background computeValue() {
                    return new Background(new BackgroundFill((Paint)CustomColorDialog.this.customColorProperty.get(), CornerRadii.EMPTY, Insets.EMPTY));
                }
            });
            this.currentColorLabel = new Label(ColorPickerSkin.getString("currentColor"));
            this.newColorLabel = new Label(ColorPickerSkin.getString("newColor"));
            this.whiteBox = new Region();
            this.whiteBox.getStyleClass().add("customcolor-controls-background");
            this.hsbButton = new ToggleButton(ColorPickerSkin.getString("colorType.hsb"));
            this.hsbButton.getStyleClass().add("left-pill");
            this.rgbButton = new ToggleButton(ColorPickerSkin.getString("colorType.rgb"));
            this.rgbButton.getStyleClass().add("center-pill");
            this.webButton = new ToggleButton(ColorPickerSkin.getString("colorType.web"));
            this.webButton.getStyleClass().add("right-pill");
            ToggleGroup group = new ToggleGroup();
            this.hBox = new HBox();
            this.hBox.setAlignment(Pos.CENTER);
            this.hBox.getChildren().addAll((Node[])new Node[]{this.hsbButton, this.rgbButton, this.webButton});
            Region spacer1 = new Region();
            spacer1.setId("spacer1");
            Region spacer2 = new Region();
            spacer2.setId("spacer2");
            Region leftSpacer = new Region();
            leftSpacer.setId("spacer-side");
            Region rightSpacer = new Region();
            rightSpacer.setId("spacer-side");
            Region bottomSpacer = new Region();
            bottomSpacer.setId("spacer-bottom");
            this.currentAndNewColor = new GridPane();
            this.currentAndNewColor.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{new ColumnConstraints(), new ColumnConstraints()});
            ((ColumnConstraints)this.currentAndNewColor.getColumnConstraints().get(0)).setHgrow(Priority.ALWAYS);
            ((ColumnConstraints)this.currentAndNewColor.getColumnConstraints().get(1)).setHgrow(Priority.ALWAYS);
            this.currentAndNewColor.getRowConstraints().addAll((RowConstraints[])new RowConstraints[]{new RowConstraints(), new RowConstraints(), new RowConstraints()});
            ((RowConstraints)this.currentAndNewColor.getRowConstraints().get(2)).setVgrow(Priority.ALWAYS);
            VBox.setVgrow(this.currentAndNewColor, Priority.ALWAYS);
            this.currentAndNewColor.getStyleClass().add("current-new-color-grid");
            this.currentAndNewColor.add(this.currentColorLabel, 0, 0);
            this.currentAndNewColor.add(this.newColorLabel, 1, 0);
            this.currentAndNewColor.add(spacer1, 0, 1, 2, 1);
            this.currentAndNewColor.add(this.currentTransparent, 0, 2, 2, 1);
            this.currentAndNewColor.add(this.currentColorRect, 0, 2);
            this.currentAndNewColor.add(this.newColorRect, 1, 2);
            this.currentAndNewColor.add(this.currentNewColorBorder, 0, 2, 2, 1);
            this.currentAndNewColor.add(spacer2, 0, 3, 2, 1);
            this.settingsPane = new GridPane();
            this.settingsPane.setId("settings-pane");
            this.settingsPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{new ColumnConstraints(), new ColumnConstraints(), new ColumnConstraints(), new ColumnConstraints(), new ColumnConstraints(), new ColumnConstraints()});
            ((ColumnConstraints)this.settingsPane.getColumnConstraints().get(0)).setHgrow(Priority.NEVER);
            ((ColumnConstraints)this.settingsPane.getColumnConstraints().get(2)).setHgrow(Priority.ALWAYS);
            ((ColumnConstraints)this.settingsPane.getColumnConstraints().get(3)).setHgrow(Priority.NEVER);
            ((ColumnConstraints)this.settingsPane.getColumnConstraints().get(4)).setHgrow(Priority.NEVER);
            ((ColumnConstraints)this.settingsPane.getColumnConstraints().get(5)).setHgrow(Priority.NEVER);
            this.settingsPane.add(this.whiteBox, 0, 0, 6, 5);
            this.settingsPane.add(this.hBox, 0, 0, 6, 1);
            this.settingsPane.add(leftSpacer, 0, 0);
            this.settingsPane.add(rightSpacer, 5, 0);
            this.settingsPane.add(bottomSpacer, 0, 4);
            CustomColorDialog.this.webField = new WebColorField();
            CustomColorDialog.this.webField.getStyleClass().add("web-field");
            CustomColorDialog.this.webField.setSkin(new WebColorFieldSkin(CustomColorDialog.this.webField));
            CustomColorDialog.this.webField.valueProperty().bindBidirectional(CustomColorDialog.this.customColorProperty);
            CustomColorDialog.this.webField.visibleProperty().bind(group.selectedToggleProperty().isEqualTo(this.webButton));
            this.settingsPane.add(CustomColorDialog.this.webField, 2, 1);
            for (int i = 0; i < 4; ++i) {
                this.labels[i] = new Label();
                this.labels[i].getStyleClass().add("settings-label");
                this.sliders[i] = new Slider();
                this.fields[i] = new IntegerField();
                this.fields[i].getStyleClass().add("color-input-field");
                this.fields[i].setSkin(new IntegerFieldSkin(this.fields[i]));
                this.units[i] = new Label(i == 0 ? "\u00b0" : "%");
                this.units[i].getStyleClass().add("settings-unit");
                if (i > 0 && i < 3) {
                    this.labels[i].visibleProperty().bind(group.selectedToggleProperty().isNotEqualTo(this.webButton));
                }
                if (i < 3) {
                    this.sliders[i].visibleProperty().bind(group.selectedToggleProperty().isNotEqualTo(this.webButton));
                    this.fields[i].visibleProperty().bind(group.selectedToggleProperty().isNotEqualTo(this.webButton));
                    this.units[i].visibleProperty().bind(group.selectedToggleProperty().isEqualTo(this.hsbButton));
                }
                int row = 1 + i;
                if (i == 3) {
                    ++row;
                }
                this.settingsPane.add(this.labels[i], 1, row);
                this.settingsPane.add(this.sliders[i], 2, row);
                this.settingsPane.add(this.fields[i], 3, row);
                this.settingsPane.add(this.units[i], 4, row);
            }
            this.set(3, ColorPickerSkin.getString("opacity_colon"), 100, CustomColorDialog.this.colorRectPane.alpha);
            this.hsbButton.setToggleGroup(group);
            this.rgbButton.setToggleGroup(group);
            this.webButton.setToggleGroup(group);
            group.selectedToggleProperty().addListener(CustomColorDialog$ControlsPane$$Lambda$1.lambdaFactory$(this, group));
            group.selectToggle(this.hsbButton);
            this.buttonBox = new HBox();
            this.buttonBox.setId("buttons-hbox");
            Button saveButton = new Button(ColorPickerSkin.getString("Save"));
            saveButton.setDefaultButton(true);
            saveButton.setOnAction(CustomColorDialog$ControlsPane$$Lambda$2.lambdaFactory$(this));
            Button useButton = new Button(ColorPickerSkin.getString("Use"));
            useButton.setOnAction(CustomColorDialog$ControlsPane$$Lambda$3.lambdaFactory$(this));
            Button cancelButton = new Button(ColorPickerSkin.getString("Cancel"));
            cancelButton.setCancelButton(true);
            cancelButton.setOnAction(CustomColorDialog$ControlsPane$$Lambda$4.lambdaFactory$(this));
            this.buttonBox.getChildren().addAll((Node[])new Node[]{saveButton, useButton, cancelButton});
            this.getChildren().addAll((Node[])new Node[]{this.currentAndNewColor, this.settingsPane, this.buttonBox});
        }

        private void showHSBSettings() {
            this.set(0, ColorPickerSkin.getString("hue_colon"), 360, CustomColorDialog.this.colorRectPane.hue);
            this.set(1, ColorPickerSkin.getString("saturation_colon"), 100, CustomColorDialog.this.colorRectPane.sat);
            this.set(2, ColorPickerSkin.getString("brightness_colon"), 100, CustomColorDialog.this.colorRectPane.bright);
        }

        private void showRGBSettings() {
            this.set(0, ColorPickerSkin.getString("red_colon"), 255, CustomColorDialog.this.colorRectPane.red);
            this.set(1, ColorPickerSkin.getString("green_colon"), 255, CustomColorDialog.this.colorRectPane.green);
            this.set(2, ColorPickerSkin.getString("blue_colon"), 255, CustomColorDialog.this.colorRectPane.blue);
        }

        private void showWebSettings() {
            this.labels[0].setText(ColorPickerSkin.getString("web_colon"));
        }

        private void set(int row, String caption, int maxValue, Property<Number> prop) {
            this.labels[row].setText(caption);
            if (this.bindedProperties[row] != null) {
                this.sliders[row].valueProperty().unbindBidirectional(this.bindedProperties[row]);
                this.fields[row].valueProperty().unbindBidirectional(this.bindedProperties[row]);
            }
            this.sliders[row].setMax(maxValue);
            this.sliders[row].valueProperty().bindBidirectional(prop);
            this.labels[row].setLabelFor(this.sliders[row]);
            this.fields[row].setMaxValue(maxValue);
            this.fields[row].valueProperty().bindBidirectional(prop);
            this.bindedProperties[row] = prop;
        }

        private /* synthetic */ void lambda$new$321(ActionEvent e) {
            CustomColorDialog.this.customColorProperty.set(CustomColorDialog.this.getCurrentColor());
            if (CustomColorDialog.this.onCancel != null) {
                CustomColorDialog.this.onCancel.run();
            }
            CustomColorDialog.this.dialog.hide();
        }

        private /* synthetic */ void lambda$new$320(ActionEvent t) {
            if (CustomColorDialog.this.onUse != null) {
                CustomColorDialog.this.onUse.run();
            }
            CustomColorDialog.this.dialog.hide();
        }

        private /* synthetic */ void lambda$new$319(ActionEvent t) {
            if (CustomColorDialog.this.onSave != null) {
                CustomColorDialog.this.onSave.run();
            }
            CustomColorDialog.this.dialog.hide();
        }

        private /* synthetic */ void lambda$new$318(ToggleGroup group, ObservableValue observable, Toggle oldValue, Toggle newValue) {
            if (newValue == null) {
                group.selectToggle(oldValue);
            } else if (newValue == this.hsbButton) {
                this.showHSBSettings();
            } else if (newValue == this.rgbButton) {
                this.showRGBSettings();
            } else {
                this.showWebSettings();
            }
        }

        static /* synthetic */ void access$lambda$0(ControlsPane controlsPane, ToggleGroup toggleGroup, ObservableValue observableValue, Toggle toggle, Toggle toggle2) {
            controlsPane.lambda$new$318(toggleGroup, observableValue, toggle, toggle2);
        }

        static /* synthetic */ void access$lambda$1(ControlsPane controlsPane, ActionEvent actionEvent) {
            controlsPane.lambda$new$319(actionEvent);
        }

        static /* synthetic */ void access$lambda$2(ControlsPane controlsPane, ActionEvent actionEvent) {
            controlsPane.lambda$new$320(actionEvent);
        }

        static /* synthetic */ void access$lambda$3(ControlsPane controlsPane, ActionEvent actionEvent) {
            controlsPane.lambda$new$321(actionEvent);
        }
    }

    private class ColorRectPane
    extends HBox {
        private Pane colorRect;
        private Pane colorBar;
        private Pane colorRectOverlayOne;
        private Pane colorRectOverlayTwo;
        private Region colorRectIndicator;
        private Region colorBarIndicator;
        private boolean changeIsLocal = false;
        private DoubleProperty hue = new SimpleDoubleProperty(-1.0){

            @Override
            protected void invalidated() {
                if (!ColorRectPane.this.changeIsLocal) {
                    ColorRectPane.this.changeIsLocal = true;
                    ColorRectPane.this.updateHSBColor();
                    ColorRectPane.this.changeIsLocal = false;
                }
            }
        };
        private DoubleProperty sat = new SimpleDoubleProperty(-1.0){

            @Override
            protected void invalidated() {
                if (!ColorRectPane.this.changeIsLocal) {
                    ColorRectPane.this.changeIsLocal = true;
                    ColorRectPane.this.updateHSBColor();
                    ColorRectPane.this.changeIsLocal = false;
                }
            }
        };
        private DoubleProperty bright = new SimpleDoubleProperty(-1.0){

            @Override
            protected void invalidated() {
                if (!ColorRectPane.this.changeIsLocal) {
                    ColorRectPane.this.changeIsLocal = true;
                    ColorRectPane.this.updateHSBColor();
                    ColorRectPane.this.changeIsLocal = false;
                }
            }
        };
        private IntegerProperty red = new SimpleIntegerProperty(-1){

            @Override
            protected void invalidated() {
                if (!ColorRectPane.this.changeIsLocal) {
                    ColorRectPane.this.changeIsLocal = true;
                    ColorRectPane.this.updateRGBColor();
                    ColorRectPane.this.changeIsLocal = false;
                }
            }
        };
        private IntegerProperty green = new SimpleIntegerProperty(-1){

            @Override
            protected void invalidated() {
                if (!ColorRectPane.this.changeIsLocal) {
                    ColorRectPane.this.changeIsLocal = true;
                    ColorRectPane.this.updateRGBColor();
                    ColorRectPane.this.changeIsLocal = false;
                }
            }
        };
        private IntegerProperty blue = new SimpleIntegerProperty(-1){

            @Override
            protected void invalidated() {
                if (!ColorRectPane.this.changeIsLocal) {
                    ColorRectPane.this.changeIsLocal = true;
                    ColorRectPane.this.updateRGBColor();
                    ColorRectPane.this.changeIsLocal = false;
                }
            }
        };
        private DoubleProperty alpha = new SimpleDoubleProperty(100.0){

            @Override
            protected void invalidated() {
                if (!ColorRectPane.this.changeIsLocal) {
                    ColorRectPane.this.changeIsLocal = true;
                    CustomColorDialog.this.setCustomColor(new Color(CustomColorDialog.this.getCustomColor().getRed(), CustomColorDialog.this.getCustomColor().getGreen(), CustomColorDialog.this.getCustomColor().getBlue(), CustomColorDialog.clamp(ColorRectPane.this.alpha.get() / 100.0)));
                    ColorRectPane.this.changeIsLocal = false;
                }
            }
        };

        private void updateRGBColor() {
            Color newColor = Color.rgb(this.red.get(), this.green.get(), this.blue.get(), CustomColorDialog.clamp(this.alpha.get() / 100.0));
            this.hue.set(newColor.getHue());
            this.sat.set(newColor.getSaturation() * 100.0);
            this.bright.set(newColor.getBrightness() * 100.0);
            CustomColorDialog.this.setCustomColor(newColor);
        }

        private void updateHSBColor() {
            Color newColor = Color.hsb(this.hue.get(), CustomColorDialog.clamp(this.sat.get() / 100.0), CustomColorDialog.clamp(this.bright.get() / 100.0), CustomColorDialog.clamp(this.alpha.get() / 100.0));
            this.red.set(CustomColorDialog.doubleToInt(newColor.getRed()));
            this.green.set(CustomColorDialog.doubleToInt(newColor.getGreen()));
            this.blue.set(CustomColorDialog.doubleToInt(newColor.getBlue()));
            CustomColorDialog.this.setCustomColor(newColor);
        }

        private void colorChanged() {
            if (!this.changeIsLocal) {
                this.changeIsLocal = true;
                this.hue.set(CustomColorDialog.this.getCustomColor().getHue());
                this.sat.set(CustomColorDialog.this.getCustomColor().getSaturation() * 100.0);
                this.bright.set(CustomColorDialog.this.getCustomColor().getBrightness() * 100.0);
                this.red.set(CustomColorDialog.doubleToInt(CustomColorDialog.this.getCustomColor().getRed()));
                this.green.set(CustomColorDialog.doubleToInt(CustomColorDialog.this.getCustomColor().getGreen()));
                this.blue.set(CustomColorDialog.doubleToInt(CustomColorDialog.this.getCustomColor().getBlue()));
                this.changeIsLocal = false;
            }
        }

        public ColorRectPane() {
            this.getStyleClass().add("color-rect-pane");
            CustomColorDialog.this.customColorProperty().addListener(CustomColorDialog$ColorRectPane$$Lambda$1.lambdaFactory$(this));
            this.colorRectIndicator = new Region();
            this.colorRectIndicator.setId("color-rect-indicator");
            this.colorRectIndicator.setManaged(false);
            this.colorRectIndicator.setMouseTransparent(true);
            this.colorRectIndicator.setCache(true);
            StackPane colorRectOpacityContainer = new StackPane();
            this.colorRect = new StackPane(){

                @Override
                public Orientation getContentBias() {
                    return Orientation.VERTICAL;
                }

                @Override
                protected double computePrefWidth(double height) {
                    return height;
                }

                @Override
                protected double computeMaxWidth(double height) {
                    return height;
                }
            };
            this.colorRect.getStyleClass().addAll((String[])new String[]{"color-rect", "transparent-pattern"});
            Pane colorRectHue = new Pane();
            colorRectHue.backgroundProperty().bind((ObservableValue<Background>)new ObjectBinding<Background>(){
                {
                    this.bind(ColorRectPane.this.hue);
                }

                @Override
                protected Background computeValue() {
                    return new Background(new BackgroundFill(Color.hsb(ColorRectPane.this.hue.getValue(), 1.0, 1.0), CornerRadii.EMPTY, Insets.EMPTY));
                }
            });
            this.colorRectOverlayOne = new Pane();
            this.colorRectOverlayOne.getStyleClass().add("color-rect");
            this.colorRectOverlayOne.setBackground(new Background(new BackgroundFill(new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop(0.0, Color.rgb(255, 255, 255, 1.0)), new Stop(1.0, Color.rgb(255, 255, 255, 0.0))), CornerRadii.EMPTY, Insets.EMPTY)));
            EventHandler rectMouseHandler = CustomColorDialog$ColorRectPane$$Lambda$2.lambdaFactory$(this);
            this.colorRectOverlayTwo = new Pane();
            this.colorRectOverlayTwo.getStyleClass().addAll((String[])new String[]{"color-rect"});
            this.colorRectOverlayTwo.setBackground(new Background(new BackgroundFill(new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop(0.0, Color.rgb(0, 0, 0, 0.0)), new Stop(1.0, Color.rgb(0, 0, 0, 1.0))), CornerRadii.EMPTY, Insets.EMPTY)));
            this.colorRectOverlayTwo.setOnMouseDragged(rectMouseHandler);
            this.colorRectOverlayTwo.setOnMousePressed(rectMouseHandler);
            Pane colorRectBlackBorder = new Pane();
            colorRectBlackBorder.setMouseTransparent(true);
            colorRectBlackBorder.getStyleClass().addAll((String[])new String[]{"color-rect", "color-rect-border"});
            this.colorBar = new Pane();
            this.colorBar.getStyleClass().add("color-bar");
            this.colorBar.setBackground(new Background(new BackgroundFill(CustomColorDialog.createHueGradient(), CornerRadii.EMPTY, Insets.EMPTY)));
            this.colorBarIndicator = new Region();
            this.colorBarIndicator.setId("color-bar-indicator");
            this.colorBarIndicator.setMouseTransparent(true);
            this.colorBarIndicator.setCache(true);
            this.colorRectIndicator.layoutXProperty().bind(this.sat.divide(100).multiply(this.colorRect.widthProperty()));
            this.colorRectIndicator.layoutYProperty().bind(Bindings.subtract(1, (ObservableNumberValue)this.bright.divide(100)).multiply(this.colorRect.heightProperty()));
            this.colorBarIndicator.layoutYProperty().bind(this.hue.divide(360).multiply(this.colorBar.heightProperty()));
            colorRectOpacityContainer.opacityProperty().bind(this.alpha.divide(100));
            EventHandler barMouseHandler = CustomColorDialog$ColorRectPane$$Lambda$3.lambdaFactory$(this);
            this.colorBar.setOnMouseDragged(barMouseHandler);
            this.colorBar.setOnMousePressed(barMouseHandler);
            this.colorBar.getChildren().setAll((Node[])new Node[]{this.colorBarIndicator});
            colorRectOpacityContainer.getChildren().setAll((Node[])new Node[]{colorRectHue, this.colorRectOverlayOne, this.colorRectOverlayTwo});
            this.colorRect.getChildren().setAll((Node[])new Node[]{colorRectOpacityContainer, colorRectBlackBorder, this.colorRectIndicator});
            HBox.setHgrow(this.colorRect, Priority.SOMETIMES);
            this.getChildren().addAll((Node[])new Node[]{this.colorRect, this.colorBar});
        }

        private void updateValues() {
            if (CustomColorDialog.this.getCurrentColor() == null) {
                CustomColorDialog.this.setCurrentColor(Color.TRANSPARENT);
            }
            this.changeIsLocal = true;
            this.hue.set(CustomColorDialog.this.getCurrentColor().getHue());
            this.sat.set(CustomColorDialog.this.getCurrentColor().getSaturation() * 100.0);
            this.bright.set(CustomColorDialog.this.getCurrentColor().getBrightness() * 100.0);
            this.alpha.set(CustomColorDialog.this.getCurrentColor().getOpacity() * 100.0);
            CustomColorDialog.this.setCustomColor(Color.hsb(this.hue.get(), CustomColorDialog.clamp(this.sat.get() / 100.0), CustomColorDialog.clamp(this.bright.get() / 100.0), CustomColorDialog.clamp(this.alpha.get() / 100.0)));
            this.red.set(CustomColorDialog.doubleToInt(CustomColorDialog.this.getCustomColor().getRed()));
            this.green.set(CustomColorDialog.doubleToInt(CustomColorDialog.this.getCustomColor().getGreen()));
            this.blue.set(CustomColorDialog.doubleToInt(CustomColorDialog.this.getCustomColor().getBlue()));
            this.changeIsLocal = false;
        }

        @Override
        protected void layoutChildren() {
            super.layoutChildren();
            this.colorRectIndicator.autosize();
            double size = Math.min(this.colorRect.getWidth(), this.colorRect.getHeight());
            this.colorRect.resize(size, size);
            this.colorBar.resize(this.colorBar.getWidth(), size);
        }

        private /* synthetic */ void lambda$new$317(MouseEvent event) {
            double y = event.getY();
            this.hue.set(CustomColorDialog.clamp(y / this.colorRect.getHeight()) * 360.0);
        }

        private /* synthetic */ void lambda$new$316(MouseEvent event) {
            double x = event.getX();
            double y = event.getY();
            this.sat.set(CustomColorDialog.clamp(x / this.colorRect.getWidth()) * 100.0);
            this.bright.set(100.0 - CustomColorDialog.clamp(y / this.colorRect.getHeight()) * 100.0);
        }

        private /* synthetic */ void lambda$new$315(ObservableValue ov, Color t, Color t1) {
            this.colorChanged();
        }

        static /* synthetic */ void access$lambda$0(ColorRectPane colorRectPane, ObservableValue observableValue, Color color, Color color2) {
            colorRectPane.lambda$new$315(observableValue, color, color2);
        }

        static /* synthetic */ void access$lambda$1(ColorRectPane colorRectPane, MouseEvent mouseEvent) {
            colorRectPane.lambda$new$316(mouseEvent);
        }

        static /* synthetic */ void access$lambda$2(ColorRectPane colorRectPane, MouseEvent mouseEvent) {
            colorRectPane.lambda$new$317(mouseEvent);
        }
    }
}

