/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.skin.DoubleField;
import com.sun.javafx.scene.control.skin.DoubleFieldSkin$$Lambda$1;
import com.sun.javafx.scene.control.skin.DoubleFieldSkin$$Lambda$2;
import com.sun.javafx.scene.control.skin.InputFieldSkin;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.scene.Node;

public class DoubleFieldSkin
extends InputFieldSkin {
    private InvalidationListener doubleFieldValueListener = DoubleFieldSkin$$Lambda$1.lambdaFactory$(this);

    public DoubleFieldSkin(DoubleField control) {
        super(control);
        control.valueProperty().addListener(this.doubleFieldValueListener);
    }

    @Override
    public DoubleField getSkinnable() {
        return (DoubleField)this.control;
    }

    @Override
    public Node getNode() {
        return this.getTextField();
    }

    @Override
    public void dispose() {
        ((DoubleField)this.control).valueProperty().removeListener(this.doubleFieldValueListener);
        super.dispose();
    }

    @Override
    protected boolean accept(String text) {
        if (text.length() == 0) {
            return true;
        }
        if (text.matches("[0-9\\.]*")) {
            try {
                Double.parseDouble(text);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    protected void updateText() {
        this.getTextField().setText("" + ((DoubleField)this.control).getValue());
    }

    @Override
    protected void updateValue() {
        double value = ((DoubleField)this.control).getValue();
        String text = this.getTextField().getText() == null ? "" : this.getTextField().getText().trim();
        try {
            double newValue = Double.parseDouble(text);
            if (newValue != value) {
                ((DoubleField)this.control).setValue(newValue);
            }
        }
        catch (NumberFormatException ex) {
            ((DoubleField)this.control).setValue(0.0);
            Platform.runLater(DoubleFieldSkin$$Lambda$2.lambdaFactory$(this));
        }
    }

    private /* synthetic */ void lambda$updateValue$349() {
        this.getTextField().positionCaret(1);
    }

    private /* synthetic */ void lambda$new$348(Observable observable) {
        this.updateText();
    }

    static /* synthetic */ void access$lambda$0(DoubleFieldSkin doubleFieldSkin, Observable observable) {
        doubleFieldSkin.lambda$new$348(observable);
    }

    static /* synthetic */ void access$lambda$1(DoubleFieldSkin doubleFieldSkin) {
        doubleFieldSkin.lambda$updateValue$349();
    }
}

