/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.SliderBehavior;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.SliderSkin$$Lambda$1;
import com.sun.javafx.scene.control.skin.SliderSkin$$Lambda$2;
import com.sun.javafx.scene.control.skin.SliderSkin$$Lambda$3;
import com.sun.javafx.scene.control.skin.SliderSkin$$Lambda$4;
import com.sun.javafx.scene.control.skin.SliderSkin$$Lambda$5;
import javafx.animation.Transition;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Side;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.chart.NumberAxis;
import javafx.scene.control.Slider;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import javafx.util.StringConverter;

public class SliderSkin
extends BehaviorSkinBase<Slider, SliderBehavior> {
    private NumberAxis tickLine = null;
    private double trackToTickGap = 2.0;
    private boolean showTickMarks;
    private double thumbWidth;
    private double thumbHeight;
    private double trackStart;
    private double trackLength;
    private double thumbTop;
    private double thumbLeft;
    private double preDragThumbPos;
    private Point2D dragStart;
    private StackPane thumb;
    private StackPane track;
    private boolean trackClicked = false;
    StringConverter<Number> stringConverterWrapper = new StringConverter<Number>(){
        Slider slider;
        {
            this.slider = (Slider)SliderSkin.this.getSkinnable();
        }

        @Override
        public String toString(Number object) {
            return object != null ? this.slider.getLabelFormatter().toString(object.doubleValue()) : "";
        }

        @Override
        public Number fromString(String string) {
            return this.slider.getLabelFormatter().fromString(string);
        }
    };

    public SliderSkin(Slider slider) {
        super(slider, new SliderBehavior(slider));
        this.initialize();
        slider.requestLayout();
        this.registerChangeListener(slider.minProperty(), "MIN");
        this.registerChangeListener(slider.maxProperty(), "MAX");
        this.registerChangeListener(slider.valueProperty(), "VALUE");
        this.registerChangeListener(slider.orientationProperty(), "ORIENTATION");
        this.registerChangeListener(slider.showTickMarksProperty(), "SHOW_TICK_MARKS");
        this.registerChangeListener(slider.showTickLabelsProperty(), "SHOW_TICK_LABELS");
        this.registerChangeListener(slider.majorTickUnitProperty(), "MAJOR_TICK_UNIT");
        this.registerChangeListener(slider.minorTickCountProperty(), "MINOR_TICK_COUNT");
        this.registerChangeListener(slider.labelFormatterProperty(), "TICK_LABEL_FORMATTER");
    }

    private void initialize() {
        this.thumb = new StackPane(){

            @Override
            public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
                switch (attribute) {
                    case VALUE: {
                        return ((Slider)SliderSkin.this.getSkinnable()).getValue();
                    }
                }
                return super.queryAccessibleAttribute(attribute, parameters);
            }
        };
        this.thumb.getStyleClass().setAll((String[])new String[]{"thumb"});
        this.thumb.setAccessibleRole(AccessibleRole.THUMB);
        this.track = new StackPane();
        this.track.getStyleClass().setAll((String[])new String[]{"track"});
        this.getChildren().clear();
        this.getChildren().addAll((Node[])new Node[]{this.track, this.thumb});
        this.setShowTickMarks(((Slider)this.getSkinnable()).isShowTickMarks(), ((Slider)this.getSkinnable()).isShowTickLabels());
        this.track.setOnMousePressed(SliderSkin$$Lambda$1.lambdaFactory$(this));
        this.track.setOnMouseDragged(SliderSkin$$Lambda$2.lambdaFactory$(this));
        this.thumb.setOnMousePressed(SliderSkin$$Lambda$3.lambdaFactory$(this));
        this.thumb.setOnMouseReleased(SliderSkin$$Lambda$4.lambdaFactory$(this));
        this.thumb.setOnMouseDragged(SliderSkin$$Lambda$5.lambdaFactory$(this));
    }

    private void setShowTickMarks(boolean ticksVisible, boolean labelsVisible) {
        this.showTickMarks = ticksVisible || labelsVisible;
        Slider slider = (Slider)this.getSkinnable();
        if (this.showTickMarks) {
            if (this.tickLine == null) {
                this.tickLine = new NumberAxis();
                this.tickLine.setAutoRanging(false);
                this.tickLine.setSide(slider.getOrientation() == Orientation.VERTICAL ? Side.RIGHT : (slider.getOrientation() == null ? Side.RIGHT : Side.BOTTOM));
                this.tickLine.setUpperBound(slider.getMax());
                this.tickLine.setLowerBound(slider.getMin());
                this.tickLine.setTickUnit(slider.getMajorTickUnit());
                this.tickLine.setTickMarkVisible(ticksVisible);
                this.tickLine.setTickLabelsVisible(labelsVisible);
                this.tickLine.setMinorTickVisible(ticksVisible);
                this.tickLine.setMinorTickCount(Math.max(slider.getMinorTickCount(), 0) + 1);
                if (slider.getLabelFormatter() != null) {
                    this.tickLine.setTickLabelFormatter(this.stringConverterWrapper);
                }
                this.getChildren().clear();
                this.getChildren().addAll((Node[])new Node[]{this.tickLine, this.track, this.thumb});
            } else {
                this.tickLine.setTickLabelsVisible(labelsVisible);
                this.tickLine.setTickMarkVisible(ticksVisible);
                this.tickLine.setMinorTickVisible(ticksVisible);
            }
        } else {
            this.getChildren().clear();
            this.getChildren().addAll((Node[])new Node[]{this.track, this.thumb});
        }
        ((Slider)this.getSkinnable()).requestLayout();
    }

    @Override
    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        Slider slider = (Slider)this.getSkinnable();
        if ("ORIENTATION".equals(p)) {
            if (this.showTickMarks && this.tickLine != null) {
                this.tickLine.setSide(slider.getOrientation() == Orientation.VERTICAL ? Side.RIGHT : (slider.getOrientation() == null ? Side.RIGHT : Side.BOTTOM));
            }
            ((Slider)this.getSkinnable()).requestLayout();
        } else if ("VALUE".equals(p)) {
            this.positionThumb(this.trackClicked);
        } else if ("MIN".equals(p)) {
            if (this.showTickMarks && this.tickLine != null) {
                this.tickLine.setLowerBound(slider.getMin());
            }
            ((Slider)this.getSkinnable()).requestLayout();
        } else if ("MAX".equals(p)) {
            if (this.showTickMarks && this.tickLine != null) {
                this.tickLine.setUpperBound(slider.getMax());
            }
            ((Slider)this.getSkinnable()).requestLayout();
        } else if ("SHOW_TICK_MARKS".equals(p) || "SHOW_TICK_LABELS".equals(p)) {
            this.setShowTickMarks(slider.isShowTickMarks(), slider.isShowTickLabels());
        } else if ("MAJOR_TICK_UNIT".equals(p)) {
            if (this.tickLine != null) {
                this.tickLine.setTickUnit(slider.getMajorTickUnit());
                ((Slider)this.getSkinnable()).requestLayout();
            }
        } else if ("MINOR_TICK_COUNT".equals(p)) {
            if (this.tickLine != null) {
                this.tickLine.setMinorTickCount(Math.max(slider.getMinorTickCount(), 0) + 1);
                ((Slider)this.getSkinnable()).requestLayout();
            }
        } else if ("TICK_LABEL_FORMATTER".equals(p) && this.tickLine != null) {
            if (slider.getLabelFormatter() == null) {
                this.tickLine.setTickLabelFormatter(null);
            } else {
                this.tickLine.setTickLabelFormatter(this.stringConverterWrapper);
                this.tickLine.requestAxisLayout();
            }
        }
    }

    void positionThumb(boolean animate) {
        double endY;
        Slider s = (Slider)this.getSkinnable();
        if (s.getValue() > s.getMax()) {
            return;
        }
        boolean horizontal = s.getOrientation() == Orientation.HORIZONTAL;
        final double endX = horizontal ? this.trackStart + (this.trackLength * ((s.getValue() - s.getMin()) / (s.getMax() - s.getMin())) - this.thumbWidth / 2.0) : this.thumbLeft;
        double d = endY = horizontal ? this.thumbTop : this.snappedTopInset() + this.trackLength - this.trackLength * ((s.getValue() - s.getMin()) / (s.getMax() - s.getMin()));
        if (animate) {
            final double startX = this.thumb.getLayoutX();
            final double startY = this.thumb.getLayoutY();
            Transition transition = new Transition(){
                {
                    this.setCycleDuration(Duration.millis(200.0));
                }

                @Override
                protected void interpolate(double frac) {
                    if (!Double.isNaN(startX)) {
                        SliderSkin.this.thumb.setLayoutX(startX + frac * (endX - startX));
                    }
                    if (!Double.isNaN(startY)) {
                        SliderSkin.this.thumb.setLayoutY(startY + frac * (endY - startY));
                    }
                }
            };
            transition.play();
        } else {
            this.thumb.setLayoutX(endX);
            this.thumb.setLayoutY(endY);
        }
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        double trackRadius;
        this.thumbWidth = this.snapSize(this.thumb.prefWidth(-1.0));
        this.thumbHeight = this.snapSize(this.thumb.prefHeight(-1.0));
        this.thumb.resize(this.thumbWidth, this.thumbHeight);
        double d = this.track.getBackground() == null ? 0.0 : (trackRadius = this.track.getBackground().getFills().size() > 0 ? this.track.getBackground().getFills().get(0).getRadii().getTopLeftHorizontalRadius() : 0.0);
        if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
            double tickLineHeight = this.showTickMarks ? this.tickLine.prefHeight(-1.0) : 0.0;
            double trackHeight = this.snapSize(this.track.prefHeight(-1.0));
            double trackAreaHeight = Math.max(trackHeight, this.thumbHeight);
            double totalHeightNeeded = trackAreaHeight + (this.showTickMarks ? this.trackToTickGap + tickLineHeight : 0.0);
            double startY = y + (h - totalHeightNeeded) / 2.0;
            this.trackLength = this.snapSize(w - this.thumbWidth);
            this.trackStart = this.snapPosition(x + this.thumbWidth / 2.0);
            double trackTop = (int)(startY + (trackAreaHeight - trackHeight) / 2.0);
            this.thumbTop = (int)(startY + (trackAreaHeight - this.thumbHeight) / 2.0);
            this.positionThumb(false);
            this.track.resizeRelocate((int)(this.trackStart - trackRadius), trackTop, (int)(this.trackLength + trackRadius + trackRadius), trackHeight);
            if (this.showTickMarks) {
                this.tickLine.setLayoutX(this.trackStart);
                this.tickLine.setLayoutY(trackTop + trackHeight + this.trackToTickGap);
                this.tickLine.resize(this.trackLength, tickLineHeight);
                this.tickLine.requestAxisLayout();
            } else {
                if (this.tickLine != null) {
                    this.tickLine.resize(0.0, 0.0);
                    this.tickLine.requestAxisLayout();
                }
                this.tickLine = null;
            }
        } else {
            double tickLineWidth = this.showTickMarks ? this.tickLine.prefWidth(-1.0) : 0.0;
            double trackWidth = this.snapSize(this.track.prefWidth(-1.0));
            double trackAreaWidth = Math.max(trackWidth, this.thumbWidth);
            double totalWidthNeeded = trackAreaWidth + (this.showTickMarks ? this.trackToTickGap + tickLineWidth : 0.0);
            double startX = x + (w - totalWidthNeeded) / 2.0;
            this.trackLength = this.snapSize(h - this.thumbHeight);
            this.trackStart = this.snapPosition(y + this.thumbHeight / 2.0);
            double trackLeft = (int)(startX + (trackAreaWidth - trackWidth) / 2.0);
            this.thumbLeft = (int)(startX + (trackAreaWidth - this.thumbWidth) / 2.0);
            this.positionThumb(false);
            this.track.resizeRelocate(trackLeft, (int)(this.trackStart - trackRadius), trackWidth, (int)(this.trackLength + trackRadius + trackRadius));
            if (this.showTickMarks) {
                this.tickLine.setLayoutX(trackLeft + trackWidth + this.trackToTickGap);
                this.tickLine.setLayoutY(this.trackStart);
                this.tickLine.resize(tickLineWidth, this.trackLength);
                this.tickLine.requestAxisLayout();
            } else {
                if (this.tickLine != null) {
                    this.tickLine.resize(0.0, 0.0);
                    this.tickLine.requestAxisLayout();
                }
                this.tickLine = null;
            }
        }
    }

    double minTrackLength() {
        return 2.0 * this.thumb.prefWidth(-1.0);
    }

    @Override
    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        Slider s = (Slider)this.getSkinnable();
        if (s.getOrientation() == Orientation.HORIZONTAL) {
            return leftInset + this.minTrackLength() + this.thumb.minWidth(-1.0) + rightInset;
        }
        return leftInset + this.thumb.prefWidth(-1.0) + rightInset;
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        Slider s = (Slider)this.getSkinnable();
        if (s.getOrientation() == Orientation.HORIZONTAL) {
            double axisHeight = this.showTickMarks ? this.tickLine.prefHeight(-1.0) + this.trackToTickGap : 0.0;
            return topInset + this.thumb.prefHeight(-1.0) + axisHeight + bottomInset;
        }
        return topInset + this.minTrackLength() + this.thumb.prefHeight(-1.0) + bottomInset;
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        Slider s = (Slider)this.getSkinnable();
        if (s.getOrientation() == Orientation.HORIZONTAL) {
            if (this.showTickMarks) {
                return Math.max(140.0, this.tickLine.prefWidth(-1.0));
            }
            return 140.0;
        }
        double axisWidth = this.showTickMarks ? this.tickLine.prefWidth(-1.0) + this.trackToTickGap : 0.0;
        return leftInset + Math.max(this.thumb.prefWidth(-1.0), this.track.prefWidth(-1.0)) + axisWidth + rightInset;
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        Slider s = (Slider)this.getSkinnable();
        if (s.getOrientation() == Orientation.HORIZONTAL) {
            return topInset + Math.max(this.thumb.prefHeight(-1.0), this.track.prefHeight(-1.0)) + (this.showTickMarks ? this.trackToTickGap + this.tickLine.prefHeight(-1.0) : 0.0) + bottomInset;
        }
        if (this.showTickMarks) {
            return Math.max(140.0, this.tickLine.prefHeight(-1.0));
        }
        return 140.0;
    }

    @Override
    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
            return Double.MAX_VALUE;
        }
        return ((Slider)this.getSkinnable()).prefWidth(-1.0);
    }

    @Override
    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
            return ((Slider)this.getSkinnable()).prefHeight(width);
        }
        return Double.MAX_VALUE;
    }

    private /* synthetic */ void lambda$initialize$464(MouseEvent me) {
        Point2D cur = this.thumb.localToParent(me.getX(), me.getY());
        double dragPos = ((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL ? cur.getX() - this.dragStart.getX() : -(cur.getY() - this.dragStart.getY());
        ((SliderBehavior)this.getBehavior()).thumbDragged(me, this.preDragThumbPos + dragPos / this.trackLength);
    }

    private /* synthetic */ void lambda$initialize$463(MouseEvent me) {
        ((SliderBehavior)this.getBehavior()).thumbReleased(me);
    }

    private /* synthetic */ void lambda$initialize$462(MouseEvent me) {
        ((SliderBehavior)this.getBehavior()).thumbPressed(me, 0.0);
        this.dragStart = this.thumb.localToParent(me.getX(), me.getY());
        this.preDragThumbPos = (((Slider)this.getSkinnable()).getValue() - ((Slider)this.getSkinnable()).getMin()) / (((Slider)this.getSkinnable()).getMax() - ((Slider)this.getSkinnable()).getMin());
    }

    private /* synthetic */ void lambda$initialize$461(MouseEvent me) {
        if (!this.thumb.isPressed()) {
            if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
                ((SliderBehavior)this.getBehavior()).trackPress(me, me.getX() / this.trackLength);
            } else {
                ((SliderBehavior)this.getBehavior()).trackPress(me, me.getY() / this.trackLength);
            }
        }
    }

    private /* synthetic */ void lambda$initialize$460(MouseEvent me) {
        if (!this.thumb.isPressed()) {
            this.trackClicked = true;
            if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
                ((SliderBehavior)this.getBehavior()).trackPress(me, me.getX() / this.trackLength);
            } else {
                ((SliderBehavior)this.getBehavior()).trackPress(me, me.getY() / this.trackLength);
            }
            this.trackClicked = false;
        }
    }

    static /* synthetic */ void access$lambda$0(SliderSkin sliderSkin, MouseEvent mouseEvent) {
        sliderSkin.lambda$initialize$460(mouseEvent);
    }

    static /* synthetic */ void access$lambda$1(SliderSkin sliderSkin, MouseEvent mouseEvent) {
        sliderSkin.lambda$initialize$461(mouseEvent);
    }

    static /* synthetic */ void access$lambda$2(SliderSkin sliderSkin, MouseEvent mouseEvent) {
        sliderSkin.lambda$initialize$462(mouseEvent);
    }

    static /* synthetic */ void access$lambda$3(SliderSkin sliderSkin, MouseEvent mouseEvent) {
        sliderSkin.lambda$initialize$463(mouseEvent);
    }

    static /* synthetic */ void access$lambda$4(SliderSkin sliderSkin, MouseEvent mouseEvent) {
        sliderSkin.lambda$initialize$464(mouseEvent);
    }
}

