/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.scene.control.MultiplePropertyChangeListenerHandler;
import com.sun.javafx.scene.control.behavior.TabPaneBehavior;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.TabPaneSkin$$Lambda$1;
import com.sun.javafx.scene.control.skin.TabPaneSkin$$Lambda$2;
import com.sun.javafx.scene.control.skin.TabPaneSkin$$Lambda$3;
import com.sun.javafx.scene.control.skin.TabPaneSkin$$Lambda$4;
import com.sun.javafx.scene.control.skin.TabPaneSkin$$Lambda$5;
import com.sun.javafx.scene.control.skin.TabPaneSkin$TabContentRegion$$Lambda$1;
import com.sun.javafx.scene.control.skin.TabPaneSkin$TabControlButtons$$Lambda$1;
import com.sun.javafx.scene.control.skin.TabPaneSkin$TabControlButtons$$Lambda$2;
import com.sun.javafx.scene.control.skin.TabPaneSkin$TabControlButtons$$Lambda$3;
import com.sun.javafx.scene.control.skin.TabPaneSkin$TabControlButtons$$Lambda$4;
import com.sun.javafx.scene.control.skin.TabPaneSkin$TabHeaderArea$$Lambda$1;
import com.sun.javafx.scene.control.skin.TabPaneSkin$TabHeaderSkin$$Lambda$1;
import com.sun.javafx.scene.control.skin.TabPaneSkin$TabHeaderSkin$$Lambda$2;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.TraversalEngine;
import com.sun.javafx.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.DropShadow;
import javafx.scene.image.ImageView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.SwipeEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Rotate;
import javafx.util.Duration;

public class TabPaneSkin
extends BehaviorSkinBase<TabPane, TabPaneBehavior> {
    private ObjectProperty<TabAnimation> openTabAnimation = new StyleableObjectProperty<TabAnimation>(TabAnimation.GROW){

        @Override
        public CssMetaData<TabPane, TabAnimation> getCssMetaData() {
            return StyleableProperties.OPEN_TAB_ANIMATION;
        }

        @Override
        public Object getBean() {
            return TabPaneSkin.this;
        }

        @Override
        public String getName() {
            return "openTabAnimation";
        }
    };
    private ObjectProperty<TabAnimation> closeTabAnimation = new StyleableObjectProperty<TabAnimation>(TabAnimation.GROW){

        @Override
        public CssMetaData<TabPane, TabAnimation> getCssMetaData() {
            return StyleableProperties.CLOSE_TAB_ANIMATION;
        }

        @Override
        public Object getBean() {
            return TabPaneSkin.this;
        }

        @Override
        public String getName() {
            return "closeTabAnimation";
        }
    };
    private static final double ANIMATION_SPEED = 150.0;
    private static final int SPACER = 10;
    private TabHeaderArea tabHeaderArea;
    private ObservableList<TabContentRegion> tabContentRegions;
    private Rectangle clipRect;
    private Rectangle tabHeaderAreaClipRect;
    private Tab selectedTab;
    private boolean isSelectingTab;
    private double maxw = 0.0;
    private double maxh = 0.0;
    static int CLOSE_BTN_SIZE = 16;
    private static final PseudoClass SELECTED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("selected");
    private static final PseudoClass TOP_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("top");
    private static final PseudoClass BOTTOM_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("bottom");
    private static final PseudoClass LEFT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("left");
    private static final PseudoClass RIGHT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("right");
    private static final PseudoClass DISABLED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("disabled");

    private static int getRotation(Side pos) {
        switch (pos) {
            case TOP: {
                return 0;
            }
            case BOTTOM: {
                return 180;
            }
            case LEFT: {
                return -90;
            }
            case RIGHT: {
                return 90;
            }
        }
        return 0;
    }

    private static Node clone(Node n) {
        if (n == null) {
            return null;
        }
        if (n instanceof ImageView) {
            ImageView iv = (ImageView)n;
            ImageView imageview = new ImageView();
            imageview.setImage(iv.getImage());
            return imageview;
        }
        if (n instanceof Label) {
            Label l = (Label)n;
            Label label = new Label(l.getText(), l.getGraphic());
            return label;
        }
        return null;
    }

    public TabPaneSkin(TabPane tabPane) {
        super(tabPane, new TabPaneBehavior(tabPane));
        this.clipRect = new Rectangle(tabPane.getWidth(), tabPane.getHeight());
        ((TabPane)this.getSkinnable()).setClip(this.clipRect);
        this.tabContentRegions = FXCollections.observableArrayList();
        for (Tab tab : ((TabPane)this.getSkinnable()).getTabs()) {
            this.addTabContent(tab);
        }
        this.tabHeaderAreaClipRect = new Rectangle();
        this.tabHeaderArea = new TabHeaderArea();
        this.tabHeaderArea.setClip(this.tabHeaderAreaClipRect);
        this.getChildren().add(this.tabHeaderArea);
        if (((TabPane)this.getSkinnable()).getTabs().size() == 0) {
            this.tabHeaderArea.setVisible(false);
        }
        this.initializeTabListener();
        this.registerChangeListener(tabPane.getSelectionModel().selectedItemProperty(), "SELECTED_TAB");
        this.registerChangeListener(tabPane.sideProperty(), "SIDE");
        this.registerChangeListener(tabPane.widthProperty(), "WIDTH");
        this.registerChangeListener(tabPane.heightProperty(), "HEIGHT");
        this.selectedTab = (Tab)((TabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        if (this.selectedTab == null && ((TabPane)this.getSkinnable()).getSelectionModel().getSelectedIndex() != -1) {
            ((TabPane)this.getSkinnable()).getSelectionModel().select(((TabPane)this.getSkinnable()).getSelectionModel().getSelectedIndex());
            this.selectedTab = (Tab)((TabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        }
        if (this.selectedTab == null) {
            ((TabPane)this.getSkinnable()).getSelectionModel().selectFirst();
        }
        this.selectedTab = (Tab)((TabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        this.isSelectingTab = false;
        this.initializeSwipeHandlers();
    }

    public StackPane getSelectedTabContentRegion() {
        for (TabContentRegion contentRegion : this.tabContentRegions) {
            if (!contentRegion.getTab().equals(this.selectedTab)) continue;
            return contentRegion;
        }
        return null;
    }

    @Override
    protected void handleControlPropertyChanged(String property) {
        super.handleControlPropertyChanged(property);
        if ("SELECTED_TAB".equals(property)) {
            this.isSelectingTab = true;
            this.selectedTab = (Tab)((TabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
            ((TabPane)this.getSkinnable()).requestLayout();
        } else if ("SIDE".equals(property)) {
            this.updateTabPosition();
        } else if ("WIDTH".equals(property)) {
            this.clipRect.setWidth(((TabPane)this.getSkinnable()).getWidth());
        } else if ("HEIGHT".equals(property)) {
            this.clipRect.setHeight(((TabPane)this.getSkinnable()).getHeight());
        }
    }

    private void removeTabs(List<? extends Tab> removedList) {
        for (Tab tab : removedList) {
            this.stopCurrentAnimation(tab);
            TabHeaderSkin tabRegion = this.tabHeaderArea.getTabHeaderSkin(tab);
            if (tabRegion == null) continue;
            tabRegion.isClosing = true;
            tabRegion.removeListeners(tab);
            this.removeTabContent(tab);
            ContextMenu popupMenu = this.tabHeaderArea.controlButtons.popup;
            TabMenuItem tabItem = null;
            if (popupMenu != null) {
                MenuItem item;
                Iterator iterator = popupMenu.getItems().iterator();
                while (iterator.hasNext() && tab != (tabItem = (TabMenuItem)(item = (MenuItem)iterator.next())).getTab()) {
                    tabItem = null;
                }
            }
            if (tabItem != null) {
                tabItem.dispose();
                popupMenu.getItems().remove(tabItem);
            }
            EventHandler cleanup = TabPaneSkin$$Lambda$1.lambdaFactory$(this, tabRegion, tab);
            if (this.closeTabAnimation.get() == TabAnimation.GROW) {
                tabRegion.animationState = TabAnimationState.HIDING;
                Timeline closedTabTimeline = tabRegion.currentAnimation = this.createTimeline(tabRegion, Duration.millis(150.0), 0.0, cleanup);
                closedTabTimeline.play();
                continue;
            }
            cleanup.handle(null);
        }
    }

    private void stopCurrentAnimation(Tab tab) {
        Timeline timeline;
        TabHeaderSkin tabRegion = this.tabHeaderArea.getTabHeaderSkin(tab);
        if (tabRegion != null && (timeline = tabRegion.currentAnimation) != null && timeline.getStatus() == Animation.Status.RUNNING) {
            timeline.getOnFinished().handle(null);
            timeline.stop();
            tabRegion.currentAnimation = null;
        }
    }

    private void addTabs(List<? extends Tab> addedList, int from) {
        int i = 0;
        ArrayList<Node> headers = new ArrayList<Node>(this.tabHeaderArea.headersRegion.getChildren());
        for (Node node : headers) {
            TabHeaderSkin header = (TabHeaderSkin)node;
            if (header.animationState != TabAnimationState.HIDING) continue;
            this.stopCurrentAnimation(header.tab);
        }
        for (Tab tab : addedList) {
            this.stopCurrentAnimation(tab);
            if (!this.tabHeaderArea.isVisible()) {
                this.tabHeaderArea.setVisible(true);
            }
            int index = from + i++;
            this.tabHeaderArea.addTab(tab, index);
            this.addTabContent(tab);
            TabHeaderSkin tabRegion = this.tabHeaderArea.getTabHeaderSkin(tab);
            if (tabRegion == null) continue;
            if (this.openTabAnimation.get() == TabAnimation.GROW) {
                tabRegion.animationState = TabAnimationState.SHOWING;
                tabRegion.animationTransition.setValue(0.0);
                tabRegion.setVisible(true);
                tabRegion.currentAnimation = this.createTimeline(tabRegion, Duration.millis(150.0), 1.0, TabPaneSkin$$Lambda$2.lambdaFactory$(tabRegion));
                tabRegion.currentAnimation.play();
                continue;
            }
            tabRegion.setVisible(true);
            tabRegion.inner.requestLayout();
        }
    }

    private void initializeTabListener() {
        ((TabPane)this.getSkinnable()).getTabs().addListener(TabPaneSkin$$Lambda$3.lambdaFactory$(this));
    }

    private void addTabContent(Tab tab) {
        TabContentRegion tabContentRegion = new TabContentRegion(tab);
        tabContentRegion.setClip(new Rectangle());
        this.tabContentRegions.add(tabContentRegion);
        this.getChildren().add(0, tabContentRegion);
    }

    private void removeTabContent(Tab tab) {
        for (TabContentRegion contentRegion : this.tabContentRegions) {
            if (!contentRegion.getTab().equals(tab)) continue;
            contentRegion.removeListeners(tab);
            this.getChildren().remove(contentRegion);
            this.tabContentRegions.remove(contentRegion);
            break;
        }
    }

    private void updateTabPosition() {
        this.tabHeaderArea.setScrollOffset(0.0);
        ((TabPane)this.getSkinnable()).applyCss();
        ((TabPane)this.getSkinnable()).requestLayout();
    }

    private Timeline createTimeline(TabHeaderSkin tabRegion, Duration duration, double endValue, EventHandler<ActionEvent> func) {
        Timeline timeline = new Timeline();
        timeline.setCycleCount(1);
        KeyValue keyValue = new KeyValue(tabRegion.animationTransition, endValue, Interpolator.LINEAR);
        timeline.getKeyFrames().clear();
        timeline.getKeyFrames().add(new KeyFrame(duration, keyValue));
        timeline.setOnFinished(func);
        return timeline;
    }

    private boolean isHorizontal() {
        Side tabPosition = ((TabPane)this.getSkinnable()).getSide();
        return Side.TOP.equals((Object)tabPosition) || Side.BOTTOM.equals((Object)tabPosition);
    }

    private void initializeSwipeHandlers() {
        if (IS_TOUCH_SUPPORTED) {
            ((TabPane)this.getSkinnable()).addEventHandler(SwipeEvent.SWIPE_LEFT, TabPaneSkin$$Lambda$4.lambdaFactory$(this));
            ((TabPane)this.getSkinnable()).addEventHandler(SwipeEvent.SWIPE_RIGHT, TabPaneSkin$$Lambda$5.lambdaFactory$(this));
        }
    }

    private boolean isFloatingStyleClass() {
        return ((TabPane)this.getSkinnable()).getStyleClass().contains("floating");
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        for (TabContentRegion contentRegion : this.tabContentRegions) {
            this.maxw = Math.max(this.maxw, this.snapSize(contentRegion.prefWidth(-1.0)));
        }
        boolean isHorizontal = this.isHorizontal();
        double tabHeaderAreaSize = this.snapSize(isHorizontal ? this.tabHeaderArea.prefWidth(-1.0) : this.tabHeaderArea.prefHeight(-1.0));
        double prefWidth = isHorizontal ? Math.max(this.maxw, tabHeaderAreaSize) : this.maxw + tabHeaderAreaSize;
        return this.snapSize(prefWidth) + rightInset + leftInset;
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        for (TabContentRegion contentRegion : this.tabContentRegions) {
            this.maxh = Math.max(this.maxh, this.snapSize(contentRegion.prefHeight(-1.0)));
        }
        boolean isHorizontal = this.isHorizontal();
        double tabHeaderAreaSize = this.snapSize(isHorizontal ? this.tabHeaderArea.prefHeight(-1.0) : this.tabHeaderArea.prefWidth(-1.0));
        double prefHeight = isHorizontal ? this.maxh + this.snapSize(tabHeaderAreaSize) : Math.max(this.maxh, tabHeaderAreaSize);
        return this.snapSize(prefHeight) + topInset + bottomInset;
    }

    @Override
    public double computeBaselineOffset(double topInset, double rightInset, double bottomInset, double leftInset) {
        Side tabPosition = ((TabPane)this.getSkinnable()).getSide();
        if (tabPosition == Side.TOP) {
            return this.tabHeaderArea.getBaselineOffset() + topInset;
        }
        return 0.0;
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        double tabsStartY;
        TabPane tabPane = (TabPane)this.getSkinnable();
        Side tabPosition = tabPane.getSide();
        double headerHeight = this.snapSize(this.tabHeaderArea.prefHeight(-1.0));
        double tabsStartX = tabPosition.equals((Object)Side.RIGHT) ? x + w - headerHeight : x;
        double d = tabsStartY = tabPosition.equals((Object)Side.BOTTOM) ? y + h - headerHeight : y;
        if (tabPosition == Side.TOP) {
            this.tabHeaderArea.resize(w, headerHeight);
            this.tabHeaderArea.relocate(tabsStartX, tabsStartY);
            this.tabHeaderArea.getTransforms().clear();
            this.tabHeaderArea.getTransforms().add(new Rotate(TabPaneSkin.getRotation(Side.TOP)));
        } else if (tabPosition == Side.BOTTOM) {
            this.tabHeaderArea.resize(w, headerHeight);
            this.tabHeaderArea.relocate(w, tabsStartY - headerHeight);
            this.tabHeaderArea.getTransforms().clear();
            this.tabHeaderArea.getTransforms().add(new Rotate(TabPaneSkin.getRotation(Side.BOTTOM), 0.0, headerHeight));
        } else if (tabPosition == Side.LEFT) {
            this.tabHeaderArea.resize(h, headerHeight);
            this.tabHeaderArea.relocate(tabsStartX + headerHeight, h - headerHeight);
            this.tabHeaderArea.getTransforms().clear();
            this.tabHeaderArea.getTransforms().add(new Rotate(TabPaneSkin.getRotation(Side.LEFT), 0.0, headerHeight));
        } else if (tabPosition == Side.RIGHT) {
            this.tabHeaderArea.resize(h, headerHeight);
            this.tabHeaderArea.relocate(tabsStartX, y - headerHeight);
            this.tabHeaderArea.getTransforms().clear();
            this.tabHeaderArea.getTransforms().add(new Rotate(TabPaneSkin.getRotation(Side.RIGHT), 0.0, headerHeight));
        }
        this.tabHeaderAreaClipRect.setX(0.0);
        this.tabHeaderAreaClipRect.setY(0.0);
        if (this.isHorizontal()) {
            this.tabHeaderAreaClipRect.setWidth(w);
        } else {
            this.tabHeaderAreaClipRect.setWidth(h);
        }
        this.tabHeaderAreaClipRect.setHeight(headerHeight);
        double contentStartX = 0.0;
        double contentStartY = 0.0;
        if (tabPosition == Side.TOP) {
            contentStartX = x;
            contentStartY = y + headerHeight;
            if (this.isFloatingStyleClass()) {
                contentStartY -= 1.0;
            }
        } else if (tabPosition == Side.BOTTOM) {
            contentStartX = x;
            contentStartY = y;
            if (this.isFloatingStyleClass()) {
                contentStartY = 1.0;
            }
        } else if (tabPosition == Side.LEFT) {
            contentStartX = x + headerHeight;
            contentStartY = y;
            if (this.isFloatingStyleClass()) {
                contentStartX -= 1.0;
            }
        } else if (tabPosition == Side.RIGHT) {
            contentStartX = x;
            contentStartY = y;
            if (this.isFloatingStyleClass()) {
                contentStartX = 1.0;
            }
        }
        double contentWidth = w - (this.isHorizontal() ? 0.0 : headerHeight);
        double contentHeight = h - (this.isHorizontal() ? headerHeight : 0.0);
        int max = this.tabContentRegions.size();
        for (int i = 0; i < max; ++i) {
            TabContentRegion tabContent = (TabContentRegion)this.tabContentRegions.get(i);
            tabContent.setAlignment(Pos.TOP_LEFT);
            if (tabContent.getClip() != null) {
                ((Rectangle)tabContent.getClip()).setWidth(contentWidth);
                ((Rectangle)tabContent.getClip()).setHeight(contentHeight);
            }
            tabContent.resize(contentWidth, contentHeight);
            tabContent.relocate(contentStartX, contentStartY);
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TabPaneSkin.getClassCssMetaData();
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case FOCUS_ITEM: {
                return this.tabHeaderArea.getTabHeaderSkin(this.selectedTab);
            }
            case ITEM_COUNT: {
                return this.tabHeaderArea.headersRegion.getChildren().size();
            }
            case ITEM_AT_INDEX: {
                Integer index = (Integer)parameters[0];
                if (index == null) {
                    return null;
                }
                return this.tabHeaderArea.headersRegion.getChildren().get(index);
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    private /* synthetic */ void lambda$initializeSwipeHandlers$487(SwipeEvent t) {
        ((TabPaneBehavior)this.getBehavior()).selectPreviousTab();
    }

    private /* synthetic */ void lambda$initializeSwipeHandlers$486(SwipeEvent t) {
        ((TabPaneBehavior)this.getBehavior()).selectNextTab();
    }

    private /* synthetic */ void lambda$initializeTabListener$485(ListChangeListener.Change c) {
        ArrayList tabsToRemove = new ArrayList();
        ArrayList tabsToAdd = new ArrayList();
        int insertPos = -1;
        while (c.next()) {
            if (c.wasPermutated()) {
                TabPane tabPane = (TabPane)this.getSkinnable();
                ObservableList<Tab> tabs = tabPane.getTabs();
                int size = c.getTo() - c.getFrom();
                Tab selTab = (Tab)tabPane.getSelectionModel().getSelectedItem();
                ArrayList permutatedTabs = new ArrayList(size);
                ((TabPane)this.getSkinnable()).getSelectionModel().clearSelection();
                TabAnimation prevOpenAnimation = (TabAnimation)((Object)this.openTabAnimation.get());
                TabAnimation prevCloseAnimation = (TabAnimation)((Object)this.closeTabAnimation.get());
                this.openTabAnimation.set(TabAnimation.NONE);
                this.closeTabAnimation.set(TabAnimation.NONE);
                for (int i = c.getFrom(); i < c.getTo(); ++i) {
                    permutatedTabs.add(tabs.get(i));
                }
                this.removeTabs(permutatedTabs);
                this.addTabs(permutatedTabs, c.getFrom());
                this.openTabAnimation.set(prevOpenAnimation);
                this.closeTabAnimation.set(prevCloseAnimation);
                ((TabPane)this.getSkinnable()).getSelectionModel().select(selTab);
            }
            if (c.wasRemoved()) {
                tabsToRemove.addAll(c.getRemoved());
            }
            if (!c.wasAdded()) continue;
            tabsToAdd.addAll(c.getAddedSubList());
            insertPos = c.getFrom();
        }
        tabsToRemove.removeAll(tabsToAdd);
        this.removeTabs(tabsToRemove);
        if (!tabsToAdd.isEmpty()) {
            for (TabContentRegion tabContentRegion : this.tabContentRegions) {
                Tab tab = tabContentRegion.getTab();
                TabHeaderSkin tabHeader = this.tabHeaderArea.getTabHeaderSkin(tab);
                if (tabHeader.isClosing || !tabsToAdd.contains(tabContentRegion.getTab())) continue;
                tabsToAdd.remove(tabContentRegion.getTab());
            }
            this.addTabs(tabsToAdd, insertPos == -1 ? this.tabContentRegions.size() : insertPos);
        }
        ((TabPane)this.getSkinnable()).requestLayout();
    }

    private static /* synthetic */ void lambda$addTabs$484(TabHeaderSkin tabRegion, ActionEvent event) {
        tabRegion.animationState = TabAnimationState.NONE;
        tabRegion.setVisible(true);
        tabRegion.inner.requestLayout();
    }

    private /* synthetic */ void lambda$removeTabs$483(TabHeaderSkin tabRegion, Tab tab, ActionEvent ae) {
        tabRegion.animationState = TabAnimationState.NONE;
        this.tabHeaderArea.removeTab(tab);
        this.tabHeaderArea.requestLayout();
        if (((TabPane)this.getSkinnable()).getTabs().isEmpty()) {
            this.tabHeaderArea.setVisible(false);
        }
    }

    static /* synthetic */ void access$lambda$0(TabPaneSkin tabPaneSkin, TabHeaderSkin tabHeaderSkin, Tab tab, ActionEvent actionEvent) {
        tabPaneSkin.lambda$removeTabs$483(tabHeaderSkin, tab, actionEvent);
    }

    static /* synthetic */ void access$lambda$1(TabHeaderSkin tabHeaderSkin, ActionEvent actionEvent) {
        TabPaneSkin.lambda$addTabs$484(tabHeaderSkin, actionEvent);
    }

    static /* synthetic */ void access$lambda$2(TabPaneSkin tabPaneSkin, ListChangeListener.Change change) {
        tabPaneSkin.lambda$initializeTabListener$485(change);
    }

    static /* synthetic */ void access$lambda$3(TabPaneSkin tabPaneSkin, SwipeEvent swipeEvent) {
        tabPaneSkin.lambda$initializeSwipeHandlers$486(swipeEvent);
    }

    static /* synthetic */ void access$lambda$4(TabPaneSkin tabPaneSkin, SwipeEvent swipeEvent) {
        tabPaneSkin.lambda$initializeSwipeHandlers$487(swipeEvent);
    }

    class TabMenuItem
    extends RadioMenuItem {
        Tab tab;
        private InvalidationListener disableListener;
        private WeakInvalidationListener weakDisableListener;

        public TabMenuItem(Tab tab) {
            super(tab.getText(), TabPaneSkin.clone(tab.getGraphic()));
            this.disableListener = new InvalidationListener(){

                @Override
                public void invalidated(Observable o) {
                    TabMenuItem.this.setDisable(TabMenuItem.this.tab.isDisable());
                }
            };
            this.weakDisableListener = new WeakInvalidationListener(this.disableListener);
            this.tab = tab;
            this.setDisable(tab.isDisable());
            tab.disableProperty().addListener(this.weakDisableListener);
            this.textProperty().bind(tab.textProperty());
        }

        public Tab getTab() {
            return this.tab;
        }

        public void dispose() {
            this.tab.disableProperty().removeListener(this.weakDisableListener);
        }
    }

    class TabControlButtons
    extends StackPane {
        private StackPane inner;
        private StackPane downArrow;
        private Pane downArrowBtn;
        private boolean showControlButtons;
        private ContextMenu popup;
        private boolean showTabsMenu = false;

        public TabControlButtons() {
            this.getStyleClass().setAll((String[])new String[]{"control-buttons-tab"});
            TabPane tabPane = (TabPane)TabPaneSkin.this.getSkinnable();
            this.downArrowBtn = new Pane();
            this.downArrowBtn.getStyleClass().setAll((String[])new String[]{"tab-down-button"});
            this.downArrowBtn.setVisible(this.isShowTabsMenu());
            this.downArrow = new StackPane();
            this.downArrow.setManaged(false);
            this.downArrow.getStyleClass().setAll((String[])new String[]{"arrow"});
            this.downArrow.setRotate(tabPane.getSide().equals((Object)Side.BOTTOM) ? 180.0 : 0.0);
            this.downArrowBtn.getChildren().add(this.downArrow);
            this.downArrowBtn.setOnMouseClicked(TabPaneSkin$TabControlButtons$$Lambda$1.lambdaFactory$(this));
            this.setupPopupMenu();
            this.inner = new StackPane(){

                @Override
                protected double computePrefWidth(double height) {
                    double maxArrowWidth = !TabControlButtons.this.isShowTabsMenu() ? 0.0 : this.snapSize(TabControlButtons.this.downArrow.prefWidth(this.getHeight())) + this.snapSize(TabControlButtons.this.downArrowBtn.prefWidth(this.getHeight()));
                    double pw = 0.0;
                    if (TabControlButtons.this.isShowTabsMenu()) {
                        pw += maxArrowWidth;
                    }
                    if (pw > 0.0) {
                        pw += this.snappedLeftInset() + this.snappedRightInset();
                    }
                    return pw;
                }

                @Override
                protected double computePrefHeight(double width) {
                    double height = 0.0;
                    if (TabControlButtons.this.isShowTabsMenu()) {
                        height = Math.max(height, this.snapSize(TabControlButtons.this.downArrowBtn.prefHeight(width)));
                    }
                    if (height > 0.0) {
                        height += this.snappedTopInset() + this.snappedBottomInset();
                    }
                    return height;
                }

                @Override
                protected void layoutChildren() {
                    if (TabControlButtons.this.isShowTabsMenu()) {
                        double x = 0.0;
                        double y = this.snappedTopInset();
                        double w = this.snapSize(this.getWidth()) - x + this.snappedLeftInset();
                        double h = this.snapSize(this.getHeight()) - y + this.snappedBottomInset();
                        this.positionArrow(TabControlButtons.this.downArrowBtn, TabControlButtons.this.downArrow, x, y, w, h);
                    }
                }

                private void positionArrow(Pane btn, StackPane arrow, double x, double y, double width, double height) {
                    btn.resize(width, height);
                    this.positionInArea(btn, x, y, width, height, 0.0, HPos.CENTER, VPos.CENTER);
                    double arrowWidth = this.snapSize(arrow.prefWidth(-1.0));
                    double arrowHeight = this.snapSize(arrow.prefHeight(-1.0));
                    arrow.resize(arrowWidth, arrowHeight);
                    this.positionInArea(arrow, btn.snappedLeftInset(), btn.snappedTopInset(), width - btn.snappedLeftInset() - btn.snappedRightInset(), height - btn.snappedTopInset() - btn.snappedBottomInset(), 0.0, HPos.CENTER, VPos.CENTER);
                }
            };
            this.inner.getStyleClass().add("container");
            this.inner.getChildren().add(this.downArrowBtn);
            this.getChildren().add(this.inner);
            tabPane.sideProperty().addListener(TabPaneSkin$TabControlButtons$$Lambda$2.lambdaFactory$(this));
            tabPane.getTabs().addListener(TabPaneSkin$TabControlButtons$$Lambda$3.lambdaFactory$(this));
            this.showControlButtons = false;
            if (this.isShowTabsMenu()) {
                this.showControlButtons = true;
                this.requestLayout();
            }
            this.getProperties().put(ContextMenu.class, this.popup);
        }

        private void showTabsMenu(boolean value) {
            boolean wasTabsMenuShowing = this.isShowTabsMenu();
            this.showTabsMenu = value;
            if (this.showTabsMenu && !wasTabsMenuShowing) {
                this.downArrowBtn.setVisible(true);
                this.showControlButtons = true;
                this.inner.requestLayout();
                TabPaneSkin.this.tabHeaderArea.requestLayout();
            } else if (!this.showTabsMenu && wasTabsMenuShowing) {
                this.hideControlButtons();
            }
        }

        private boolean isShowTabsMenu() {
            return this.showTabsMenu;
        }

        @Override
        protected double computePrefWidth(double height) {
            double pw = this.snapSize(this.inner.prefWidth(height));
            if (pw > 0.0) {
                pw += this.snappedLeftInset() + this.snappedRightInset();
            }
            return pw;
        }

        @Override
        protected double computePrefHeight(double width) {
            return Math.max(((TabPane)TabPaneSkin.this.getSkinnable()).getTabMinHeight(), this.snapSize(this.inner.prefHeight(width))) + this.snappedTopInset() + this.snappedBottomInset();
        }

        @Override
        protected void layoutChildren() {
            double x = this.snappedLeftInset();
            double y = this.snappedTopInset();
            double w = this.snapSize(this.getWidth()) - x + this.snappedRightInset();
            double h = this.snapSize(this.getHeight()) - y + this.snappedBottomInset();
            if (this.showControlButtons) {
                this.showControlButtons();
                this.showControlButtons = false;
            }
            this.inner.resize(w, h);
            this.positionInArea(this.inner, x, y, w, h, 0.0, HPos.CENTER, VPos.BOTTOM);
        }

        private void showControlButtons() {
            this.setVisible(true);
            if (this.popup == null) {
                this.setupPopupMenu();
            }
        }

        private void hideControlButtons() {
            if (this.isShowTabsMenu()) {
                this.showControlButtons = true;
            } else {
                this.setVisible(false);
                this.popup.getItems().clear();
                this.popup = null;
            }
            this.requestLayout();
        }

        private void setupPopupMenu() {
            if (this.popup == null) {
                this.popup = new ContextMenu();
            }
            this.popup.getItems().clear();
            ToggleGroup group = new ToggleGroup();
            ObservableList<TabMenuItem> menuitems = FXCollections.observableArrayList();
            for (Tab tab : ((TabPane)TabPaneSkin.this.getSkinnable()).getTabs()) {
                TabMenuItem item = new TabMenuItem(tab);
                item.setToggleGroup(group);
                item.setOnAction(TabPaneSkin$TabControlButtons$$Lambda$4.lambdaFactory$(this, tab));
                menuitems.add(item);
            }
            this.popup.getItems().addAll((Collection<MenuItem>)menuitems);
        }

        private void showPopupMenu() {
            for (MenuItem mi : this.popup.getItems()) {
                TabMenuItem tmi = (TabMenuItem)mi;
                if (!TabPaneSkin.this.selectedTab.equals(tmi.getTab())) continue;
                tmi.setSelected(true);
                break;
            }
            this.popup.show(this.downArrowBtn, Side.BOTTOM, 0.0, 0.0);
        }

        private /* synthetic */ void lambda$setupPopupMenu$495(Tab tab, ActionEvent t) {
            ((TabPane)TabPaneSkin.this.getSkinnable()).getSelectionModel().select(tab);
        }

        private /* synthetic */ void lambda$new$494(ListChangeListener.Change c) {
            this.setupPopupMenu();
        }

        private /* synthetic */ void lambda$new$493(Observable valueModel) {
            Side tabPosition = ((TabPane)TabPaneSkin.this.getSkinnable()).getSide();
            this.downArrow.setRotate(tabPosition.equals((Object)Side.BOTTOM) ? 180.0 : 0.0);
        }

        private /* synthetic */ void lambda$new$492(MouseEvent me) {
            this.showPopupMenu();
        }

        static /* synthetic */ void access$lambda$0(TabControlButtons tabControlButtons, MouseEvent mouseEvent) {
            tabControlButtons.lambda$new$492(mouseEvent);
        }

        static /* synthetic */ void access$lambda$1(TabControlButtons tabControlButtons, Observable observable) {
            tabControlButtons.lambda$new$493(observable);
        }

        static /* synthetic */ void access$lambda$2(TabControlButtons tabControlButtons, ListChangeListener.Change change) {
            tabControlButtons.lambda$new$494(change);
        }

        static /* synthetic */ void access$lambda$3(TabControlButtons tabControlButtons, Tab tab, ActionEvent actionEvent) {
            tabControlButtons.lambda$setupPopupMenu$495(tab, actionEvent);
        }
    }

    class TabContentRegion
    extends StackPane {
        private TraversalEngine engine;
        private Direction direction = Direction.NEXT;
        private Tab tab;
        private InvalidationListener tabContentListener = TabPaneSkin$TabContentRegion$$Lambda$1.lambdaFactory$(this);
        private InvalidationListener tabSelectedListener = new InvalidationListener(){

            @Override
            public void invalidated(Observable valueModel) {
                TabContentRegion.this.setVisible(TabContentRegion.this.tab.isSelected());
            }
        };
        private WeakInvalidationListener weakTabContentListener = new WeakInvalidationListener(this.tabContentListener);
        private WeakInvalidationListener weakTabSelectedListener = new WeakInvalidationListener(this.tabSelectedListener);

        public Tab getTab() {
            return this.tab;
        }

        public TabContentRegion(Tab tab) {
            this.getStyleClass().setAll((String[])new String[]{"tab-content-area"});
            this.setManaged(false);
            this.tab = tab;
            this.updateContent();
            this.setVisible(tab.isSelected());
            tab.selectedProperty().addListener(this.weakTabSelectedListener);
            tab.contentProperty().addListener(this.weakTabContentListener);
        }

        private void updateContent() {
            Node newContent = this.getTab().getContent();
            if (newContent == null) {
                this.getChildren().clear();
            } else {
                this.getChildren().setAll((Node[])new Node[]{newContent});
            }
        }

        private void removeListeners(Tab tab) {
            tab.selectedProperty().removeListener(this.weakTabSelectedListener);
            tab.contentProperty().removeListener(this.weakTabContentListener);
        }

        private /* synthetic */ void lambda$new$491(Observable valueModel) {
            this.updateContent();
        }

        static /* synthetic */ void access$lambda$0(TabContentRegion tabContentRegion, Observable observable) {
            tabContentRegion.lambda$new$491(observable);
        }
    }

    class TabHeaderSkin
    extends StackPane {
        private final Tab tab;
        private Label label;
        private StackPane closeBtn;
        private StackPane inner;
        private Tooltip oldTooltip;
        private Tooltip tooltip;
        private Rectangle clip;
        private boolean isClosing = false;
        private MultiplePropertyChangeListenerHandler listener = new MultiplePropertyChangeListenerHandler(TabPaneSkin$TabHeaderSkin$$Lambda$1.lambdaFactory$(this));
        private final ListChangeListener<String> styleClassListener = new ListChangeListener<String>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends String> c) {
                TabHeaderSkin.this.getStyleClass().setAll((Collection<String>)TabHeaderSkin.this.tab.getStyleClass());
            }
        };
        private final WeakListChangeListener<String> weakStyleClassListener = new WeakListChangeListener<String>(this.styleClassListener);
        private final DoubleProperty animationTransition = new SimpleDoubleProperty(this, "animationTransition", 1.0){

            @Override
            protected void invalidated() {
                TabHeaderSkin.this.requestLayout();
            }
        };
        private TabAnimationState animationState = TabAnimationState.NONE;
        private Timeline currentAnimation;

        public Tab getTab() {
            return this.tab;
        }

        public TabHeaderSkin(Tab tab) {
            this.getStyleClass().setAll((Collection<String>)tab.getStyleClass());
            this.setId(tab.getId());
            this.setStyle(tab.getStyle());
            this.setAccessibleRole(AccessibleRole.TAB_ITEM);
            this.tab = tab;
            this.clip = new Rectangle();
            this.setClip(this.clip);
            this.label = new Label(tab.getText(), tab.getGraphic());
            this.label.getStyleClass().setAll((String[])new String[]{"tab-label"});
            this.closeBtn = new StackPane(){

                @Override
                protected double computePrefWidth(double h) {
                    return CLOSE_BTN_SIZE;
                }

                @Override
                protected double computePrefHeight(double w) {
                    return CLOSE_BTN_SIZE;
                }

                @Override
                public void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
                    switch (action) {
                        case FIRE: {
                            Tab tab = TabHeaderSkin.this.getTab();
                            TabPaneBehavior behavior = (TabPaneBehavior)TabPaneSkin.this.getBehavior();
                            if (!behavior.canCloseTab(tab)) break;
                            behavior.closeTab(tab);
                            this.setOnMousePressed(null);
                        }
                    }
                    super.executeAccessibleAction(action, parameters);
                }
            };
            this.closeBtn.setAccessibleRole(AccessibleRole.BUTTON);
            this.closeBtn.setAccessibleText(ControlResources.getString("Accessibility.title.TabPane.CloseButton"));
            this.closeBtn.getStyleClass().setAll((String[])new String[]{"tab-close-button"});
            this.closeBtn.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent me) {
                    Tab tab = TabHeaderSkin.this.getTab();
                    TabPaneBehavior behavior = (TabPaneBehavior)TabPaneSkin.this.getBehavior();
                    if (behavior.canCloseTab(tab)) {
                        behavior.closeTab(tab);
                        TabHeaderSkin.this.setOnMousePressed(null);
                    }
                }
            });
            this.updateGraphicRotation();
            final Region focusIndicator = new Region();
            focusIndicator.setMouseTransparent(true);
            focusIndicator.getStyleClass().add("focus-indicator");
            this.inner = new StackPane(){

                @Override
                protected void layoutChildren() {
                    TabPane skinnable = (TabPane)TabPaneSkin.this.getSkinnable();
                    double paddingTop = this.snappedTopInset();
                    double paddingRight = this.snappedRightInset();
                    double paddingBottom = this.snappedBottomInset();
                    double paddingLeft = this.snappedLeftInset();
                    double w = this.getWidth() - (paddingLeft + paddingRight);
                    double h = this.getHeight() - (paddingTop + paddingBottom);
                    double prefLabelWidth = this.snapSize(TabHeaderSkin.this.label.prefWidth(-1.0));
                    double prefLabelHeight = this.snapSize(TabHeaderSkin.this.label.prefHeight(-1.0));
                    double closeBtnWidth = TabHeaderSkin.this.showCloseButton() ? this.snapSize(TabHeaderSkin.this.closeBtn.prefWidth(-1.0)) : 0.0;
                    double closeBtnHeight = TabHeaderSkin.this.showCloseButton() ? this.snapSize(TabHeaderSkin.this.closeBtn.prefHeight(-1.0)) : 0.0;
                    double minWidth = this.snapSize(skinnable.getTabMinWidth());
                    double maxWidth = this.snapSize(skinnable.getTabMaxWidth());
                    double maxHeight = this.snapSize(skinnable.getTabMaxHeight());
                    double labelAreaWidth = prefLabelWidth;
                    double labelWidth = prefLabelWidth;
                    double labelHeight = prefLabelHeight;
                    double childrenWidth = labelAreaWidth + closeBtnWidth;
                    double childrenHeight = Math.max(labelHeight, closeBtnHeight);
                    if (childrenWidth > maxWidth && maxWidth != Double.MAX_VALUE) {
                        labelAreaWidth = maxWidth - closeBtnWidth;
                        labelWidth = maxWidth - closeBtnWidth;
                    } else if (childrenWidth < minWidth) {
                        labelAreaWidth = minWidth - closeBtnWidth;
                    }
                    if (childrenHeight > maxHeight && maxHeight != Double.MAX_VALUE) {
                        labelHeight = maxHeight;
                    }
                    if (TabHeaderSkin.this.animationState != TabAnimationState.NONE) {
                        labelAreaWidth *= TabHeaderSkin.this.animationTransition.get();
                        TabHeaderSkin.this.closeBtn.setVisible(false);
                    } else {
                        TabHeaderSkin.this.closeBtn.setVisible(TabHeaderSkin.this.showCloseButton());
                    }
                    TabHeaderSkin.this.label.resize(labelWidth, labelHeight);
                    double labelStartX = paddingLeft;
                    double closeBtnStartX = (maxWidth < Double.MAX_VALUE ? Math.min(w, maxWidth) : w) - paddingRight - closeBtnWidth;
                    this.positionInArea(TabHeaderSkin.this.label, labelStartX, paddingTop, labelAreaWidth, h, 0.0, HPos.CENTER, VPos.CENTER);
                    if (TabHeaderSkin.this.closeBtn.isVisible()) {
                        TabHeaderSkin.this.closeBtn.resize(closeBtnWidth, closeBtnHeight);
                        this.positionInArea(TabHeaderSkin.this.closeBtn, closeBtnStartX, paddingTop, closeBtnWidth, h, 0.0, HPos.CENTER, VPos.CENTER);
                    }
                    int vPadding = Utils.isMac() ? 2 : 3;
                    int hPadding = Utils.isMac() ? 2 : 1;
                    focusIndicator.resizeRelocate(paddingLeft - (double)hPadding, paddingTop + (double)vPadding, w + (double)(2 * hPadding), h - (double)(2 * vPadding));
                }
            };
            this.inner.getStyleClass().add("tab-container");
            this.inner.setRotate(((TabPane)TabPaneSkin.this.getSkinnable()).getSide().equals((Object)Side.BOTTOM) ? 180.0 : 0.0);
            this.inner.getChildren().addAll((Node[])new Node[]{this.label, this.closeBtn, focusIndicator});
            this.getChildren().addAll((Node[])new Node[]{this.inner});
            this.tooltip = tab.getTooltip();
            if (this.tooltip != null) {
                Tooltip.install(this, this.tooltip);
                this.oldTooltip = this.tooltip;
            }
            this.listener.registerChangeListener(tab.closableProperty(), "CLOSABLE");
            this.listener.registerChangeListener(tab.selectedProperty(), "SELECTED");
            this.listener.registerChangeListener(tab.textProperty(), "TEXT");
            this.listener.registerChangeListener(tab.graphicProperty(), "GRAPHIC");
            this.listener.registerChangeListener(tab.contextMenuProperty(), "CONTEXT_MENU");
            this.listener.registerChangeListener(tab.tooltipProperty(), "TOOLTIP");
            this.listener.registerChangeListener(tab.disableProperty(), "DISABLE");
            this.listener.registerChangeListener(tab.styleProperty(), "STYLE");
            tab.getStyleClass().addListener(this.weakStyleClassListener);
            this.listener.registerChangeListener(((TabPane)TabPaneSkin.this.getSkinnable()).tabClosingPolicyProperty(), "TAB_CLOSING_POLICY");
            this.listener.registerChangeListener(((TabPane)TabPaneSkin.this.getSkinnable()).sideProperty(), "SIDE");
            this.listener.registerChangeListener(((TabPane)TabPaneSkin.this.getSkinnable()).rotateGraphicProperty(), "ROTATE_GRAPHIC");
            this.listener.registerChangeListener(((TabPane)TabPaneSkin.this.getSkinnable()).tabMinWidthProperty(), "TAB_MIN_WIDTH");
            this.listener.registerChangeListener(((TabPane)TabPaneSkin.this.getSkinnable()).tabMaxWidthProperty(), "TAB_MAX_WIDTH");
            this.listener.registerChangeListener(((TabPane)TabPaneSkin.this.getSkinnable()).tabMinHeightProperty(), "TAB_MIN_HEIGHT");
            this.listener.registerChangeListener(((TabPane)TabPaneSkin.this.getSkinnable()).tabMaxHeightProperty(), "TAB_MAX_HEIGHT");
            this.getProperties().put(Tab.class, tab);
            this.getProperties().put(ContextMenu.class, tab.getContextMenu());
            this.setOnContextMenuRequested(TabPaneSkin$TabHeaderSkin$$Lambda$2.lambdaFactory$(this));
            this.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent me) {
                    if (TabHeaderSkin.this.getTab().isDisable()) {
                        return;
                    }
                    if (me.getButton().equals((Object)MouseButton.MIDDLE)) {
                        if (TabHeaderSkin.this.showCloseButton()) {
                            Tab tab = TabHeaderSkin.this.getTab();
                            TabPaneBehavior behavior = (TabPaneBehavior)TabPaneSkin.this.getBehavior();
                            if (behavior.canCloseTab(tab)) {
                                TabHeaderSkin.this.removeListeners(tab);
                                behavior.closeTab(tab);
                            }
                        }
                    } else if (me.getButton().equals((Object)MouseButton.PRIMARY)) {
                        ((TabPaneBehavior)TabPaneSkin.this.getBehavior()).selectTab(TabHeaderSkin.this.getTab());
                    }
                }
            });
            this.pseudoClassStateChanged(SELECTED_PSEUDOCLASS_STATE, tab.isSelected());
            this.pseudoClassStateChanged(DISABLED_PSEUDOCLASS_STATE, tab.isDisable());
            Side side = ((TabPane)TabPaneSkin.this.getSkinnable()).getSide();
            this.pseudoClassStateChanged(TOP_PSEUDOCLASS_STATE, side == Side.TOP);
            this.pseudoClassStateChanged(RIGHT_PSEUDOCLASS_STATE, side == Side.RIGHT);
            this.pseudoClassStateChanged(BOTTOM_PSEUDOCLASS_STATE, side == Side.BOTTOM);
            this.pseudoClassStateChanged(LEFT_PSEUDOCLASS_STATE, side == Side.LEFT);
        }

        private void handlePropertyChanged(String p) {
            if ("CLOSABLE".equals(p)) {
                this.inner.requestLayout();
                this.requestLayout();
            } else if ("SELECTED".equals(p)) {
                this.pseudoClassStateChanged(SELECTED_PSEUDOCLASS_STATE, this.tab.isSelected());
                this.inner.requestLayout();
                this.requestLayout();
            } else if ("TEXT".equals(p)) {
                this.label.setText(this.getTab().getText());
            } else if ("GRAPHIC".equals(p)) {
                this.label.setGraphic(this.getTab().getGraphic());
            } else if (!"CONTEXT_MENU".equals(p)) {
                if ("TOOLTIP".equals(p)) {
                    if (this.oldTooltip != null) {
                        Tooltip.uninstall(this, this.oldTooltip);
                    }
                    this.tooltip = this.tab.getTooltip();
                    if (this.tooltip != null) {
                        Tooltip.install(this, this.tooltip);
                        this.oldTooltip = this.tooltip;
                    }
                } else if ("DISABLE".equals(p)) {
                    this.pseudoClassStateChanged(DISABLED_PSEUDOCLASS_STATE, this.tab.isDisable());
                    this.inner.requestLayout();
                    this.requestLayout();
                } else if ("STYLE".equals(p)) {
                    this.setStyle(this.tab.getStyle());
                } else if ("TAB_CLOSING_POLICY".equals(p)) {
                    this.inner.requestLayout();
                    this.requestLayout();
                } else if ("SIDE".equals(p)) {
                    Side side = ((TabPane)TabPaneSkin.this.getSkinnable()).getSide();
                    this.pseudoClassStateChanged(TOP_PSEUDOCLASS_STATE, side == Side.TOP);
                    this.pseudoClassStateChanged(RIGHT_PSEUDOCLASS_STATE, side == Side.RIGHT);
                    this.pseudoClassStateChanged(BOTTOM_PSEUDOCLASS_STATE, side == Side.BOTTOM);
                    this.pseudoClassStateChanged(LEFT_PSEUDOCLASS_STATE, side == Side.LEFT);
                    this.inner.setRotate(side == Side.BOTTOM ? 180.0 : 0.0);
                    if (((TabPane)TabPaneSkin.this.getSkinnable()).isRotateGraphic()) {
                        this.updateGraphicRotation();
                    }
                } else if ("ROTATE_GRAPHIC".equals(p)) {
                    this.updateGraphicRotation();
                } else if ("TAB_MIN_WIDTH".equals(p)) {
                    this.requestLayout();
                    ((TabPane)TabPaneSkin.this.getSkinnable()).requestLayout();
                } else if ("TAB_MAX_WIDTH".equals(p)) {
                    this.requestLayout();
                    ((TabPane)TabPaneSkin.this.getSkinnable()).requestLayout();
                } else if ("TAB_MIN_HEIGHT".equals(p)) {
                    this.requestLayout();
                    ((TabPane)TabPaneSkin.this.getSkinnable()).requestLayout();
                } else if ("TAB_MAX_HEIGHT".equals(p)) {
                    this.requestLayout();
                    ((TabPane)TabPaneSkin.this.getSkinnable()).requestLayout();
                }
            }
        }

        private void updateGraphicRotation() {
            if (this.label.getGraphic() != null) {
                this.label.getGraphic().setRotate(((TabPane)TabPaneSkin.this.getSkinnable()).isRotateGraphic() ? 0.0 : (double)(((TabPane)TabPaneSkin.this.getSkinnable()).getSide().equals((Object)Side.RIGHT) ? -90.0f : (((TabPane)TabPaneSkin.this.getSkinnable()).getSide().equals((Object)Side.LEFT) ? 90.0f : 0.0f)));
            }
        }

        private boolean showCloseButton() {
            return this.tab.isClosable() && (((TabPane)TabPaneSkin.this.getSkinnable()).getTabClosingPolicy().equals((Object)TabPane.TabClosingPolicy.ALL_TABS) || ((TabPane)TabPaneSkin.this.getSkinnable()).getTabClosingPolicy().equals((Object)TabPane.TabClosingPolicy.SELECTED_TAB) && this.tab.isSelected());
        }

        private void removeListeners(Tab tab) {
            this.listener.dispose();
            this.inner.getChildren().clear();
            this.getChildren().clear();
        }

        @Override
        protected double computePrefWidth(double height) {
            double minWidth = this.snapSize(((TabPane)TabPaneSkin.this.getSkinnable()).getTabMinWidth());
            double maxWidth = this.snapSize(((TabPane)TabPaneSkin.this.getSkinnable()).getTabMaxWidth());
            double paddingRight = this.snappedRightInset();
            double paddingLeft = this.snappedLeftInset();
            double tmpPrefWidth = this.snapSize(this.label.prefWidth(-1.0));
            if (this.showCloseButton()) {
                tmpPrefWidth += this.snapSize(this.closeBtn.prefWidth(-1.0));
            }
            if (tmpPrefWidth > maxWidth) {
                tmpPrefWidth = maxWidth;
            } else if (tmpPrefWidth < minWidth) {
                tmpPrefWidth = minWidth;
            }
            return tmpPrefWidth += paddingRight + paddingLeft;
        }

        @Override
        protected double computePrefHeight(double width) {
            double minHeight = this.snapSize(((TabPane)TabPaneSkin.this.getSkinnable()).getTabMinHeight());
            double maxHeight = this.snapSize(((TabPane)TabPaneSkin.this.getSkinnable()).getTabMaxHeight());
            double paddingTop = this.snappedTopInset();
            double paddingBottom = this.snappedBottomInset();
            double tmpPrefHeight = this.snapSize(this.label.prefHeight(width));
            if (tmpPrefHeight > maxHeight) {
                tmpPrefHeight = maxHeight;
            } else if (tmpPrefHeight < minHeight) {
                tmpPrefHeight = minHeight;
            }
            return tmpPrefHeight += paddingTop + paddingBottom;
        }

        @Override
        protected void layoutChildren() {
            double w = (this.snapSize(this.getWidth()) - this.snappedRightInset() - this.snappedLeftInset()) * this.animationTransition.getValue();
            this.inner.resize(w, this.snapSize(this.getHeight()) - this.snappedTopInset() - this.snappedBottomInset());
            this.inner.relocate(this.snappedLeftInset(), this.snappedTopInset());
        }

        @Override
        protected void setWidth(double value) {
            super.setWidth(value);
            this.clip.setWidth(value);
        }

        @Override
        protected void setHeight(double value) {
            super.setHeight(value);
            this.clip.setHeight(value);
        }

        @Override
        public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
            switch (attribute) {
                case TEXT: {
                    return this.getTab().getText();
                }
                case SELECTED: {
                    return TabPaneSkin.this.selectedTab == this.getTab();
                }
            }
            return super.queryAccessibleAttribute(attribute, parameters);
        }

        @Override
        public void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
            switch (action) {
                case REQUEST_FOCUS: {
                    ((TabPane)TabPaneSkin.this.getSkinnable()).getSelectionModel().select(this.getTab());
                    break;
                }
                default: {
                    super.executeAccessibleAction(action, parameters);
                }
            }
        }

        private /* synthetic */ void lambda$new$490(ContextMenuEvent me) {
            if (this.getTab().getContextMenu() != null) {
                this.getTab().getContextMenu().show(this.inner, me.getScreenX(), me.getScreenY());
                me.consume();
            }
        }

        private /* synthetic */ Void lambda$new$489(String param) {
            this.handlePropertyChanged(param);
            return null;
        }

        static /* synthetic */ Void access$lambda$0(TabHeaderSkin tabHeaderSkin, String string) {
            return tabHeaderSkin.lambda$new$489(string);
        }

        static /* synthetic */ void access$lambda$1(TabHeaderSkin tabHeaderSkin, ContextMenuEvent contextMenuEvent) {
            tabHeaderSkin.lambda$new$490(contextMenuEvent);
        }
    }

    class TabHeaderArea
    extends StackPane {
        private Rectangle headerClip;
        private StackPane headersRegion;
        private StackPane headerBackground;
        private TabControlButtons controlButtons;
        private boolean measureClosingTabs = false;
        private double scrollOffset;
        private List<TabHeaderSkin> removeTab = new ArrayList<TabHeaderSkin>();

        public TabHeaderArea() {
            this.getStyleClass().setAll((String[])new String[]{"tab-header-area"});
            this.setManaged(false);
            TabPane tabPane = (TabPane)TabPaneSkin.this.getSkinnable();
            this.headerClip = new Rectangle();
            this.headersRegion = new StackPane(){

                @Override
                protected double computePrefWidth(double height) {
                    double width = 0.0;
                    for (Node child : this.getChildren()) {
                        TabHeaderSkin tabHeaderSkin = (TabHeaderSkin)child;
                        if (!tabHeaderSkin.isVisible() || !TabHeaderArea.this.measureClosingTabs && tabHeaderSkin.isClosing) continue;
                        width += tabHeaderSkin.prefWidth(height);
                    }
                    return this.snapSize(width) + this.snappedLeftInset() + this.snappedRightInset();
                }

                @Override
                protected double computePrefHeight(double width) {
                    double height = 0.0;
                    for (Node child : this.getChildren()) {
                        TabHeaderSkin tabHeaderSkin = (TabHeaderSkin)child;
                        height = Math.max(height, tabHeaderSkin.prefHeight(width));
                    }
                    return this.snapSize(height) + this.snappedTopInset() + this.snappedBottomInset();
                }

                @Override
                protected void layoutChildren() {
                    if (TabHeaderArea.this.tabsFit()) {
                        TabHeaderArea.this.setScrollOffset(0.0);
                    } else if (!TabHeaderArea.this.removeTab.isEmpty()) {
                        double offset = 0.0;
                        double w = TabPaneSkin.this.tabHeaderArea.getWidth() - this.snapSize(TabHeaderArea.this.controlButtons.prefWidth(-1.0)) - TabHeaderArea.this.firstTabIndent() - 10.0;
                        Iterator i = this.getChildren().iterator();
                        while (i.hasNext()) {
                            TabHeaderSkin tabHeader = (TabHeaderSkin)i.next();
                            double tabHeaderPrefWidth = this.snapSize(tabHeader.prefWidth(-1.0));
                            if (TabHeaderArea.this.removeTab.contains(tabHeader)) {
                                if (offset < w) {
                                    TabPaneSkin.this.isSelectingTab = true;
                                }
                                i.remove();
                                TabHeaderArea.this.removeTab.remove(tabHeader);
                                if (TabHeaderArea.this.removeTab.isEmpty()) break;
                            }
                            offset += tabHeaderPrefWidth;
                        }
                    }
                    if (TabPaneSkin.this.isSelectingTab) {
                        TabHeaderArea.this.ensureSelectedTabIsVisible();
                        TabPaneSkin.this.isSelectingTab = false;
                    } else {
                        TabHeaderArea.this.validateScrollOffset();
                    }
                    Side tabPosition = ((TabPane)TabPaneSkin.this.getSkinnable()).getSide();
                    double tabBackgroundHeight = this.snapSize(this.prefHeight(-1.0));
                    double tabX = tabPosition.equals((Object)Side.LEFT) || tabPosition.equals((Object)Side.BOTTOM) ? this.snapSize(this.getWidth()) - TabHeaderArea.this.getScrollOffset() : TabHeaderArea.this.getScrollOffset();
                    TabHeaderArea.this.updateHeaderClip();
                    for (Node node : this.getChildren()) {
                        double startY;
                        TabHeaderSkin tabHeader = (TabHeaderSkin)node;
                        double tabHeaderPrefWidth = this.snapSize(tabHeader.prefWidth(-1.0) * tabHeader.animationTransition.get());
                        double tabHeaderPrefHeight = this.snapSize(tabHeader.prefHeight(-1.0));
                        tabHeader.resize(tabHeaderPrefWidth, tabHeaderPrefHeight);
                        double d = startY = tabPosition.equals((Object)Side.BOTTOM) ? 0.0 : tabBackgroundHeight - tabHeaderPrefHeight - this.snappedBottomInset();
                        if (tabPosition.equals((Object)Side.LEFT) || tabPosition.equals((Object)Side.BOTTOM)) {
                            tabHeader.relocate(tabX -= tabHeaderPrefWidth, startY);
                            continue;
                        }
                        tabHeader.relocate(tabX, startY);
                        tabX += tabHeaderPrefWidth;
                    }
                }
            };
            this.headersRegion.getStyleClass().setAll((String[])new String[]{"headers-region"});
            this.headersRegion.setClip(this.headerClip);
            this.headerBackground = new StackPane();
            this.headerBackground.getStyleClass().setAll((String[])new String[]{"tab-header-background"});
            int i = 0;
            for (Tab tab : tabPane.getTabs()) {
                this.addTab(tab, i++);
            }
            this.controlButtons = new TabControlButtons();
            this.controlButtons.setVisible(false);
            if (this.controlButtons.isVisible()) {
                this.controlButtons.setVisible(true);
            }
            this.getChildren().addAll((Node[])new Node[]{this.headerBackground, this.headersRegion, this.controlButtons});
            this.addEventHandler(ScrollEvent.SCROLL, TabPaneSkin$TabHeaderArea$$Lambda$1.lambdaFactory$(this));
        }

        private void updateHeaderClip() {
            Side tabPosition = ((TabPane)TabPaneSkin.this.getSkinnable()).getSide();
            double x = 0.0;
            double y = 0.0;
            double clipWidth = 0.0;
            double clipHeight = 0.0;
            double maxWidth = 0.0;
            double shadowRadius = 0.0;
            double clipOffset = this.firstTabIndent();
            double controlButtonPrefWidth = this.snapSize(this.controlButtons.prefWidth(-1.0));
            this.measureClosingTabs = true;
            double headersPrefWidth = this.snapSize(this.headersRegion.prefWidth(-1.0));
            this.measureClosingTabs = false;
            double headersPrefHeight = this.snapSize(this.headersRegion.prefHeight(-1.0));
            if (controlButtonPrefWidth > 0.0) {
                controlButtonPrefWidth += 10.0;
            }
            if (this.headersRegion.getEffect() instanceof DropShadow) {
                DropShadow shadow = (DropShadow)this.headersRegion.getEffect();
                shadowRadius = shadow.getRadius();
            }
            maxWidth = this.snapSize(this.getWidth()) - controlButtonPrefWidth - clipOffset;
            if (tabPosition.equals((Object)Side.LEFT) || tabPosition.equals((Object)Side.BOTTOM)) {
                if (headersPrefWidth < maxWidth) {
                    clipWidth = headersPrefWidth + shadowRadius;
                } else {
                    x = headersPrefWidth - maxWidth;
                    clipWidth = maxWidth + shadowRadius;
                }
                clipHeight = headersPrefHeight;
            } else {
                x = -shadowRadius;
                clipWidth = (headersPrefWidth < maxWidth ? headersPrefWidth : maxWidth) + shadowRadius;
                clipHeight = headersPrefHeight;
            }
            this.headerClip.setX(x);
            this.headerClip.setY(y);
            this.headerClip.setWidth(clipWidth);
            this.headerClip.setHeight(clipHeight);
        }

        private void addTab(Tab tab, int addToIndex) {
            TabHeaderSkin tabHeaderSkin = new TabHeaderSkin(tab);
            this.headersRegion.getChildren().add(addToIndex, tabHeaderSkin);
        }

        private void removeTab(Tab tab) {
            TabHeaderSkin tabHeaderSkin = this.getTabHeaderSkin(tab);
            if (tabHeaderSkin != null) {
                if (this.tabsFit()) {
                    this.headersRegion.getChildren().remove(tabHeaderSkin);
                } else {
                    this.removeTab.add(tabHeaderSkin);
                    tabHeaderSkin.removeListeners(tab);
                }
            }
        }

        private TabHeaderSkin getTabHeaderSkin(Tab tab) {
            for (Node child : this.headersRegion.getChildren()) {
                TabHeaderSkin tabHeaderSkin = (TabHeaderSkin)child;
                if (!tabHeaderSkin.getTab().equals(tab)) continue;
                return tabHeaderSkin;
            }
            return null;
        }

        private boolean tabsFit() {
            double controlTabWidth;
            double headerPrefWidth = this.snapSize(this.headersRegion.prefWidth(-1.0));
            double visibleWidth = headerPrefWidth + (controlTabWidth = this.snapSize(this.controlButtons.prefWidth(-1.0))) + this.firstTabIndent() + 10.0;
            return visibleWidth < this.getWidth();
        }

        private void ensureSelectedTabIsVisible() {
            double tabPaneWidth = this.snapSize(TabPaneSkin.this.isHorizontal() ? ((TabPane)TabPaneSkin.this.getSkinnable()).getWidth() : ((TabPane)TabPaneSkin.this.getSkinnable()).getHeight());
            double controlTabWidth = this.snapSize(this.controlButtons.getWidth());
            double visibleWidth = tabPaneWidth - controlTabWidth - this.firstTabIndent() - 10.0;
            double offset = 0.0;
            double selectedTabOffset = 0.0;
            double selectedTabWidth = 0.0;
            for (Node node : this.headersRegion.getChildren()) {
                TabHeaderSkin tabHeader = (TabHeaderSkin)node;
                double tabHeaderPrefWidth = this.snapSize(tabHeader.prefWidth(-1.0));
                if (TabPaneSkin.this.selectedTab != null && TabPaneSkin.this.selectedTab.equals(tabHeader.getTab())) {
                    selectedTabOffset = offset;
                    selectedTabWidth = tabHeaderPrefWidth;
                }
                offset += tabHeaderPrefWidth;
            }
            double scrollOffset = this.getScrollOffset();
            double selectedTabStartX = selectedTabOffset;
            double selectedTabEndX = selectedTabOffset + selectedTabWidth;
            double visibleAreaEndX = visibleWidth;
            if (selectedTabStartX < -scrollOffset) {
                this.setScrollOffset(-selectedTabStartX);
            } else if (selectedTabEndX > visibleAreaEndX - scrollOffset) {
                this.setScrollOffset(visibleAreaEndX - selectedTabEndX);
            }
        }

        public double getScrollOffset() {
            return this.scrollOffset;
        }

        private void validateScrollOffset() {
            this.setScrollOffset(this.getScrollOffset());
        }

        private void setScrollOffset(double newScrollOffset) {
            double tabPaneWidth = this.snapSize(TabPaneSkin.this.isHorizontal() ? ((TabPane)TabPaneSkin.this.getSkinnable()).getWidth() : ((TabPane)TabPaneSkin.this.getSkinnable()).getHeight());
            double controlTabWidth = this.snapSize(this.controlButtons.getWidth());
            double visibleWidth = tabPaneWidth - controlTabWidth - this.firstTabIndent() - 10.0;
            double offset = 0.0;
            for (Node node : this.headersRegion.getChildren()) {
                TabHeaderSkin tabHeader = (TabHeaderSkin)node;
                double tabHeaderPrefWidth = this.snapSize(tabHeader.prefWidth(-1.0));
                offset += tabHeaderPrefWidth;
            }
            double actualNewScrollOffset = visibleWidth - newScrollOffset > offset && newScrollOffset < 0.0 ? visibleWidth - offset : (newScrollOffset > 0.0 ? 0.0 : newScrollOffset);
            if (actualNewScrollOffset != this.scrollOffset) {
                this.scrollOffset = actualNewScrollOffset;
                this.headersRegion.requestLayout();
            }
        }

        private double firstTabIndent() {
            switch (((TabPane)TabPaneSkin.this.getSkinnable()).getSide()) {
                case TOP: 
                case BOTTOM: {
                    return this.snappedLeftInset();
                }
                case LEFT: 
                case RIGHT: {
                    return this.snappedTopInset();
                }
            }
            return 0.0;
        }

        @Override
        protected double computePrefWidth(double height) {
            double padding = TabPaneSkin.this.isHorizontal() ? this.snappedLeftInset() + this.snappedRightInset() : this.snappedTopInset() + this.snappedBottomInset();
            return this.snapSize(this.headersRegion.prefWidth(height)) + this.controlButtons.prefWidth(height) + this.firstTabIndent() + 10.0 + padding;
        }

        @Override
        protected double computePrefHeight(double width) {
            double padding = TabPaneSkin.this.isHorizontal() ? this.snappedTopInset() + this.snappedBottomInset() : this.snappedLeftInset() + this.snappedRightInset();
            return this.snapSize(this.headersRegion.prefHeight(-1.0)) + padding;
        }

        @Override
        public double getBaselineOffset() {
            if (((TabPane)TabPaneSkin.this.getSkinnable()).getSide() == Side.TOP) {
                return this.headersRegion.getBaselineOffset() + this.snappedTopInset();
            }
            return 0.0;
        }

        @Override
        protected void layoutChildren() {
            double leftInset = this.snappedLeftInset();
            double rightInset = this.snappedRightInset();
            double topInset = this.snappedTopInset();
            double bottomInset = this.snappedBottomInset();
            double w = this.snapSize(this.getWidth()) - (TabPaneSkin.this.isHorizontal() ? leftInset + rightInset : topInset + bottomInset);
            double h = this.snapSize(this.getHeight()) - (TabPaneSkin.this.isHorizontal() ? topInset + bottomInset : leftInset + rightInset);
            double tabBackgroundHeight = this.snapSize(this.prefHeight(-1.0));
            double headersPrefWidth = this.snapSize(this.headersRegion.prefWidth(-1.0));
            double headersPrefHeight = this.snapSize(this.headersRegion.prefHeight(-1.0));
            this.controlButtons.showTabsMenu(!this.tabsFit());
            this.updateHeaderClip();
            this.headersRegion.requestLayout();
            double btnWidth = this.snapSize(this.controlButtons.prefWidth(-1.0));
            double btnHeight = this.controlButtons.prefHeight(btnWidth);
            this.controlButtons.resize(btnWidth, btnHeight);
            this.headersRegion.resize(headersPrefWidth, headersPrefHeight);
            if (TabPaneSkin.this.isFloatingStyleClass()) {
                this.headerBackground.setVisible(false);
            } else {
                this.headerBackground.resize(this.snapSize(this.getWidth()), this.snapSize(this.getHeight()));
                this.headerBackground.setVisible(true);
            }
            double startX = 0.0;
            double startY = 0.0;
            double controlStartX = 0.0;
            double controlStartY = 0.0;
            Side tabPosition = ((TabPane)TabPaneSkin.this.getSkinnable()).getSide();
            if (tabPosition.equals((Object)Side.TOP)) {
                startX = leftInset;
                startY = tabBackgroundHeight - headersPrefHeight - bottomInset;
                controlStartX = w - btnWidth + leftInset;
                controlStartY = this.snapSize(this.getHeight()) - btnHeight - bottomInset;
            } else if (tabPosition.equals((Object)Side.RIGHT)) {
                startX = topInset;
                startY = tabBackgroundHeight - headersPrefHeight - leftInset;
                controlStartX = w - btnWidth + topInset;
                controlStartY = this.snapSize(this.getHeight()) - btnHeight - leftInset;
            } else if (tabPosition.equals((Object)Side.BOTTOM)) {
                startX = this.snapSize(this.getWidth()) - headersPrefWidth - leftInset;
                startY = tabBackgroundHeight - headersPrefHeight - topInset;
                controlStartX = rightInset;
                controlStartY = this.snapSize(this.getHeight()) - btnHeight - topInset;
            } else if (tabPosition.equals((Object)Side.LEFT)) {
                startX = this.snapSize(this.getWidth()) - headersPrefWidth - topInset;
                startY = tabBackgroundHeight - headersPrefHeight - rightInset;
                controlStartX = leftInset;
                controlStartY = this.snapSize(this.getHeight()) - btnHeight - rightInset;
            }
            if (this.headerBackground.isVisible()) {
                this.positionInArea(this.headerBackground, 0.0, 0.0, this.snapSize(this.getWidth()), this.snapSize(this.getHeight()), 0.0, HPos.CENTER, VPos.CENTER);
            }
            this.positionInArea(this.headersRegion, startX, startY, w, h, 0.0, HPos.LEFT, VPos.CENTER);
            this.positionInArea(this.controlButtons, controlStartX, controlStartY, btnWidth, btnHeight, 0.0, HPos.CENTER, VPos.CENTER);
        }

        private /* synthetic */ void lambda$new$488(ScrollEvent e) {
            Side side = ((TabPane)TabPaneSkin.this.getSkinnable()).getSide();
            side = side == null ? Side.TOP : side;
            switch (side) {
                default: {
                    this.setScrollOffset(this.scrollOffset - e.getDeltaY());
                    break;
                }
                case LEFT: 
                case RIGHT: {
                    this.setScrollOffset(this.scrollOffset + e.getDeltaY());
                }
            }
        }

        static /* synthetic */ void access$lambda$0(TabHeaderArea tabHeaderArea, ScrollEvent scrollEvent) {
            tabHeaderArea.lambda$new$488(scrollEvent);
        }
    }

    private static class StyleableProperties {
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;
        private static final CssMetaData<TabPane, TabAnimation> OPEN_TAB_ANIMATION;
        private static final CssMetaData<TabPane, TabAnimation> CLOSE_TAB_ANIMATION;

        private StyleableProperties() {
        }

        static {
            OPEN_TAB_ANIMATION = new CssMetaData<TabPane, TabAnimation>("-fx-open-tab-animation", new EnumConverter<TabAnimation>(TabAnimation.class), TabAnimation.GROW){

                @Override
                public boolean isSettable(TabPane node) {
                    return true;
                }

                @Override
                public StyleableProperty<TabAnimation> getStyleableProperty(TabPane node) {
                    TabPaneSkin skin = (TabPaneSkin)node.getSkin();
                    return (StyleableProperty)((Object)skin.openTabAnimation);
                }
            };
            CLOSE_TAB_ANIMATION = new CssMetaData<TabPane, TabAnimation>("-fx-close-tab-animation", new EnumConverter<TabAnimation>(TabAnimation.class), TabAnimation.GROW){

                @Override
                public boolean isSettable(TabPane node) {
                    return true;
                }

                @Override
                public StyleableProperty<TabAnimation> getStyleableProperty(TabPane node) {
                    TabPaneSkin skin = (TabPaneSkin)node.getSkin();
                    return (StyleableProperty)((Object)skin.closeTabAnimation);
                }
            };
            ArrayList styleables = new ArrayList(SkinBase.getClassCssMetaData());
            styleables.add(OPEN_TAB_ANIMATION);
            styleables.add(CLOSE_TAB_ANIMATION);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    private static enum TabAnimationState {
        SHOWING,
        HIDING,
        NONE;

    }

    private static enum TabAnimation {
        NONE,
        GROW;

    }
}

