/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.scene.control.MultiplePropertyChangeListenerHandler;
import com.sun.javafx.scene.control.TableColumnSortTypeWrapper;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.NestedTableColumnHeader;
import com.sun.javafx.scene.control.skin.TableColumnHeader$$Lambda$1;
import com.sun.javafx.scene.control.skin.TableColumnHeader$$Lambda$2;
import com.sun.javafx.scene.control.skin.TableColumnHeader$$Lambda$3;
import com.sun.javafx.scene.control.skin.TableColumnHeader$$Lambda$4;
import com.sun.javafx.scene.control.skin.TableColumnHeader$$Lambda$5;
import com.sun.javafx.scene.control.skin.TableColumnHeader$$Lambda$6;
import com.sun.javafx.scene.control.skin.TableColumnHeader$$Lambda$7;
import com.sun.javafx.scene.control.skin.TableColumnHeader$$Lambda$8;
import com.sun.javafx.scene.control.skin.TableColumnHeader$$Lambda$9;
import com.sun.javafx.scene.control.skin.TableHeaderRow;
import com.sun.javafx.scene.control.skin.TableViewSkinBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.DoubleProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;

public class TableColumnHeader
extends Region {
    static final double DEFAULT_COLUMN_WIDTH = 80.0;
    private boolean autoSizeComplete = false;
    private double dragOffset;
    private final TableViewSkinBase<?, ?, ?, ?, ?, TableColumnBase<?, ?>> skin;
    private NestedTableColumnHeader nestedColumnHeader;
    private final TableColumnBase<?, ?> column;
    private TableHeaderRow tableHeaderRow;
    private NestedTableColumnHeader parentHeader;
    Label label;
    int sortPos = -1;
    private Region arrow;
    private Label sortOrderLabel;
    private HBox sortOrderDots;
    private Node sortArrow;
    private boolean isSortColumn;
    private boolean isSizeDirty = false;
    boolean isLastVisibleColumn = false;
    int columnIndex = -1;
    private int newColumnPos;
    protected final Region columnReorderLine;
    protected final MultiplePropertyChangeListenerHandler changeListenerHandler;
    private ListChangeListener<TableColumnBase<?, ?>> sortOrderListener = TableColumnHeader$$Lambda$1.lambdaFactory$(this);
    private ListChangeListener<TableColumnBase<?, ?>> visibleLeafColumnsListener = TableColumnHeader$$Lambda$2.lambdaFactory$(this);
    private ListChangeListener<String> styleClassListener = TableColumnHeader$$Lambda$3.lambdaFactory$(this);
    private WeakListChangeListener<TableColumnBase<?, ?>> weakSortOrderListener = new WeakListChangeListener(this.sortOrderListener);
    private final WeakListChangeListener<TableColumnBase<?, ?>> weakVisibleLeafColumnsListener = new WeakListChangeListener(this.visibleLeafColumnsListener);
    private final WeakListChangeListener<String> weakStyleClassListener = new WeakListChangeListener<String>(this.styleClassListener);
    private static final EventHandler<MouseEvent> mousePressedHandler = TableColumnHeader$$Lambda$6.lambdaFactory$();
    private static final EventHandler<MouseEvent> mouseDraggedHandler = TableColumnHeader$$Lambda$7.lambdaFactory$();
    private static final EventHandler<MouseEvent> mouseReleasedHandler = TableColumnHeader$$Lambda$8.lambdaFactory$();
    private static final EventHandler<ContextMenuEvent> contextMenuRequestedHandler = TableColumnHeader$$Lambda$9.lambdaFactory$();
    private DoubleProperty size;
    private static final PseudoClass PSEUDO_CLASS_LAST_VISIBLE = PseudoClass.getPseudoClass("last-visible");

    public TableColumnHeader(TableViewSkinBase skin, TableColumnBase tc) {
        this.skin = skin;
        this.column = tc;
        this.columnReorderLine = skin.getColumnReorderLine();
        this.setFocusTraversable(false);
        this.updateColumnIndex();
        this.initUI();
        this.changeListenerHandler = new MultiplePropertyChangeListenerHandler(TableColumnHeader$$Lambda$4.lambdaFactory$(this));
        this.changeListenerHandler.registerChangeListener(this.sceneProperty(), "SCENE");
        if (this.column != null && skin != null) {
            this.updateSortPosition();
            skin.getSortOrder().addListener(this.weakSortOrderListener);
            skin.getVisibleLeafColumns().addListener(this.weakVisibleLeafColumnsListener);
        }
        if (this.column != null) {
            this.changeListenerHandler.registerChangeListener(this.column.idProperty(), "TABLE_COLUMN_ID");
            this.changeListenerHandler.registerChangeListener(this.column.styleProperty(), "TABLE_COLUMN_STYLE");
            this.changeListenerHandler.registerChangeListener(this.column.widthProperty(), "TABLE_COLUMN_WIDTH");
            this.changeListenerHandler.registerChangeListener(this.column.visibleProperty(), "TABLE_COLUMN_VISIBLE");
            this.changeListenerHandler.registerChangeListener(this.column.sortNodeProperty(), "TABLE_COLUMN_SORT_NODE");
            this.changeListenerHandler.registerChangeListener(this.column.sortableProperty(), "TABLE_COLUMN_SORTABLE");
            this.changeListenerHandler.registerChangeListener(this.column.textProperty(), "TABLE_COLUMN_TEXT");
            this.changeListenerHandler.registerChangeListener(this.column.graphicProperty(), "TABLE_COLUMN_GRAPHIC");
            this.column.getStyleClass().addListener(this.weakStyleClassListener);
            this.setId(this.column.getId());
            this.setStyle(this.column.getStyle());
            this.updateStyleClass();
            this.setAccessibleRole(AccessibleRole.TABLE_COLUMN);
        }
    }

    private double getSize() {
        return this.size == null ? 20.0 : this.size.doubleValue();
    }

    private DoubleProperty sizeProperty() {
        if (this.size == null) {
            this.size = new StyleableDoubleProperty(20.0){

                @Override
                protected void invalidated() {
                    double value = this.get();
                    if (value <= 0.0) {
                        if (this.isBound()) {
                            this.unbind();
                        }
                        this.set(20.0);
                        throw new IllegalArgumentException("Size cannot be 0 or negative");
                    }
                }

                @Override
                public Object getBean() {
                    return TableColumnHeader.this;
                }

                @Override
                public String getName() {
                    return "size";
                }

                @Override
                public CssMetaData<TableColumnHeader, Number> getCssMetaData() {
                    return StyleableProperties.SIZE;
                }
            };
        }
        return this.size;
    }

    protected void handlePropertyChanged(String p) {
        if ("SCENE".equals(p)) {
            this.updateScene();
        } else if ("TABLE_COLUMN_VISIBLE".equals(p)) {
            this.setVisible(this.getTableColumn().isVisible());
        } else if ("TABLE_COLUMN_WIDTH".equals(p)) {
            this.isSizeDirty = true;
            this.requestLayout();
        } else if ("TABLE_COLUMN_ID".equals(p)) {
            this.setId(this.column.getId());
        } else if ("TABLE_COLUMN_STYLE".equals(p)) {
            this.setStyle(this.column.getStyle());
        } else if ("TABLE_COLUMN_SORT_TYPE".equals(p)) {
            this.updateSortGrid();
            if (this.arrow != null) {
                this.arrow.setRotate(TableColumnSortTypeWrapper.isAscending(this.column) ? 180.0 : 0.0);
            }
        } else if ("TABLE_COLUMN_SORT_NODE".equals(p)) {
            this.updateSortGrid();
        } else if ("TABLE_COLUMN_SORTABLE".equals(p)) {
            if (this.skin.getSortOrder().contains(this.getTableColumn())) {
                NestedTableColumnHeader root = this.getTableHeaderRow().getRootHeader();
                this.updateAllHeaders(root);
            }
        } else if ("TABLE_COLUMN_TEXT".equals(p)) {
            this.label.setText(this.column.getText());
        } else if ("TABLE_COLUMN_GRAPHIC".equals(p)) {
            this.label.setGraphic(this.column.getGraphic());
        }
    }

    protected TableViewSkinBase<?, ?, ?, ?, ?, TableColumnBase<?, ?>> getTableViewSkin() {
        return this.skin;
    }

    NestedTableColumnHeader getNestedColumnHeader() {
        return this.nestedColumnHeader;
    }

    void setNestedColumnHeader(NestedTableColumnHeader nch) {
        this.nestedColumnHeader = nch;
    }

    public TableColumnBase getTableColumn() {
        return this.column;
    }

    TableHeaderRow getTableHeaderRow() {
        return this.tableHeaderRow;
    }

    void setTableHeaderRow(TableHeaderRow thr) {
        this.tableHeaderRow = thr;
    }

    NestedTableColumnHeader getParentHeader() {
        return this.parentHeader;
    }

    void setParentHeader(NestedTableColumnHeader ph) {
        this.parentHeader = ph;
    }

    @Override
    protected void layoutChildren() {
        if (this.isSizeDirty) {
            this.resize(this.getTableColumn().getWidth(), this.getHeight());
            this.isSizeDirty = false;
        }
        double sortWidth = 0.0;
        double w = this.snapSize(this.getWidth()) - (this.snappedLeftInset() + this.snappedRightInset());
        double h = this.getHeight() - (this.snappedTopInset() + this.snappedBottomInset());
        double x = w;
        if (this.arrow != null) {
            this.arrow.setMaxSize(this.arrow.prefWidth(-1.0), this.arrow.prefHeight(-1.0));
        }
        if (this.sortArrow != null && this.sortArrow.isVisible()) {
            sortWidth = this.sortArrow.prefWidth(-1.0);
            this.sortArrow.resize(sortWidth, this.sortArrow.prefHeight(-1.0));
            this.positionInArea(this.sortArrow, x -= sortWidth, this.snappedTopInset(), sortWidth, h, 0.0, HPos.CENTER, VPos.CENTER);
        }
        if (this.label != null) {
            double labelWidth = w - sortWidth;
            this.label.resizeRelocate(this.snappedLeftInset(), 0.0, labelWidth, this.getHeight());
        }
    }

    @Override
    protected double computePrefWidth(double height) {
        if (this.getNestedColumnHeader() != null) {
            double width = this.getNestedColumnHeader().prefWidth(height);
            if (this.column != null) {
                this.column.impl_setWidth(width);
            }
            return width;
        }
        if (this.column != null && this.column.isVisible()) {
            return this.column.getWidth();
        }
        return 0.0;
    }

    @Override
    protected double computeMinHeight(double width) {
        return this.label == null ? 0.0 : this.label.minHeight(width);
    }

    @Override
    protected double computePrefHeight(double width) {
        if (this.getTableColumn() == null) {
            return 0.0;
        }
        return Math.max(this.getSize(), this.label.prefHeight(-1.0));
    }

    private void updateAllHeaders(TableColumnHeader header) {
        if (header instanceof NestedTableColumnHeader) {
            ObservableList<TableColumnHeader> children = ((NestedTableColumnHeader)header).getColumnHeaders();
            for (int i = 0; i < children.size(); ++i) {
                this.updateAllHeaders((TableColumnHeader)children.get(i));
            }
        } else {
            header.updateSortPosition();
        }
    }

    private void updateStyleClass() {
        this.getStyleClass().setAll((String[])new String[]{"column-header"});
        this.getStyleClass().addAll((Collection<String>)this.column.getStyleClass());
    }

    private void updateScene() {
        int n = 30;
        if (!this.autoSizeComplete) {
            if (this.getTableColumn() == null || this.getTableColumn().getWidth() != 80.0 || this.getScene() == null) {
                return;
            }
            this.doColumnAutoSize(this.getTableColumn(), 30);
            this.autoSizeComplete = true;
        }
    }

    void dispose() {
        TableViewSkinBase<?, ?, ?, ?, ?, TableColumnBase<?, ?>> skin = this.getTableViewSkin();
        if (skin != null) {
            skin.getVisibleLeafColumns().removeListener(this.weakVisibleLeafColumnsListener);
            skin.getSortOrder().removeListener(this.weakSortOrderListener);
        }
        this.changeListenerHandler.dispose();
    }

    private boolean isSortingEnabled() {
        return true;
    }

    private boolean isColumnReorderingEnabled() {
        return !BehaviorSkinBase.IS_TOUCH_SUPPORTED && this.getTableViewSkin().getVisibleLeafColumns().size() > 1;
    }

    private void initUI() {
        if (this.column == null) {
            return;
        }
        this.setOnMousePressed(mousePressedHandler);
        this.setOnMouseDragged(mouseDraggedHandler);
        this.setOnDragDetected(TableColumnHeader$$Lambda$5.lambdaFactory$());
        this.setOnContextMenuRequested(contextMenuRequestedHandler);
        this.setOnMouseReleased(mouseReleasedHandler);
        this.label = new Label();
        this.label.setText(this.column.getText());
        this.label.setGraphic(this.column.getGraphic());
        this.label.setVisible(this.column.isVisible());
        if (this.isSortingEnabled()) {
            this.updateSortGrid();
        }
    }

    private void doColumnAutoSize(TableColumnBase<?, ?> column, int cellsToMeasure) {
        double prefWidth = column.getPrefWidth();
        if (prefWidth == 80.0) {
            this.getTableViewSkin().resizeColumnToFitContent(column, cellsToMeasure);
        }
    }

    private void updateSortPosition() {
        this.sortPos = !this.column.isSortable() ? -1 : this.getSortPosition();
        this.updateSortGrid();
    }

    private void updateSortGrid() {
        if (this instanceof NestedTableColumnHeader) {
            return;
        }
        this.getChildren().clear();
        this.getChildren().add(this.label);
        if (!this.isSortingEnabled()) {
            return;
        }
        boolean bl = this.isSortColumn = this.sortPos != -1;
        if (!this.isSortColumn) {
            if (this.sortArrow != null) {
                this.sortArrow.setVisible(false);
            }
            return;
        }
        int visibleLeafIndex = this.skin.getVisibleLeafIndex(this.getTableColumn());
        if (visibleLeafIndex == -1) {
            return;
        }
        int sortColumnCount = this.getVisibleSortOrderColumnCount();
        boolean showSortOrderDots = this.sortPos <= 3 && sortColumnCount > 1;
        Node _sortArrow = null;
        if (this.getTableColumn().getSortNode() != null) {
            _sortArrow = this.getTableColumn().getSortNode();
            this.getChildren().add(_sortArrow);
        } else {
            GridPane sortArrowGrid = new GridPane();
            _sortArrow = sortArrowGrid;
            sortArrowGrid.setPadding(new Insets(0.0, 3.0, 0.0, 0.0));
            this.getChildren().add(sortArrowGrid);
            if (this.arrow == null) {
                this.arrow = new Region();
                this.arrow.getStyleClass().setAll((String[])new String[]{"arrow"});
                this.arrow.setVisible(true);
                this.arrow.setRotate(TableColumnSortTypeWrapper.isAscending(this.column) ? 180.0 : 0.0);
                this.changeListenerHandler.registerChangeListener(TableColumnSortTypeWrapper.getSortTypeProperty(this.column), "TABLE_COLUMN_SORT_TYPE");
            }
            this.arrow.setVisible(this.isSortColumn);
            if (this.sortPos > 2) {
                if (this.sortOrderLabel == null) {
                    this.sortOrderLabel = new Label();
                    this.sortOrderLabel.getStyleClass().add("sort-order");
                }
                this.sortOrderLabel.setText("" + (this.sortPos + 1));
                this.sortOrderLabel.setVisible(sortColumnCount > 1);
                sortArrowGrid.add(this.arrow, 1, 1);
                GridPane.setHgrow(this.arrow, Priority.NEVER);
                GridPane.setVgrow(this.arrow, Priority.NEVER);
                sortArrowGrid.add(this.sortOrderLabel, 2, 1);
            } else if (showSortOrderDots) {
                boolean isAscending;
                if (this.sortOrderDots == null) {
                    this.sortOrderDots = new HBox(0.0);
                    this.sortOrderDots.getStyleClass().add("sort-order-dots-container");
                }
                int arrowRow = (isAscending = TableColumnSortTypeWrapper.isAscending(this.column)) ? 1 : 2;
                int dotsRow = isAscending ? 2 : 1;
                sortArrowGrid.add(this.arrow, 1, arrowRow);
                GridPane.setHalignment(this.arrow, HPos.CENTER);
                sortArrowGrid.add(this.sortOrderDots, 1, dotsRow);
                this.updateSortOrderDots(this.sortPos);
            } else {
                sortArrowGrid.add(this.arrow, 1, 1);
                GridPane.setHgrow(this.arrow, Priority.NEVER);
                GridPane.setVgrow(this.arrow, Priority.ALWAYS);
            }
        }
        this.sortArrow = _sortArrow;
        if (this.sortArrow != null) {
            this.sortArrow.setVisible(this.isSortColumn);
        }
        this.requestLayout();
    }

    private void updateSortOrderDots(int sortPos) {
        double arrowWidth = this.arrow.prefWidth(-1.0);
        this.sortOrderDots.getChildren().clear();
        for (int i = 0; i <= sortPos; ++i) {
            Region r = new Region();
            r.getStyleClass().add("sort-order-dot");
            String sortTypeName = TableColumnSortTypeWrapper.getSortTypeName(this.column);
            if (sortTypeName != null && !sortTypeName.isEmpty()) {
                r.getStyleClass().add(sortTypeName.toLowerCase(Locale.ROOT));
            }
            this.sortOrderDots.getChildren().add(r);
            if (i >= sortPos) continue;
            Region spacer = new Region();
            double rp = sortPos == 1 ? 1.0 : 1.0;
            double lp = sortPos == 1 ? 1.0 : 0.0;
            spacer.setPadding(new Insets(0.0, rp, 0.0, lp));
            this.sortOrderDots.getChildren().add(spacer);
        }
        this.sortOrderDots.setAlignment(Pos.TOP_CENTER);
        this.sortOrderDots.setMaxWidth(arrowWidth);
    }

    void moveColumn(TableColumnBase column, int newColumnPos) {
        int actualNewColumnPos;
        if (column == null || newColumnPos < 0) {
            return;
        }
        ObservableList<TableColumnBase<?, ?>> columns = this.getColumns(column);
        int columnsCount = columns.size();
        int currentPos = columns.indexOf(column);
        int max = actualNewColumnPos = newColumnPos;
        for (int i = 0; i <= max && i < columnsCount; ++i) {
            actualNewColumnPos += ((TableColumnBase)columns.get(i)).isVisible() ? 0 : 1;
        }
        if (actualNewColumnPos >= columnsCount) {
            actualNewColumnPos = columnsCount - 1;
        } else if (actualNewColumnPos < 0) {
            actualNewColumnPos = 0;
        }
        if (actualNewColumnPos == currentPos) {
            return;
        }
        ArrayList tempList = new ArrayList(columns);
        tempList.remove(column);
        tempList.add(actualNewColumnPos, column);
        columns.setAll(tempList);
    }

    private ObservableList<TableColumnBase<?, ?>> getColumns(TableColumnBase column) {
        return column.getParentColumn() == null ? this.getTableViewSkin().getColumns() : column.getParentColumn().getColumns();
    }

    private int getIndex(TableColumnBase<?, ?> column) {
        if (column == null) {
            return -1;
        }
        ObservableList<TableColumnBase<?, ?>> columns = this.getColumns(column);
        int index = -1;
        for (int i = 0; i < columns.size(); ++i) {
            TableColumnBase _column = (TableColumnBase)columns.get(i);
            if (!_column.isVisible()) continue;
            ++index;
            if (column.equals(_column)) break;
        }
        return index;
    }

    private void updateColumnIndex() {
        TableViewSkinBase<?, ?, ?, ?, ?, TableColumnBase<?, ?>> skin = this.getTableViewSkin();
        TableColumnBase tc = this.getTableColumn();
        this.columnIndex = skin == null || tc == null ? -1 : skin.getVisibleLeafIndex(tc);
        this.isLastVisibleColumn = this.getTableColumn() != null && this.columnIndex != -1 && this.columnIndex == this.getTableViewSkin().getVisibleLeafColumns().size() - 1;
        this.pseudoClassStateChanged(PSEUDO_CLASS_LAST_VISIBLE, this.isLastVisibleColumn);
    }

    private void sortColumn(boolean addColumn) {
        if (!this.isSortingEnabled()) {
            return;
        }
        if (this.column == null || this.column.getColumns().size() != 0 || this.column.getComparator() == null || !this.column.isSortable()) {
            return;
        }
        ObservableList<TableColumnBase<?, ?>> sortOrder = this.getTableViewSkin().getSortOrder();
        if (addColumn) {
            if (!this.isSortColumn) {
                TableColumnSortTypeWrapper.setSortType(this.column, TableColumn.SortType.ASCENDING);
                sortOrder.add(this.column);
            } else if (TableColumnSortTypeWrapper.isAscending(this.column)) {
                TableColumnSortTypeWrapper.setSortType(this.column, TableColumn.SortType.DESCENDING);
            } else {
                int i = sortOrder.indexOf(this.column);
                if (i != -1) {
                    sortOrder.remove(i);
                }
            }
        } else if (this.isSortColumn && sortOrder.size() == 1) {
            if (TableColumnSortTypeWrapper.isAscending(this.column)) {
                TableColumnSortTypeWrapper.setSortType(this.column, TableColumn.SortType.DESCENDING);
            } else {
                sortOrder.remove(this.column);
            }
        } else if (this.isSortColumn) {
            if (TableColumnSortTypeWrapper.isAscending(this.column)) {
                TableColumnSortTypeWrapper.setSortType(this.column, TableColumn.SortType.DESCENDING);
            } else if (TableColumnSortTypeWrapper.isDescending(this.column)) {
                TableColumnSortTypeWrapper.setSortType(this.column, TableColumn.SortType.ASCENDING);
            }
            ArrayList sortOrderCopy = new ArrayList(sortOrder);
            sortOrderCopy.remove(this.column);
            sortOrderCopy.add(0, this.column);
            sortOrder.setAll(this.column);
        } else {
            TableColumnSortTypeWrapper.setSortType(this.column, TableColumn.SortType.ASCENDING);
            sortOrder.setAll(this.column);
        }
    }

    private int getSortPosition() {
        if (this.column == null) {
            return -1;
        }
        List<TableColumnBase> sortOrder = this.getVisibleSortOrderColumns();
        int pos = 0;
        for (int i = 0; i < sortOrder.size(); ++i) {
            TableColumnBase _tc = sortOrder.get(i);
            if (this.column.equals(_tc)) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    private List<TableColumnBase> getVisibleSortOrderColumns() {
        ObservableList<TableColumnBase<?, ?>> sortOrder = this.getTableViewSkin().getSortOrder();
        ArrayList<TableColumnBase> visibleSortOrderColumns = new ArrayList<TableColumnBase>();
        for (int i = 0; i < sortOrder.size(); ++i) {
            TableColumnBase _tc = (TableColumnBase)sortOrder.get(i);
            if (_tc == null || !_tc.isSortable() || !_tc.isVisible()) continue;
            visibleSortOrderColumns.add(_tc);
        }
        return visibleSortOrderColumns;
    }

    private int getVisibleSortOrderColumnCount() {
        return this.getVisibleSortOrderColumns().size();
    }

    void columnReorderingStarted(double dragOffset) {
        if (!this.column.impl_isReorderable()) {
            return;
        }
        this.dragOffset = dragOffset;
        this.getTableHeaderRow().setReorderingColumn(this.column);
        this.getTableHeaderRow().setReorderingRegion(this);
    }

    void columnReordering(double sceneX, double sceneY) {
        if (!this.column.impl_isReorderable()) {
            return;
        }
        this.getTableHeaderRow().setReordering(true);
        TableColumnHeader hoverHeader = null;
        double x = this.getParentHeader().sceneToLocal(sceneX, sceneY).getX();
        double dragX = ((Node)((Object)this.getTableViewSkin().getSkinnable())).sceneToLocal(sceneX, sceneY).getX() - this.dragOffset;
        this.getTableHeaderRow().setDragHeaderX(dragX);
        double startX = 0.0;
        double endX = 0.0;
        double headersWidth = 0.0;
        this.newColumnPos = 0;
        for (TableColumnHeader header : this.getParentHeader().getColumnHeaders()) {
            if (!header.isVisible()) continue;
            double headerWidth = header.prefWidth(-1.0);
            headersWidth += headerWidth;
            startX = header.getBoundsInParent().getMinX();
            endX = startX + headerWidth;
            if (x >= startX && x < endX) {
                hoverHeader = header;
                break;
            }
            ++this.newColumnPos;
        }
        if (hoverHeader == null) {
            this.newColumnPos = x > headersWidth ? this.getParentHeader().getColumns().size() - 1 : 0;
            return;
        }
        double midPoint = startX + (endX - startX) / 2.0;
        boolean beforeMidPoint = x <= midPoint;
        int currentPos = this.getIndex(this.column);
        this.newColumnPos += this.newColumnPos > currentPos && beforeMidPoint ? -1 : (this.newColumnPos < currentPos && !beforeMidPoint ? 1 : 0);
        double lineX = this.getTableHeaderRow().sceneToLocal(hoverHeader.localToScene(hoverHeader.getBoundsInLocal())).getMinX();
        if ((lineX += beforeMidPoint ? 0.0 : hoverHeader.getWidth()) >= -0.5 && lineX <= ((Region)((Object)this.getTableViewSkin().getSkinnable())).getWidth()) {
            this.columnReorderLine.setTranslateX(lineX);
            this.columnReorderLine.setVisible(true);
        }
        this.getTableHeaderRow().setReordering(true);
    }

    void columnReorderingComplete() {
        if (!this.column.impl_isReorderable()) {
            return;
        }
        this.moveColumn(this.getTableColumn(), this.newColumnPos);
        this.columnReorderLine.setTranslateX(0.0);
        this.columnReorderLine.setLayoutX(0.0);
        this.newColumnPos = 0;
        this.getTableHeaderRow().setReordering(false);
        this.columnReorderLine.setVisible(false);
        this.getTableHeaderRow().setReorderingColumn(null);
        this.getTableHeaderRow().setReorderingRegion(null);
        this.dragOffset = 0.0;
    }

    double getDragRectHeight() {
        return this.getHeight();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TableColumnHeader.getClassCssMetaData();
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case INDEX: {
                return this.getIndex(this.column);
            }
            case TEXT: {
                return this.column != null ? this.column.getText() : null;
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    private static /* synthetic */ void lambda$static$56(ContextMenuEvent me) {
        TableColumnHeader header = (TableColumnHeader)me.getSource();
        TableColumnBase tableColumn = header.getTableColumn();
        ContextMenu menu = tableColumn.getContextMenu();
        if (menu != null) {
            menu.show(header, me.getScreenX(), me.getScreenY());
            me.consume();
        }
    }

    private static /* synthetic */ void lambda$static$55(MouseEvent me) {
        if (me.isPopupTrigger()) {
            return;
        }
        TableColumnHeader header = (TableColumnHeader)me.getSource();
        TableColumnBase tableColumn = header.getTableColumn();
        ContextMenu menu = tableColumn.getContextMenu();
        if (menu != null && menu.isShowing()) {
            return;
        }
        if (header.getTableHeaderRow().isReordering() && header.isColumnReorderingEnabled()) {
            header.columnReorderingComplete();
        } else if (me.isStillSincePress()) {
            header.sortColumn(me.isShiftDown());
        }
        me.consume();
    }

    private static /* synthetic */ void lambda$static$54(MouseEvent me) {
        TableColumnHeader header = (TableColumnHeader)me.getSource();
        if (me.isPrimaryButtonDown() && header.isColumnReorderingEnabled()) {
            header.columnReordering(me.getSceneX(), me.getSceneY());
        }
        me.consume();
    }

    private static /* synthetic */ void lambda$static$53(MouseEvent me) {
        TableColumnHeader header = (TableColumnHeader)me.getSource();
        ((Node)((Object)header.getTableViewSkin().getSkinnable())).requestFocus();
        if (me.isPrimaryButtonDown() && header.isColumnReorderingEnabled()) {
            header.columnReorderingStarted(me.getX());
        }
        me.consume();
    }

    private /* synthetic */ void lambda$new$52(ListChangeListener.Change c) {
        this.updateStyleClass();
    }

    private /* synthetic */ void lambda$new$51(ListChangeListener.Change c) {
        this.updateColumnIndex();
        this.updateSortPosition();
    }

    private /* synthetic */ void lambda$new$50(ListChangeListener.Change c) {
        this.updateSortPosition();
    }

    private /* synthetic */ Void lambda$new$49(String p) {
        this.handlePropertyChanged(p);
        return null;
    }

    static /* synthetic */ void access$lambda$0(TableColumnHeader tableColumnHeader, ListChangeListener.Change change) {
        tableColumnHeader.lambda$new$50(change);
    }

    static /* synthetic */ void access$lambda$1(TableColumnHeader tableColumnHeader, ListChangeListener.Change change) {
        tableColumnHeader.lambda$new$51(change);
    }

    static /* synthetic */ void access$lambda$2(TableColumnHeader tableColumnHeader, ListChangeListener.Change change) {
        tableColumnHeader.lambda$new$52(change);
    }

    static /* synthetic */ Void access$lambda$3(TableColumnHeader tableColumnHeader, String string) {
        return tableColumnHeader.lambda$new$49(string);
    }

    static /* synthetic */ void access$lambda$4(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    static /* synthetic */ void access$lambda$5(MouseEvent mouseEvent) {
        TableColumnHeader.lambda$static$53(mouseEvent);
    }

    static /* synthetic */ void access$lambda$6(MouseEvent mouseEvent) {
        TableColumnHeader.lambda$static$54(mouseEvent);
    }

    static /* synthetic */ void access$lambda$7(MouseEvent mouseEvent) {
        TableColumnHeader.lambda$static$55(mouseEvent);
    }

    static /* synthetic */ void access$lambda$8(ContextMenuEvent contextMenuEvent) {
        TableColumnHeader.lambda$static$56(contextMenuEvent);
    }

    private static class StyleableProperties {
        private static final CssMetaData<TableColumnHeader, Number> SIZE = new CssMetaData<TableColumnHeader, Number>("-fx-size", SizeConverter.getInstance(), (Number)20.0){

            @Override
            public boolean isSettable(TableColumnHeader n) {
                return n.size == null || !n.size.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(TableColumnHeader n) {
                return (StyleableProperty)((Object)n.sizeProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Region.getClassCssMetaData());
            styleables.add(SIZE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

