/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.glass.ui.android.DalvikInput;
import com.sun.glass.ui.android.SoftwareKeyboard;
import com.sun.javafx.scene.control.skin.TextAreaSkin;
import com.sun.javafx.scene.control.skin.TextAreaSkinAndroid$$Lambda$1;
import com.sun.javafx.scene.control.skin.TextAreaSkinAndroid$$Lambda$2;
import com.sun.javafx.scene.control.skin.TextAreaSkinAndroid$$Lambda$3;
import javafx.beans.value.ObservableValue;
import javafx.scene.Scene;
import javafx.scene.control.TextArea;

public class TextAreaSkinAndroid
extends TextAreaSkin {
    private final TextArea textArea;
    boolean isShowingSoftwareKeyboard = false;

    public TextAreaSkinAndroid(TextArea textArea) {
        super(textArea);
        this.textArea = textArea;
        if (textArea.isFocused() && textArea.isEditable() && textArea.getScene() != null) {
            this.showSoftwareKeyboard();
        }
        textArea.sceneProperty().addListener(TextAreaSkinAndroid$$Lambda$1.lambdaFactory$(this));
        textArea.focusedProperty().addListener(TextAreaSkinAndroid$$Lambda$2.lambdaFactory$(this));
    }

    private void showSoftwareKeyboard() {
        if (!this.textArea.isEditable()) {
            return;
        }
        if (!this.isShowingSoftwareKeyboard) {
            SoftwareKeyboard.show();
            this.isShowingSoftwareKeyboard = true;
            try {
                DalvikInput.setActiveNode(this.textArea);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        double kh = DalvikInput.keyboardSize;
        this.adjustSize(kh);
        DalvikInput.setKeyboardHeightListener(TextAreaSkinAndroid$$Lambda$3.lambdaFactory$(this));
    }

    private void evaluateVisibility() {
        Scene scene = this.textArea.getScene();
        boolean focused = this.textArea.isFocused();
        if (scene != null && focused) {
            this.showSoftwareKeyboard();
        } else {
            this.hideSoftwareKeyboard();
        }
    }

    private void adjustSize(double kh) {
        double th;
        double tTot = this.textArea.getScene().getHeight();
        double trans = this.textArea.getLocalToSceneTransform().getTy();
        double ty = trans + (th = this.textArea.getHeight());
        if (ty > tTot - kh) {
            if (tTot < kh + th) {
                this.textArea.getScene().getRoot().setTranslateY(-trans);
            } else {
                this.textArea.getScene().getRoot().setTranslateY(tTot - ty - kh);
            }
        } else if (kh < 1.0) {
            this.textArea.getScene().getRoot().setTranslateY(0.0);
        }
    }

    private void hideSoftwareKeyboard() {
        if (!this.textArea.isEditable()) {
            return;
        }
        if (!this.isShowingSoftwareKeyboard) {
            return;
        }
        SoftwareKeyboard.hide();
        this.isShowingSoftwareKeyboard = false;
        if (this.textArea.getScene() != null) {
            this.textArea.getScene().getRoot().setTranslateY(0.0);
        }
    }

    private /* synthetic */ void lambda$showSoftwareKeyboard$640(Double e) {
        this.adjustSize(e);
    }

    private /* synthetic */ void lambda$new$639(ObservableValue o, Boolean a, Boolean b) {
        this.evaluateVisibility();
    }

    private /* synthetic */ void lambda$new$638(ObservableValue o, Scene a, Scene b) {
        this.evaluateVisibility();
    }

    static /* synthetic */ void access$lambda$0(TextAreaSkinAndroid textAreaSkinAndroid, ObservableValue observableValue, Scene scene, Scene scene2) {
        textAreaSkinAndroid.lambda$new$638(observableValue, scene, scene2);
    }

    static /* synthetic */ void access$lambda$1(TextAreaSkinAndroid textAreaSkinAndroid, ObservableValue observableValue, Boolean bl, Boolean bl2) {
        textAreaSkinAndroid.lambda$new$639(observableValue, bl, bl2);
    }

    static /* synthetic */ void access$lambda$2(TextAreaSkinAndroid textAreaSkinAndroid, Double d) {
        textAreaSkinAndroid.lambda$showSoftwareKeyboard$640(d);
    }
}

