/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.PasswordFieldBehavior;
import com.sun.javafx.scene.control.behavior.TextFieldBehavior;
import com.sun.javafx.scene.control.skin.TextFieldSkin$$Lambda$1;
import com.sun.javafx.scene.control.skin.TextFieldSkin$$Lambda$10;
import com.sun.javafx.scene.control.skin.TextFieldSkin$$Lambda$11;
import com.sun.javafx.scene.control.skin.TextFieldSkin$$Lambda$12;
import com.sun.javafx.scene.control.skin.TextFieldSkin$$Lambda$2;
import com.sun.javafx.scene.control.skin.TextFieldSkin$$Lambda$3;
import com.sun.javafx.scene.control.skin.TextFieldSkin$$Lambda$4;
import com.sun.javafx.scene.control.skin.TextFieldSkin$$Lambda$5;
import com.sun.javafx.scene.control.skin.TextFieldSkin$$Lambda$6;
import com.sun.javafx.scene.control.skin.TextFieldSkin$$Lambda$7;
import com.sun.javafx.scene.control.skin.TextFieldSkin$$Lambda$8;
import com.sun.javafx.scene.control.skin.TextFieldSkin$$Lambda$9;
import com.sun.javafx.scene.control.skin.TextInputControlSkin;
import com.sun.javafx.scene.control.skin.Utils;
import com.sun.javafx.scene.text.HitInfo;
import com.sun.javafx.tk.FontMetrics;
import java.util.Collection;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.IndexRange;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;

public class TextFieldSkin
extends TextInputControlSkin<TextField, TextFieldBehavior> {
    private Pane textGroup = new Pane();
    private Group handleGroup;
    private Rectangle clip = new Rectangle();
    private Text textNode = new Text();
    private Text promptNode;
    private Path selectionHighlightPath = new Path();
    private Path characterBoundingPath = new Path();
    private ObservableBooleanValue usePromptText;
    private DoubleProperty textTranslateX = new SimpleDoubleProperty(this, "textTranslateX");
    private double caretWidth;
    protected ObservableDoubleValue textRight;
    private double pressX;
    private double pressY;
    public static final char BULLET = '\u25cf';

    protected int translateCaretPosition(int cp) {
        return cp;
    }

    protected Point2D translateCaretPosition(Point2D p) {
        return p;
    }

    public TextFieldSkin(TextField textField) {
        this(textField, textField instanceof PasswordField ? new PasswordFieldBehavior((PasswordField)textField) : new TextFieldBehavior(textField));
    }

    public TextFieldSkin(final TextField textField, TextFieldBehavior behavior) {
        super(textField, behavior);
        behavior.setTextFieldSkin(this);
        textField.caretPositionProperty().addListener(TextFieldSkin$$Lambda$1.lambdaFactory$(this, textField));
        this.forwardBiasProperty().addListener(TextFieldSkin$$Lambda$2.lambdaFactory$(this, textField));
        this.textRight = new DoubleBinding(){
            {
                this.bind(TextFieldSkin.this.textGroup.widthProperty());
            }

            @Override
            protected double computeValue() {
                return TextFieldSkin.this.textGroup.getWidth();
            }
        };
        this.clip.setSmooth(false);
        this.clip.setX(0.0);
        this.clip.widthProperty().bind(this.textGroup.widthProperty());
        this.clip.heightProperty().bind(this.textGroup.heightProperty());
        this.textGroup.setClip(this.clip);
        this.textGroup.getChildren().addAll((Node[])new Node[]{this.selectionHighlightPath, this.textNode, new Group(this.caretPath)});
        this.getChildren().add(this.textGroup);
        if (SHOW_HANDLES) {
            this.handleGroup = new Group();
            this.handleGroup.setManaged(false);
            this.handleGroup.getChildren().addAll((Node[])new Node[]{this.caretHandle, this.selectionHandle1, this.selectionHandle2});
            this.getChildren().add(this.handleGroup);
        }
        this.textNode.setManaged(false);
        this.textNode.getStyleClass().add("text");
        this.textNode.fontProperty().bind(textField.fontProperty());
        this.textNode.layoutXProperty().bind(this.textTranslateX);
        this.textNode.textProperty().bind(new StringBinding(){
            {
                this.bind(textField.textProperty());
            }

            @Override
            protected String computeValue() {
                return TextFieldSkin.this.maskText(textField.textProperty().getValueSafe());
            }
        });
        this.textNode.fillProperty().bind(this.textFill);
        this.textNode.impl_selectionFillProperty().bind((ObservableValue<Paint>)new ObjectBinding<Paint>(){
            {
                this.bind(TextFieldSkin.this.highlightTextFill, TextFieldSkin.this.textFill, textField.focusedProperty());
            }

            @Override
            protected Paint computeValue() {
                return textField.isFocused() ? (Paint)TextFieldSkin.this.highlightTextFill.get() : (Paint)TextFieldSkin.this.textFill.get();
            }
        });
        this.updateTextNodeCaretPos(textField.getCaretPosition());
        textField.selectionProperty().addListener(TextFieldSkin$$Lambda$3.lambdaFactory$(this));
        this.selectionHighlightPath.setManaged(false);
        this.selectionHighlightPath.setStroke(null);
        this.selectionHighlightPath.layoutXProperty().bind(this.textTranslateX);
        this.selectionHighlightPath.visibleProperty().bind(textField.anchorProperty().isNotEqualTo(textField.caretPositionProperty()).and(textField.focusedProperty()));
        this.selectionHighlightPath.fillProperty().bind(this.highlightFill);
        this.textNode.impl_selectionShapeProperty().addListener(TextFieldSkin$$Lambda$4.lambdaFactory$(this));
        this.caretPath.setManaged(false);
        this.caretPath.setStrokeWidth(1.0);
        this.caretPath.fillProperty().bind(this.textFill);
        this.caretPath.strokeProperty().bind(this.textFill);
        this.caretPath.opacityProperty().bind(new DoubleBinding(){
            {
                this.bind(TextFieldSkin.this.caretVisible);
            }

            @Override
            protected double computeValue() {
                return TextFieldSkin.this.caretVisible.get() ? 1.0 : 0.0;
            }
        });
        this.caretPath.layoutXProperty().bind(this.textTranslateX);
        this.textNode.impl_caretShapeProperty().addListener(TextFieldSkin$$Lambda$5.lambdaFactory$(this, textField));
        textField.fontProperty().addListener(TextFieldSkin$$Lambda$6.lambdaFactory$(this, textField));
        this.registerChangeListener(textField.prefColumnCountProperty(), "prefColumnCount");
        if (textField.isFocused()) {
            this.setCaretAnimating(true);
        }
        textField.alignmentProperty().addListener(TextFieldSkin$$Lambda$7.lambdaFactory$(this, textField));
        this.usePromptText = new BooleanBinding(){
            {
                this.bind(textField.textProperty(), textField.promptTextProperty(), TextFieldSkin.this.promptTextFill);
            }

            @Override
            protected boolean computeValue() {
                String txt = textField.getText();
                String promptTxt = textField.getPromptText();
                return (txt == null || txt.isEmpty()) && promptTxt != null && !promptTxt.isEmpty() && !((Paint)TextFieldSkin.this.promptTextFill.get()).equals(Color.TRANSPARENT);
            }
        };
        this.promptTextFill.addListener(TextFieldSkin$$Lambda$8.lambdaFactory$(this));
        textField.textProperty().addListener(TextFieldSkin$$Lambda$9.lambdaFactory$(this));
        if (this.usePromptText.get()) {
            this.createPromptNode();
        }
        this.usePromptText.addListener(TextFieldSkin$$Lambda$10.lambdaFactory$(this, textField));
        if (SHOW_HANDLES) {
            this.selectionHandle1.setRotate(180.0);
            EventHandler handlePressHandler = TextFieldSkin$$Lambda$11.lambdaFactory$(this);
            this.caretHandle.setOnMousePressed(handlePressHandler);
            this.selectionHandle1.setOnMousePressed(handlePressHandler);
            this.selectionHandle2.setOnMousePressed(handlePressHandler);
            this.caretHandle.setOnMouseDragged(TextFieldSkin$$Lambda$12.lambdaFactory$(this));
            this.selectionHandle1.setOnMouseDragged((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent e) {
                    TextField textField = (TextField)TextFieldSkin.this.getSkinnable();
                    Point2D tp = TextFieldSkin.this.textNode.localToScene(0.0, 0.0);
                    Point2D p = new Point2D(e.getSceneX() - tp.getX() + 10.0 - TextFieldSkin.this.pressX + TextFieldSkin.this.selectionHandle1.getWidth() / 2.0, e.getSceneY() - tp.getY() - TextFieldSkin.this.pressY - 6.0);
                    HitInfo hit = TextFieldSkin.this.textNode.impl_hitTestChar(TextFieldSkin.this.translateCaretPosition(p));
                    int pos = hit.getCharIndex();
                    if (textField.getAnchor() < textField.getCaretPosition()) {
                        textField.selectRange(textField.getCaretPosition(), textField.getAnchor());
                    }
                    if (pos >= 0) {
                        if (pos >= textField.getAnchor() - 1) {
                            hit.setCharIndex(Math.max(0, textField.getAnchor() - 1));
                        }
                        TextFieldSkin.this.positionCaret(hit, true);
                    }
                    e.consume();
                }
            });
            this.selectionHandle2.setOnMouseDragged((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent e) {
                    TextField textField = (TextField)TextFieldSkin.this.getSkinnable();
                    Point2D tp = TextFieldSkin.this.textNode.localToScene(0.0, 0.0);
                    Point2D p = new Point2D(e.getSceneX() - tp.getX() + 10.0 - TextFieldSkin.this.pressX + TextFieldSkin.this.selectionHandle2.getWidth() / 2.0, e.getSceneY() - tp.getY() - TextFieldSkin.this.pressY - 6.0);
                    HitInfo hit = TextFieldSkin.this.textNode.impl_hitTestChar(TextFieldSkin.this.translateCaretPosition(p));
                    int pos = hit.getCharIndex();
                    if (textField.getAnchor() > textField.getCaretPosition()) {
                        textField.selectRange(textField.getCaretPosition(), textField.getAnchor());
                    }
                    if (pos > 0) {
                        if (pos <= textField.getAnchor()) {
                            hit.setCharIndex(Math.min(textField.getAnchor() + 1, textField.getLength()));
                        }
                        TextFieldSkin.this.positionCaret(hit, true);
                    }
                    e.consume();
                }
            });
        }
    }

    private void updateTextNodeCaretPos(int pos) {
        if (pos == 0 || this.isForwardBias()) {
            this.textNode.setImpl_caretPosition(pos);
        } else {
            this.textNode.setImpl_caretPosition(pos - 1);
        }
        this.textNode.impl_caretBiasProperty().set(this.isForwardBias());
    }

    private void createPromptNode() {
        if (this.promptNode != null || !this.usePromptText.get()) {
            return;
        }
        this.promptNode = new Text();
        this.textGroup.getChildren().add(0, this.promptNode);
        this.promptNode.setManaged(false);
        this.promptNode.getStyleClass().add("text");
        this.promptNode.visibleProperty().bind(this.usePromptText);
        this.promptNode.fontProperty().bind(((TextField)this.getSkinnable()).fontProperty());
        this.promptNode.textProperty().bind(((TextField)this.getSkinnable()).promptTextProperty());
        this.promptNode.fillProperty().bind(this.promptTextFill);
        this.updateSelection();
    }

    private void updateSelection() {
        TextField textField = (TextField)this.getSkinnable();
        IndexRange newValue = textField.getSelection();
        if (newValue == null || newValue.getLength() == 0) {
            this.textNode.impl_selectionStartProperty().set(-1);
            this.textNode.impl_selectionEndProperty().set(-1);
        } else {
            this.textNode.impl_selectionStartProperty().set(newValue.getStart());
            this.textNode.impl_selectionEndProperty().set(newValue.getStart());
            this.textNode.impl_selectionEndProperty().set(newValue.getEnd());
        }
        PathElement[] elements = (PathElement[])this.textNode.impl_selectionShapeProperty().get();
        if (elements == null) {
            this.selectionHighlightPath.getElements().clear();
        } else {
            this.selectionHighlightPath.getElements().setAll((PathElement[])elements);
        }
        if (SHOW_HANDLES && newValue != null && newValue.getLength() > 0) {
            int caretPos = textField.getCaretPosition();
            int anchorPos = textField.getAnchor();
            this.updateTextNodeCaretPos(anchorPos);
            Bounds b = this.caretPath.getBoundsInParent();
            if (caretPos < anchorPos) {
                this.selectionHandle2.setLayoutX(b.getMinX() - this.selectionHandle2.getWidth() / 2.0);
            } else {
                this.selectionHandle1.setLayoutX(b.getMinX() - this.selectionHandle1.getWidth() / 2.0);
            }
            this.updateTextNodeCaretPos(caretPos);
            b = this.caretPath.getBoundsInParent();
            if (caretPos < anchorPos) {
                this.selectionHandle1.setLayoutX(b.getMinX() - this.selectionHandle1.getWidth() / 2.0);
            } else {
                this.selectionHandle2.setLayoutX(b.getMinX() - this.selectionHandle2.getWidth() / 2.0);
            }
        }
    }

    @Override
    protected void handleControlPropertyChanged(String propertyReference) {
        if ("prefColumnCount".equals(propertyReference)) {
            ((TextField)this.getSkinnable()).requestLayout();
        } else {
            super.handleControlPropertyChanged(propertyReference);
        }
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        TextField textField = (TextField)this.getSkinnable();
        double characterWidth = ((FontMetrics)this.fontMetrics.get()).computeStringWidth("W");
        int columnCount = textField.getPrefColumnCount();
        return (double)columnCount * characterWidth + leftInset + rightInset;
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + this.textNode.getLayoutBounds().getHeight() + bottomInset;
    }

    @Override
    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((TextField)this.getSkinnable()).prefHeight(width);
    }

    @Override
    public double computeBaselineOffset(double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + this.textNode.getBaselineOffset();
    }

    private void updateTextPos() {
        double oldX = this.textTranslateX.get();
        double textNodeWidth = this.textNode.getLayoutBounds().getWidth();
        switch (this.getHAlignment()) {
            case CENTER: {
                double newX;
                double midPoint = this.textRight.get() / 2.0;
                if (this.usePromptText.get()) {
                    newX = midPoint - this.promptNode.getLayoutBounds().getWidth() / 2.0;
                    this.promptNode.setLayoutX(newX);
                } else {
                    newX = midPoint - textNodeWidth / 2.0;
                }
                if (!(newX + textNodeWidth <= this.textRight.get())) break;
                this.textTranslateX.set(newX);
                break;
            }
            case RIGHT: {
                double newX = this.textRight.get() - textNodeWidth - this.caretWidth / 2.0;
                if (newX > oldX || newX > 0.0) {
                    this.textTranslateX.set(newX);
                }
                if (!this.usePromptText.get()) break;
                this.promptNode.setLayoutX(this.textRight.get() - this.promptNode.getLayoutBounds().getWidth() - this.caretWidth / 2.0);
                break;
            }
            default: {
                double newX = this.caretWidth / 2.0;
                if (newX < oldX || newX + textNodeWidth <= this.textRight.get()) {
                    this.textTranslateX.set(newX);
                }
                if (!this.usePromptText.get()) break;
                this.promptNode.layoutXProperty().set(newX);
            }
        }
    }

    protected void updateCaretOff() {
        double delta = 0.0;
        double caretX = this.caretPath.getLayoutBounds().getMinX() + this.textTranslateX.get();
        if (caretX < 0.0) {
            delta = caretX;
        } else if (caretX > this.textRight.get() - this.caretWidth) {
            delta = caretX - (this.textRight.get() - this.caretWidth);
        }
        switch (this.getHAlignment()) {
            case CENTER: {
                this.textTranslateX.set(this.textTranslateX.get() - delta);
                break;
            }
            case RIGHT: {
                this.textTranslateX.set(Math.max(this.textTranslateX.get() - delta, this.textRight.get() - this.textNode.getLayoutBounds().getWidth() - this.caretWidth / 2.0));
                break;
            }
            default: {
                this.textTranslateX.set(Math.min(this.textTranslateX.get() - delta, this.caretWidth / 2.0));
            }
        }
        if (SHOW_HANDLES) {
            this.caretHandle.setLayoutX(caretX - this.caretHandle.getWidth() / 2.0 + 1.0);
        }
    }

    public void replaceText(int start, int end, String txt) {
        double textMaxXOld = this.textNode.getBoundsInParent().getMaxX();
        double caretMaxXOld = this.caretPath.getLayoutBounds().getMaxX() + this.textTranslateX.get();
        ((TextField)this.getSkinnable()).replaceText(start, end, txt);
        this.scrollAfterDelete(textMaxXOld, caretMaxXOld);
    }

    public void deleteChar(boolean previous) {
        boolean shouldBeep;
        double textMaxXOld = this.textNode.getBoundsInParent().getMaxX();
        double caretMaxXOld = this.caretPath.getLayoutBounds().getMaxX() + this.textTranslateX.get();
        boolean bl = previous ? !((TextField)this.getSkinnable()).deletePreviousChar() : (shouldBeep = !((TextField)this.getSkinnable()).deleteNextChar());
        if (!shouldBeep) {
            this.scrollAfterDelete(textMaxXOld, caretMaxXOld);
        }
    }

    public void scrollAfterDelete(double textMaxXOld, double caretMaxXOld) {
        Bounds textLayoutBounds = this.textNode.getLayoutBounds();
        Bounds textBounds = this.textNode.localToParent(textLayoutBounds);
        Bounds clipBounds = this.clip.getBoundsInParent();
        Bounds caretBounds = this.caretPath.getLayoutBounds();
        switch (this.getHAlignment()) {
            case RIGHT: {
                if (textBounds.getMaxX() > clipBounds.getMaxX()) {
                    double delta = caretMaxXOld - caretBounds.getMaxX() - this.textTranslateX.get();
                    if (textBounds.getMaxX() + delta < clipBounds.getMaxX()) {
                        delta = textMaxXOld <= clipBounds.getMaxX() ? textMaxXOld - textBounds.getMaxX() : clipBounds.getMaxX() - textBounds.getMaxX();
                    }
                    this.textTranslateX.set(this.textTranslateX.get() + delta);
                    break;
                }
                this.updateTextPos();
                break;
            }
            default: {
                if (!(textBounds.getMinX() < clipBounds.getMinX() + this.caretWidth / 2.0) || !(textBounds.getMaxX() <= clipBounds.getMaxX())) break;
                double delta = caretMaxXOld - caretBounds.getMaxX() - this.textTranslateX.get();
                if (textBounds.getMaxX() + delta < clipBounds.getMaxX()) {
                    delta = textMaxXOld <= clipBounds.getMaxX() ? textMaxXOld - textBounds.getMaxX() : clipBounds.getMaxX() - textBounds.getMaxX();
                }
                this.textTranslateX.set(this.textTranslateX.get() + delta);
            }
        }
        this.updateCaretOff();
    }

    public HitInfo getIndex(double x, double y) {
        Point2D p = new Point2D(x - this.textTranslateX.get() - this.snappedLeftInset(), y - this.snappedTopInset());
        return this.textNode.impl_hitTestChar(this.translateCaretPosition(p));
    }

    public void positionCaret(HitInfo hit, boolean select) {
        TextField textField = (TextField)this.getSkinnable();
        int pos = Utils.getHitInsertionIndex(hit, textField.textProperty().getValueSafe());
        if (select) {
            textField.selectPositionCaret(pos);
        } else {
            textField.positionCaret(pos);
        }
        this.setForwardBias(hit.isLeading());
    }

    @Override
    public Rectangle2D getCharacterBounds(int index) {
        double height;
        double width;
        double y;
        double x;
        if (index == this.textNode.getText().length()) {
            Bounds textNodeBounds = this.textNode.getBoundsInLocal();
            x = textNodeBounds.getMaxX();
            y = 0.0;
            width = 0.0;
            height = textNodeBounds.getMaxY();
        } else {
            this.characterBoundingPath.getElements().clear();
            this.characterBoundingPath.getElements().addAll((PathElement[])this.textNode.impl_getRangeShape(index, index + 1));
            this.characterBoundingPath.setLayoutX(this.textNode.getLayoutX());
            this.characterBoundingPath.setLayoutY(this.textNode.getLayoutY());
            Bounds bounds = this.characterBoundingPath.getBoundsInLocal();
            x = bounds.getMinX();
            y = bounds.getMinY();
            width = bounds.isEmpty() ? 0.0 : bounds.getWidth();
            height = bounds.isEmpty() ? 0.0 : bounds.getHeight();
        }
        Bounds textBounds = this.textGroup.getBoundsInParent();
        return new Rectangle2D(x + textBounds.getMinX() + this.textTranslateX.get(), y + textBounds.getMinY(), width, height);
    }

    @Override
    protected PathElement[] getUnderlineShape(int start, int end) {
        return this.textNode.impl_getUnderlineShape(start, end);
    }

    @Override
    protected PathElement[] getRangeShape(int start, int end) {
        return this.textNode.impl_getRangeShape(start, end);
    }

    @Override
    protected void addHighlight(List<? extends Node> nodes, int start) {
        this.textGroup.getChildren().addAll((Collection<Node>)nodes);
    }

    @Override
    protected void removeHighlight(List<? extends Node> nodes) {
        this.textGroup.getChildren().removeAll((Collection<?>)nodes);
    }

    @Override
    public void nextCharacterVisually(boolean moveRight) {
        if (this.isRTL()) {
            moveRight = !moveRight;
        }
        Bounds caretBounds = this.caretPath.getLayoutBounds();
        if (this.caretPath.getElements().size() == 4) {
            caretBounds = new Path((PathElement)this.caretPath.getElements().get(0), (PathElement)this.caretPath.getElements().get(1)).getLayoutBounds();
        }
        double hitX = moveRight ? caretBounds.getMaxX() : caretBounds.getMinX();
        double hitY = (caretBounds.getMinY() + caretBounds.getMaxY()) / 2.0;
        HitInfo hit = this.textNode.impl_hitTestChar(this.translateCaretPosition(new Point2D(hitX, hitY)));
        Path charShape = new Path(this.textNode.impl_getRangeShape(hit.getCharIndex(), hit.getCharIndex() + 1));
        if (moveRight && charShape.getLayoutBounds().getMaxX() > caretBounds.getMaxX() || !moveRight && charShape.getLayoutBounds().getMinX() < caretBounds.getMinX()) {
            hit.setLeading(!hit.isLeading());
        }
        this.positionCaret(hit, false);
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        if (this.textNode != null) {
            double textY;
            Bounds textNodeBounds = this.textNode.getLayoutBounds();
            double ascent = this.textNode.getBaselineOffset();
            double descent = textNodeBounds.getHeight() - ascent;
            switch (((TextField)this.getSkinnable()).getAlignment().getVpos()) {
                case TOP: {
                    textY = ascent;
                    break;
                }
                case CENTER: {
                    textY = (ascent + this.textGroup.getHeight() - descent) / 2.0;
                    break;
                }
                default: {
                    textY = this.textGroup.getHeight() - descent;
                }
            }
            this.textNode.setY(textY);
            if (this.promptNode != null) {
                this.promptNode.setY(textY);
            }
            if (((TextField)this.getSkinnable()).getWidth() > 0.0) {
                this.updateTextPos();
                this.updateCaretOff();
            }
        }
        if (SHOW_HANDLES) {
            this.handleGroup.setLayoutX(x + this.textTranslateX.get());
            this.handleGroup.setLayoutY(y);
            this.selectionHandle1.resize(this.selectionHandle1.prefWidth(-1.0), this.selectionHandle1.prefHeight(-1.0));
            this.selectionHandle2.resize(this.selectionHandle2.prefWidth(-1.0), this.selectionHandle2.prefHeight(-1.0));
            this.caretHandle.resize(this.caretHandle.prefWidth(-1.0), this.caretHandle.prefHeight(-1.0));
            Bounds b = this.caretPath.getBoundsInParent();
            this.caretHandle.setLayoutY(b.getMaxY() - 1.0);
            this.selectionHandle1.setLayoutY(b.getMinY() - this.selectionHandle1.getHeight() + 1.0);
            this.selectionHandle2.setLayoutY(b.getMaxY() - 1.0);
        }
    }

    protected HPos getHAlignment() {
        HPos hPos = ((TextField)this.getSkinnable()).getAlignment().getHpos();
        return hPos;
    }

    @Override
    public Point2D getMenuPosition() {
        Point2D p = super.getMenuPosition();
        if (p != null) {
            p = new Point2D(Math.max(0.0, p.getX() - this.textNode.getLayoutX() - this.snappedLeftInset() + this.textTranslateX.get()), Math.max(0.0, p.getY() - this.textNode.getLayoutY() - this.snappedTopInset()));
        }
        return p;
    }

    @Override
    protected String maskText(String txt) {
        if (this.getSkinnable() instanceof PasswordField) {
            int n = txt.length();
            StringBuilder passwordBuilder = new StringBuilder(n);
            for (int i = 0; i < n; ++i) {
                passwordBuilder.append('\u25cf');
            }
            return passwordBuilder.toString();
        }
        return txt;
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case BOUNDS_FOR_RANGE: 
            case OFFSET_AT_POINT: {
                return this.textNode.queryAccessibleAttribute(attribute, parameters);
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    private /* synthetic */ void lambda$new$205(MouseEvent e) {
        Point2D p = new Point2D(this.caretHandle.getLayoutX() + e.getX() + this.pressX - this.textNode.getLayoutX(), this.caretHandle.getLayoutY() + e.getY() - this.pressY - 6.0);
        HitInfo hit = this.textNode.impl_hitTestChar(this.translateCaretPosition(p));
        this.positionCaret(hit, false);
        e.consume();
    }

    private /* synthetic */ void lambda$new$204(MouseEvent e) {
        this.pressX = e.getX();
        this.pressY = e.getY();
        e.consume();
    }

    private /* synthetic */ void lambda$new$203(TextField textField, Observable observable) {
        this.createPromptNode();
        textField.requestLayout();
    }

    private /* synthetic */ void lambda$new$202(Observable observable) {
        if (!((TextFieldBehavior)this.getBehavior()).isEditing()) {
            this.updateTextPos();
        }
    }

    private /* synthetic */ void lambda$new$201(Observable observable) {
        this.updateTextPos();
    }

    private /* synthetic */ void lambda$new$200(TextField textField, Observable observable) {
        if (textField.getWidth() > 0.0) {
            this.updateTextPos();
            this.updateCaretOff();
            textField.requestLayout();
        }
    }

    private /* synthetic */ void lambda$new$199(TextField textField, Observable observable) {
        textField.requestLayout();
        ((TextField)this.getSkinnable()).requestLayout();
    }

    private /* synthetic */ void lambda$new$198(TextField textField, Observable observable) {
        this.caretPath.getElements().setAll((PathElement[])((Object[])this.textNode.impl_caretShapeProperty().get()));
        if (this.caretPath.getElements().size() == 0) {
            this.updateTextNodeCaretPos(textField.getCaretPosition());
        } else if (this.caretPath.getElements().size() != 4) {
            this.caretWidth = Math.round(this.caretPath.getLayoutBounds().getWidth());
        }
    }

    private /* synthetic */ void lambda$new$197(Observable observable) {
        this.updateSelection();
    }

    private /* synthetic */ void lambda$new$196(Observable observable) {
        this.updateSelection();
    }

    private /* synthetic */ void lambda$new$195(TextField textField, Observable observable) {
        if (textField.getWidth() > 0.0) {
            this.updateTextNodeCaretPos(textField.getCaretPosition());
            this.updateCaretOff();
        }
    }

    private /* synthetic */ void lambda$new$194(TextField textField, ObservableValue observable, Number oldValue, Number newValue) {
        if (textField.getWidth() > 0.0) {
            this.updateTextNodeCaretPos(textField.getCaretPosition());
            if (!this.isForwardBias()) {
                this.setForwardBias(true);
            }
            this.updateCaretOff();
        }
    }

    static /* synthetic */ void access$lambda$0(TextFieldSkin textFieldSkin, TextField textField, ObservableValue observableValue, Number number, Number number2) {
        textFieldSkin.lambda$new$194(textField, observableValue, number, number2);
    }

    static /* synthetic */ void access$lambda$1(TextFieldSkin textFieldSkin, TextField textField, Observable observable) {
        textFieldSkin.lambda$new$195(textField, observable);
    }

    static /* synthetic */ void access$lambda$2(TextFieldSkin textFieldSkin, Observable observable) {
        textFieldSkin.lambda$new$196(observable);
    }

    static /* synthetic */ void access$lambda$3(TextFieldSkin textFieldSkin, Observable observable) {
        textFieldSkin.lambda$new$197(observable);
    }

    static /* synthetic */ void access$lambda$4(TextFieldSkin textFieldSkin, TextField textField, Observable observable) {
        textFieldSkin.lambda$new$198(textField, observable);
    }

    static /* synthetic */ void access$lambda$5(TextFieldSkin textFieldSkin, TextField textField, Observable observable) {
        textFieldSkin.lambda$new$199(textField, observable);
    }

    static /* synthetic */ void access$lambda$6(TextFieldSkin textFieldSkin, TextField textField, Observable observable) {
        textFieldSkin.lambda$new$200(textField, observable);
    }

    static /* synthetic */ void access$lambda$7(TextFieldSkin textFieldSkin, Observable observable) {
        textFieldSkin.lambda$new$201(observable);
    }

    static /* synthetic */ void access$lambda$8(TextFieldSkin textFieldSkin, Observable observable) {
        textFieldSkin.lambda$new$202(observable);
    }

    static /* synthetic */ void access$lambda$9(TextFieldSkin textFieldSkin, TextField textField, Observable observable) {
        textFieldSkin.lambda$new$203(textField, observable);
    }

    static /* synthetic */ void access$lambda$10(TextFieldSkin textFieldSkin, MouseEvent mouseEvent) {
        textFieldSkin.lambda$new$204(mouseEvent);
    }

    static /* synthetic */ void access$lambda$11(TextFieldSkin textFieldSkin, MouseEvent mouseEvent) {
        textFieldSkin.lambda$new$205(mouseEvent);
    }
}

