/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.glass.ui.android.DalvikInput;
import com.sun.glass.ui.android.SoftwareKeyboard;
import com.sun.javafx.scene.control.behavior.TextFieldBehavior;
import com.sun.javafx.scene.control.skin.TextFieldSkin;
import com.sun.javafx.scene.control.skin.TextFieldSkinAndroid$$Lambda$1;
import com.sun.javafx.scene.control.skin.TextFieldSkinAndroid$$Lambda$2;
import com.sun.javafx.scene.control.skin.TextFieldSkinAndroid$$Lambda$3;
import javafx.beans.value.ObservableValue;
import javafx.scene.Scene;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;

public class TextFieldSkinAndroid
extends TextFieldSkin {
    public static final char MOBILEBULLET = '\u2022';
    private final TextField textField;
    boolean isShowingSoftwareKeyboard = false;

    public TextFieldSkinAndroid(TextField textField) {
        super(textField);
        this.textField = textField;
        if (textField.isFocused() && textField.getScene() != null) {
            this.showSoftwareKeyboard();
        }
        textField.sceneProperty().addListener(TextFieldSkinAndroid$$Lambda$1.lambdaFactory$(this));
        textField.focusedProperty().addListener(TextFieldSkinAndroid$$Lambda$2.lambdaFactory$(this));
    }

    public TextFieldSkinAndroid(TextField textField, TextFieldBehavior behavior) {
        super(textField, behavior);
        this.textField = textField;
    }

    private void evaluateVisibility() {
        Scene scene = this.textField.getScene();
        boolean focused = this.textField.isFocused();
        if (scene != null && focused) {
            this.showSoftwareKeyboard();
        } else {
            this.hideSoftwareKeyboard();
        }
    }

    @Override
    protected String maskText(String txt) {
        if (this.getSkinnable() instanceof PasswordField) {
            int n = txt.length();
            StringBuilder passwordBuilder = new StringBuilder(n);
            for (int i = 0; i < n; ++i) {
                passwordBuilder.append('\u2022');
            }
            return passwordBuilder.toString();
        }
        return txt;
    }

    private void showSoftwareKeyboard() {
        if (!this.textField.isEditable()) {
            return;
        }
        if (!this.isShowingSoftwareKeyboard) {
            SoftwareKeyboard.show();
            this.isShowingSoftwareKeyboard = true;
            try {
                DalvikInput.setActiveNode(this.textField);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        double kh = DalvikInput.keyboardSize;
        this.adjustSize(kh);
        DalvikInput.setKeyboardHeightListener(TextFieldSkinAndroid$$Lambda$3.lambdaFactory$(this));
    }

    private void adjustSize(double kh) {
        double tTot = this.textField.getScene().getHeight();
        double ty = this.textField.getLocalToSceneTransform().getTy() + this.textField.getHeight();
        if (ty > tTot - kh) {
            this.textField.getScene().getRoot().setTranslateY(tTot - ty - kh);
        } else if (kh < 1.0) {
            this.textField.getScene().getRoot().setTranslateY(0.0);
        }
    }

    private void hideSoftwareKeyboard() {
        if (!this.textField.isEditable()) {
            return;
        }
        if (!this.isShowingSoftwareKeyboard) {
            return;
        }
        SoftwareKeyboard.hide();
        this.isShowingSoftwareKeyboard = false;
        if (this.textField.getScene() != null) {
            this.textField.getScene().getRoot().setTranslateY(0.0);
        }
    }

    private /* synthetic */ void lambda$showSoftwareKeyboard$643(Double e) {
        this.adjustSize(e);
    }

    private /* synthetic */ void lambda$new$642(ObservableValue o, Boolean a, Boolean b) {
        this.evaluateVisibility();
    }

    private /* synthetic */ void lambda$new$641(ObservableValue o, Scene a, Scene b) {
        this.evaluateVisibility();
    }

    static /* synthetic */ void access$lambda$0(TextFieldSkinAndroid textFieldSkinAndroid, ObservableValue observableValue, Scene scene, Scene scene2) {
        textFieldSkinAndroid.lambda$new$641(observableValue, scene, scene2);
    }

    static /* synthetic */ void access$lambda$1(TextFieldSkinAndroid textFieldSkinAndroid, ObservableValue observableValue, Boolean bl, Boolean bl2) {
        textFieldSkinAndroid.lambda$new$642(observableValue, bl, bl2);
    }

    static /* synthetic */ void access$lambda$2(TextFieldSkinAndroid textFieldSkinAndroid, Double d) {
        textFieldSkinAndroid.lambda$showSoftwareKeyboard$643(d);
    }
}

