/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.scene.control.MultiplePropertyChangeListenerHandler;
import com.sun.javafx.scene.control.behavior.TreeCellBehavior;
import com.sun.javafx.scene.control.skin.CellSkinBase;
import com.sun.javafx.scene.control.skin.TreeCellSkin$$Lambda$1;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.beans.property.DoubleProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;

public class TreeCellSkin<T>
extends CellSkinBase<TreeCell<T>, TreeCellBehavior<T>> {
    private static final Map<TreeView<?>, Double> maxDisclosureWidthMap = new WeakHashMap();
    private DoubleProperty indent = null;
    private boolean disclosureNodeDirty = true;
    private TreeItem<?> treeItem;
    private double fixedCellSize;
    private boolean fixedCellSizeEnabled;
    private MultiplePropertyChangeListenerHandler treeItemListener = new MultiplePropertyChangeListenerHandler(TreeCellSkin$$Lambda$1.lambdaFactory$(this));

    public final void setIndent(double value) {
        this.indentProperty().set(value);
    }

    public final double getIndent() {
        return this.indent == null ? 10.0 : this.indent.get();
    }

    public final DoubleProperty indentProperty() {
        if (this.indent == null) {
            this.indent = new StyleableDoubleProperty(10.0){

                @Override
                public Object getBean() {
                    return TreeCellSkin.this;
                }

                @Override
                public String getName() {
                    return "indent";
                }

                @Override
                public CssMetaData<TreeCell<?>, Number> getCssMetaData() {
                    return StyleableProperties.INDENT;
                }
            };
        }
        return this.indent;
    }

    public TreeCellSkin(TreeCell<T> control) {
        super(control, new TreeCellBehavior<T>(control));
        this.fixedCellSize = control.getTreeView().getFixedCellSize();
        this.fixedCellSizeEnabled = this.fixedCellSize > 0.0;
        this.updateTreeItem();
        this.updateDisclosureNodeRotation(false);
        this.registerChangeListener(control.treeItemProperty(), "TREE_ITEM");
        this.registerChangeListener(control.textProperty(), "TEXT");
        this.registerChangeListener(control.getTreeView().fixedCellSizeProperty(), "FIXED_CELL_SIZE");
    }

    @Override
    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("TREE_ITEM".equals(p)) {
            this.updateTreeItem();
            this.disclosureNodeDirty = true;
            ((TreeCell)this.getSkinnable()).requestLayout();
        } else if ("TEXT".equals(p)) {
            ((TreeCell)this.getSkinnable()).requestLayout();
        } else if ("FIXED_CELL_SIZE".equals(p)) {
            this.fixedCellSize = ((TreeCell)this.getSkinnable()).getTreeView().getFixedCellSize();
            this.fixedCellSizeEnabled = this.fixedCellSize > 0.0;
        }
    }

    private void updateDisclosureNodeRotation(boolean animate) {
    }

    private void updateTreeItem() {
        if (this.treeItem != null) {
            this.treeItemListener.unregisterChangeListener(this.treeItem.expandedProperty());
        }
        this.treeItem = ((TreeCell)this.getSkinnable()).getTreeItem();
        if (this.treeItem != null) {
            this.treeItemListener.registerChangeListener(this.treeItem.expandedProperty(), "EXPANDED");
        }
        this.updateDisclosureNodeRotation(false);
    }

    private void updateDisclosureNode() {
        if (((TreeCell)this.getSkinnable()).isEmpty()) {
            return;
        }
        Node disclosureNode = ((TreeCell)this.getSkinnable()).getDisclosureNode();
        if (disclosureNode == null) {
            return;
        }
        boolean disclosureVisible = this.treeItem != null && !this.treeItem.isLeaf();
        disclosureNode.setVisible(disclosureVisible);
        if (!disclosureVisible) {
            this.getChildren().remove(disclosureNode);
        } else if (disclosureNode.getParent() == null) {
            this.getChildren().add(disclosureNode);
            disclosureNode.toFront();
        } else {
            disclosureNode.toBack();
        }
        if (disclosureNode.getScene() != null) {
            disclosureNode.applyCss();
        }
    }

    @Override
    protected void updateChildren() {
        super.updateChildren();
        this.updateDisclosureNode();
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        double defaultDisclosureWidth;
        TreeView tree = ((TreeCell)this.getSkinnable()).getTreeView();
        if (tree == null) {
            return;
        }
        if (this.disclosureNodeDirty) {
            this.updateDisclosureNode();
            this.disclosureNodeDirty = false;
        }
        Node disclosureNode = ((TreeCell)this.getSkinnable()).getDisclosureNode();
        int level = tree.getTreeItemLevel(this.treeItem);
        if (!tree.isShowRoot()) {
            --level;
        }
        double leftMargin = this.getIndent() * (double)level;
        x += leftMargin;
        boolean disclosureVisible = disclosureNode != null && this.treeItem != null && !this.treeItem.isLeaf();
        double disclosureWidth = defaultDisclosureWidth = maxDisclosureWidthMap.containsKey(tree) ? maxDisclosureWidthMap.get(tree) : 18.0;
        if (disclosureVisible) {
            if (disclosureNode == null || disclosureNode.getScene() == null) {
                this.updateChildren();
            }
            if (disclosureNode != null) {
                disclosureWidth = disclosureNode.prefWidth(h);
                if (disclosureWidth > defaultDisclosureWidth) {
                    maxDisclosureWidthMap.put(tree, disclosureWidth);
                }
                double ph = disclosureNode.prefHeight(disclosureWidth);
                disclosureNode.resize(disclosureWidth, ph);
                this.positionInArea(disclosureNode, x, y, disclosureWidth, ph, 0.0, HPos.CENTER, VPos.CENTER);
            }
        }
        int padding = this.treeItem != null && this.treeItem.getGraphic() == null ? 0 : 3;
        x += disclosureWidth + (double)padding;
        w -= leftMargin + disclosureWidth + (double)padding;
        Node graphic = ((TreeCell)this.getSkinnable()).getGraphic();
        if (graphic != null && !this.getChildren().contains(graphic)) {
            this.getChildren().add(graphic);
        }
        this.layoutLabelInArea(x, y, w, h);
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.fixedCellSizeEnabled) {
            return this.fixedCellSize;
        }
        double pref = super.computeMinHeight(width, topInset, rightInset, bottomInset, leftInset);
        Node d = ((TreeCell)this.getSkinnable()).getDisclosureNode();
        return d == null ? pref : Math.max(d.minHeight(-1.0), pref);
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.fixedCellSizeEnabled) {
            return this.fixedCellSize;
        }
        TreeCell cell = (TreeCell)this.getSkinnable();
        double pref = super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
        Node d = cell.getDisclosureNode();
        double prefHeight = d == null ? pref : Math.max(d.prefHeight(-1.0), pref);
        return this.snapSize(Math.max(cell.getMinHeight(), prefHeight));
    }

    @Override
    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.fixedCellSizeEnabled) {
            return this.fixedCellSize;
        }
        return super.computeMaxHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double labelWidth = super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
        double pw = this.snappedLeftInset() + this.snappedRightInset();
        TreeView tree = ((TreeCell)this.getSkinnable()).getTreeView();
        if (tree == null) {
            return pw;
        }
        if (this.treeItem == null) {
            return pw;
        }
        pw = labelWidth;
        int level = tree.getTreeItemLevel(this.treeItem);
        if (!tree.isShowRoot()) {
            --level;
        }
        pw += this.getIndent() * (double)level;
        Node disclosureNode = ((TreeCell)this.getSkinnable()).getDisclosureNode();
        double disclosureNodePrefWidth = disclosureNode == null ? 0.0 : disclosureNode.prefWidth(-1.0);
        double defaultDisclosureWidth = maxDisclosureWidthMap.containsKey(tree) ? maxDisclosureWidthMap.get(tree) : 0.0;
        return pw += Math.max(defaultDisclosureWidth, disclosureNodePrefWidth);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TreeCellSkin.getClassCssMetaData();
    }

    private /* synthetic */ Void lambda$new$520(String p) {
        if ("EXPANDED".equals(p)) {
            this.updateDisclosureNodeRotation(true);
        }
        return null;
    }

    static /* synthetic */ Void access$lambda$0(TreeCellSkin treeCellSkin, String string) {
        return treeCellSkin.lambda$new$520(string);
    }

    private static class StyleableProperties {
        private static final CssMetaData<TreeCell<?>, Number> INDENT = new CssMetaData<TreeCell<?>, Number>("-fx-indent", SizeConverter.getInstance(), 10.0){

            @Override
            public boolean isSettable(TreeCell<?> n) {
                DoubleProperty p = ((TreeCellSkin)n.getSkin()).indentProperty();
                return p == null || !p.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(TreeCell<?> n) {
                TreeCellSkin skin = (TreeCellSkin)n.getSkin();
                return (StyleableProperty)((Object)skin.indentProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(CellSkinBase.getClassCssMetaData());
            styleables.add(INDENT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

