/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.skin.ColorPickerSkin;
import com.sun.javafx.scene.control.skin.InputFieldSkin;
import com.sun.javafx.scene.control.skin.WebColorField;
import com.sun.javafx.scene.control.skin.WebColorFieldSkin$$Lambda$1;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.paint.Color;

class WebColorFieldSkin
extends InputFieldSkin {
    private InvalidationListener integerFieldValueListener = WebColorFieldSkin$$Lambda$1.lambdaFactory$(this);
    private boolean noChangeInValue = false;

    public WebColorFieldSkin(WebColorField control) {
        super(control);
        control.valueProperty().addListener(this.integerFieldValueListener);
        this.getTextField().setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
    }

    @Override
    public WebColorField getSkinnable() {
        return (WebColorField)this.control;
    }

    @Override
    public Node getNode() {
        return this.getTextField();
    }

    @Override
    public void dispose() {
        ((WebColorField)this.control).valueProperty().removeListener(this.integerFieldValueListener);
        super.dispose();
    }

    @Override
    protected boolean accept(String text) {
        if (text.length() == 0) {
            return true;
        }
        return text.matches("#[a-fA-F0-9]{0,6}") || text.matches("[a-fA-F0-9]{0,6}");
    }

    @Override
    protected void updateText() {
        Color color = ((WebColorField)this.control).getValue();
        if (color == null) {
            color = Color.BLACK;
        }
        this.getTextField().setText(ColorPickerSkin.formatHexString(color));
    }

    @Override
    protected void updateValue() {
        String text;
        if (this.noChangeInValue) {
            return;
        }
        Color value = ((WebColorField)this.control).getValue();
        String string = text = this.getTextField().getText() == null ? "" : this.getTextField().getText().trim().toUpperCase(Locale.ROOT);
        if (text.matches("#[A-F0-9]{6}") || text.matches("[A-F0-9]{6}")) {
            try {
                Color newValue;
                Color color = newValue = text.charAt(0) == '#' ? Color.web(text) : Color.web("#" + text);
                if (!newValue.equals(value)) {
                    ((WebColorField)this.control).setValue(newValue);
                } else {
                    this.noChangeInValue = true;
                    this.getTextField().setText(ColorPickerSkin.formatHexString(newValue));
                    this.noChangeInValue = false;
                }
            }
            catch (IllegalArgumentException ex) {
                System.out.println("Failed to parse [" + text + "]");
            }
        }
    }

    private /* synthetic */ void lambda$new$548(Observable observable) {
        this.updateText();
    }

    static /* synthetic */ void access$lambda$0(WebColorFieldSkin webColorFieldSkin, Observable observable) {
        webColorFieldSkin.lambda$new$548(observable);
    }
}

