/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.text;

import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.scene.text.GlyphList;
import com.sun.javafx.scene.text.TextSpan;
import com.sun.javafx.text.TextLine;

public class TextRun
implements GlyphList {
    int glyphCount;
    int[] gids;
    float[] positions;
    int[] charIndices;
    int start;
    int length;
    float width = -1.0f;
    byte level;
    int script;
    TextSpan span;
    TextLine line;
    Point2D location;
    private float ascent;
    private float descent;
    private float leading;
    int flags = 0;
    int slot = 0;
    static final int FLAGS_TAB = 1;
    static final int FLAGS_LINEBREAK = 2;
    static final int FLAGS_SOFTBREAK = 4;
    static final int FLAGS_NO_LINK_BEFORE = 8;
    static final int FLAGS_NO_LINK_AFTER = 16;
    static final int FLAGS_COMPLEX = 32;
    static final int FLAGS_EMBEDDED = 64;
    static final int FLAGS_SPLIT = 128;
    static final int FLAGS_SPLIT_LAST = 256;
    static final int FLAGS_LEFT_BEARING = 512;
    static final int FLAGS_RIGHT_BEARING = 1024;
    static final int FLAGS_CANONICAL = 2048;
    static final int FLAGS_COMPACT = 4096;
    float cacheWidth = 0.0f;
    int cacheIndex = 0;

    public TextRun(int start, int length, byte level, boolean complex, int script, TextSpan span, int slot, boolean canonical) {
        this.start = start;
        this.length = length;
        this.level = level;
        this.script = script;
        this.span = span;
        this.slot = slot;
        if (canonical) {
            this.flags |= 0x800;
        }
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.start + this.length;
    }

    public int getLength() {
        return this.length;
    }

    public byte getLevel() {
        return this.level;
    }

    @Override
    public RectBounds getLineBounds() {
        return this.line.getBounds();
    }

    public void setLine(TextLine line) {
        this.line = line;
    }

    public int getScript() {
        return this.script;
    }

    @Override
    public TextSpan getTextSpan() {
        return this.span;
    }

    public int getSlot() {
        return this.slot;
    }

    public boolean isLinebreak() {
        return (this.flags & 2) != 0;
    }

    public boolean isCanonical() {
        return (this.flags & 0x800) != 0;
    }

    public boolean isSoftbreak() {
        return (this.flags & 4) != 0;
    }

    public boolean isBreak() {
        return (this.flags & 6) != 0;
    }

    public boolean isTab() {
        return (this.flags & 1) != 0;
    }

    public boolean isEmbedded() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isNoLinkBefore() {
        return (this.flags & 8) != 0;
    }

    public boolean isNoLinkAfter() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isSplit() {
        return (this.flags & 0x80) != 0;
    }

    public boolean isSplitLast() {
        return (this.flags & 0x100) != 0;
    }

    @Override
    public boolean isComplex() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isLeftBearing() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isRightBearing() {
        return (this.flags & 0x400) != 0;
    }

    public boolean isLeftToRight() {
        return (this.level & 1) == 0;
    }

    public void setComplex(boolean complex) {
        this.flags = complex ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
    }

    @Override
    public float getWidth() {
        if (this.width != -1.0f) {
            return this.width;
        }
        if (this.positions != null) {
            if ((this.flags & 0x1000) != 0) {
                this.width = 0.0f;
                for (int i = 0; i < this.glyphCount; ++i) {
                    this.width += this.positions[this.start + i];
                }
                return this.width;
            }
            return this.positions[this.glyphCount << 1];
        }
        return 0.0f;
    }

    @Override
    public float getHeight() {
        return -this.ascent + this.descent + this.leading;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setMetrics(float ascent, float descent, float leading) {
        this.ascent = ascent;
        this.descent = descent;
        this.leading = leading;
    }

    public float getAscent() {
        return this.ascent;
    }

    public float getDescent() {
        return this.descent;
    }

    public float getLeading() {
        return this.leading;
    }

    public void setLocation(float x, float y) {
        this.location = new Point2D(x, y);
    }

    @Override
    public Point2D getLocation() {
        return this.location;
    }

    public void setTab() {
        this.flags |= 1;
    }

    public void setEmbedded(RectBounds bounds, int length) {
        this.width = bounds.getWidth() * (float)length;
        this.ascent = bounds.getMinY();
        this.descent = bounds.getHeight() + this.ascent;
        this.length = length;
        this.flags |= 0x40;
    }

    public void setLinebreak() {
        this.flags |= 2;
    }

    public void setSoftbreak() {
        this.flags |= 4;
    }

    public void setLeftBearing() {
        this.flags |= 0x200;
    }

    public void setRightBearing() {
        this.flags |= 0x400;
    }

    public int getWrapIndex(float width) {
        if (this.glyphCount == 0) {
            return 0;
        }
        if (this.isLeftToRight()) {
            int gi;
            if ((this.flags & 0x1000) != 0) {
                float right = 0.0f;
                for (gi = 0; gi < this.glyphCount; ++gi) {
                    if (!((right += this.positions[this.start + gi]) > width)) continue;
                    return this.getCharOffset(gi);
                }
            } else {
                while (gi < this.glyphCount) {
                    if (this.positions[gi + 1 << 1] > width) {
                        return this.getCharOffset(gi);
                    }
                    ++gi;
                }
            }
        } else {
            int gi = 0;
            float runWidth = this.positions[this.glyphCount << 1];
            while (runWidth > width) {
                float glyphWidth = this.positions[gi + 1 << 1] - this.positions[gi << 1];
                if (runWidth - glyphWidth <= width) {
                    return this.getCharOffset(gi);
                }
                runWidth -= glyphWidth;
                ++gi;
            }
        }
        return 0;
    }

    @Override
    public int getGlyphCount() {
        return this.glyphCount;
    }

    @Override
    public int getGlyphCode(int glyphIndex) {
        if (0 <= glyphIndex && glyphIndex < this.glyphCount) {
            if ((this.flags & 0x1000) != 0) {
                return this.gids[this.start + glyphIndex];
            }
            return this.gids[glyphIndex];
        }
        return 65535;
    }

    @Override
    public float getPosX(int glyphIndex) {
        if (0 <= glyphIndex && glyphIndex <= this.glyphCount) {
            if ((this.flags & 0x1000) != 0) {
                if (this.cacheIndex == glyphIndex) {
                    return this.cacheWidth;
                }
                float x = 0.0f;
                if (this.cacheIndex + 1 == glyphIndex) {
                    x = this.cacheWidth + this.positions[this.start + glyphIndex - 1];
                } else {
                    for (int i = 0; i < glyphIndex; ++i) {
                        x += this.positions[this.start + i];
                    }
                }
                this.cacheIndex = glyphIndex;
                this.cacheWidth = x;
                return x;
            }
            return this.positions[glyphIndex << 1];
        }
        return glyphIndex == 0 ? 0.0f : this.getWidth();
    }

    @Override
    public float getPosY(int glyphIndex) {
        if ((this.flags & 0x1000) != 0) {
            return 0.0f;
        }
        if (0 <= glyphIndex && glyphIndex <= this.glyphCount) {
            return this.positions[(glyphIndex << 1) + 1];
        }
        return 0.0f;
    }

    public float getAdvance(int glyphIndex) {
        if ((this.flags & 0x1000) != 0) {
            return this.positions[this.start + glyphIndex];
        }
        return this.positions[glyphIndex + 1 << 1] - this.positions[glyphIndex << 1];
    }

    public void shape(int count, int[] glyphs, float[] pos, int[] indices) {
        this.glyphCount = count;
        this.gids = glyphs;
        this.positions = pos;
        this.charIndices = indices;
    }

    public void shape(int count, int[] glyphs, float[] pos) {
        this.glyphCount = count;
        this.gids = glyphs;
        this.positions = pos;
        this.charIndices = null;
        this.flags |= 0x1000;
    }

    public float getXAtOffset(int offset, boolean leading) {
        boolean ltr = this.isLeftToRight();
        if (offset == this.length) {
            return ltr ? this.getWidth() : 0.0f;
        }
        if (this.glyphCount > 0) {
            int glyphIndex = this.getGlyphIndex(offset);
            if (ltr) {
                return this.getPosX(glyphIndex + (leading ? 0 : 1));
            }
            return this.getPosX(glyphIndex + (leading ? 1 : 0));
        }
        if (this.isTab()) {
            if (ltr) {
                return leading ? 0.0f : this.getWidth();
            }
            return leading ? this.getWidth() : 0.0f;
        }
        return 0.0f;
    }

    public int getGlyphAtX(float x, int[] trailing) {
        boolean ltr = this.isLeftToRight();
        float runX = 0.0f;
        for (int i = 0; i < this.glyphCount; ++i) {
            float advance = this.getAdvance(i);
            if (runX + advance > x) {
                if (trailing != null) {
                    trailing[0] = x - runX > advance / 2.0f ? (ltr ? 1 : 0) : (ltr ? 0 : 1);
                }
                return i;
            }
            runX += advance;
        }
        if (trailing != null) {
            trailing[0] = ltr ? 1 : 0;
        }
        return Math.max(0, this.glyphCount - 1);
    }

    public int getOffsetAtX(float x, int[] trailing) {
        if (this.glyphCount > 0) {
            int glyphIndex = this.getGlyphAtX(x, trailing);
            return this.getCharOffset(glyphIndex);
        }
        if (this.width != -1.0f && this.length > 0 && trailing != null && x > this.width / 2.0f) {
            trailing[0] = 1;
        }
        return 0;
    }

    private void reset() {
        this.positions = null;
        this.charIndices = null;
        this.gids = null;
        this.width = -1.0f;
        this.leading = 0.0f;
        this.descent = 0.0f;
        this.ascent = 0.0f;
        this.glyphCount = 0;
    }

    public TextRun split(int offset) {
        int newLength = this.length - offset;
        this.length = offset;
        boolean complex = this.isComplex();
        TextRun newRun = new TextRun(this.start + this.length, newLength, this.level, complex, this.script, this.span, this.slot, this.isCanonical());
        this.flags |= 0x10;
        newRun.flags |= 8;
        this.flags |= 0x80;
        this.flags &= 0xFFFFFEFF;
        newRun.flags |= 0x100;
        newRun.setMetrics(this.ascent, this.descent, this.leading);
        if (!complex) {
            this.glyphCount = this.length;
            if ((this.flags & 0x1000) != 0) {
                newRun.shape(newLength, this.gids, this.positions);
                if (this.width != -1.0f) {
                    if (newLength > this.length) {
                        float oldWidth = this.width;
                        this.width = -1.0f;
                        newRun.setWidth(oldWidth - this.getWidth());
                    } else {
                        this.width -= newRun.getWidth();
                    }
                }
            } else {
                int[] newGlyphs = new int[newLength];
                float[] newPos = new float[newLength + 1 << 1];
                System.arraycopy(this.gids, offset, newGlyphs, 0, newLength);
                float width = this.getWidth();
                int delta = offset << 1;
                for (int i = 2; i < newPos.length; i += 2) {
                    newPos[i] = this.positions[i + delta] - width;
                }
                newRun.shape(newLength, newGlyphs, newPos, null);
            }
        } else {
            this.reset();
        }
        return newRun;
    }

    public void merge(TextRun run) {
        if (run != null) {
            this.length += run.length;
            this.glyphCount += run.glyphCount;
            this.width = this.width != -1.0f && run.width != -1.0f ? (this.width += run.width) : -1.0f;
        }
        this.flags &= 0xFFFFFF7F;
        this.flags &= 0xFFFFFEFF;
    }

    public TextRun unwrap() {
        TextRun newRun = new TextRun(this.start, this.length, this.level, this.isComplex(), this.script, this.span, this.slot, this.isCanonical());
        newRun.shape(this.glyphCount, this.gids, this.positions);
        newRun.setWidth(this.width);
        newRun.setMetrics(this.ascent, this.descent, this.leading);
        int mask = 28;
        newRun.flags = this.flags & ~mask;
        return newRun;
    }

    public void justify(int offset, float width) {
        if (this.positions != null) {
            int glyphIndex = this.getGlyphIndex(offset);
            if (glyphIndex != -1) {
                for (int i = glyphIndex + 1; i <= this.glyphCount; ++i) {
                    int n = i << 1;
                    this.positions[n] = this.positions[n] + width;
                }
                this.width = -1.0f;
            }
            this.setComplex(true);
        }
    }

    public int getGlyphIndex(int charOffset) {
        if (this.charIndices == null) {
            return charOffset;
        }
        for (int i = 0; i < this.charIndices.length && i < this.glyphCount; ++i) {
            if (this.charIndices[i] != charOffset) continue;
            return i;
        }
        if (this.isLeftToRight()) {
            if (charOffset > 0) {
                return this.getGlyphIndex(charOffset - 1);
            }
        } else if (charOffset + 1 < this.length) {
            return this.getGlyphIndex(charOffset + 1);
        }
        return 0;
    }

    @Override
    public int getCharOffset(int glyphIndex) {
        return this.charIndices == null ? glyphIndex : this.charIndices[glyphIndex];
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("TextRun start=");
        buffer.append(this.start);
        buffer.append(", length=");
        buffer.append(this.length);
        buffer.append(", script=");
        buffer.append(this.script);
        buffer.append(", linebreak=");
        buffer.append(this.isLinebreak());
        buffer.append(", softbreak=");
        buffer.append(this.isSoftbreak());
        buffer.append(", complex=");
        buffer.append(this.isComplex());
        buffer.append(", tab=");
        buffer.append(this.isTab());
        buffer.append(", compact=");
        buffer.append((this.flags & 0x1000) != 0);
        buffer.append(", ltr=");
        buffer.append(this.isLeftToRight());
        buffer.append(", split=");
        buffer.append(this.isSplit());
        return buffer.toString();
    }
}

