/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.tk.FocusCause;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.TKStageListener;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.GlassStage$$Lambda$1;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

abstract class GlassStage
implements TKStage {
    private static final List<GlassStage> windows = new ArrayList<GlassStage>();
    private static List<TKStage> importantWindows = new ArrayList<TKStage>();
    private GlassScene scene;
    protected TKStageListener stageListener;
    private boolean visible;
    private boolean important = true;
    private AccessControlContext accessCtrlCtx = null;
    protected static final AtomicReference<GlassStage> activeFSWindow = new AtomicReference();

    protected GlassStage() {
        windows.add(this);
    }

    @Override
    public void close() {
        assert (this.scene == null);
        windows.remove(this);
        importantWindows.remove(this);
        GlassStage.notifyWindowListeners();
    }

    @Override
    public void setTKStageListener(TKStageListener listener) {
        this.stageListener = listener;
    }

    protected final GlassScene getScene() {
        return this.scene;
    }

    @Override
    public void setScene(TKScene scene) {
        if (this.scene != null) {
            this.scene.setStage(null);
        }
        this.scene = (GlassScene)scene;
        if (this.scene != null) {
            this.scene.setStage(this);
        }
    }

    final AccessControlContext getAccessControlContext() {
        if (this.accessCtrlCtx == null) {
            throw new RuntimeException("Stage security context has not been set!");
        }
        return this.accessCtrlCtx;
    }

    public final void setSecurityContext(AccessControlContext ctx) {
        if (this.accessCtrlCtx != null) {
            throw new RuntimeException("Stage security context has been already set!");
        }
        AccessControlContext acc = AccessController.getContext();
        this.accessCtrlCtx = AccessController.getContext();
    }

    @Override
    public void requestFocus() {
    }

    @Override
    public void requestFocus(FocusCause cause) {
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        if (visible) {
            if (this.important) {
                importantWindows.add(this);
                GlassStage.notifyWindowListeners();
            }
        } else if (this.important) {
            importantWindows.remove(this);
            GlassStage.notifyWindowListeners();
        }
        if (this.scene != null) {
            this.scene.stageVisible(visible);
        }
    }

    boolean isVisible() {
        return this.visible;
    }

    protected void setPlatformEnabled(boolean enabled) {
    }

    void windowsSetEnabled(boolean enabled) {
        for (GlassStage window : windows.toArray(new GlassStage[windows.size()])) {
            if (window == this || !windows.contains(window)) continue;
            window.setPlatformEnabled(enabled);
        }
    }

    @Override
    public void setImportant(boolean important) {
        this.important = important;
    }

    private static void notifyWindowListeners() {
        Toolkit.getToolkit().notifyWindowListeners(importantWindows);
    }

    static void requestClosingAllWindows() {
        GlassStage fsWindow = activeFSWindow.get();
        if (fsWindow != null) {
            fsWindow.setFullScreen(false);
        }
        for (GlassStage window : windows.toArray(new GlassStage[windows.size()])) {
            if (!windows.contains(window) || !window.isVisible() || window.stageListener == null) continue;
            AccessController.doPrivileged(GlassStage$$Lambda$1.lambdaFactory$(window), window.getAccessControlContext());
        }
    }

    private static /* synthetic */ Void lambda$requestClosingAllWindows$286(GlassStage window) {
        window.stageListener.closing();
        return null;
    }

    static /* synthetic */ Void access$lambda$0(GlassStage glassStage) {
        return GlassStage.lambda$requestClosingAllWindows$286(glassStage);
    }
}

