/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Window;
import com.sun.javafx.tk.FocusCause;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.GlassWindowEventHandler$$Lambda$1;
import com.sun.javafx.tk.quantum.GlassWindowEventHandler$$Lambda$2;
import com.sun.javafx.tk.quantum.GlassWindowEventHandler$$Lambda$3;
import com.sun.javafx.tk.quantum.GlassWindowEventHandler$$Lambda$4;
import com.sun.javafx.tk.quantum.GlassWindowEventHandler$$Lambda$5;
import com.sun.javafx.tk.quantum.GlassWindowEventHandler$$Lambda$6;
import com.sun.javafx.tk.quantum.GlassWindowEventHandler$$Lambda$7;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.WindowStage;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;

class GlassWindowEventHandler
extends Window.EventHandler
implements PrivilegedAction<Void> {
    private final WindowStage stage;
    private Window window;
    private int type;

    public GlassWindowEventHandler(WindowStage stage) {
        this.stage = stage;
    }

    @Override
    public Void run() {
        if (this.stage == null || this.stage.stageListener == null) {
            return null;
        }
        switch (this.type) {
            case 531: {
                this.stage.stageListener.changedIconified(true);
                break;
            }
            case 532: {
                this.stage.stageListener.changedMaximized(true);
                break;
            }
            case 533: {
                this.stage.stageListener.changedIconified(false);
                this.stage.stageListener.changedMaximized(false);
                break;
            }
            case 512: {
                float pScale = this.window.getPlatformScale();
                Screen screen = this.window.getScreen();
                float sx = screen == null ? 0.0f : (float)screen.getX();
                float sy = screen == null ? 0.0f : (float)screen.getY();
                float wx = this.window.getX();
                float wy = this.window.getY();
                float newx = sx + (wx - sx) / pScale;
                float newy = sy + (wy - sy) / pScale;
                this.stage.stageListener.changedLocation(newx, newy);
                if (Application.GetApplication().hasWindowManager()) break;
                QuantumToolkit.runWithRenderLock(GlassWindowEventHandler$$Lambda$1.lambdaFactory$(this));
                break;
            }
            case 511: {
                float pScale = this.window.getPlatformScale();
                this.stage.stageListener.changedSize((float)this.window.getWidth() / pScale, (float)this.window.getHeight() / pScale);
                break;
            }
            case 542: {
                WindowStage.addActiveWindow(this.stage);
                this.stage.stageListener.changedFocused(true, FocusCause.ACTIVATED);
                break;
            }
            case 541: {
                this.stage.stageListener.changedFocused(false, FocusCause.DEACTIVATED);
                break;
            }
            case 546: {
                this.stage.stageListener.focusUngrab();
                break;
            }
            case 543: {
                WindowStage.addActiveWindow(this.stage);
                this.stage.stageListener.changedFocused(true, FocusCause.TRAVERSED_FORWARD);
                break;
            }
            case 544: {
                WindowStage.addActiveWindow(this.stage);
                this.stage.stageListener.changedFocused(true, FocusCause.TRAVERSED_BACKWARD);
                break;
            }
            case 545: {
                this.stage.handleFocusDisabled();
                break;
            }
            case 522: {
                this.stage.setPlatformWindowClosed();
                this.stage.stageListener.closed();
                break;
            }
            case 521: {
                this.stage.stageListener.closing();
                break;
            }
            default: {
                if (!QuantumToolkit.verbose) break;
                System.err.println("GlassWindowEventHandler: unknown type: " + this.type);
            }
        }
        return null;
    }

    @Override
    public void handleLevelEvent(int level) {
        QuantumToolkit.runWithoutRenderLock(GlassWindowEventHandler$$Lambda$2.lambdaFactory$(this, level));
    }

    @Override
    public void handleWindowEvent(Window window, long time, int type) {
        this.window = window;
        this.type = type;
        QuantumToolkit.runWithoutRenderLock(GlassWindowEventHandler$$Lambda$3.lambdaFactory$(this));
    }

    @Override
    public void handleScreenChangedEvent(Window window, long time, Screen oldScreen, Screen newScreen) {
        GlassScene scene = this.stage.getScene();
        if (scene != null) {
            QuantumToolkit.runWithRenderLock(GlassWindowEventHandler$$Lambda$4.lambdaFactory$(scene));
        }
        QuantumToolkit.runWithoutRenderLock(GlassWindowEventHandler$$Lambda$5.lambdaFactory$(this, oldScreen, newScreen));
    }

    private /* synthetic */ Void lambda$handleScreenChangedEvent$409(Screen oldScreen, Screen newScreen) {
        AccessControlContext acc = this.stage.getAccessControlContext();
        return (Void)AccessController.doPrivileged(GlassWindowEventHandler$$Lambda$6.lambdaFactory$(this, oldScreen, newScreen), acc);
    }

    private /* synthetic */ Void lambda$null$408(Screen oldScreen, Screen newScreen) {
        this.stage.stageListener.changedScreen(oldScreen, newScreen);
        return null;
    }

    private static /* synthetic */ Object lambda$handleScreenChangedEvent$407(GlassScene scene) {
        scene.entireSceneNeedsRepaint();
        scene.updateSceneState();
        return null;
    }

    private /* synthetic */ Void lambda$handleWindowEvent$406() {
        AccessControlContext acc = this.stage.getAccessControlContext();
        return AccessController.doPrivileged(this, acc);
    }

    private /* synthetic */ Void lambda$handleLevelEvent$405(int level) {
        AccessControlContext acc = this.stage.getAccessControlContext();
        return (Void)AccessController.doPrivileged(GlassWindowEventHandler$$Lambda$7.lambdaFactory$(this, level), acc);
    }

    private /* synthetic */ Void lambda$null$404(int level) {
        this.stage.stageListener.changedAlwaysOnTop(level != 1);
        return null;
    }

    private /* synthetic */ Object lambda$run$403() {
        GlassScene scene = this.stage.getScene();
        if (scene != null) {
            scene.updateSceneState();
        }
        return null;
    }

    static /* synthetic */ Object access$lambda$0(GlassWindowEventHandler glassWindowEventHandler) {
        return glassWindowEventHandler.lambda$run$403();
    }

    static /* synthetic */ Void access$lambda$1(GlassWindowEventHandler glassWindowEventHandler, int n) {
        return glassWindowEventHandler.lambda$handleLevelEvent$405(n);
    }

    static /* synthetic */ Void access$lambda$2(GlassWindowEventHandler glassWindowEventHandler) {
        return glassWindowEventHandler.lambda$handleWindowEvent$406();
    }

    static /* synthetic */ Object access$lambda$3(GlassScene glassScene) {
        return GlassWindowEventHandler.lambda$handleScreenChangedEvent$407(glassScene);
    }

    static /* synthetic */ Void access$lambda$4(GlassWindowEventHandler glassWindowEventHandler, Screen screen, Screen screen2) {
        return glassWindowEventHandler.lambda$handleScreenChangedEvent$409(screen, screen2);
    }

    static /* synthetic */ Void access$lambda$5(GlassWindowEventHandler glassWindowEventHandler, Screen screen, Screen screen2) {
        return glassWindowEventHandler.lambda$null$408(screen, screen2);
    }

    static /* synthetic */ Void access$lambda$6(GlassWindowEventHandler glassWindowEventHandler, int n) {
        return glassWindowEventHandler.lambda$null$404(n);
    }
}

