/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl;

import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.LockableResource;
import com.sun.scenario.effect.impl.ImagePool$$Lambda$1;
import com.sun.scenario.effect.impl.PoolFilterable;
import com.sun.scenario.effect.impl.Renderer;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ImagePool {
    public static long numEffects;
    static long numCreated;
    static long pixelsCreated;
    static long numAccessed;
    static long pixelsAccessed;
    static final int QUANT = 32;
    private final List<SoftReference<PoolFilterable>> unlocked = new ArrayList<SoftReference<PoolFilterable>>();
    private final List<SoftReference<PoolFilterable>> locked = new ArrayList<SoftReference<PoolFilterable>>();
    private final boolean usePurgatory = Boolean.getBoolean("decora.purgatory");
    private final List<Filterable> hardPurgatory = new ArrayList<Filterable>();
    private final List<SoftReference<PoolFilterable>> softPurgatory = new ArrayList<SoftReference<PoolFilterable>>();

    static void printStats() {
        System.out.println("effects executed:  " + numEffects);
        System.out.println("images created:    " + numCreated);
        System.out.println("pixels created:    " + pixelsCreated);
        System.out.println("images accessed:   " + numAccessed);
        System.out.println("pixels accessed:   " + pixelsAccessed);
        if (numEffects != 0L) {
            double avgImgs = (double)numAccessed / (double)numEffects;
            double avgPxls = (double)pixelsAccessed / (double)numEffects;
            System.out.println("images per effect: " + avgImgs);
            System.out.println("pixels per effect: " + avgPxls);
        }
    }

    ImagePool() {
    }

    public synchronized PoolFilterable checkOut(Renderer renderer, int w, int h) {
        Filterable eimg;
        SoftReference<PoolFilterable> entry;
        if (w <= 0 || h <= 0) {
            h = 1;
            w = 1;
        }
        w = (w + 32 - 1) / 32 * 32;
        h = (h + 32 - 1) / 32 * 32;
        w = renderer.getCompatibleWidth(w);
        h = renderer.getCompatibleHeight(h);
        ++numAccessed;
        pixelsAccessed += (long)w * (long)h;
        SoftReference<PoolFilterable> chosenEntry = null;
        LockableResource chosenImage = null;
        int mindiff = Integer.MAX_VALUE;
        Iterator<SoftReference<PoolFilterable>> entries = this.unlocked.iterator();
        while (entries.hasNext()) {
            entry = entries.next();
            eimg = entry.get();
            if (eimg == null) {
                entries.remove();
                continue;
            }
            int ew = eimg.getMaxContentWidth();
            int eh = eimg.getMaxContentHeight();
            if (ew < w || eh < h || ew * eh / 2 > w * h) continue;
            int diff = (ew - w) * (eh - h);
            if (chosenEntry != null && diff >= mindiff) continue;
            eimg.lock();
            if (eimg.isLost()) {
                entries.remove();
                continue;
            }
            if (chosenImage != null) {
                chosenImage.unlock();
            }
            chosenEntry = entry;
            chosenImage = eimg;
            mindiff = diff;
        }
        if (chosenEntry != null) {
            this.unlocked.remove(chosenEntry);
            this.locked.add(chosenEntry);
            renderer.clearImage((Filterable)chosenImage);
            return chosenImage;
        }
        entries = this.locked.iterator();
        while (entries.hasNext()) {
            entry = entries.next();
            eimg = entry.get();
            if (eimg != null) continue;
            entries.remove();
        }
        PoolFilterable img = null;
        try {
            img = renderer.createCompatibleImage(w, h);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        if (img == null) {
            this.pruneCache();
            try {
                img = renderer.createCompatibleImage(w, h);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
        }
        if (img != null) {
            img.setImagePool(this);
            this.locked.add(new SoftReference<PoolFilterable>(img));
            ++numCreated;
            pixelsCreated += (long)w * (long)h;
        }
        return img;
    }

    public synchronized void checkIn(PoolFilterable img) {
        SoftReference<PoolFilterable> chosenEntry = null;
        Filterable chosenImage = null;
        Iterator<SoftReference<PoolFilterable>> entries = this.locked.iterator();
        while (entries.hasNext()) {
            SoftReference<PoolFilterable> entry = entries.next();
            Filterable eimg = entry.get();
            if (eimg == null) {
                entries.remove();
                continue;
            }
            if (eimg != img) continue;
            chosenEntry = entry;
            chosenImage = eimg;
            img.unlock();
            break;
        }
        if (chosenEntry != null) {
            this.locked.remove(chosenEntry);
            if (this.usePurgatory) {
                this.hardPurgatory.add(chosenImage);
                this.softPurgatory.add(chosenEntry);
            } else {
                this.unlocked.add(chosenEntry);
            }
        }
    }

    public synchronized void releasePurgatory() {
        if (this.usePurgatory && !this.softPurgatory.isEmpty()) {
            this.unlocked.addAll(this.softPurgatory);
            this.softPurgatory.clear();
            this.hardPurgatory.clear();
        }
    }

    private void pruneCache() {
        for (SoftReference<PoolFilterable> r : this.unlocked) {
            Filterable image = r.get();
            if (image == null) continue;
            image.flush();
        }
        this.unlocked.clear();
        System.gc();
        System.runFinalization();
        System.gc();
        System.runFinalization();
    }

    public synchronized void dispose() {
        for (SoftReference<PoolFilterable> r : this.unlocked) {
            Filterable image = r.get();
            if (image == null) continue;
            image.flush();
        }
        this.unlocked.clear();
        this.locked.clear();
    }

    private static /* synthetic */ Object lambda$static$36() {
        if (System.getProperty("decora.showstats") != null) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    ImagePool.printStats();
                }
            });
        }
        return null;
    }

    static {
        AccessController.doPrivileged(ImagePool$$Lambda$1.lambdaFactory$());
    }

    static /* synthetic */ Object access$lambda$0() {
        return ImagePool.lambda$static$36();
    }
}

