/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.state;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.geom.Rectangle;
import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.EffectPeer;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.LinearConvolveRenderState$$Lambda$1;
import com.sun.scenario.effect.impl.state.RenderState;
import java.nio.FloatBuffer;
import java.security.AccessController;

public abstract class LinearConvolveRenderState
implements RenderState {
    public static final int MAX_COMPILED_KERNEL_SIZE = 128;
    public static final int MAX_KERNEL_SIZE;
    static final float MIN_EFFECT_RADIUS = 0.00390625f;
    static final float[] BLACK_COMPONENTS;

    public static int getPeerSize(int ksize) {
        if (ksize < 32) {
            return ksize + 3 & 0xFFFFFFFC;
        }
        if (ksize <= MAX_KERNEL_SIZE) {
            return ksize + 31 & 0xFFFFFFE0;
        }
        throw new RuntimeException("No peer available for kernel size: " + ksize);
    }

    static boolean nearZero(float v, int size) {
        return (double)Math.abs(v * (float)size) < 0.001953125;
    }

    static boolean nearOne(float v, int size) {
        return (double)Math.abs(v * (float)size - (float)size) < 0.001953125;
    }

    public abstract boolean isShadow();

    public abstract Color4f getShadowColor();

    public abstract int getInputKernelSize(int var1);

    public abstract boolean isNop();

    public abstract ImageData validatePassInput(ImageData var1, int var2);

    public abstract boolean isPassNop();

    public EffectPeer<? extends LinearConvolveRenderState> getPassPeer(Renderer r, FilterContext fctx) {
        if (this.isPassNop()) {
            return null;
        }
        int ksize = this.getPassKernelSize();
        int psize = LinearConvolveRenderState.getPeerSize(ksize);
        String opname = this.isShadow() ? "LinearConvolveShadow" : "LinearConvolve";
        return r.getPeerInstance(fctx, opname, psize);
    }

    public abstract Rectangle getPassResultBounds(Rectangle var1, Rectangle var2);

    public PassType getPassType() {
        return PassType.GENERAL_VECTOR;
    }

    public abstract FloatBuffer getPassWeights();

    public abstract int getPassWeightsArrayLength();

    public abstract float[] getPassVector();

    public abstract float[] getPassShadowColorComponents();

    public abstract int getPassKernelSize();

    private static /* synthetic */ Integer lambda$static$26(int defSize) {
        return Integer.getInteger("decora.maxLinearConvolveKernelSize", defSize);
    }

    static {
        BLACK_COMPONENTS = Color4f.BLACK.getPremultipliedRGBComponents();
        int defSize = PlatformUtil.isEmbedded() ? 64 : 128;
        int size = (Integer)AccessController.doPrivileged(LinearConvolveRenderState$$Lambda$1.lambdaFactory$(defSize));
        if (size > 128) {
            System.out.println("Clamping maxLinearConvolveKernelSize to 128");
            size = 128;
        }
        MAX_KERNEL_SIZE = size;
    }

    static /* synthetic */ Integer access$lambda$0(int n) {
        return LinearConvolveRenderState.lambda$static$26(n);
    }

    public static enum PassType {
        HORIZONTAL_CENTERED,
        VERTICAL_CENTERED,
        GENERAL_VECTOR;

    }
}

