/*
 * Decompiled with CFR 0.152.
 */
package javafx.application;

import com.sun.javafx.application.LauncherImpl;
import com.sun.javafx.application.ParametersImpl;
import com.sun.javafx.application.PlatformImpl;
import java.util.List;
import java.util.Map;
import javafx.application.HostServices;
import javafx.application.Preloader;
import javafx.stage.Stage;

public abstract class Application {
    public static final String STYLESHEET_CASPIAN = "CASPIAN";
    public static final String STYLESHEET_MODENA = "MODENA";
    private HostServices hostServices = null;
    private static String userAgentStylesheet = null;

    public static void launch(Class<? extends Application> appClass, String ... args) {
        LauncherImpl.launchApplication(appClass, args);
    }

    public static void launch(String ... args) {
        StackTraceElement[] cause = Thread.currentThread().getStackTrace();
        boolean foundThisMethod = false;
        String callingClassName = null;
        for (StackTraceElement se : cause) {
            String className = se.getClassName();
            String methodName = se.getMethodName();
            if (foundThisMethod) {
                callingClassName = className;
                break;
            }
            if (!Application.class.getName().equals(className) || !"launch".equals(methodName)) continue;
            foundThisMethod = true;
        }
        if (callingClassName == null) {
            throw new RuntimeException("Error: unable to determine Application class");
        }
        try {
            Class<?> theClass = Class.forName(callingClassName, true, Thread.currentThread().getContextClassLoader());
            if (!Application.class.isAssignableFrom(theClass)) {
                throw new RuntimeException("Error: " + theClass + " is not a subclass of javafx.application.Application");
            }
            Class<?> appClass = theClass;
            LauncherImpl.launchApplication(appClass, args);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void init() throws Exception {
    }

    public abstract void start(Stage var1) throws Exception;

    public void stop() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HostServices getHostServices() {
        Application application = this;
        synchronized (application) {
            if (this.hostServices == null) {
                this.hostServices = new HostServices(this);
            }
            return this.hostServices;
        }
    }

    public final Parameters getParameters() {
        return ParametersImpl.getParameters(this);
    }

    public final void notifyPreloader(Preloader.PreloaderNotification info) {
        LauncherImpl.notifyPreloader(this, info);
    }

    public static String getUserAgentStylesheet() {
        return userAgentStylesheet;
    }

    public static void setUserAgentStylesheet(String url) {
        userAgentStylesheet = url;
        if (url == null) {
            PlatformImpl.setDefaultPlatformUserAgentStylesheet();
        } else {
            PlatformImpl.setPlatformUserAgentStylesheet(url);
        }
    }

    public static abstract class Parameters {
        public abstract List<String> getRaw();

        public abstract List<String> getUnnamed();

        public abstract Map<String, String> getNamed();
    }
}

