/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.property;

import com.sun.javafx.binding.ListExpressionHelper;
import java.lang.ref.WeakReference;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ListPropertyBase$$Lambda$1;
import javafx.beans.property.ListPropertyBase$$Lambda$2;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanPropertyBase;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerPropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public abstract class ListPropertyBase<E>
extends ListProperty<E> {
    private final ListChangeListener<E> listChangeListener;
    private ObservableList<E> value;
    private ObservableValue<? extends ObservableList<E>> observable;
    private InvalidationListener listener;
    private boolean valid;
    private ListExpressionHelper<E> helper;
    private SizeProperty size0;
    private EmptyProperty empty0;

    public ListPropertyBase() {
        this.listChangeListener = ListPropertyBase$$Lambda$1.lambdaFactory$(this);
        this.observable = null;
        this.listener = null;
        this.valid = true;
        this.helper = null;
    }

    public ListPropertyBase(ObservableList<E> initialValue) {
        this.listChangeListener = ListPropertyBase$$Lambda$2.lambdaFactory$(this);
        this.observable = null;
        this.listener = null;
        this.valid = true;
        this.helper = null;
        this.value = initialValue;
        if (initialValue != null) {
            initialValue.addListener(this.listChangeListener);
        }
    }

    @Override
    public ReadOnlyIntegerProperty sizeProperty() {
        if (this.size0 == null) {
            this.size0 = new SizeProperty();
        }
        return this.size0;
    }

    @Override
    public ReadOnlyBooleanProperty emptyProperty() {
        if (this.empty0 == null) {
            this.empty0 = new EmptyProperty();
        }
        return this.empty0;
    }

    @Override
    public void addListener(InvalidationListener listener) {
        this.helper = ListExpressionHelper.addListener(this.helper, this, listener);
    }

    @Override
    public void removeListener(InvalidationListener listener) {
        this.helper = ListExpressionHelper.removeListener(this.helper, listener);
    }

    @Override
    public void addListener(ChangeListener<? super ObservableList<E>> listener) {
        this.helper = ListExpressionHelper.addListener(this.helper, this, listener);
    }

    @Override
    public void removeListener(ChangeListener<? super ObservableList<E>> listener) {
        this.helper = ListExpressionHelper.removeListener(this.helper, listener);
    }

    @Override
    public void addListener(ListChangeListener<? super E> listener) {
        this.helper = ListExpressionHelper.addListener(this.helper, this, listener);
    }

    @Override
    public void removeListener(ListChangeListener<? super E> listener) {
        this.helper = ListExpressionHelper.removeListener(this.helper, listener);
    }

    protected void fireValueChangedEvent() {
        ListExpressionHelper.fireValueChangedEvent(this.helper);
    }

    protected void fireValueChangedEvent(ListChangeListener.Change<? extends E> change) {
        ListExpressionHelper.fireValueChangedEvent(this.helper, change);
    }

    private void invalidateProperties() {
        if (this.size0 != null) {
            this.size0.fireValueChangedEvent();
        }
        if (this.empty0 != null) {
            this.empty0.fireValueChangedEvent();
        }
    }

    private void markInvalid(ObservableList<E> oldValue) {
        if (this.valid) {
            if (oldValue != null) {
                oldValue.removeListener(this.listChangeListener);
            }
            this.valid = false;
            this.invalidateProperties();
            this.invalidated();
            this.fireValueChangedEvent();
        }
    }

    protected void invalidated() {
    }

    @Override
    public ObservableList<E> get() {
        if (!this.valid) {
            this.value = this.observable == null ? this.value : this.observable.getValue();
            this.valid = true;
            if (this.value != null) {
                this.value.addListener(this.listChangeListener);
            }
        }
        return this.value;
    }

    @Override
    public void set(ObservableList<E> newValue) {
        if (this.isBound()) {
            throw new RuntimeException((this.getBean() != null && this.getName() != null ? this.getBean().getClass().getSimpleName() + "." + this.getName() + " : " : "") + "A bound value cannot be set.");
        }
        if (this.value != newValue) {
            ObservableList<E> oldValue = this.value;
            this.value = newValue;
            this.markInvalid(oldValue);
        }
    }

    @Override
    public boolean isBound() {
        return this.observable != null;
    }

    @Override
    public void bind(ObservableValue<? extends ObservableList<E>> newObservable) {
        if (newObservable == null) {
            throw new NullPointerException("Cannot bind to null");
        }
        if (!newObservable.equals(this.observable)) {
            this.unbind();
            this.observable = newObservable;
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            this.observable.addListener(this.listener);
            this.markInvalid(this.value);
        }
    }

    @Override
    public void unbind() {
        if (this.observable != null) {
            this.value = this.observable.getValue();
            this.observable.removeListener(this.listener);
            this.observable = null;
        }
    }

    @Override
    public String toString() {
        Object bean = this.getBean();
        String name = this.getName();
        StringBuilder result = new StringBuilder("ListProperty [");
        if (bean != null) {
            result.append("bean: ").append(bean).append(", ");
        }
        if (name != null && !name.equals("")) {
            result.append("name: ").append(name).append(", ");
        }
        if (this.isBound()) {
            result.append("bound, ");
            if (this.valid) {
                result.append("value: ").append(this.get());
            } else {
                result.append("invalid");
            }
        } else {
            result.append("value: ").append(this.get());
        }
        result.append("]");
        return result.toString();
    }

    private /* synthetic */ void lambda$new$27(ListChangeListener.Change change) {
        this.invalidateProperties();
        this.invalidated();
        this.fireValueChangedEvent(change);
    }

    static /* synthetic */ void access$lambda$0(ListPropertyBase listPropertyBase, ListChangeListener.Change change) {
        listPropertyBase.lambda$new$27(change);
    }

    static /* synthetic */ void access$lambda$1(ListPropertyBase listPropertyBase, ListChangeListener.Change change) {
        listPropertyBase.lambda$new$27(change);
    }

    private static class Listener<E>
    implements InvalidationListener {
        private final WeakReference<ListPropertyBase<E>> wref;

        public Listener(ListPropertyBase<E> ref) {
            this.wref = new WeakReference<ListPropertyBase<E>>(ref);
        }

        @Override
        public void invalidated(Observable observable) {
            ListPropertyBase ref = (ListPropertyBase)this.wref.get();
            if (ref == null) {
                observable.removeListener(this);
            } else {
                ref.markInvalid(ref.value);
            }
        }
    }

    private class EmptyProperty
    extends ReadOnlyBooleanPropertyBase {
        private EmptyProperty() {
        }

        @Override
        public boolean get() {
            return ListPropertyBase.this.isEmpty();
        }

        @Override
        public Object getBean() {
            return ListPropertyBase.this;
        }

        @Override
        public String getName() {
            return "empty";
        }

        @Override
        protected void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }
    }

    private class SizeProperty
    extends ReadOnlyIntegerPropertyBase {
        private SizeProperty() {
        }

        @Override
        public int get() {
            return ListPropertyBase.this.size();
        }

        @Override
        public Object getBean() {
            return ListPropertyBase.this;
        }

        @Override
        public String getName() {
            return "size";
        }

        @Override
        protected void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }
    }
}

